#include"functionB.h"

extern int TOTAL;
extern Cluster *G;

void Swap(Object *A,Object *B) {
  Object *tmp;
  tmp = (Object *) malloc(sizeof(Object));
  if(!tmp)
    exit(-1);  
  memcpy(tmp,A,sizeof(Object));
  memcpy(A,  B,sizeof(Object));
  memcpy(B,  tmp,sizeof(Object));
  free(tmp);
  return;
}

void swap(int  *x,int *y) {
  int tmp;
  tmp = *x;
  *x = *y;
  *y = tmp;
}

int Gonzales(Object *S,int j) {
  int i,k,idx = -1;
  float temp,t1 = 0,t2 = 0;
  for(i=j;i<n;i++) {
    temp = 99999999;
    for(k=0;k<j;k++) {
      t1 = Dist(S+i,S+k);
      if(t1 < temp) {
	temp = t1;
      }
    }
    if(temp > t2) {
      t2 = temp;
      idx = i;
    }
  }
  return idx;
}

int Centroid(Cluster *G,int num_clusters,int idx) {
  int i;
  for(i=0;i<num_clusters;i++) {
    if(G[i].Centroid == idx)
      return i;
  }
  return -1;
}

int Median1(Object *S,int *T,int start,int size) {
  int i,j,ret=-1;
  float dis,ris=99999999;
  //  fprintf(stderr,"\nstart:%d sze:%d",start,size);
  //getchar();
  for(i=start;i<size;i++) {
    dis = 0;
    for(j=start;j<size;j++) {
      dis += Dist(S+T[i],S+T[j]);
      //  fprintf(stderr,"\n%d %d idx1:%d idx2:%d dis:%f",i,j,*S[T[i]].index,*S[T[j]].index,dis);
    }
    if(dis < ris) {
      ris = dis;
      ret = i;
    }
  }
  //  fprintf(stderr,"\n%d",T[ret]);
  return T[ret];
}

int Median(int i,int *Elements,int size,Object *S) {
  int j,k,size_T,size_W,i1,i2,ss,start;
  int *T=NULL,*W=NULL;
  //fprintf(stderr,"\nsize:%d",size);
  //getchar();
  T = (int *)malloc(sizeof(int)*size);
  size_T = size;
  for(j=0;j<size-1;j++) {
    T[j] = Elements[j];
  }
  T[size-1] = i;
  
  // for(j=0;j<size;j++) {
  // fprintf(stderr,"T[%d]:%d ",j,T[j]);
  //}
  
  start = 0;
  
  while(size_T > 8) {
    //fprintf(stderr,"\nentri start:%d size:%d",start,size);
    //getchar();
    for(k=start;k<size;k++) {
      i1 = start + rand()%size_T;
      i2 = start + rand()%size_T;
      //fprintf(stderr,"\nswappo :%d %d",i1,i2);
      //getchar();
      swap(T+i1,T+i2);
    }
    //    fprintf(stderr,"\nsize_T:%d",size_T);
    //getchar();
    size_W = 0;

    while(size_T >= 6) {
      start += 3;
      ss = Median1(S,T,start-3,start);
      size_W++;
      W = (int *)realloc(W,sizeof(int)*size_W);
      W[size_W-1] = ss;
      size_T -= 3;
      //fprintf(stderr,"\nstart:%d size_T:%d size_W:%d",start,size_T,size_W);
      //getchar();
    }
    if(size_T > 0) {
      ss = Median1(S,T,start,size);
      size_T = 1;
      start = size;
      T[--start] = ss;
      //fprintf(stderr,"\nsize_T > 0 start:%d size_T:%d",start,size_T);
    }
    
    for(ss = 0; ss < size_W; ss++) {
      T[--start] = W[ss];
      size_T++;
    }
    if(W) {
      free(W);
      W = NULL;
    }
    //    fprintf(stderr,"\nsize_T:%d",size_T);
    //getchar();
    //    for(ss = start; ss < size; ss++) {
    // fprintf(stderr,"\n%d ",T[ss]);
    //}
  }
  ss = Median1(S,T,start,size);
  free(T);
  return ss;
}

void Build(Object *S,int num_clusters) {
  int i,j=0,k,idx=-1;
  float dis,temp;
  
  i = (int) (rand()%n);
  G[j].Elements = NULL;
  G[j].Dc = NULL;
  G[j].size = 1;
  G[j].radius = 0;
  G[j].Centroid = j;
  j++;

  //  fprintf(stderr,"\nswappo i:%d j-1:%d",i,j-1);
  Swap(S+j-1,S+i);
    
  while(j<num_clusters) {
    i = Gonzales(S,j);
    G[j].Centroid = j;
    G[j].size = 1;
    G[j].radius = 0;
    G[j].Elements = NULL;
    G[j].Dc = NULL;
    j++;
    //    fprintf(stderr,"\nswappo i:%d j-1:%d",i,j-1);
    Swap(S+j-1,S+i);
  }
  
  for(i=j;i<n;i++) {
    temp = 999999999;
    for(k=0;k<j;k++) {
      dis = Dist(S+i,S+k);
      if(dis < temp) {
	temp = dis;
	idx = k;
      }
    }
    //    fprintf(stderr,"\nEl %d piu vicino a Cen:%d",*S[i].index,*S[idx].index);
    //getchar();
    //fprintf(stderr,"\n%d",G[idx].size);
    G[idx].size++;
    G[idx].Elements = (int *)realloc(G[idx].Elements,sizeof(int)*(G[idx].size-1));
    G[idx].Dc = (float *)realloc(G[idx].Dc,sizeof(float)*(G[idx].size-1));
    G[idx].Elements[G[idx].size-2] = i;
    G[idx].Dc[G[idx].size-2] = temp;
    if(temp > G[idx].radius)
      G[idx].radius = temp;
  }

  //  for(i=0;i<20;i++)
  // fprintf(stderr,"S[%d]:%d ",i,*S[i].index);
  //getchar();

  for(i=0;i<j;i++) {
    // fprintf(stderr,"i:%d j:%d size:%d ",i,j,G[i].size);
    //fprintf(stderr,"\n");

    //for(lop=0;lop<G[i].size-1;lop++)
    // fprintf(stderr,"El[%d]:%d ",lop,G[i].Elements[lop]);
    //getchar();

    if(G[i].size > 2) {
      k = Median(i,G[i].Elements,G[i].size,S);
      
      Swap(S+G[i].Centroid,S+k);
      G[i].radius = 0;
      
      for(k=0;k<G[i].size-1;k++) {
	dis = Dist(S+G[i].Elements[k],S+G[i].Centroid);
	G[i].Dc[k] = dis;
	if(dis > G[i].radius)
	  G[i].radius = dis;
	
      }
    }
  }
  //  for(i=0;i<20;i++)
  // fprintf(stderr,"S[%d]:%d ",i,*S[i].index);
  //getchar();
}
