# From http://zguide.zeromq.org/py:taskwork
# Connects PULL socket to tcp://localhost:5557
# Collects workloads from manager via that socket
# Connects PUSH socket to tcp://localhost:5558
# Sends results to sink also in manager via that socket
#
# Author: Lev Givon <lev(at)columbia(dot)edu>
# Slightly modified by Dennis Shasha for voting and to put manager and sink
# in the same process.

import sys
import time
import zmq
import random

context = zmq.Context()

# Socket to receive messages on
receiver = context.socket(zmq.PULL)
receiver.connect("tcp://localhost:5557")

# Socket to send messages to
sender = context.socket(zmq.PUSH)
sender.connect("tcp://localhost:5558")

votenum = 0

# Process tasks forever
while True:
  votenum+= 1
  data = receiver.recv()
  fields = data.split(" ")
  # Simple progress indicator for the viewer
  vote = random.choice([' Hamilton', ' Burr'])
  print ("vote of worker "+ fields[-1]+ " is: "+ vote+ " for vote "+ str(votenum))
  print ()
  sys.stdout.flush()

  # Send results to sink
  sender.send(fields[-1] + vote)
