# http://zguide.zeromq.org/py:taskvent

# Task ventilator
# Binds PUSH socket to tcp://localhost:5557
# Sends batch of tasks to workers via that socket
#
# Author: Lev Givon <lev(at)columbia(dot)edu>
# Modified by Dennis Shasha so manager both pushes tasks and receives
# results before going on to the next phase.
# The number of workers is dynamic, but workers must all be running
# before you press enter.

import zmq
import random
import time

try:
    raw_input
except NameError:
    # Python 3
    raw_input = input

context = zmq.Context()

# Socket to send messages on
sender = context.socket(zmq.PUSH)
sender.bind("tcp://*:5557")

# Socket with direct access to the sink: used to syncronize start of batch
receiver = context.socket(zmq.PULL)
receiver.bind("tcp://*:5558")



print("Press Enter after the workers have been started: ")
_ = raw_input()
print("Sending tasks to workers")

numworkers = 2


# Send numworkers requests for votes
numvotes = 10
for i in range(numvotes):
  print (("This is vote number: ")+ str(i+1))
  for w in range(numworkers):
    sender.send_string('Please send your vote ' + str(w)) # it will send to workers in round-robin fashion

  numresponses = 0
  while numresponses < numworkers:
    time.sleep(1)
    data = receiver.recv()
    fields = data.split(" ")
    print (("Voter: ")+ fields[0]+ (" voted ")+ fields[1])
    numresponses+= 1


  # Give 0MQ time to deliver
  time.sleep(1)
