#!/usr/bin/env python
# Echo server program
import zmq
import sys
import random
import time
import os
import platform
import copy

# Calls are requestlist, mybid, requeststatus
# In each case, the server will receive a call and if that call is appropriate
# for this time, it will answer. Only after all clients have sent in their
# calls will the server go onto the next stage.
# The stages are requestlist, then a loop
# mybid requeststatus mybid requeststatus etc. until someone wins

port = "50018"
context = zmq.Context()
socket = context.socket(zmq.REP)
socket.bind("tcp://*:%s" % port)

bot = False #This will change the interface and a few sleep statements of the server, it has two settings
#one for bot play and one for manual play
numbidders = 2 #change this for how many bots you want to play with
HOST = 'localhost' #change this to your own IP address if you want to use it over LAN/Wifi

if platform.system() == 'Windows':
  os.system('cls')
if not bot:
  print ("Server initiated, waiting for players to connect.\n")
else:
  print ("Server initiated, waiting for bots to connect.\n")


bidderids = []
neededtowin = 3 # how many items each player needs to win
itemtypes = ['Picasso', 'Van_Gogh', 'Rembrandt', 'Da_Vinci'] # four different types
maxbudget = 100 # budget per player
won = {}
listtosend = str(numbidders) + ' '
typearray = []
i = 0
#Generate itemsinauction and string containing number of bidders and 
#items in auction list to send to the client
while(i < 200):
  x = itemtypes[int((len(itemtypes))*random.random())]
  typearray.append(x)
  listtosend = listtosend + x + ' '
  i+= 1

# distribute list to send to everyone
bidderids = []
readybidders = []
flag1 = True
#Outer loop waits until every client has been told that the socket is
#ready to receive bids
# stage: requestlist
while(numbidders > len(readybidders)):
  data = socket.recv()
  print (("1. data: "), data)
  request_bidder = data.split(" ")
  if (request_bidder[1] not in readybidders) and (request_bidder[0] == "requestlist"):
    readybidders.append(request_bidder[1])
    ret = (str(len(readybidders)-1) + " " + listtosend)
    assert(type(ret) is str)
    print (("Type of ret is: "), type(ret) )
    socket.send("%s " % (ret))
    print (("This is what was sent: "),     ret)
  else:
    ret = "Wait not ready"
    socket.send("%s " % (ret))


won['Picasso'] = {name: 0 for name in readybidders}
won['Van_Gogh'] = {name: 0 for name in readybidders}
won['Rembrandt'] = {name: 0 for name in readybidders}
won['Da_Vinci'] = {name: 0 for name in readybidders}
moneyspent = {name: 0 for name in readybidders}
players = readybidders
doneflag = 0 # will be done only if someone wins or goes over budget with money spent
j = 0
# Now we start a loop between mybid and requeststatus
while(0 == doneflag):
  if platform.system() == 'Windows':
    os.system('cls')
  else:
    os.system('clear')
  start = time.time()
  print ("Auction round", str(j+1) + ':')
  print ()
  if not bot:
    if j != 0:
      print (winnerid, "bought a", mytype, "for", bestbid)
      print ()
    print ("Current standings are:\n")
    for player in players:
      print (player + ':', {'money': 100-moneyspent[player], 'Picasso': won['Picasso'][player], "Rembrandt": won['Rembrandt'][player], "Da_Vinci": won['Da_Vinci'][player], "Van_Gogh": won['Van_Gogh'][player]})
    print ()
  mytype = typearray[j]
  print ("We are currently bidding for a", mytype + '.')
  print ()
  bidderids = []
  bids = []
  flag2 = True
  #Keep checking for bids until all are received
  # stage: mybid
  while(numbidders > len(bidderids)):
    data = socket.recv()
    print (("2. data: "), data)
    print (("bidderids: "), bidderids)
    request_bidder_amount = data.split(" ")
    if (request_bidder_amount[1] not in bidderids) and (request_bidder_amount[0] == 'mybid'):
      bidderids.append(request_bidder_amount[1])
      x = (int(request_bidder_amount[2]))
      if (x > (maxbudget - moneyspent[(request_bidder_amount[1])])):
        x = -1 # request_bidder_amount[1] is not allowed to bid over budget
      assert(request_bidder_amount[0] == 'mybid')
      bids.append(x)
      socket.send('bid received')
      print ("Bidder: ", request_bidder_amount[1] , " amount: ", request_bidder_amount[2])
      print ()
        # print "number of bids received is: ", len(bidderids)
    else:
      assert(request_bidder_amount[0] == 'requeststatus')
      socket.send('wait ')

  # Now have all the bids
  bestbid = max(bids)
  # print ("Best bid for step ", j, " is ", bestbid)
  # print "Here are the identifiers of the bidders " 
  # print bidderids
  # print "Here are the bids "
  # print bids
  #winnerid=bidderids[random.choice([x for x in range(len(bids)) if bids[x]==bestbid])]
  b = bids.index(bestbid)
  winnerid = bidderids[b]
  won[mytype][winnerid]+= 1
  moneyspent[winnerid]+= bestbid
  if bot:
    time.sleep(1.5)
    print ()
    print (winnerid+ " bought a "+ mytype+ " for "+ str(bestbid))
    print ()
    time.sleep(2)
    print ()
    print ("Current standings are:\n")
    for player in players:
      print (player + ':', {'money': 100-moneyspent[player], 'Picasso': won['Picasso'][player], "Rembrandt": won['Rembrandt'][player], "Da_Vinci": won['Da_Vinci'][player], "Van_Gogh": won['Van_Gogh'][player]}, "\n")
    print ()
    time.sleep(6)
  if (won[mytype][winnerid] >= neededtowin):
    doneflag = 1
    if platform.system() == 'Windows':
      os.system('cls')
    else:
      os.system('clear')
    print ("Current standings are:\n")
    for player in players:
      print (player + ':', {'money': 100-moneyspent[player], 'Picasso': won['Picasso'][player], "Rembrandt": won['Rembrandt'][player], "Da_Vinci": won['Da_Vinci'][player], "Van_Gogh": won['Van_Gogh'][player]}, "\n")
    print  (winnerid, "has won.")
    print ("Please close all child processes and this one")
  # Now receive requests for results
  print ("bidderids: ", bidderids)
  requestindexes = [] # which bidder indexes have made requeststatus calls
  # stage: requeststatus
  while(numbidders > len(requestindexes)):
    data = socket.recv()
    print (("3. data: "), data)
    request_bidder_amount = data.split(" ")
    myindex = readybidders.index(request_bidder_amount[1])
    print ("myindex: ", myindex)
    print ("1. requestindexes: ", requestindexes)
    if(myindex not in requestindexes) and (request_bidder_amount[0] == 'requeststatus'):
      requestindexes.append(myindex)
      print ("2. requestindexes: ", requestindexes)
      #receive results
      bestindex = readybidders.index(winnerid)
      if(doneflag == 1):
        socket.send(str(bestindex) + ' has bought ' + mytype + ' for ' + str(bestbid) + ' and won.')
      else:
        socket.send(str(bestindex) + ' has bought ' + mytype + ' for ' + str(bestbid))
    else:
      socket.send('wait')
  j+=1

time.sleep(40)
