from __future__ import print_function #I added this because it made my life a lot easier when
#the 'end = ...' function was added in the print function that I didn't know a nice way to do
#in Python 2.7, so print statements must all have brackets in this version, no need in the server though
# Echo client program
import random
import time
import os
import platform
import setupngrok


socket = setupngrok.socket

# APPLICATION


partnerid = -1 # no partner
numberbidders = 0 # will be given by server
artists = ['Picasso', 'Rembrandt', 'Van_Gogh', 'Da_Vinci']

dedicated_artist = None # artist we want and will focus on
num_we_have = 0 # the number of paintings we have of the dedicated_artist

def dedicated33then34then33Bidder(itemsinauction, winnerarray, winneramount, numberbidders, players, mybidderid, artists, standings, round):
  
  global dedicated_artist, num_we_have

  # Check if we won last round (we are "mybidderid")
  if round > 0 and mybidderid == winnerarray[round-1]:
    dedicated_artist = itemsinauction[round-1]
    num_we_have += 1 # If we won, then add one to the number of paintings we have
  
  if dedicated_artist != None:
      # If we have a dedicated artist we want, then we try to get that
    if itemsinauction[round] != dedicated_artist:
      # If there is a dedicated artist, but the painting being sold is not of the artist we want, skip
      return 0
    elif num_we_have == 1:
      # On our 2nd bid (when we already have 1 painting), we bid 34
      return 34 
    else: # If the painting is that of the dedicated artist, then we bid 33
      return 33
  
  # If there is no dedicated artist yet, then bid 33 regardless of which artist
  return 33

top_paintings = [] # list of top paintings we want

# Focus on top 2 paintings only
def twoOrThreeGroupBidderWithDiversity(itemsinauction, winnerarray, winneramount, numberbidders, players, mybidderid, artists, standings, round, number_target_for_paintings):
  global top_paintings

  # On the first round, we find the top 2 paintings we want
  if round == 0:
    counter = 0 #counter to find the top paintings
    # Find the top 2 paintings
    paintings_count = {artist: 0 for artist in artists}

    for item in itemsinauction: # Look through every item in the auction
      paintings_count[item] += 1 # add 1 to their count
      # number_target_for_paintings is a value when we reach, we consider the painting a top painting
      # for example, consider the items A, B, B, B, B, and we want the first to reach 4
      # then, we take B, because it is the first to reach 4
      if paintings_count[item] == number_target_for_paintings:  # first painting to reach four
        counter += 1
        top_paintings.append(item)
      if counter == 2: # if we got the top 2 paintings, stop the loop
        break
  
  current_item = itemsinauction[round] # what is being bid for in the current round
  money_left = standings[mybidderid]['money'] # how much money is left

  if current_item not in top_paintings: # do not bid if the current artist is not one of the top paintings we want
    return 0
  else:
    # If the current artist is one of the two top paintings, we bid
    if current_item == top_paintings[0]:
      num_we_need = 3-standings[mybidderid][current_item] # number of items we need to win
      # For the most top painting, we bid 33
      if standings[mybidderid][current_item] in [0,1]:
        if money_left < 33:
          # If we do not have enough money, then we divide equally
          return money_left//num_we_need
        return 33
      else:
        return money_left
    else:
      if standings[mybidderid][current_item] in [0,1]:
        # We bid randomly from 2 to 10 for our 2nd most wanted painting
        return 2+int(random.random() * 8)
      else:
        return money_left
	

def determinebid(itemsinauction, winnerarray, winneramount, numberbidders, players, mybidderid, artists, standings, round):
  # Depending on the number of bidders, we choose different bots
  if numberbidders >= 4:
    return dedicated33then34then33Bidder(itemsinauction, winnerarray, winneramount, numberbidders, players, mybidderid, artists, standings, round)
  elif numberbidders == 3:
    return twoOrThreeGroupBidderWithDiversity(itemsinauction, winnerarray, winneramount, numberbidders, players, mybidderid, artists, standings, round, 6)
  else: # for 1v1 (or numberbidders == 2)
    return twoOrThreeGroupBidderWithDiversity(itemsinauction, winnerarray, winneramount, numberbidders, players, mybidderid, artists, standings, round, 4)


# DATA

mybidderid = 'humaid_ali'
moneyleft = 100 # should change over time
winnerarray = [] # who won each round
winneramount = [] # how much they paid

itemsinauction = []
myTypes = {'Picasso': 0, 'Rembrandt': 0, 'Van_Gogh': 0, 'Da_Vinci': 0, 'money': moneyleft}

# EXECUTION

# get list of items and types
getlistflag = 1
socket.send((str(mybidderid)).encode())
while(getlistflag == 1):
  data = socket.recv(5024)
  x = (data.decode("utf-8")).split(" ")
  # print "Have received response at ", str(mybidderid), " of: ", ' '.join(x)
  #Receives first how many players are in the game and then all 200 items in auction
  if(x[0] != "Not" and len(data) != 0):
    getlistflag = 0
    numberbidders = int(x[0])
    itemsinauction = x[1:]
  else:
    time.sleep(2)

while True:
  socket.send((str(mybidderid) + ' ').encode())
  data = socket.recv(5024)
  x = (data.decode("utf-8")).split(" ")
  #Wait until everyone has connected before bidding
  if (x[0] == 'wait'):
    continue
  #When everyone has connected the server knows all names
  #it can therefore transfer all the names after telling the client that it's ready
  players = []
  for player in range(1, numberbidders + 1):
    players.append(x[player])
  break
#Create initial standings for each player after everyone connected
standings = {name: {'Picasso': 0, 'Van_Gogh': 0, 'Rembrandt': 0, 'Da_Vinci': 0, 'money': 100} for name in players}
# now do bids
continueflag = 1
j = 0
if platform.system() == 'Windows':
  os.system('cls')
else:
  os.system('clear')
while(continueflag == 1):
  #roundStart = time.time()
  print(random.choice(["I'm doing my best, okay?", "Why aren't you cheering louder?", "Aren't you proud of me?", "Damn I'm good, and I don't even have a brain!", "And do you think you could do any better?", "I feel like it's me doing all the work, you're just chilling in your chair", "If I lose this it's your fault not mine... I'm doing EXACTLY what you told me to do!"]))
  print()
  bidflag = 1
  bid = determinebid(itemsinauction, winnerarray, winneramount, numberbidders, players, mybidderid, artists, standings, len(winnerarray))
  #sleep before sending the bid to make sure the server is ready, currently it's at a very big value 1
  #this should make it safe for any speed of computers or internet, but can probably be lower as I have had
  #it working on Wifi with my computer at 0.2
  time.sleep(1)
  socket.send((str(mybidderid) + " " + str(bid)).encode())
  while(bidflag == 1):
    # print "Have sent data from ", str(mybidderid)
    data = socket.recv(5024)
    x = (data.decode("utf-8")).split(" ")
    # print "Have received response at ", str(mybidderid), " of: ", ' '.join(x)
    if(x[0] != "Not"):
      bidflag = 0
    else:
      print("exception")
      time.sleep(2)


  resultflag = 1
  while(resultflag == 1):
    socket.send((str(mybidderid)).encode())
    # print "Have sent data from ", str(mybidderid)
    data = socket.recv(5024)
    x = (data.decode("utf-8")).split(" ")
    #Wait for all bids to be received
    if (x[0] == 'wait'):
      continue
    # print "Have received response at ", str(mybidderid), " of: ", ' '.join(x)
    #Check if the server told client that game is finished
    if len(x) >= 7 and x[7] == 'won.':
      time.sleep(5)
      continueflag = 0
      resultflag = 0
      print(data)
      print()
      print('game over')
    #Else update standings, winnerarray etc.
    if(x[0] != "ready") and (continueflag == 1):
      #roundLength = time.time()-roundStart
      #time.sleep(max(0, 5-roundLength))
      resultflag = 0
      if platform.system() == 'Windows':
        os.system('cls')
      else:
        os.system('clear')
      # print x
      winnerarray.append(x[0])
      winneramount.append(int(x[5]))
      standings[x[0]]['money'] -= int(x[5])
      standings[x[0]][x[3]] += 1
      if (x[0] == mybidderid):
        moneyleft -= int(x[5])
        myTypes[itemsinauction[j]] += 1
      # update moneyleft, winnerarray
    else:
      time.sleep(2)
  j+= 1
