

from copy import deepcopy
from pprint import pprint
import zmq
import time
import random
     
p=0
v=0
d=0
r=0
counter=0
counterf=0
beton=""
strat=1
blocking=False
init_state = p, v, d, r, counter, beton, counterf, strat, blocking

def dennis_fmt(info):
    """
    converts info to Dennis' format
    itemsinauction is a list where at index "rd" the item in that round is being sold is displayed.
    winnerarray is a list where at index "rd" the winner of the item sold in that round is displayed.
    winneramount is a list where at index "rd" the amount of money paid for the item sold in that round is displayed.
    example: I will now construct a sentence that would be correct if you substituted the outputs of the lists:
    In round 5 winnerarray[4] bought itemsinauction[4] for winneramount[4] dirhams/dollars/money unit.
    numberbidders is an integer displaying the amount of people playing the auction game.
    players is a list containing all the names of the current players.
    mybidderid is a string that contains your name.
    artists is a list containing all the names of the artists (paintings) that are for sale in our auction.
    standings is a set of nested dictionaries (standings is a dictionary that for each person has another dictionary
    associated with them). standings[name][artist] will return how many paintings "artist" the player "name" currently has
    standings[name]['money'] (remember quotes for string, important!) returns how much money the player "name" has left.
    If you want to access information about yourself use standings[mybidderid][(name of artist)/'money']
    rd is the current round in 0 based indexing.
    """
    itemsinauction = info["items"]
    winnerarray = [x["player"] for x in info["history"]]
    winneramount = [x["bid"] for x in info["history"]]
    numberbidders = len(info["others"]) + 1
    all_p = info["others"] + [info["self"]]
    players = [p["name"] for p in all_p]
    mybidderid = info["self"]["name"]
    artists = info["item_types"]
    standings = []
    for p in all_p:
        d1 = {artist: p["item_count"][artist] for artist in artists}
        d1.update({"money": p["budget"]})
        standings.append(d1)
    rd = info["cur_round"]
    return (
        itemsinauction,
        winnerarray,
        winneramount,
        numberbidders,
        players,
        mybidderid,
        artists,
        standings,
        rd,
    )
def compute_bid_state(info,  prev_state=None):
    if prev_state is None:
        prev_state = deepcopy(init_state)
    p,v,d,r,counter,beton, counterf,strat, blocking= prev_state
    """
    TODO: complete this function to determine the best bid.
    >>> compute_bid(sample_info)
    2
    """
    # convert info to Dennis' format
    # you are free to apply further preprocessing to make your life easier
    (
        itemsinauction,
        winnerarray,
        winneramount,
        numberbidders,
        players,
        mybidderid,
        artists,
        standings,
        rd,
    ) = dennis_fmt(info)
    def calcNumPaint(itemsinauction):
        nonlocal v,p,r,d,beton,counter
        i=rd
        p=info["self"]["item_count"]["Picasso"]
        r=info["self"]["item_count"]["Rembrandt"]
        d=info["self"]["item_count"]["Da_Vinci"]
        v=info["self"]["item_count"]["Van_Gogh"]
        while v<3 and p<3 and r<3 and d<3:
            if itemsinauction[i]=="Picasso":
                p=p+1
            elif itemsinauction[i]=="Van_Gogh":
                v=v+1
            elif itemsinauction[i]=="Rembrandt":
                r=r+1
            elif itemsinauction[i]=="Da_Vinci":
                d=d+1
            i=i+1
        if p==3:
            beton="Picasso"
        if d==3:
            beton="Da_Vinci"
        if r==3:
            beton="Rembrandt"
        if v==3:
            beton="Van_Gogh"
        counter=counter+1       
    bid = 0
    if numberbidders>2:
        if counter==0 or counterf>info["self"]["item_count"][beton]:
            calcNumPaint(itemsinauction)
            #print("Final--",beton, " is what i choose")
            #print("")
            counterf=info["self"]["item_count"][beton]
        if itemsinauction[rd]==beton:
            #print("")
            #print("Final--i own ",info["self"]["item_count"][beton], " of ", beton)
            #print("")
            if (info["self"]["item_count"][beton])==0:
                
                bid=round((info["self"]["budget"])/3)
                counterf=counterf+1
            elif (info["self"]["item_count"][beton])==1:
                bid=round((info["self"]["budget"])/2)
                counterf=counterf+1
            elif (info["self"]["item_count"][beton])==2:
                bid= (info["self"]["budget"])
                counterf=counterf+1
            else:
                bid=0
    if numberbidders==2:
        if counter==0:
            calcNumPaint(itemsinauction)
            #print("Final--",beton, " is what i choose")
            #print("")
        elif counterf>(info["self"]["item_count"][beton]):
            calcNumPaint(itemsinauction)
            #print("Final--",beton, " is what i choose")
            #print("")
            counterf=info["self"]["item_count"][beton]   
        if itemsinauction[rd]==beton:
            #print("")
            #print("Final--i own ",info["self"]["item_count"][beton], " of ", beton)
            #print("")
            if (info["self"]["item_count"][beton])==0:
                bid=round((info["self"]["budget"])/3)
                counterf=counterf+1
            elif (info["self"]["item_count"][beton])==1:
                bid=round((info["self"]["budget"])/2)
                counterf=counterf+1
            elif (info["self"]["item_count"][beton])==2:
                bid= (info["self"]["budget"])
                counterf=counterf+1
            else:
                bid=0
        for player in info["others"]:
            pnum=player["item_count"]["Picasso"]
            vnum=player["item_count"]["Van_Gogh"]
            rnum=player["item_count"]["Rembrandt"]
            dnum=player["item_count"]["Da_Vinci"]
            if pnum==2:
                if itemsinauction[rd]=="Picasso":
                    bid=player["budget"]+1
            if vnum==2:
                if itemsinauction[rd]=="Van_Gogh":
                    bid=player["budget"]+1
            if rnum==2:
                if itemsinauction[rd]=="Rembrandt":
                    bid=player["budget"]+1
            if dnum==2:
                if itemsinauction[rd]=="Da_Vinci":
                    bid=player["budget"]+1
    #print(f"Final--bidding ${bid} for a", info["items"][rd]) 
    next_state=p,v,d,r,counter,beton,counterf,strat,blocking
    return bid, next_state

