n: 1000000;
stocks: `ibm`hp`amaz`goog`aapl;
rantrade:([]stock: n?stocks; price: 20 + n?380.0;amount: 100*(1+n?1000);
  time: 10:00:00.000 + n?06:00:00.000);

"select avg price from rantrade where amount=1300"
\t select avg price from rantrade where amount=1300
"select avg amount from rantrade where price=50"
\t select avg amount from rantrade where price=50
"Note that searching through integers is better than searching through floats"
"Set up grouping on amount; this is like a non-clustering index "
" in a relational database"
@[`rantrade;`amount;`g#]
show meta rantrade
"select avg price from rantrade where amount=1400"
\t select avg price from rantrade where amount=1400
"select avg amount from rantrade where price=50"
\t select avg amount from rantrade where price=50
"Set up grouping on price as well; takes longer"
@[`rantrade;`price;`g#]
show meta rantrade
"select avg amount from rantrade where price=50"
\t select avg amount from rantrade where price=50
"select avg price from rantrade where amount=1400"
\t select avg price from rantrade where amount=1400


"select avg price from rantrade where stock=`aapl"
\t select avg price from rantrade where stock=`aapl

"How to improve queries that use like"
"select avg price from rantrade where stock like \"a*\""
\t select avg price from rantrade where stock like "a*"
"second time: select avg price from rantrade where stock like \"a*\""
\t select avg price from rantrade where stock like "a*"
@[`rantrade;`stock;`g#]
"after grouping select avg price from rantrade where stock like \"a*\""
\t select avg price from rantrade where stock like "a*"
/ "try with a side table; add up the following:"
/ g: group exec stock from rantrade
/ indtable:([stockname: key g] indices: value g)
/ \t x: exec from indtable where stockname like "a*"
/ \t myind: raze x[`indices]
/ \t avg rantrade.price[myind]
/ "stop adding"
\t tmp: select stock, amount, price from rantrade where amount = 12100
\t tmp2: select amount from rantrade where amount = 12100

/ "Alternative is to group the entire table by stock and then query"
/ rantradegrouped: select by stock from rantrade
/ x: select from rantradegrouped where stock like "a*"

rantrade2: rantrade
"part on stock (like clustering in sybase/iot in oracle)"
\t @[`stock xasc `rantrade;`stock;`p#]
`stock xasc `rantrade2
"part on stock after sorting is faster"
\t @[`rantrade2;`stock;`p#]
"after parting select avg price from rantrade where stock like \"a*\""
\t select avg price from rantrade where stock like "a*"
@[`rantrade2;`amount;`g#]
show meta rantrade2



/ Note that by parting, you lose the benefit of the grouping on amount.
/ "group on stock"
/ @[`rantrade;`stock;`g#]
show meta rantrade
"select avg price from rantrade where amount=1400"
\t select avg price from rantrade where amount=1400
"select avg price from rantrade where stock=`aapl"
\t select avg price from rantrade where stock=`aapl
"select avg amount from rantrade where stock=`aapl and price > 50"
\t select avg amount from rantrade where (stock=`aapl) and (price > 50)
"select avg amount from rantrade where stock=`aapl, price > 50"
\t select avg amount from rantrade where stock=`aapl, price > 50
"select avg amount from rantrade where price > 50,stock = `aapl"
\t select avg amount from rantrade where price > 50, stock=`aapl



"The equivalent in q of the having clause in sql is fby."
"Just as having permits the testing of aggregates over groups, so does fby"
" Here we want to find stocks whose average trade contains at least 200 shares"

"One query with fby"
\t select distinct stock from rantrade where 200 < (avg;amount) fby stock


"The alternative is to use two queries (add up these times)."
\t intermed: select a: avg amount by stock from rantrade 
\t select stock from intermed where a > 200

"In the preceding example, two queries is better, but if you don't ."
"like the idea of creating a temporary table, then..."
\t select stock from(select avg amount by stock from rantrade)where amount>200

"And here is even a better way (thanks to Arthur Whitney)"
\t where 200<exec avg amount by stock from rantrade


"find stocks that have the highest price for their amount"
select stock, max(price) by amount from rantrade
