/ Monte Carlo for an arbitrary number of years.
/ Basic algorithm:
/ Keep as the state the number of instances of each commulative interest
/ rate up to this point as well as the very last interest rate.
/ Then, when sampling, do a weighted sample depending on the number.
/ So, the state will be (numinstance; cumulativeinterest; lastinterest)
/ To update this, we will take the state and cross that with the
/ interest movement possibilities, then compute the cumulative interest
/ and last interest and group and combine number of instances.



/ states are triples
/ sort the states based on their cumulative interest rates
/ and then get the number in each case and then get running sums
/ of multiplicities
evalmedold:{[mystate]
 totscenarios: sum mystate[;0];
 allcumuls: (asc mystate[;1]),'sums (mystate[iasc mystate[;1];0]);
 i25: allcumuls[;1] bin (floor 0.25 * totscenarios);
 i50: allcumuls[;1] bin (floor 0.50 * totscenarios);
 i75: allcumuls[;1] bin (floor 0.75 * totscenarios);
 (allcumuls[i50]; allcumuls[i75]; allcumuls[i25]) }

evalmed:{[mystate]
 totscenarios: sum mystate[;0];
 4 + `x;
 allcumuls: (asc mystate[;1]),'sums (mystate[iasc mystate[;1];0]);
 i25: allcumuls[;1] bin (floor 0.25 * totscenarios);
 i50: allcumuls[;1] bin (floor 0.50 * totscenarios);
 i75: allcumuls[;1] bin (floor 0.75 * totscenarios);
 (allcumuls[i50]; allcumuls[i75]; allcumuls[i25]) }
 
 
 
 

/ Weighted sample: e.g. if I have 5 instances of scenario A and 
/ 50 instances of scenario B, then I take the running sum of the number
/ of instances and I use bin to find the scenario.
/ Find the median of the net interest rates
/ over n years assuming the current interest rate is curintrate
/ and each year it can go up or down by increment or stay the same.
monte:{[n; curintrate; increment]
 x: (0; increment%100; neg (increment%100));
 mystate: enlist (1; 1 + (curintrate%100) + x[0]; (curintrate%100) + x[0]); 
 mystate,: enlist (1; 1 + (curintrate%100) + x[1]; (curintrate%100) + x[1]); 
 mystate,: enlist (1; 1 + (curintrate%100) + x[2]; (curintrate%100) + x[2]); 
	/ num instances, cumulative multiplier, last interest
 i: 0;
 while[i < (n-1); / n-1 because have already taken care of year 1
   j: 0;
   newstate: ();
   while[j < count mystate;
     lastint: mystate[j;2];
     nextint: lastint+x[0];
     newstate,: enlist (mystate[j;0]; mystate[j;1]*(1+nextint);nextint);
     nextint: lastint+x[1];
     newstate,: enlist (mystate[j;0]; mystate[j;1]*(1+nextint);nextint);
     nextint: lastint+x[2];
     newstate,: enlist (mystate[j;0]; mystate[j;1]*(1+nextint);nextint);
     j+: 1;
   ];
   g: group (newstate[;1]),'(newstate[;2]); / cumulative multiplier and last int
		/ all scenarios leading to same cumulative multiplier 
		/ and same last interest rate  are equivalent scenarios
   multiplicities: sum each newstate[;0][value g]; / how many of each
	/ equivalent class are there.
   mystate: multiplicities,'((key g)[;0]),'((key g)[;1]);
   / mystate: newstate; / this skips the multiplicities -- simpler but slower
   i+: 1;
 ];
 evalmed[mystate]}



/ EXECUTION

nums: "F"$ .z.x
monte[floor nums[0]; nums[1]; nums[2]]
