#!/usr/bin/env python
#

# past first person: d h b tu
# past second person masc: d h b ta
# past second person fem: d h b ti
# past third person masc: d h b
# past third person fem: d h b t
# past first person plural: d h b n a
# past second person plural: d h b t n
# past third person plural: d h b u

# present first person: a d h b 
# present second person masc: t d h b 
# present second person fem: t d h b in
# present third person masc: ya d h b
# present third person fem: t d h b 
# present first person plural: n d h b 
# present second person plural: t d h b un
# present third person plural: ya d h b un

########
# Arabic Script import part
## I have implemented script lookup for characters in the start of word..
## YOU HAVE TO IMPLEMENT THE MIDDLE AND END CHARACTER CASES. 
## Hint: Make different dictionaries for different positions and then use them
## You can find the characters at "http://en.wikipedia.org/wiki/Arabic_script_in_Unicode#Contextual_forms"
## YOU have to convert the Hex (e.g. 0x6240) to decimal number..just google hex to decimal...
## Look "arabicscript" file for reference...
import unicodedata
myscript={'a':'1571','b': '1576'}
script=open("arabicscript","r")
scripttext =script.readlines()
script.close()
for line in scripttext:
	arr_script=line.split(" ")
	myscript[arr_script[0]]=arr_script[1]
###########

##Suffix and Prefix lookups. YOU have to add all that are shown in comments above
suffixconjugation= {'pastfirstpersonsingular': 'tu', 'pastsecondpersonmasc': 'ta', 'presentfirstperson' : ''}
prefixconjugation = {'presentfirstperson' : 'a'}

#########

## Getting arabic root from the file, YOU have to add more roots to the file "arabicdictionary.txt"
mydictionary = {'go' : 'dhb', 'ir' : 'dhb', 'read' : 'qr', 'leer' : 'qr'}
dictionaryfile = open("arabicdictionary.txt","r")
text = dictionaryfile.readlines()
#print text
dictionaryfile.close()
for line in text:
	arr = line.split("=")
	#print arr
	mydictionary[arr[0]] = arr[1]
##print mydictionary

###################

## getting User input and then using it
ineng = input ("Please give me a root followed by a conjugation e.g., 'go past second person masc'. ")
mywords = ineng.split(" ")
# print mywords
root1 = mydictionary[mywords[0]] # Getting arabic root from the array we made above
root1=root1.strip() # Don't worry about it
#print root1
root=root1.replace(" ","") # and this too
#print root
## YOU add suffix and prefix and print the word
if(mywords[1] == 'past'):
	word = root + suffixconjugation[''.join(mywords[1:])]
	print(word)	
else:
	print(prefixconjugation[''.join(mywords[1:])] + root + suffixconjugation[''.join(mywords[1:])])

###########

### Printing Arabic Script
## I am just doing the suffix part and YOU have to add the prefix part
## and also take into consideration what is the location of character you are printing:
## the start, middle or end of word
### Adding Suffix after root
suff= suffixconjugation[''.join(mywords[1:])] # length of suffix, YOU have to add the prefix part
lets = []
tmp = root1.split(" ")
for x in tmp:
   lets.append(x) 
tmp = list(suff) 
for x in tmp:
   lets.append(x)
##### YOU can do the same for Prefix but you have to add your prefix before the root
#print lets
arabic=''
for x in lets:
	abc = myscript[x]
	abc=abc.strip()
	arabic+= chr(int(abc))
print(arabic)

