import getData
import analysisFunctions
import itertools



#Each stimulus is a dictionary containing two values. 'control' and 'stimulus'. Control is the 300 frames before the stimulus starts and stimulus is the 300 frames after.
odor,airpuff,sound=getData.get('load_data/raw_fluorescence.txt')

#print odor['stimulus'][1]


def neuronAnalysis(before,after):
	return analysisFunctions.neuronAnalysis([before,after])

odorPVals=[]
airpuffPVals=[]
soundPVals=[]
for x in range(300):
	odorPVals.append(neuronAnalysis(odor['control'][x],odor['stimulus'][x]))
	airpuffPVals.append(neuronAnalysis(airpuff['control'][x],airpuff['stimulus'][x]))
	soundPVals.append(neuronAnalysis(sound['control'][x],sound['stimulus'][x]))



f=open("pvalues.txt",'w')
f.write("odor,airpuff,sound\n")
for x in range(300):
	f.write(str(odorPVals[x])+","+str(airpuffPVals[x])+","+str(soundPVals[x])+"\n")
f.close()
#combos=list(itertools.combinations(range(300), 2))


