/*
  Programmed by James Kelleher
  Created by James Kelleher, Danya Degen, and Dennis Shasha
  
  Make hint system more robust – explain WHY they are getting
  closer or farther.  Furthermore, reward getting correct
  letter in wrong place.
  
  Change dots to boxes, then change numbers of
  letters needed.
  
  Identify glitches with particular quiz options
*/

// set something to testvar in order to display it to the screen
var testvar;

//sets the gamemode
var mode = 0;

var tileHeight;

var keyPass;

var fatChar  = "\u064E";
var damChar  = "\u064F";
var kasChar  = "\u0650";
var sukChar  = "\u0652";
var shadChar = "\u0651";

//tile images
PImage alif = null, alifHam = null, alifMak = null, ayn = null, beh = null, daad = null, daal = null, damma = null, dhaal = null, fatha = null, feh = null, ghayn = null, haa = null, hay = null, jeem = null, kaf = null, kasra = null, khaa = null, laam = null, miim = null, nuun = null, qaaf = null, raa = null, saad = null, seen = null, shadda = null, shin = null, sukun = null, taah = null, teh = null, thaa = null, theh = null, waaw = null, waawHam = null, yaa = null, zay = null;

//font var
PFont f = loadFont("Arial");

//contains tiles for root
var root = new Array(null, null, null);
//tiles that the player will manipulate
var tiles = new Array();
//diacritical mark tiles
var diacrits = new Array();

//translating hashmap
var trans = new HashMap();

//translating hashmap
var images = new HashMap();

var xOffset = 0;
var yOffset = 0;
var lockedTile = null;

var txt = "", answer = null;
var chars = new Array();
var vowChars = new Array();
var shadChars = new Array();

var ansChars = new Array();
var ansVowChars = new Array();
var ansShadChars = new Array();

//array to contain the text file
var txtfile = null;
//array to contain the mode's unique characters
var modChars = new Array();

var oldDist = -1;
var currDist = -1;

/* @pjs preload="images/alif.png,images/alifHamsa.png,images/alifMaksura.png,images/ayn.png,images/beh.png,images/daad.png,images/daal.png,images/damma.png,images/dhaal.png,images/fatha.png,images/feh.png,images/ghayn.png,images/haa.png,images/hay.png,images/jeem.png,images/kaf.png,images/kasra.png,images/khaa.png,images/laam.png,images/miim.png,images/nuun.png,images/qaaf.png,images/raa.png,images/saad.png,images/seen.png,images/shadda.png,images/shin.png,images/sukun.png,images/taah.png,images/teh.png,images/thaa.png,images/theh.png,images/waaw.png,images/waawHamsa.png,images/yaa.png,images/zay.png"; */

void setup() {
  testvar = "";
  fill(0);
  size(900, 700);

  tileHeight = height*16/20;

  frameRate(30);
  
  textFont(f, 32);
  textAlign(CENTER);

  imageMode(CENTER);
  
  rectMode(CENTER);


  //load images to variables
  alif = loadImage("images/alif.png");
  alifHam = loadImage("images/alifHamsa.png");
  alifMak = loadImage("images/alifMaksura.png");
  ayn = loadImage("images/ayn.png");
  beh = loadImage("images/beh.png");
  daad = loadImage("images/daad.png");
  daal = loadImage("images/daal.png");
  damma = loadImage("images/damma.png");
  dhaal = loadImage("images/dhaal.png");
  fatha = loadImage("images/fatha.png");
  feh = loadImage("images/feh.png");
  ghayn = loadImage("images/ghayn.png");
  haa = loadImage("images/haa.png");
  hay = loadImage("images/hay.png");
  jeem = loadImage("images/jeem.png");
  kaf = loadImage("images/kaf.png");
  kasra = loadImage("images/kasra.png");
  khaa = loadImage("images/khaa.png");
  laam = loadImage("images/laam.png");
  miim = loadImage("images/miim.png");
  nuun = loadImage("images/nuun.png");
  qaaf = loadImage("images/qaaf.png");
  raa = loadImage("images/raa.png");
  saad = loadImage("images/saad.png");
  seen = loadImage("images/seen.png");
  shadda = loadImage("images/shadda.png");
  shin = loadImage("images/shin.png");
  sukun = loadImage("images/sukun.png");
  taah = loadImage("images/taah.png");
  taaDam = loadImage("taaDam.png");
  taaFat = loadImage("taaFat.png");
  taaKas = loadImage("taaKas.png");
  taaReg = loadImage("taaReg.png");
  taaSuk = loadImage("taaSuk.png");
  teh = loadImage("images/teh.png");
  thaa = loadImage("images/thaa.png");
  theh = loadImage("images/theh.png");
  waaw = loadImage("images/waaw.png");
  waawHam = loadImage("images/waawHamsa.png");
  yaa = loadImage("images/yaa.png");
  zay = loadImage("images/zay.png");

  //maps unicode letter to image    
  images.put("ا", alif);
  images.put("أ", alifHam);
  images.put("ئ", alifMak);
  images.put("ع", ayn);
  images.put("ب", beh);
  images.put("ض", daad);
  images.put("د", daal);
  images.put("ُ", damma);
  images.put("ز", dhaal);
  images.put("َ", fatha);
  images.put("ف", feh);
  images.put("غ", ghayn);
  images.put("ح", haa);
  images.put("ه", hay);
  images.put("ج", jeem);
  images.put("ك", kaf);
  images.put("ِ", kasra);
  images.put("خ", khaa);
  images.put("ل", laam);
  images.put("م", miim);
  images.put("ن", nuun);
  images.put("ق", qaaf);
  images.put("ر", raa);
  images.put("ص", saad);
  images.put("ّ", shadda);
  images.put("ش", shin);
  images.put("س", seen);
  images.put("ْ", sukun);
  images.put("ط", taah);
  images.put("ت", teh);
  images.put("ظ", thaa);
  images.put("ث", theh);
  images.put("و", waaw);
  images.put("ؤ", waawHam);
  images.put("ي", yaa);
  images.put("ز", zay);   

  var i = 0; 
  
  tiles = new Array();
}

void draw() {   
  fill(0);  
  //text(currDist, width/2, height/2);

  if (mode == 0) {
    background(255);
    text("Arabic Language Processing Game", width/2, height * 2/7);
    textFont(f, 26);
    text("Created by James Kelleher, Danya Degen, and Dennis Shasha", width/2, height * 3/7);
    text("Press Return to Begin", width/2, height * 6/7);
    text("(Click the window if nothing is happening)", width/2, height * 6/7 + 34);
    textFont(f, 32);
    if (keyPressed && key == ENTER) {
      background(255);
      mode = -1;
    }
  }
  
  //quiz mode
  if (mode == 1) {
    background(255);
    text("Quiz Mode", width/2, height * 1/9);
    displayRoot();
    displayTiles();
    displayDiacrits();
    getArabicString();
    prompt();
    if (keyPressed && key == '2') {
      mode = 3;
    }
  }

  //discovery mode
  else if (mode == 2) {
    background(255);
    textFont(f, 24);
    text("Discovery Mode", width/2, height * 1/9 - 20);
    textFont(f, 32);
    displayRoot();
    displayTiles();
    displayDiacrits();
    getArabicString();
    printAndTranslate();
    if (keyPressed && key == '1') {
      mode = 1;
      resetQuiz();
    }
    if (keyPressed && key == 'r'  && keyPass == true) {
      mode = 3;
      keyPass = false;
    }
  }

  // used for resetting discovery mode
  else if (mode == 3) {
    resetDisc();
    mode = 2;
  }
  
  // select root family
  else if (mode == -1) {
    background(255);
    text("Please Select a Verb Family", width/2, height * 1/9 - 20);

    textAlign(LEFT);
    rectMode(CORNER);
    
    if ( mouseInBounds(width * 1/9 - 3, 165, width * 1/9 + 217, 215) ) {
      fill(100);
      rect(width * 1/9 - 3, 165, 220, 50);
      fill(255);
      text("1. Gather: ج م ع", width * 1/9, 200);
    }
    else {
      fill(255);
      rect(width * 1/9 - 3, 165, 220, 50);
      fill(0);
      text("1. Gather: ج م ع", width * 1/9, 200);
    }
    
    if ( mouseInBounds(width * 1/9 - 3, 240, width * 1/9 + 217, 290) ) {
      fill(100);
      rect(width * 1/9 - 3, 240, 220, 50);
      fill(255);
      text("2. Leave: خ ر ج", width * 1/9, 275);
    }
    else {
      fill(255);
      rect(width * 1/9 - 3, 240, 220, 50);
      fill(0);
      text("2. Leave: خ ر ج", width * 1/9, 275);
    }
    
    if ( mouseInBounds(width * 1/9 - 3, 315, width * 1/9 + 217, 365) ) {
      fill(100);
      rect(width * 1/9 - 3, 315, 220, 50);
      fill(255);
      text("3. Study: د ر س", width * 1/9, 350);
    }
    else {
      fill(255);
      rect(width * 1/9 - 3, 315, 220, 50);
      fill(0);
      text("3. Study: د ر س", width * 1/9, 350);
    }
    
    if ( mouseInBounds(width * 1/9 - 3, 390, width * 1/9 + 217, 440) ) {
      fill(100);
      rect(width * 1/9 - 3, 390, 220, 50);
      fill(255);
      text("4. Work: ع م ل", width * 1/9, 425);
    }
    else {
      fill(255);
      rect(width * 1/9 - 3, 390, 220, 50);
      fill(0);
      text("4. Work: ع م ل", width * 1/9, 425);
    }
    
    textAlign(CENTER);
    rectMode(CENTER);
    fill(0);
    
    if (mousePressed) {
      if ( mouseInBounds(width * 1/9 - 3, 165, width * 1/9 + 217, 215) ) {
        initialize("gather-final.txt");
        tiles.length = 0;
        diacrits.length = 0;
        mode = 1;
        resetQuiz();
      }
      else if ( mouseInBounds(width * 1/9 - 3, 240, width * 1/9 + 217, 290) ) {
        initialize("leave-final.txt");
        tiles.length = 0;
        diacrits.length = 0;
        mode = 1;
        resetQuiz();
      }
      else if ( mouseInBounds(width * 1/9 - 3, 315, width * 1/9 + 217, 365) ) {
        initialize("study-final.txt");
        tiles.length = 0;
        diacrits.length = 0;
        mode = 1;
        resetQuiz();   
      }
      else if ( mouseInBounds(width * 1/9 - 3, 390, width * 1/9 + 217, 440) ) {
        initialize("work-final.txt");
        tiles.length = 0;
        diacrits.length = 0;
        mode = 1;
        resetQuiz();
      }
    }
  }
  if (mode > 0) displayButton();
  text(testvar, width/2, height/2 + 100);
}

// set-up
function initialize(var i) {
    var t = loadStrings(i);
    txtfile = t;

    var m = txtfile[1].split("\u060C");
    modChars = m;
    
    var rootChars = txtfile[0].split("\u060C");
    root[0] = images.get(rootChars[0]);
    root[1] = images.get(rootChars[1]);
    root[2] = images.get(rootChars[2]); 

    //initialize the root array
    chars[0] = " ";
    chars[1] = " ";
    chars[2] = " ";
    chars[3] = rootChars[0];
    chars[4] = rootChars[1];
    chars[5] = rootChars[2];
    chars[6] = " ";
    chars[7] = " ";
    chars[8] = " ";
    
    //intialize the diacritical arrays
    for (i = 0; i < chars.length; i++) {
      vowChars[i]  = " ";
      shadChars[i] = " ";
    }
    
    trans.put(txtfile[2], txtfile[3]);
    
    
    for (i = 7; i < txtfile.length; i+=6) {
      trans.put(txtfile[i], txtfile[i+2]);
      var vowArray = txtfile[i-2].split("\u060C");
      var j = 0;
      while (vowArray[j].equals("")) j++;
      var k = vowArray.length - 1 - j;
      var noDiacrits = txtfile[i-3].replace("\u060C", "");
      var txtFinal = noDiacrits.substring(0, k+1) + vowArray[j] + noDiacrits.substring(k+1, noDiacrits.length);
      trans.put(txtFinal, txtfile[i+2]);
    }
  }

// displays the root as images, not tiles
public void displayRoot() {
  image(root[0], width/2 + 100, height*6/20, 100, 150);
  image(root[1], width/2 +  0, height*6/20, 100, 150);
  image(root[2], width/2 - 100, height*6/20, 100, 150);
}

// draw all moveable tiles
public void displayTiles() {
  var i;

  fill(112);
  for (i = 0; i < chars.length; i++) {
    if (chars[i].equals(" "))
      ellipse(width/2 + 400 - (100 * i), height*6/20, 25, 25);
  }
  fill(0);

  for (i = 0; i < tiles.length; i++) {
    image(tiles[i].img, tiles[i].posX, tiles[i].posY, 100, 150);
  }
  for (i = 0; i < diacrits.length(); i++) {
    image(diacrits[i].img, diacrits[i].posX, diacrits[i].posY, 100, 100);
  }
}

// check if mouse in given bounds
function mouseInBounds(var xMin, var yMin, var xMax, var yMax) {
  if (mouseX >= xMin && mouseX <= xMax && mouseY >= yMin && mouseY <= yMax) return true;
  else return false;
}

// draw the diacriticals – note that these are images, not tiles
// the tiles are generated using the location of the mouse when clicked
function displayDiacrits() { 
  image(fatha,  width/2 - 200, height - 50, 100, 100);
  image(kasra,  width/2 - 100, height - 25, 100, 100);
  image(damma,  width/2 +   0, height - 50, 100, 100);
  image(sukun,  width/2 + 100, height - 50, 100, 100);
  image(shadda, width/2 + 200, height - 50, 100, 100);
}

// handles the "Change Verb" button
function displayButton() {
  if (mouseX >= width - 145 &&
      mouseX <= width - 35  &&
      mouseY >= 25 &&
      mouseY <= 62) {
        fill(100);
        rect(width - 91, height * 1/9 - 29, 111, 32);
        fill(255);
        textFont(f, 18);
        text("Change Verb", width-90, height * 1/9 - 21);
        textFont(f, 32);
        fill(0);
  }
  else {
    fill(255);
    rect(width - 91, height * 1/9 - 29, 111, 32);
    fill(0);
    textFont(f, 18);
    text("Change Verb", width-90, height * 1/9 - 21);
    textFont(f, 32);
  } 
}

//get the string of Arabic letters
public void getArabicString() {
  //set txt to be the string of all characters in the array
  txt = "";
  for (var i = 0; i < chars.length; i++) {
    txt = txt + chars[i] + vowChars[i] + shadChars[i];
  }
}


//prints Arabic and English strings
public void printAndTranslate() {
  var pInput = getProcessedInput();
  text(pInput, width/2, height*9/20);
  engTrans = trans.get(pInput);
  if (engTrans != null) {
    text(engTrans, width/2, height*11/20);
    text("drag the tiles to the spaces to form words", width/2, height*12/20);
  }
  else {
    text("drag the tiles to the spaces to form words", width/2, height*12/20);
  }
}

// needed for checking the "distance"
function getOffset() {
  var theRoot = txt[3] + txt[4] + txt[5];
  var ansSubString;
  for (int i = 0; i < answer.length; i++) {
    ansSubString = ansChars[i] + ansChars[i+1] + ansChars[i+2];
    if (theRoot.equals(ansSubString)) break;
  }
  
  var offset = 3 - i;
  if (offset < 0) offset = 0;
  return offset;
}

// returns a version of the input where spaces on either end are replaced with empty strings
function getProcessedInput() {
  var output = "";
  for (int i = 0; i < txt.length; i++) {
    if (!txt[i].equals(" ")) output += txt[i];
  }
  
  return output;
}

// prompts the user for the answer and evaluates
public void prompt() {
  var pInput = getProcessedInput();
  text(pInput, width/2, height*9/20);
  text("please enter: " + trans.get(answer), width/2, height*11/20);
  if (!pInput.equals(chars[3] + chars[4] + chars[5])) {
    // check for complete correctness
    if (currDist == 0) {
      text("correct! press enter to reset", width/2, height*11/20 + 48);
      if (keyPressed && key == ENTER) {
        resetQuiz();
      }
    }
    else {
      // the next few dozen lines are used to check for partial completion
      // (aka, the consonants are all correct, and the final vowel is in place)
      var ansConsString = getConsString(answer);
      var inputConsString = getConsString(pInput);
      if (ansConsString.equals(inputConsString)) {
        //final vowel check
        int numVowels = 0;
        // see how many vowels have been entered
        for (i = 0; i < vowChars.length; i++) {
          if (!vowChars[i].equals(" ")) numVowels++;
        }
        i = chars.length - 1;
        while (i >= 0 && ansChars[i].equals(" ")) {
          i--;
        }
        i = vowChars.length - 1 - i;
        if (ansVowChars[i].equals(" ")) numVowels++;  

      
        if (numVowels == 1 && 
            ansVowChars[i].equals(vowChars[chars.length - i - 1])) {
          text("correct! feel free to keep filling in vowels\nor press enter to continue", width/2, height*11/20 + 48);
          if (keyPressed && key == ENTER) {
            resetQuiz();
          }
          return;
        }
        else if (numVowels == 0) text("you've got the consonants:\nnow time for the final vowel", width/2, height*11/20 + 48);
        else if (currDist < oldDist) text("you're getting closer to fully voweled – good job!", width/2, height*11/20 + 96);
        else text("that doesn't get you any closer to fully voweled", width/2, height*11/20 + 96);
      }
      else if (currDist < oldDist) {
        text("you're getting closer", width/2, height*11/20 + 48);
      }
      else {
        text("that move doesn't bring you closer", width/2, height*11/20 + 48);
      }
    }
  }
}

//gets some arabic string, and strips diacritical marks
function getConsString(var str) {
  var output = "";
  for (var i = 0; i < str.length; i++) {
    if (!str[i].equals(damChar) &&
      !str[i].equals(fatChar) &&
      !str[i].equals(kasChar) &&
      !str[i].equals(sukChar) &&
      !str[i].equals(shadChar))
      output = output + str[i];
  }
  return output;
}

// determine the current and old distance, to see if the
// player is moving towards or away from correctness
// note that for some peculiar reason, the array of 
// answer vowel chars appears to be reversed
function getCurrDist() {
  if (mode == 1) {
    var newDist = 0;
    
    for (int i = 0; i < chars.length; i++) {
      if (!chars[i].equals(ansChars[i])) {
        if (chars[i].equals(" "))     newDist += 1;
        else                          newDist += 2;
      }
      if (!vowChars[i].equals(ansVowChars[chars.length - i - 1])) {
        if (vowChars[i].equals(" "))  newDist += 1;
        else                          newDist += 2;
      }
      if (!shadChars[i].equals(ansShadChars[i])) {
        if (shadChars[i].equals(" ")) newDist += 1;
        else                          newDist += 2;
      }
    }
    
    oldDist = currDist;
    currDist = newDist;
  }
}

// returns true if a character is a consonant
function isConsonant(var c) {
  if (c == sukChar || c == fatChar || c == damChar ||
      c == kasChar || c == shadChar) return false;
  else return true;
}

// returns true if a character is a vowel
function isVowel(var c) {
  if (c == sukChar || c == fatChar || c == damChar ||
      c == kasChar) return true;
  else return false;
}

// returns true if a character is a vowel
function isShadda(var c) {
  if (c == shadChar) return true;
  else return false;
}

// clears the correct-character arrays
function resetAnsArrays() {
  ansChars.clear();
  ansVowChars.clear();
  ansShadChars.clear();
}

// used to calculate the levenshtein distance
// note that I do not think this function is used anymore
// as the program currently stands
function levDist(var s, var len_s, var t, var len_t) {

  if (len_s == 0) return len_t;
  if (len_t == 0) return len_s;

  var cost;

  if (s[len_s-1] == t[len_t-1]) cost = 0;
  else                          cost = 1;
  
  return minimum(levDist(s, len_s - 1, t, len_t    ) + 1, 
  levDist(s, len_s, t, len_t - 1) + 1, 
  levDist(s, len_s - 1, t, len_t - 1) + cost);
}

// returns the min value of three
function minimum(var a, var b, var c) {
  if (a <= b) {
    if (a <= c) return a;
    else return c;
  }
  else {
    if (b <= c) return b;
    else return c;
  }
}

// resets discovery mode
public void resetDisc() {
  //initialize the root array
  chars[0] = " ";
  chars[1] = " ";
  chars[2] = " ";
  chars[6] = " ";
  chars[7] = " ";
  chars[8] = " ";
  
  //intialize the diacritical arrays
  for (i = 0; i < chars.length; i++) {
    vowChars[i]  = " ";
    shadChars[i] = " ";
  }
  
  tiles.length = 0;
  diacrits.length = 0;
  for (int i = 0; i < modChars.length; i++) {
    tiles[i] = new Tile(50 + 100*i, tileHeight, modChars[i], images.get(modChars[i]));
  }
}

// resets quiz mode, also selecting a new quiz prompt
public void resetQuiz() {
  var rand = (int)random(0, txtfile.length);
  var index = rand - (rand % 6);
  // index is a multiple of 6
  
  // Use the commented line below
  // for checking if specific quiz inputs work.
  // Leave the 6, change the value of the second number
  // index = 6 * 12;
  
  var randIndex = shuffle(3);
  var a;
  a = txtfile[index + 4].split("\u060C");
  ansChars = a;
  a = txtfile[index + 5].split("\u060C");
  ansVowChars = a;
  a = txtfile[index + 6].split("\u060C");
  ansShadChars = a;
  
  var i;
  for (i = 0; i < a.length; i++) {
    if (ansChars[i].equals("")) ansChars[i] = " ";
    if (ansVowChars[i].equals("")) ansVowChars[i] = " ";
    if (ansShadChars[i].equals("")) ansShadChars[i] = " ";
  }
  
  answer = txtfile[index + 7]; //an arabic string
  tiles.length = 0;
  diacrits.length = 0;
  
  var aChars = new Array();
  if (txtfile[index + 8].equals("")) aChars.length = 0;
  else aChars = txtfile[index + 8].split("\u060C"); //chars that are needed for the answer
    
  chars[0] = " "; 
  chars[1] = " "; 
  chars[2] = " ";
  chars[6] = " ";
  chars[7] = " ";
  chars[8] = " "; // reset consonants
  for (i = 0; i < vowChars.length; i++) {          // reset diacriticals
    vowChars[i]  = " ";
    shadChars[i] = " ";
  }

  for (i = 0; i < aChars.length; i++) {   // put correct chars in array
    tiles[i] = new Tile(width/2 - 100 + 100*randIndex[i], tileHeight, aChars[i], images.get(aChars[i]));
  }
  
  var rChars = txtfile[1].split("\u060C");     // randomly obtained chars

  for (i = aChars.length; i < 3; i++) {
    var matchFound = 1;
    while (matchFound == 1) {
      rand = (int) random(0, rChars.length);
      matchFound = 0;
      for (var j = 0; j < aChars.length; j++) {
        if (rChars[rand].equals(aChars[j])) {
          matchFound = 1;
          break;
        }
      }
      for (j = aChars.length; j < i; j++) {
        if (images.get(rChars[rand]).equals(tiles[j].img)) {
          matchFound = 1;
          break;
        }
      }
    }
    tiles[i] = new Tile(width/2 - 100 + 100*randIndex[i], tileHeight, rChars[rand], images.get(rChars[rand]));
  }

  getArabicString();
  getCurrDist();
 
}

// returns an array of size a that consists of the
// numbers 0 through a–1, shuffled
function shuffle(var a) {
  var randArray = new Array();
  var i;
  for (i = 0; i < a; i++) {
    randArray[i] = i;
  }
  var rand;
  var tmp;
  for (i = 0; i < a; i++) {
    rand = (int)random(0, a);
    tmp = randArray[i];
    randArray[i] = randArray[rand];
    randArray[rand] = tmp;
  }
  return randArray;
}

void keyReleased() {
  // lets the program know that the key has been 
  keyPass = true;
}
//used for dragging
public void mousePressed() {
  if (mode   >  0           &&
      mouseX >= width - 145 &&
      mouseX <= width - 35  &&
      mouseY >= 25          &&
      mouseY <= 62) {
        mode = -1;
        resetDisc();
  }
  else if (lockedTile == null) {
    var oldString = txt;
    //locks a tile to be dragged
    //currently prioritized to tiles that are placed in array earlier
    //think about fixing latter down the road
    lockedTile = topTile();
    var i = lockedBounds();
    if (i > -1) {
      if (lockedTile.img.equals(fatha) ||
        lockedTile.img.equals(kasra) ||
        lockedTile.img.equals(damma) ||
        lockedTile.img.equals(sukun)) {
          // XXX
        vowChars[i] = " ";
        getCurrDist();
      }
      else if (lockedTile.img.equals(shadda)) {
        // XXX
        shadChars[i] = " ";
        getCurrDist();
      }
      else {
        chars[i] = " ";
        getCurrDist();
      }
    }
  }
  else {
    xOffset = mouseX - lockedTile.posX;
    yOffset = mouseY - lockedTile.posY;
  }
}

//used for dragging
public void mouseDragged() {
  if (lockedTile != null) {
    lockedTile.posX = mouseX - xOffset;
    lockedTile.posY = mouseY - yOffset;
  }
}

//TODO: Figure out what to do with tiles sent to -100
//releases the locked tile
public void mouseReleased() {
  var oldString = txt;
  if (lockedTile != null) {
    var i = lockedBounds();
    if (lockedTile.img.equals(kasra)) {
      if (i > -1 && vowChars[i].equals(" ")) {
        lockedTile.posX = (float) (width/2 + 400 - (100 * i));
        lockedTile.posY = height*8/20;
        vowChars[i] = lockedTile.c;
        getCurrDist();
      }
      else lockedTile.posX = -100;
      lockedTile = null;
    }
    else if (lockedTile.img.equals(fatha) ||
      lockedTile.img.equals(damma) ||
      lockedTile.img.equals(sukun)) {
        // XXX
      if (i > -1 && vowChars[i].equals(" ")) {
        lockedTile.posX = (float) (width/2 + 400 - (100 * i));
        lockedTile.posY = height*4/20;
        vowChars[i] = lockedTile.c;
        getCurrDist();
      }
      else lockedTile.posX = -100;
      lockedTile = null;
    }
    else if (lockedTile.img.equals(shadda)) {
      // XXX
      if (i > -1 && shadChars[i].equals(" ")) {
        lockedTile.posX = (float) (width/2 + 400 - (100 * i));
        lockedTile.posY = height*3/20;
        shadChars[i] = lockedTile.c;
        getCurrDist();
      }
      else lockedTile.posX = -100;
      lockedTile = null;
    }
    else {
      if ((i == 0 || i == 1 || i == 2 || i == 6 || i == 7 || i == 8) && chars[i].equals(" ")) {
        lockedTile.posX = (float) (width/2 + 400 - (100 * i));
        lockedTile.posY = height*6/20;
        chars[i] = lockedTile.c;
        getCurrDist();
      }
      else {
        lockedTile.posX = lockedTile.stickyX;
        lockedTile.posY = lockedTile.stickyY;
      }
      lockedTile = null;
    }
  }
}

//gets the first tile in the tile array that the mouse is hovering over
//this prevents more than one tile from being selected at a time
function topTile() {
  var i;
  for (i = 0; i < tiles.length; i++) {
    if (mouseX > tiles[i].posX - 75 &&
      mouseX < tiles[i].posX + 75 &&
      mouseY > tiles[i].posY - 50 &&
      mouseY < tiles[i].posY + 50) {
      return tiles[i];
    }
  }
  for (i = 0; i < diacrits.length; i++) {
    if (mouseX > diacrits[i].posX - 12 &&
      mouseX < diacrits[i].posX + 12 &&
      mouseY > diacrits[i].posY - 12 &&
      mouseY < diacrits[i].posY + 12) {
      return diacrits[i];
    }
  }
  if (mouseY > height - 100) {
    if (mouseX > width/2 - 225 && mouseX < width/2 - 175) {
      var t = new Tile(mouseX, mouseY, "\u064e", fatha);
      var index = diacrits.length;
      diacrits[index] = t;
      return t;
    }
    else if (mouseX > width/2 - 125 && mouseX < width/2 - 75) {
      var t = new Tile(mouseX, mouseY, "\u0650", kasra);
      var index = diacrits.length;
      diacrits[index] = t;
      return t;
    }
    else if (mouseX > width/2 - 25 && mouseX < width/2 + 25) {
      var t = new Tile(mouseX, mouseY, "\u064f", damma);
      var index = diacrits.length;
      diacrits[index] = t;
      return t;
    }
    else if (mouseX > width/2 + 75 && mouseX < width/2 + 125) {
      var t = new Tile(mouseX, mouseY, "\u0652", sukun);
      var index = diacrits.length;
      diacrits[index] = t;
      return t;
    }
    else if (mouseX > width/2 + 175 && mouseX < width/2 + 225) {
      var t = new Tile(mouseX, mouseY, "\u0651", shadda);
      var index = diacrits.length;
      diacrits[index] = t;
      return t;
    }
  }
  return null;
}

// each character input position is assigned an integer
// this function returns that integer, depending on where
// the currently-being-dragged tile is upon release
function lockedBounds() {
  var t = lockedTile;
  if (t == null) return -1;
  if (t.posY > height*6/20 - 150 &&
    t.posY < height*6/20 + 150) {
    for (var i = 0; i < chars.length; i++) {
      if (t.posX < width/2 + 450 - (i * 100) &&
        t.posX > width/2 + 350 - (i * 100))
        return i;
    }
  }
  return -1;
}

class Tile {
  float stickyX;
  float stickyY;
  float posX;
  float posY;
  String c;
  int arrayPos = -1;
  boolean locked = false;
  PImage img;

  Tile(float x, float y, String cha, PImage pi) {
    stickyX = x; 
    posX = x; 
    stickyY = y; 
    posY = y; 
    c = cha; 
    img = pi;
  }
}


