from flask import g
import sqlite3

@app.before_request
def set_up():
    """
    Connect to SQLITE 3 database before anything else is done.
    """
    g.db = sqlite3.connect('demo.db')

@app.teardown_request
def teardown(exception):
    """
    Close database connection when the app is closed.
    """
    g.db.close()
