import random
import math
import zmq
import time
import subprocess
import sys
import os
import copy

context = zmq.Context()

def sigmoid(x):
  return 1 / (1 + math.exp(-x))

def create_starting_generation():
    population = []
    for i in range(100):
        population.append(create_new_member())
    return population
def create_game(members):
    ans = [0 for i in range(10)]
    subprocess.Popen('python serverzmq.py', shell=True)
    for i in range(10):
        #print("i =" + str(i))
        subprocess.Popen('python clientzmq.py', shell=True)
        socket = context.socket(zmq.REP)
        socket.bind("tcp://*:61802")
        socket.recv()
        time.sleep(0.01)
        socket.send(str(i))
        socket.recv()
        time.sleep(0.01)
        socket.send(str(members[i]))
        socket.close()
    for i in range(10):
        socket = context.socket(zmq.REQ)
        socket.connect("tcp://localhost:5000" + str(i))
        socket.send("gimme the good stuff")
        data = socket.recv().decode("utf-8").split(" ")
        #print(data)
        ans[int(data[0])] = int(data[1])
        socket.close()
    #print(ans)
    #print("done")
    #print(ans)
    return(ans)
# def crossover(a, b):
#     return a
def mutate(member):
    ans = copy.deepcopy(member)
    for i in range(50):
        for j in range(50):
            if random.random() < 0.05:
                ans[0][i][j] = 2*random.random()-1
        if random.random() < 0.05:
            ans[1][i] = 2*random.random()-1
        if random.random() < 0.05:
            ans[2][i] = 2*random.random()-1
    if random.random() < 0.05:
        ans[3] = 2*random.random()-1
    return ans
def create_new_member():
    w1 = []
    for i in range(50):
        w1.append([2*random.random()-1 for i in range(50)])
    w2 = [2*random.random()-1 for i in range(50)]
    b1 = [2*random.random()-1 for i in range(50)]
    b2 = 2*random.random()-1
    member = [w1, w2, b1, b2, 0]
    return member

def main():
    population = create_starting_generation()
    #print(population)
    for i in range(2):
        print(i)
        random.shuffle(population)
        for j in range(10):
            members = [population[member] for member in range(10*j,10*j+10)]
            scores = create_game(members)
            #print(scores)
            for k in range(10):
                population[10*j + k][4] = scores[k]
        new_population = []
        winners = []
        for member in population:
            if member[4] == 3:
                new_population.append(member)
                winners.append(member)
            if member[4] == 2:
                if random.random() < .25:
                    new_population.append(member)
        for j in range(len(new_population)):
            new_population[j] = mutate(new_population[j])
        new_population.append(winners)
        new_population = new_population[:100]
        while(len(new_population) < 100):
            new_population.append(create_new_member())
        population = copy.deepcopy(new_population)
    for member in population:
        if member[4] == 3:
            print(member)
            exit()
main()
