goog.provide('hps.prime.BoardFactory');

goog.require('hps.prime.Board');

hps.prime.BoardFactory.create = function(filledCell){
    board = new hps.prime.Board();  
    for(var x = 0;x<= 8;x++){
	board._map[x] = -1;
    }
    return board;
};goog.provide('hps.prime.Board');

var PRIME_LIST = [
101, 103, 107, 
109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 
193, 197, 199, 211,223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 
281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379,
383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 
479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 
593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 
683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 
809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 
911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997
];

var BOARD_WIDTH = 3;

hps.prime.Board = function(){
    this._map = [];  // 0 - 8
    for(var x = 0;x<= 8;x++){
	this._map[x] = -1;
    }
    this._step = 0;
};


/*
 * 
 * x, y starts from 0 ends at 2
 * */
hps.prime.Board.getOffSet = function(x, y){
    return x + y* BOARD_WIDTH;
};

hps.prime.Board.prototype.set = function(x, y, num){
    // alert(x.toString()+' '+y.toString());
    if(x < BOARD_WIDTH && x >=0 && y<BOARD_WIDTH && y >= 0){
	this._map[hps.prime.Board.getOffSet(x,y)] = num;
	this._step ++ ;
    }
};


hps.prime.Board.prototype.get = function(x,y){
    return this._map[hps.prime.Board.getOffSet(x,y)];
};

hps.prime.Board.prototype.getAddScore = function(x, y, n){
    var totalScore = 0;
    var rowScore = this._checkRow(x,y);
    if(rowScore !== -1){
	totalScore += rowScore;
    }
    var colScore = this._checkCol(x,y);
    if(colScore !== -1){
	totalScore += colScore;
    }
    var diagScore1 = this._checkDiag1(x,y);
    if(diagScore1 !== -1){
	totalScore += diagScore1;
    }
    var diagScore2 = this._checkDiag2(x,y);
    if(diagScore2 !== -1){
	totalScore +=diagScore2;
    }
    
    return totalScore;
    
 };


hps.prime.Board.prototype.moveNum = function(){
    return this._step;    
};





/*
 * @return (NaN) the score of row return -1 if the row is incomplete
 * */
hps.prime.Board.prototype._checkRow = function(x,y){
    // alert(hps.prime.Board.getOffSet(x,y));
    var num = 0;
    var score = 0;
    for(var i = 0; i< BOARD_WIDTH ; ++i){
	var n = this._map[hps.prime.Board.getOffSet(i,y)];
	if ( n === -1){
	    return -1;
	}
	num = 10*num + n;
    }
    if(this._isValidPrime(num)){
	score ++; 
    }
    
    // reverse order
    num = 0;
    for(var j = BOARD_WIDTH -1; j>=0; j--){
	var n = this._map[hps.prime.Board.getOffSet(j,y)];
	if ( n === -1){
	    return -1;
	}
	num = 10*num + n;
    }
    if(this._isValidPrime(num)){
	score ++;
    }
    return score;
};

/*
 * @return (NaN) the socre of the column return -1 if the column is incomplete
 * */
hps.prime.Board.prototype._checkCol = function(x, y){
    var num = 0;
    var score = 0;
    for(var i = 0; i< BOARD_WIDTH ; ++i){
	var n = this._map[hps.prime.Board.getOffSet(x,i)];
	if ( n === -1){
	    return -1;
	}
	num = 10*num + n;
    }
    if(this._isValidPrime(num)){
	score ++; 
    }
    
    // reverse order
    num = 0;
    for(var j = BOARD_WIDTH -1; j>=0; j--){
	var n = this._map[hps.prime.Board.getOffSet(x,j)];
	if ( n === -1){
	    return -1;
	}
	num = 10*num + n;
    }
    if(this._isValidPrime(num)){
	score ++;
    }
    return score;  
};

/*
 * @return (NaN) return the score of diagonal return -1 if it's incomplete
 * */
hps.prime.Board.prototype._checkDiag1 = function(x, y){
    var score = 0;
    if(x === y){ // in diagonal 1
	var num = 0;
	var i = 0;
	var j = 0;
	for(i = 0,j=0; i< BOARD_WIDTH && j<BOARD_WIDTH; i++,j++){
	    var n = this._map[hps.prime.Board.getOffSet(i,j)];
	    if ( n === -1){
		return -1;
	    }
	    
	    num = 10*num + n;
	} 
	if(this._isValidPrime(num)){
	    score ++; 
	}
	num = 0;
	i = 0;
	j = 0;
	for(i = BOARD_WIDTH-1,j=BOARD_WIDTH-1; i>=0 && j>=0; i--,j--){
	    var n = this._map[hps.prime.Board.getOffSet(i,j)];
	    if ( n === -1){
		return -1;
	    }
	    
	    num = 10*num + n;
	} 
	if(this._isValidPrime(num)){
	    score ++; 
	}
	return score;
	
    }else{
	return -1;
    }
};

hps.prime.Board.prototype._checkDiag2 = function(x, y){
    var score = 0;
    if(2-x === y){ // in diagonal 2
	var num = 0;
	var i = 0;
	var j = 0;
	for(i = 0,j=BOARD_WIDTH-1; i< BOARD_WIDTH && j>=0; i++,j--){
	    var n = this._map[hps.prime.Board.getOffSet(i,j)];
	    if ( n === -1){
		return -1;
	    }
	    
	    num = 10*num + n;
	} 
	if(this._isValidPrime(num)){
	    score ++; 
	}
	num = 0;
	i = 0;
	j = 0;
	for(i = BOARD_WIDTH-1,j=0; i>=0 && j<BOARD_WIDTH; i--,j++){
	    var n = this._map[hps.prime.Board.getOffSet(i,j)];
	    if ( n === -1){
		return -1;
	    }
	    
	    num = 10*num + n;
	} 
	if(this._isValidPrime(num)){
	    score ++; 
	}
	return score;
	
    }else{
	return -1;
    }


};


hps.prime.Board.prototype._isValidPrime = function(num){
    
    if(!isNaN(num) && num>=100 && num<1000){
	for(var i = 0; i<PRIME_LIST.length; ++i){
	    if(num === PRIME_LIST[i]){
		return true;
	    }
	}	
	return false;
    }else{
	// error
	return false;
    }
};/**
 * @author roy
 */

goog.provide('hps.prime.BoardUI');

goog.require('hps.prime.NextTurnEvent');
goog.require('hps.prime.GameOverEvent');

goog.require('hps.prime.BoardFactory');

goog.require('goog.ui.Palette');
goog.require('goog.ui.Prompt');
goog.require('goog.dom.classes');
goog.require('goog.events.EventTarget');


var WIDTH_SIZE = 3;
var LENGTH_SIZE = 3;
  
hps.prime.BoardUI = function(filledCell, playerList,node){
    goog.base(this);
    this._isGameOver = false;
    this._board = hps.prime.BoardFactory.create(filledCell);
    this._players = playerList;

    var self = this;
    var items = [];
    for (var y = 0; y < LENGTH_SIZE; y++) {
	for (var x = 0; x < WIDTH_SIZE; x++) {
	    var cell = this._board.get(x,y);
	    var cellDisp = (cell === -1) ? '' : cell;
	    items.push(goog.dom.createTextNode(cellDisp));
	}
    }
    this._boardPalette = new goog.ui.Palette(items);
    this._boardPalette.setSize(WIDTH_SIZE);
    this._boardPalette.render(node);

    goog.dom.classes.add(this._boardPalette.getElement(),'simple-palette');

    goog.events.listen(this._boardPalette, goog.ui.Component.EventType.ACTION,
		       function(e) { self._selectCell(e.target); });

    this._refreshDisplay();
};
goog.inherits(hps.prime.BoardUI, goog.events.EventTarget);


hps.prime.BoardUI.prototype._selectCell = function(palette){
    var idx = palette.getSelectedIndex();
    var x = hps.prime.BoardUI._getX(idx);
    var y = hps.prime.BoardUI._getY(idx);
    var self = this;
    if(!this._isGameOver && this._board.get(x,y) === -1){
	var handler = function(response){ // handler
	    if(response != null){
		var n = parseInt(response);

		self._board.set(x,y,n);

		// get score 
		var addScore = self._board.getAddScore(x,y,n);
		// alert(addScore);
		// send next round event or game over event 
		if(self._board.moveNum() == 9){
		    // send player:addscore game over 
		    self.dispatchEvent(new hps.prime.NextTurnEvent(
			self._players.getCurrentPlayer(),addScore));
		    self._gameOver();
		}else{
		    // send player:addscore event to main ui 
		    self.dispatchEvent(new hps.prime.NextTurnEvent(
			self._players.getCurrentPlayer(),addScore));
		    if(self._board.moveNum() < 8){ // not reach move 8 
			self._players.next();
		    }

		}
		
		// self._refreshDisplay();
		goog.dom.setTextContent(palette.getSelectedItem(), n);
	    }
	};
	
	// pop up a promt window
	prompt = new goog.ui.Prompt('','Set the value',handler);

	prompt.setValidationFunction(function(input){
		if(!hps.prime.BoardUI.is_int(input)){
		    return false;
		}
		var num = parseInt(input);
		if(x === 1 && y ===1){
		    return (num >=0 && num <=9);
		}else{
		    return (num >0 && num <=9);
		}
		
	    });
	prompt.setVisible(true);
    }
};

hps.prime.BoardUI.prototype._gameOver = function(){
    this._isGameOver = true;
    this.dispatchEvent(new hps.prime.GameOverEvent());
};

hps.prime.BoardUI._getX = function(idx){
    return idx % WIDTH_SIZE;
};

hps.prime.BoardUI._getY = function(idx){
    return Math.floor(idx/WIDTH_SIZE);
};

hps.prime.BoardUI.prototype._refreshDisplay = function(){
    var x = 0;
    var y ;
    var cell;
    var origSelIdx;
    this._boardPalette.setEnabled(false);
    origSelIdx = this._boardPalette.getSelectedIndex();
    

    this._boardPalette.setEnabled(true);

};




hps.prime.BoardUI.createEmptyBoard = function(node){
    var items = [];
    for (var y = 0; y < LENGTH_SIZE; y++) {
	for (var x = 0; x < WIDTH_SIZE; x++) {
	    items.push(goog.dom.createTextNode(''));
	}
    }
    var boardPalette = new goog.ui.Palette(items);
    boardPalette.setSize(WIDTH_SIZE);
    
    boardPalette.render(node);
    // class is the key
    goog.dom.classes.add(boardPalette.getElement(),'simple-palette'); 
    

};



hps.prime.BoardUI.is_int = function(value){
    if((parseFloat(value) == parseInt(value))){
      return true;
    } else { 
	return false;
    } 
};


function sayHi() {
    var newHeader = goog.dom.createDom('h1', {'style': 'background-color:#EEE'},
    'Hello world!');
    goog.dom.appendChild(document.body, newHeader);

    var node = goog.dom.createDom('div',{'id':'prime-board'});
    goog.dom.appendChild(document.body, node);
    
    b = new hps.prime.BoardUI('',[],node);
    // hps.prime.BoardUI.renderEmptyBoard(node);
}

function test_Board_UI(){
    var node = goog.dom.createDom('div',{'id':'prime-board'});
    goog.dom.appendChild(document.body, node);
    p = new hps.prime.PlayerList([1,2]);
    b = new hps.prime.BoardUI('',p,node);
}goog.provide('hps.prime.Boot');


goog.require('goog.dom');
goog.require('hps.prime.MainUI');


(function() {
  var ui = new hps.prime.MainUI(goog.dom.getElement('board'));
})();goog.provide('hps.prime.EventType');

goog.require('goog.events');

/*
 * @enum {string}
 * */
hps.prime.EventType = {
    GAME_OVER: goog.events.getUniqueId('Game Over'),
    NEXT_TURN: goog.events.getUniqueId('Next Turn')
};
goog.provide('hps.prime.GameOverEvent');

goog.require('hps.prime.EventType');
goog.require('goog.events.Event');

hps.prime.GameOverEvent = function(target){
    goog.base(this,hps.prime.EventType.GAME_OVER, target);
    
};


goog.inherits(hps.prime.GameOverEvent, goog.events.Event);

goog.provide('hps.prime.MainUI');

goog.require('hps.prime.PlayerListUI');

goog.require('hps.prime.PlayerList');
goog.require('hps.prime.Player');

goog.require('hps.prime.BoardUI');
goog.require('hps.prime.EventType');

goog.require('goog.Uri');
goog.require('goog.dom');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');

goog.require('goog.events');
goog.require('goog.events.EventType');
goog.require('goog.ui.Button');
goog.require('goog.ui.FlatButtonRenderer');


var GAME_MSG = 'add two players then presss start to begin';



hps.prime.MainUI = function(node){
    var self = this;
    this._move = 0;
    this._isPlaying = false;    


    this._statusBarDom = goog.dom.createDom('div',{id:'status-bar'});
    goog.dom.setTextContent(this._statusBarDom, GAME_MSG);    
    goog.dom.appendChild(node, this._statusBarDom);
    

    var winnerBarDom = goog.dom.createDom('div',{id:'winner-bar-status'});
    this._winnerDom = goog.dom.createDom('div',{id:'winner-bar'});
    goog.dom.setTextContent(this._winnerDom,'This is winner board');

    goog.dom.appendChild(winnerBarDom,this._winnerDom);
    goog.dom.appendChild(node,winnerBarDom);


    this._player1NameDom = goog.dom.createDom('div',{id:'score-bar-player-name'});
    this._player1ScoreDom = goog.dom.createDom('div',{id:'score-bar-player-score'});
    this._player1Dom = goog.dom.createDom('div',{id:'score-bar'},
					  this._player1NameDom,this._player1ScoreDom);
    goog.dom.setTextContent(this._player1NameDom,'Player1: ');


    this._player2NameDom = goog.dom.createDom('div',{id:'score-bar-player-name'});
    this._player2ScoreDom = goog.dom.createDom('div',{id:'score-bar-player-score'});
    this._player2Dom = goog.dom.createDom('div',{id:'score-bar'},
					 this._player2NameDom, this._player2ScoreDom);
    goog.dom.setTextContent(this._player2NameDom,'Player2: ');

    

    
    this._scoreBarDom = goog.dom.createDom('div','score-bars',
					   this._player1Dom,this._player2Dom
					   );
    goog.dom.appendChild(node, this._scoreBarDom);
    
    // create a board UI
    this._gamestate = null;
    this._boardDom = goog.dom.createDom('div',{id:'prime-board'});
    // goog.dom.appendChild(node, this._boardDom);
    hps.prime.BoardUI.createEmptyBoard(this._boardDom);
    // hps.prime.BoardUI.createEmptyBoard(this._boardDom);
    
    // crate a player list UI
    this._sideBarDom = goog.dom.createDom('div',{id:'prime-sidebar'});
    this._playerListUI = new hps.prime.PlayerListUI(this._sideBarDom);

    // put board and sidebar together 
    var boardAndSideDom  = goog.dom.createDom('div',{id:'board-and-sidebar'},
					     this._boardDom, this._sideBarDom);
    goog.dom.appendChild(node, boardAndSideDom);
    

    var btnBarDom = goog.dom.createDom('div',{id: 'btn-bar'});
    // add button
    var startGameDom = goog.dom.createDom('div',{id: 'start-game-btn'});
    this._startGameBtn = new goog.ui.Button('start game',
					    goog.ui.FlatButtonRenderer.getInstance());
    this._startGameBtn.render(startGameDom);
    goog.dom.appendChild(btnBarDom, startGameDom);

    // add button
    /*
    var saveGameDom = goog.dom.createDom('div',{id: 'save-game-btn'});
    this._saveScoreBtn = new goog.ui.Button('save game',
					    goog.ui.FlatButtonRenderer.getInstance());
    this._saveScoreBtn.render(saveGameDom);
    this._saveScoreBtn.setEnabled(false);
    goog.dom.appendChild(btnBarDom, saveGameDom);
     */

    goog.dom.appendChild(node,btnBarDom);
    
    // listening to event 
    var handleStartBtn = function(e){
	//  TODO
	// here this doesn't mean this file !!!!!!
	// a good way is to save this point at the begining of the constructor
	var selfRef = self;
	if(selfRef._isPlaying){
	    // click stop game
	    goog.dom.setTextContent(selfRef._statusBarDom,'Game Stopped');
	    selfRef._playerListUI.enable();
	    selfRef._disposeBoard();
	    goog.dom.setTextContent(selfRef._startGameBtn.getElement(), 'start game');
	    // selfRef._saveScoreBtn.setEnabled(false);
	}else{
	    // is not playing, click  the button, start the game
	    if(selfRef._playerListUI.getPlayerCount() != 2){
		goog.dom.setTextContent(selfRef._statusBarDom,
					'ERROR: the player number is not 2, could not start');
		return;
	    }

	    selfRef._createBoard();
	    // disable ui
	    selfRef._playerListUI.disable();
	    goog.dom.setTextContent(selfRef._startGameBtn.getElement(), 'stop game');
	    // selfRef._saveScoreBtn.setEnabled(false);
	   
	}
	selfRef._isPlaying = !selfRef._isPlaying;

    };
    
    goog.events.listen(this._startGameBtn, goog.ui.Component.EventType.ACTION,
		      handleStartBtn);
     
    /* 
    var handleSaveBtn = function(e){
	// TODO
	var selfRef = self;
	

	selfRef._saveScoreBtn.setEnabled(false);
    };
    
    goog.events.listen(this._saveScoreBtn, goog.ui.Component.EventType.ACTION,
		      handleSaveBtn);
     */
};



hps.prime.MainUI.prototype._createBoard = function(){
    // player store the information of each player.
    // recreate player list which stores player information
    this._move = 0;
    this._activePlayerList = this._playerListUI.getPlayerList();
    if(this._activePlayerList.length !== 2){
	goog.dom.setTextContent(this._statusBarDom,
				'ERROR: the player number is not 2, could not start');
    }else{
	goog.dom.removeChildren(this._boardDom);
	goog.dom.setTextContent(this._statusBarDom,
				'Game start: '+
				this._activePlayerList[0].getName()+' moves');
	
	var p1 = this._activePlayerList[0];
	var p2 = this._activePlayerList[1];
	
	goog.dom.setTextContent(this._player1NameDom,'Player1: '+p1.getName());
	goog.dom.setTextContent(this._player2NameDom,'Player2: '+p2.getName());
	goog.dom.setTextContent(this._player1ScoreDom, '0');
	goog.dom.setTextContent(this._player2ScoreDom, '0');
	p = new hps.prime.PlayerList([p1,p2]);
	this._gamestate = new hps.prime.BoardUI('',p,this._boardDom);

	// listening to gameover event etc 
	goog.events.listen(this._gamestate, hps.prime.EventType.GAME_OVER,
			   this._handleGameOver,false, this);
	
	goog.events.listen(this._gamestate, hps.prime.EventType.NEXT_TURN,
		      this._handleNextTurn, false, this);


	goog.dom.setTextContent(this._winnerDom,'This is winner board');
	
    }
};


/*
 * game over handler
 * */
hps.prime.MainUI.prototype._handleGameOver = function(e){
    // var message = goog.string.buildString('Game Over: ');
    // show who wins 
    var player1 = this._activePlayerList[0];
    var player2 = this._activePlayerList[1];

    if(player1.getScore() > player2.getScore()){
	goog.dom.setTextContent(this._winnerDom, 
				'Game over, '+player1.getName()+' wins!');
    }else if(player1.getScore() < player2.getScore()){
	goog.dom.setTextContent(this._winnerDom, 
				'Game over, '+player2.getName()+' wins!');
    }else{
	goog.dom.setTextContent(this._winnerDom, 
				'Game over, tie!');
    }

    goog.dom.setTextContent(this._startGameBtn.getElement(),'start game');
    this._playerListUI.enable();
    this._isPlaying = false;
    // this._saveScoreBtn.setEnabled(true);
    
};


/*
 * next turn handler
 * */
hps.prime.MainUI.prototype._handleNextTurn = function(e){
    var player = e.getPlayer();
    var addScore = e.getAddScore();    

    // alert(player.getName());
    // show each player's score 
    goog.dom.setTextContent(this._statusBarDom, player.getName()+'+'+addScore.toString());   

    var idx = player.getIndex();
    
    this._activePlayerList[idx].addScore(addScore);
    
    var score1 = this._activePlayerList[0].getScore();
    var score2 = this._activePlayerList[1].getScore();
    
    var text1 = goog.dom.getTextContent(this._player1Dom);
    var text2 = goog.dom.getTextContent(this._player2Dom);

    goog.dom.setTextContent(this._player1ScoreDom, score1.toString());
    goog.dom.setTextContent(this._player2ScoreDom, score2.toString());
    // show who's turn.  (next player)
    var size =  this._activePlayerList.length;
    var nextIdx = -1;
    if(this._move == 7){
	nextIdx = idx;
    }else{
	nextIdx = idx + 1 >= size ? (idx+1) % size : idx+1;
    }
    goog.dom.setTextContent(this._statusBarDom, 
			    player.getName()+'+'+addScore.toString()+' Now '+
    			    this._activePlayerList[nextIdx].getName()+' moves ');
    
    this._move ++;
};


/*
 * dispose the board
 * */
hps.prime.MainUI.prototype._disposeBoard = function(){
    goog.dom.removeChildren(this._boardDom);
    hps.prime.BoardUI.createEmptyBoard(this._boardDom);
    goog.dom.setTextContent(this._player1NameDom,'Player1: ');
    goog.dom.setTextContent(this._player2NameDom,'Player1: ');
    goog.dom.setTextContent(this._player1ScoreDom, '');
    goog.dom.setTextContent(this._player2ScoreDom, '');
    this._gamestate = null;
};



hps.prime.MainUI.getWinnerBoardContent = function(){
    var content = goog.dom.getTextContent(goog.dom.getElement('winner-bar'));

    goog.dom.setTextContent(goog.dom.getElement('winner-bar'),'This is winner board');
    return content;
};goog.provide('hps.prime.NextTurnEvent');

goog.require('hps.prime.EventType');
goog.require('goog.events.Event');


hps.prime.NextTurnEvent = function(player,addScore,target){
    goog.base(this, hps.prime.EventType.NEXT_TURN, target);  
    
    this._player = player;
    this._addScore = addScore;
};
goog.inherits(hps.prime.NextTurnEvent, goog.events.Event);


hps.prime.NextTurnEvent.prototype.getPlayer = function(){
    return this._player;
};

hps.prime.NextTurnEvent.prototype.getAddScore = function(){
    return this._addScore;
};goog.provide('hps.prime.Player');

hps.prime.Player = function(index, name, score){
    this._index = index;
    this._name = name;
    this._score = score;
};

hps.prime.Player.prototype.getName = function(){
    return this._name;  
};

hps.prime.Player.prototype.getScore = function(){
    return this._score;
};

hps.prime.Player.prototype.setScore = function(score){
    this._score = score;
};


hps.prime.Player.prototype.addScore = function(score){
    this._score += score;
};


hps.prime.Player.prototype.getIndex = function(){
    return this._index;
};goog.provide('hps.prime.PlayerList');

goog.require('goog.structs');

hps.prime.PlayerList = function(players){
    this._players = players;
    this._currentIdx = 0;
};


hps.prime.PlayerList.prototype.next = function(){
    var size = this._players.length;
    if( size !== 2){
	throw "not 2 players";
    }
    var nextPlayer = this._players[this._currentIdx++];
    if (this._currentIdx >= size){
	this._currentIdx = this._currentIdx % size;
    }
    return nextPlayer;
};

hps.prime.PlayerList.prototype.getCurrentPlayer = function(){
    var player = null;
    if(this._players.length > 0){
	player = this._players[this._currentIdx];
    }
    return player;
};

hps.prime.PlayerList.prototype.getPlayerCount = function(){
    return this._players.length;
};


hps.prime.PlayerList.prototype.getNextPlayer = function(){
    var size = this._players.length;
    var nextPlayerIdx = this._currentIdx + 1;
    if(nextPlayerIdx >= size){
	return this._players[nextPlayerIdx % size];
    }else{
	return this._players[nextPlayerIdx];
    }
};goog.provide('hps.prime.PlayerListUI');

goog.require('goog.string');

goog.require('goog.dom');
goog.require('goog.ui.LabelInput');

goog.require('goog.events');
goog.require('goog.events.EventType');

goog.require('goog.ui.CustomButton');
goog.require('goog.ui.Button');
goog.require('goog.ui.FlatButtonRenderer');

goog.require('hps.prime.Player');
goog.require('hps.prime.PlayerList');

/*
 * 
 * */
hps.prime.PlayerListUI = function(node){
    self = this;
    
    this._names = [];


    addInputDom = goog.dom.createDom('div',{id:'add-input'});
    this._addInput = new goog.ui.LabelInput();
    


    addPlayerDom = goog.dom.createDom('div', {id: 'add-player-btn'});
    this._addPlayerBtn = new goog.ui.Button('add player',
				       goog.ui.FlatButtonRenderer.getInstance());
    
    this._playerTableDom = goog.dom.createDom('div','player-table');
    
    

    GUIDom = goog.dom.createDom('div', {id:'player-list'},
				    addInputDom, addPlayerDom, this._playerTableDom);
    
    goog.dom.appendChild(node, GUIDom);
    
    this._addInput.render(addInputDom);   
    this._addPlayerBtn.render(addPlayerDom);

    goog.events.listen(this._addPlayerBtn,goog.ui.Component.EventType.ACTION,
		      this._addPlayerHandler,false, this);

};



hps.prime.PlayerListUI.prototype._addPlayerHandler = function(e){
    // check if the name exists
    var selfRef = this;
    
    if(this._names.length >= 2){
	alert('cannot add more player');
	this._addInput.clear();
	return;
    }

    var inputName = this._addInput.getValue();
    if(inputName.length > 8 || inputName.length <=0){
	alert('the name is too long or too short:(');
	this._addInput.clear();
	return;
    }

    if(!this.hasTheUniqName(inputName)){
	alert('the name cannot be the same :( ');
	this._addInput.clear();
	return;
    }
    
    var nameDom = goog.dom.createDom('div','player-list-entry-name');
    goog.dom.setTextContent(nameDom, inputName);
    
    var btnDom = goog.dom.createDom('div','player-list-entry-btn');
    rmBtn = new goog.ui.Button('remove');
    // rmBtn.addClassName('player-list-icon');
    
    //rmBtn.addClassName('goog-custom-button');
    //rmBtn.addClassName('player-list-rm');
    rmBtn.render(btnDom);
   
    var playerDom = goog.dom.createDom('div','player-list-entry',nameDom,btnDom);
   
    goog.dom.appendChild(this._playerTableDom, playerDom);


    goog.events.listen(rmBtn, goog.ui.Component.EventType.ACTION, function(e){
		       goog.dom.removeNode(playerDom);
		       if(!selfRef.deleteName(inputName)){
			   alert("error cannot delete the name");
		       }	   
		       });

    this._names.push(inputName);    
    this._addInput.clear();
    
};



hps.prime.PlayerListUI.prototype.getPlayerList = function(){
    var playerList = [];
    var rowDom =  goog.dom.getFirstElementChild(this._playerTableDom);
    while(rowDom != null){
        var name = goog.dom.getTextContent(goog.dom.getFirstElementChild(rowDom));
	playerList.push(new hps.prime.Player(playerList.length,name,0));	
	rowDom = goog.dom.getNextElementSibling(rowDom);
    }
    return playerList;
};


hps.prime.PlayerListUI.prototype.disable = function(){
    this._addPlayerBtn.setEnabled(false);  
    var rowDom =  goog.dom.getFirstElementChild(this._playerTableDom);
    while(rowDom != null){
	var sth = goog.dom.getLastElementChild(rowDom);
	var btn = goog.dom.getFirstElementChild(sth);
	btn.disabled = true;
	rowDom = goog.dom.getNextElementSibling(rowDom);
    }
};

hps.prime.PlayerListUI.prototype.enable = function(){
    this._addPlayerBtn.setEnabled(true);
    var rowDom =  goog.dom.getFirstElementChild(this._playerTableDom);
    while(rowDom != null){
	var sth = goog.dom.getLastElementChild(rowDom);
	var btn = goog.dom.getFirstElementChild(sth);
	btn.disabled = false;
	rowDom = goog.dom.getNextElementSibling(rowDom);
    }
};



hps.prime.PlayerListUI.prototype.getPlayerCount = function(){
    return goog.dom.getChildren(this._playerTableDom).length;
};





hps.prime.PlayerListUI.prototype.hasTheUniqName = function(name){
    for(var i = 0; i<this._names.length; i++){
	if(name === this._names[i]){
	    return false;
	}
    }
    return true;
};


hps.prime.PlayerListUI.prototype.deleteName = function(name){
    for(var i = 0; i<this._names.length; i++){
	if(name === this._names[i]){
	    this._names.splice(i,1);
	    return true;
	}
    }
    return false;
};

