//*****************************
//  VSegment.Java
//  A Point Class developed
//  by Monty Faidley and
//  Chris Poultney
//  December 2, 1996
//*****************************

public class VSegment extends VLine {
  VPoint s,e;

  VSegment() {
    super();
  }

  VSegment(VPoint q1,VPoint q2) {
    this();
    Set(q1,q2);
  }

  public void Set(VPoint q1,VPoint q2) {
    super.Set(q1,q2);
    s=new VPoint(q1);
    e=new VPoint(q2);
  }

  public double Eval(VPoint q) {
    return(A*q.dX()+B*q.dY()+C);
  }

  public VPoint Intersect(VLine l) {
    VPoint q=super.Intersect(l);
    double minx=Math.min(s.dX(),e.dX());
    double maxx=Math.max(s.dX(),e.dX());
    double miny=Math.min(s.dY(),e.dY());
    double maxy=Math.max(s.dY(),e.dY());

    if(q!=null) {
      if(q.dX()<minx || q.dX() > maxx || q.dY() < miny || q.dY() > maxy) {
        q=null;
      }
    }

    return q;
  }

  public VLine PB() {
    VPoint mid=new VPoint((s.dX()+e.dX())/2,(s.dY()+e.dY())/2);
    VLine tempLine=new VLine(-B,A,0);
    VLine retLine=new VLine(-B,A,-tempLine.Eval(mid));

    return retLine;
  }
}
