//*****************************
//  Point.Java
//  A Point Class developed
//  by Monty Faidley and
//  Chris Poultney
//  December 2, 1996
//*****************************


class VPoint {

  private double x;           //x,y coordinates of the point
  private double y;

  public VPoint()
  {
    x = 0.0;
    y = 0.0;
  }

  public VPoint(double inX,double inY)
  {
    x=inX;
    y=inY;
  }

  public VPoint( int inX, int inY )
  {
    x = (double)inX;
    y = (double)inY;
  }

  public VPoint( VPoint A )
  {
    x = A.x;
    y = A.y;
  }

  public int iX()
  {
    return( (int)x );
  }

  public int iY()
  {
    return( (int)y );
  }

  public double dX()
  {
    return( x );
  }

  public double dY()
  {
    return( y );
  }

  public double Theta( VPoint p ) {
    return Theta(p.iX(),p.iY());
  }

  public double Theta( int CX, int CY)
  {
    double Dx = x - (double)CX;
    double Dy = y - (double)CY;
    double R = Math.sqrt( Dx*Dx + Dy*Dy );
    double CosTh = Dx/R;
    if( Dy >= 0 )
      return( Math.acos(CosTh) );
    else
      return( 2*Math.PI - Math.acos(CosTh) );
  }
                                            
  public void Set(double inX,double inY)
  {
    x=inX;
    y=inY;
  }

  public void Set( int inX, int inY )
  {
    x = (double)inX;
    y = (double)inY;

  }

  public void Set( VPoint A )
  {
    x = A.x;
    y = A.y;
  }

  public boolean equals( VPoint A )
  {
    if( (x == A.x) && (y == A.y) )
      return( true );
    return(false);
  }
}//end of class VPoint
