package pseudoCli;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import noon.Config;

public class PseudoClient {
	
    InetAddress host;
    Socket socket;
    protected InputStream in;
	protected PrintStream out;
	protected Scanner scanner;
	
	public PseudoClient(int port) {
		try {
			// Create a connection to the server socket on the server application
	        this.host = InetAddress.getLocalHost();
	        this.socket = new Socket(host.getHostName(), port);
	        this.in = new BufferedInputStream(this.socket.getInputStream());
	        this.out = new PrintStream(this.socket.getOutputStream());
	        this.scanner = new Scanner(this.in);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public static void beginGame() {
		
		PseudoClient H = new PseudoClient(Config.DEFAULT_PLAYER_PORT);
		H.play();
	}
	
	public void play() {
		// Get if it is hunter or prey
		String hello = this.scanner.nextLine();
		if (hello.contains("Hunter")) {
			hunterMove();
		}
		else {
			preyMove();
		}
		System.err.println("From Client: " + hello);
	}
	
	public void printSth(String str, String role) {
		while (true) {
			String receive = this.scanner.nextLine();
			if (receive.startsWith("#")) continue;
			System.err.println(role + " receive: " + receive);
			break;
		}
		this.out.println(str);
	}
	
	public void hunterMove() {
		this.out.println("Noon_H");
		int i = 0;
		for (; i < 4; ++ i) {
			printSth("0", "H"+i);
		}
		
		for (; i < 10; ++ i) {
			printSth("0", "H" + i);
		}
		List<String> walls = new ArrayList<String>();
		printSth("10 10 400 10", "H"+(i++));
		walls.add("10 10 400 10");
		for (; i < 500; ++ i) {
			int j = i % 500;
			int k = j + 200;
			if (i % 80 == 0) {
				if (i % 160 == 0) {
					String a = j + " " + j + " " + j + " " + k;
					printSth(a, "H" + i);
					walls.add(a);
				}
				else {
					String a = j + " " + j + " " + k + " " + j;
					printSth(a, "H" + i);
					walls.add(a);
				}
			}
			else {
				printSth("0", "H" + i);
			}
		}
		printSth("10 10 400 10", "H"+(i++));
		printSth("4 4 4 200", "H"+(i++));
		for (; i < 1500; ++ i) {
			printSth("0", "H" + i);
		}
		printSth(walls.get(1), "H" + (i ++));
		for (; i < 5000; ++ i) {
			printSth("0", "H" + i);
		}
		/*try {
			Thread.sleep(10000);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}*/
	}
	
	public void preyMove() {
		this.out.println("Noon_P");
		int i = 0;
		for (;i < 7; ++ i) {
			printSth("1 1", "P" + i);
		}
		printSth("2 3", "P" + (i ++));
		for (; i < 200; ++ i) {
			printSth("-1 -1", "P" + i);
		}
		for (; i < 400; ++ i) {
			printSth("1 -1", "P" + i);
		}
		for (; i < 1000; ++ i) {
			printSth("0 1", "P" + i);
		}
		for (; i < 1500; ++ i) {
			printSth("-1 1", "P" + i);
		}
		/*try {
			Thread.sleep(10000);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}*/
	}
	
    public static void main(String[] args) throws Exception {
    	Thread hunter = new Thread() {
    		public void run() {
    			beginGame();
			}
    	};
    	Thread prey = new Thread() {
    		public void run() {
    			beginGame();
			}
    	};
    	hunter.start();
    	prey.start();
	}

}
