package noon;

public class EvasionApplication {

	/**
	 * 
	 * @param args 1=cooldown 2=maximum 3=observer_port 4=player_port
	 */
	private static void test(String[] args) {
		// init parameters
		int wallCoolDown = Config.DEFAULT_COOLDOWN;
		int wallMaximum = Config.DEFAULT_MAXIMUM;
		if (args.length > 1) {
			wallCoolDown = Integer.parseInt(args[0]);
			wallMaximum = Integer.parseInt(args[1]);
		}
		int observerPort = Config.DEFAULT_OBSERVER_PORT;
		if (args.length > 2) {
			observerPort = Integer.parseInt(args[2]);
		}
		int playerPort = Config.DEFAULT_PLAYER_PORT;
		if (args.length > 3) {
			playerPort = Integer.parseInt(args[3]);
		}
		System.out.println("Arguments: ");
		System.out.println("  N=" + wallCoolDown);
		System.out.println("  M=" + wallMaximum);
		System.out.println("  L=" + observerPort);
		System.out.println("  P=" + playerPort);
		// start observer
		ObserverConnector observerConn = new ObserverConnector();
		observerConn.start(1, null);
		// start players
		Board.Parameter parameter = new Board.Parameter(wallCoolDown, wallMaximum);
//		PlayerConnector playerConn = new PlayerConnector();
//		playerConn.waitPlayers(playerPort, parameter, observerConn);
		Game.HunterPlayer hunter = observerConn.getHunter();
		Game.PreyPlayer prey = observerConn.getPrey();
		observerConn.connected(hunter, prey);
		// play game
		Game.Result result = Game.play(parameter, hunter, prey, observerConn);
		observerConn.over(result);
		// cleanup
//		playerConn.close(result);
		observerConn.close();
	}

	public static void main(String[] args) {
		test(args);
	}

}
