package noon;


import java.io.PrintWriter;
import java.io.StringWriter;

public class DebugBase {
	
	public static interface ILogger {
		public void log(String txt);
	}
	
	public static ILogger logger = new ILogger() {
		@Override
		public void log(String txt) {
			System.out.println(txt);
		}
	};
	public class PerformanceTimer {
		public PerformanceTimer(String name) {
			this.name = name;
			reset();
		}
		public void reset() {
			time = System.nanoTime();
		}
		public void log() {
			DebugBase.this.log("PT:" + name + " " + (System.nanoTime() - time));
		}
		public long get() {
			return System.nanoTime() - time;
		}
		private String name;
		private long time;
	}
	
	protected void log(Object txt) {
		log(getClass(), txt);
	}
	protected <T> T except(Exception e) {
		return except(getClass(), e);
	}
	protected <T> T error(Throwable e) {
		return error(getClass(), e);
	}
	protected Runnable checkRun(final Runnable runnable) {
		return checkRun(getClass(), runnable);
	}
	
	public static <T> String classToString(Class<?> clazz) {
		return clazz.getSimpleName();
	}
	public static void log(Class<?> clazz, Object txt) {
		logger.log("[" + classToString(clazz) + "]" + txt);
	}
	public static <T> T except(Class<?> clazz, Exception e) {
		logger.log("[" + classToString(clazz) + "]Exception: " + e);
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		e.printStackTrace(pw);
		logger.log(sw.toString());
		pw.close();
		return null;
	}
	public static <T> T error(Class<?> clazz, Throwable e) {
		logger.log("[" + classToString(clazz) + "]Error: " + e);
		e.printStackTrace();
		throw new RuntimeException(e);
	}
	public static <T> Runnable checkRun(final Class<?> clazz, final Runnable runnable) {
		return new Runnable() {
			@Override
			public void run() {
				try {
					runnable.run();
				} catch (Throwable e) { error(clazz, e); }
			}
		};
	}
}
