function Pagination(tableName, itemsPerPage) {
    this.tableName = tableName;
    this.itemsPerPage = itemsPerPage;
    this.currentPage = 1;
    this.pages = 0;
    this.inited = false;
   
    this.showRecords = function(from, to) {       
        var rows = document.getElementById(tableName).rows;
        // i starts from 1 to skip table header row
        for (var i = 1; i < rows.length; i++) {
            if (i < from || i > to) 
                rows[i].style.display = 'none';
            else
                rows[i].style.display = '';
        }
    }
   
    this.showPage = function(pageNumber) {
     if (! this.inited) {
      alert("not inited");
      return;
     }

        var oldPageAnchor = document.getElementById('pg'+this.currentPage);
        oldPageAnchor.className = 'pg-normal';
       
        this.currentPage = pageNumber;
        var newPageAnchor = document.getElementById('pg'+this.currentPage);
        newPageAnchor.className = 'pg-selected';
       
        var from = (pageNumber - 1) * itemsPerPage + 1;
        var to = from + itemsPerPage - 1;
        this.showRecords(from, to);
    }  
   
    this.prev = function() {
        if (this.currentPage > 1)
            this.showPage(this.currentPage - 1);
    }
   
    this.next = function() {
        if (this.currentPage < this.pages) {
            this.showPage(this.currentPage + 1);
        }
    }                       
   
    this.init = function() {
        var rows = document.getElementById(tableName).rows;
        var records = (rows.length - 1);
        this.pages = Math.ceil(records / itemsPerPage);
        this.inited = true;
    }

    this.showPageNav = function(pagerName, positionId) {
     if (! this.inited) {
      alert("not inited");
      return;
     }
     var element = document.getElementById(positionId);
     
     var pagerHtml = '<span onclick="' + pagerName + '.prev();" class="pg-normal"> &#171 Previous </span> | ';
        for (var page = 1; page <= this.pages; page++)
            pagerHtml += '<span id="pg' + page + '" class="pg-normal" onclick="' + pagerName + '.showPage(' + page + ');">' + page + '</span> | ';
        pagerHtml += '<span onclick="'+pagerName+'.next();" class="pg-normal"> Next &#187;</span>';           
       
        element.innerHTML = pagerHtml;
    }
}





function confirmDel()
{
	if (confirm('Are you sure you want to delete this score?'))
	{
	   return true;
    }else{
	
	   return false;
   }
}


function confirmDelUser()
{
	if (confirm('Are you sure you want to delete this user?'))
	{
	   return true;
    }else{
	
	   return false;
   }
}


function confirmDelGame()
{
	if (confirm('Are you sure you want to delete this game?'))
	{
	   return true;
    }else{
	
	   return false;
   }
}


function confirmDelTopic()
{
	if (confirm('Are you sure you want to delete this post?'))
	{
	   return true;
    }else{
	
	   return false;
   }
}


function verifMail(email) {
   var reg = /^[a-z0-9._-]+@[a-z0-9.-]{2,}[.][a-z]{2,3}$/
   return (reg.exec(email)!=null)
}


function check_newaccount()
{

	if(detectSpec(document.register.userlogin.value))
	{
		alert("The user ID can not contain special characters."+document.register.userlogin.value);
		return false;
	} 

	if(detectSpec(document.register.userpass.value))
	{
		alert("The password can not contain special characters.");
		return false;
	} 

	if(detectSpec(document.register.username.value))
	{
		alert("The name can not contain special characters.");
		return false;
	} 

	if(document.register.userlogin.value.length<5 || document.register.userlogin.value.length>15)
	{

		alert("The user ID must be between 5 and 15 characters.");
		return false;
	}

	if(document.register.userpass.value.length<4 || document.register.userpass.value.length>15)
	{

		alert("The password must be between 4 and 15 characters.");
		return false;
	}

	if(document.register.username.value.length<3 || document.register.username.value.length>30)
	{
		alert("The name must be between 3 and 30 characters.");
		return false;
	}

	if(document.register.userlogin.value == "" ||
			document.register.username.value == "" ||
			document.register.userpass.value == "" ||
			document.register.usermail.value == ""
	)  
	{
		alert("Please fill in all fields.");
		return false;
	}

	if(!verifMail(document.register.usermail.value))  
	{

		alert("The e-mail is not in the right format.");
		return false;
	}
}



function check_editUser()
{

	  if(!detectSpec(document.editUser.userlogin.value))
    {
       alert("The user ID can not contain special characters.");
       return false;
    } 
   
	
	if(!detectSpec(document.editUser.username.value))
    {
       alert("The name can not contain special characters.");
       return false;
    } 

	  if(document.editUser.userlogin.value.length<5 || document.editUser.userlogin.value.length>15)
	  {

	   alert("The user ID must be between 5 and 15 characters.");
	   return false;
	  }
	  
	  if(document.editUser.username.value.length<3 || document.editUser.username.value.length>30)
	  {
	   alert("The name must be between 3 and 30 characters.");
	   return false;
	  }

	   if(document.editUser.userlogin.value == "" ||
		  document.editUser.username.value == "" ||
		  document.editUser.usermail.value == ""
	   )  
	   {
		   alert("Please fill in all fields.");

		   return false;
	  }
		
	  if(!verifMail(document.editUser.usermail.value))  
	   {
	 
	   alert("The e-mail is not in the right format.");
	   return false;
	  }
}

function check_userupdatedata()
{

	if(!detectSpec(document.userupdatedata.username.value))
    {
       alert("The name can not contain special characters.");
       return false;
    } 


	  if(document.userupdatedata.username.value.length<3 || document.editUser.username.value.length>30)
	  {
	   alert("The name must be between 3 and 30 characters.");
	   return false;
	  }

	   if(document.userupdatedata.username.value == "" ||
		  document.userupdatedata.usermail.value == ""
	   )  
	   {
		   alert("Please fill in the field Name and Email.");

		   return false;
	  }
	   
	   if(document.userupdatedata.oldpass.value == ""  )  
	   {
		   alert("Please fill in your old password.");
		   return false;
	   }
		
	  if(!verifMail(document.userupdatedata.usermail.value))  
	   {
	 
	   alert("The e-mail is not in the right format.");
	   return false;
	  }
}


function detectSpec(chaine) {
	var iChars = "!@#$%^&*()+=-[]\\\';,./{}|\":<>?";

	  for (var i = 0; i <chaine.length; i++) {
	  	if (iChars.indexOf(document.formname.fieldname.value.charAt(i)) != -1) {
	  	return false;
	  	}
	  }
}
