import java.util.*;

/**
 * class for the Jump Snatch game.
 */
public class JumpSnatchGame {

   public Board      board    = null;
   
   public Player     snatcher = null;
   public Player     jumper   = null;

   public boolean    gameOver       = false;   
   public int        numOfTurns     = 0;
   public MoveList   lastMoveList   = null;

   public String     mcMsg = null;

  
  /**
   * Creates a new game instance.
   */
  public JumpSnatchGame() {
      
    board = new Board(Const.DEFALUT_BOARD_SIZE);  
  }

  public void newGame(int pnBoardSize) {
      
    board = new Board(pnBoardSize);  
  }

  /**
   * start of a new game
   */
   public void start(int pnSnatcherId, int pnJumperId) {

      if(pnSnatcherId == Const.HUMAN) {
         snatcher = new HumanPlayer( Const.TIME_LIMIT, pnSnatcherId, Const.SNATCHER);
      }
      if(pnJumperId == Const.HUMAN) {
         jumper   = new HumanPlayer( Const.TIME_LIMIT, pnJumperId,   Const.JUMPER);
      }

      gameOver       = false;   
      numOfTurns     = 0;
      lastMoveList   = null;
      
      return;
   }

  /**
   * return true if game is over.
   */
   public boolean isGameOver() {

      if(!gameOver) {
         if(board.getNumOfStonesOnBoard() < 2) {
            gameOver = true;
         }
      }

      return gameOver;
   }

  /**
   * return the player whose turn is next.
   */
   public Player getPreviousPlayer() {
   
      if((numOfTurns % 2) == 1) {
         return snatcher;
      }
      else {
         return jumper;
      }
   }
  
  /**
   * return the player whose turn is next.
   */
   public Player getNextPlayer() {
   
      if((numOfTurns % 2) == 0) {
         return snatcher;
      }
      else {
         return jumper;
      }
   }
      
  /**
   * Get next player to play the game.
   *    note: invalid moves are not executed on the board here and game will be over.
   * 
   * Return true if the moves were successfully placed on the board, 
   *        set the player, player's moves, and applicable error message.
   */
   public boolean play(Player pcPlayer, MoveList pcMoveList) {
      boolean  lbDone     = false;
      Player   nextPlayer = getNextPlayer();
      MoveList moveList   = null;
      Board    boardTemp  = null;

      mcMsg = null;

      if(!isGameOver()) {
      
         boardTemp  = board.copy();     //new copy of the board

         //ttt if(nextPlayer == null) {
         //ttt    System.out.println("==> play() null player");
         //ttt }
         //ttt else {
         //ttt    if(nextPlayer.type == Const.JUMPER)
         //ttt       System.out.println("==> play() player jumper");
         //ttt    else
         //ttt       System.out.println("==> play() player snatcher"); 
         //ttt }

         moveList = nextPlayer.play(boardTemp);         

         if(moveList != null) {
            mcMsg = board.editMoves(moveList);
            if(mcMsg != null) {
               board.executeMoves(moveList);
               lbDone = true;
            }
            else {
               gameOver = true;
            }         
         }
      }
      else {
         mcMsg = "Game is over";
      }

      numOfTurns++;
      lastMoveList = moveList;
      
      pcPlayer   = nextPlayer;
      pcMoveList = moveList;
      
      return(lbDone);      
   }

  /**
   * return the player whose turn is next.
   */
   public String getLastMsg() {
      return(mcMsg);         
   }
}
