/*-----------------------------------------------------------------------------------**
** Course:			CSCI-GA.2965 Fall 2011                                             **
** Project:       Jump Snatch Game                                                   **
**                                                                                   **
** Class:         JumpSnatchApplet (Applet)                                          **
**                                                                                   **
** <p>                                                                               **
** <center>                                                                          **
** <applet code="JumpSnatchApplet.class" width=750 height=700>                       **
** <param name=debug value="n"> <== optional parameter, set to 'y' for debug only    **
** </applet>                                                                         **
** </center>                                                                         **
**-----------------------------------------------------------------------------------*/

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class JumpSnatchApplet extends Applet {


	public Image      hiddenimagebuffer;
	public Graphics   hiddengraphics;
   public boolean    debug;

   public JumpSnatchGame game = null;
   
   public String     winner      = "not set";
   public String     winnerScore = "not set";
   public String     winnerTries = "not set";
         
	public void init() {
   
      loadParameters();

      game = new JumpSnatchGame();
      
		setLayout(new BorderLayout());
		ViewPanel vp = new ViewPanel(this);

		add("Center",  vp);	 
		add("North",   new ControlsTop(vp));

		hiddenimagebuffer = createImage(this.size().width, this.size().height);
		hiddengraphics    = hiddenimagebuffer.getGraphics();

		repaint();
	}

   //get the applet parameters. 
   protected void loadParameters() { 
      String value;
      
      debug = false;
      value = getParameter("debug");
      if(value != null) {
		   if(value.equals("y")) {
            debug = true;
		   }
      }
   } 

	public void resetWinner() {
      winner      = "not set";
      winnerScore = "not set";
      winnerTries = "not set";
	}

	public String getWinner() {
      return winner;
	}

	public String getWinnerScore() {
      return winnerScore;
	}

	public String getWinnerTries() {
      return winnerTries;
	}

	public boolean handleEvent(Event e) {
		switch (e.id) {
		case Event.WINDOW_DESTROY:
			System.exit(0);
			return true;
		default:
			return false;
		}
	}

	public static void main(String args[]) {
		Frame f = new Frame("JumpSnatchApplet");
		JumpSnatchApplet view = new JumpSnatchApplet();
		view.init();
		view.start();
		f.add("Center", view);
		f.show();
	}
}


/**
 * ViewPanel
 */
class ViewPanel extends Panel implements MouseListener, MouseMotionListener{

	JumpSnatchApplet   parent;
   public boolean     debug;         

	private boolean firstTime = true;
	private boolean gameStart = false;   
	private boolean gameOver  = false;      

   private int     numOfSnatch = 0;
   private int     numOfSlide  = 0;
   private int     numOfJump   = 0;
   
   //done button
   Button      doneButton = null;
   
   //help button
   Button      buttonGameHelp = null;
   private HelpFrame helpFrame;
   
   //board size
   private int boardSize = Const.DEFALUT_BOARD_SIZE;   
	public static final int BOARD_SIZE_3 = 3;
	public static final int BOARD_SIZE_4 = 4;
	public static final int BOARD_SIZE_5 = 5;      

   private int snatcherId = Const.HUMAN;
   private int jumperId   = Const.HUMAN;

   private MoveList  moveListHuman = null;
   
   private Player    lastPlayer   = null;
   private MoveList  lastMoveList = null;;
   private String    lastMsg      = null;

	private int gridspace = 4;                         //one cell occupies 2 grid space
	private int gridlines = Const.DEFALUT_BOARD_SIZE; 	//lines on either side of the center, default to 3

   //frame of the board 
	private int min_x, max_x, min_y, max_y;
   //center of the board
	private int centerX, centerY;

   //mouse movements
	private int       mousePresX,  mousePresY;   
	private int       mouseDragX,  mouseDragY;   
	private int       mouseRlseX,  mouseRlseY;   
	private boolean   mousePres = false;         //pressed
	private boolean   mouseDrag = false;         //dragged
	private boolean   mouseRlse = true;          //released

	private boolean   invalidJump  = false;      //for display msg
	private boolean   invalidSlide = false;      //for display msg

   //stone selected by mouse
	private int       stoneSelIdxX, stoneSelIdxY;   
	private int       sel_min_x, sel_max_x, sel_min_y, sel_max_y;
	private boolean   stoneSel = false;
      
	ViewPanel(JumpSnatchApplet target) {
		this.parent = target;      
      this.debug  = target.debug;
      setLayout(null);

      //done button
 		doneButton = new Button("End My Turn");
      int x = (int) Math.round(parent.size().width  * 0.81); 
      int y = 15;       
      int w = (int) Math.round(parent.size().width  * 0.18); 
      int h = 35;      
      doneButton.setBounds(x, y, w, h);    //x, y, w, h
 		add(doneButton);                                  
 		doneButton.addActionListener(actionDone); 
      doneButton.setEnabled(false);
		doneButton.setVisible(false);      

      //help frame
		helpFrame = new HelpFrame();
		helpFrame.setVisible(false);      

      //game help
 		buttonGameHelp = new Button(" H e l p ");              
      x = (int) Math.round(parent.size().width  * 0.01);      
      y = 15;       
      w = (int) Math.round(parent.size().width  * 0.14); 
      h = 35;      
      buttonGameHelp.setBounds(x, y, w, h);    //x, y, w, h
 		add(buttonGameHelp);                                  
 		buttonGameHelp.addActionListener(actionGameHelp); 		
      
      init();

		addMouseListener(this);
		addMouseMotionListener(this);      
	}

	public void init() {

      moveListHuman = new MoveList();
      parent.game.start(snatcherId, jumperId);
      if(debug) {      
         System.out.println("viewpanel init()...");
      }      
	}

	public void start() {
	}

	public void stop() {
	}

	public void destroy() {
	}

	public void setBoardSize(int boardSize) {
      this.boardSize = boardSize;
      parent.game.newGame(boardSize);
      initSize();
      repaint();
	}

	public void setSnatcherId(int snatcherId) {
      this.snatcherId = snatcherId;
	}

	public void setJumperId(int jumperId) {
      this.jumperId = jumperId;
	}

	public void actionNewGame() {
      parent.game.newGame(boardSize);
      parent.resetWinner();
      resetNumOfMoves();      
      gameStart = false;
      gameOver  = false;

      disableDoneButton();
      repaint();
	}

	public void actionGameStart() {
      parent.game.start(snatcherId, jumperId);
      
      if(snatcherId == Const.HUMAN ||
         jumperId   == Const.HUMAN) {
         moveListHuman = new MoveList();
      }
       
      resetNumOfMoves();
      gameStart = true;
      gameOver  = false;

      disableDoneButton();
      repaint();
	}

	public void actionGameOver() {

      gameStart = false;
      gameOver  = true;
      lastPlayer = parent.game.getNextPlayer();
         
      if(lastMsg == null || lastMsg.length() == 0) {
         parent.winner = lastPlayer.getName();
         lastMsg = "Game over and the winner is " + parent.winner;
      }
      else {
         //let opponent win?
         Player player = parent.game.snatcher;
         if(lastPlayer.getType() == Const.SNATCHER) {
            player = parent.game.jumper;
         }
         parent.winner = player.getName();
         lastMsg = "Game over and the winner is " + parent.winner;
      }

      if(debug) {      
         System.out.println(lastMsg);
      }
      
      disableDoneButton();
	}

	public void actionDone() {
      boolean lbMovesExecuted = false;
      boolean lbGameOver = false;

      if(!noValidOfMove()) {
         lbMovesExecuted = parent.game.play(lastPlayer, lastMoveList);
         lastMsg = parent.game.getLastMsg();
         lbGameOver = parent.game.isGameOver();

         if(lbGameOver) {
            actionGameOver();
         }

         moveListHuman = new MoveList();      
         resetNumOfMoves();
         
         disableDoneButton();
         repaint();
      }
	}

  	ActionListener actionDone = new ActionListener () {

		public void actionPerformed(ActionEvent actionDone) {
			actionDone();
		}

	};

	public void enableDoneButton() {
      doneButton.setEnabled(true);
  		doneButton.setVisible(true);      
	}   

	public void disableDoneButton() {
      doneButton.setEnabled(false);
  		doneButton.setVisible(false);      
	}   


   //action - game help
  	ActionListener actionGameHelp = new ActionListener () {

		public void actionPerformed(ActionEvent actionGameHelp) {

			helpFrame.setVisible(true);
		}
	};   

	public void initSize() {

      gridlines = boardSize;
      gridspace = (int) Math.round((size().height - 40) / (gridlines*2 + 1)); 

		centerX = size().width  / 2;
		centerY = ((size().height - 40) / 2) + 30 ;

      if(debug) {      
         System.out.println("viewpanel initSize() - w " + parent.size().width + " h " + parent.size().height + 
                            " s " + gridspace + " centerX " + centerX + " centerY " + centerY + 
                            " wp " + size().width + " wh " + size().height);
      }
	}	 

	public void paint(Graphics g) {
		int x, y, r;
      int xi, yi;
      int width, height;
      
      if(parent.size().height == size().height) {
         return;
      }

      if(firstTime) {
         initSize();
      }

		min_x = (centerX - gridspace * gridlines);
		max_x = (centerX + gridspace * gridlines);
		min_y = (centerY - gridspace * gridlines);
		max_y = (centerY + gridspace * gridlines);

      if(debug) {
         System.out.println("paint() - w " + parent.size().width + " h " + parent.size().height + 
                            " s " + gridspace + " centerX " + centerX + " centerY " + centerY + 
                            " wp " + size().width + " wh " + size().height);
      }

		parent.hiddengraphics.setColor( new Color(245, 245, 245) ); //white
		parent.hiddengraphics.fillRect(0,0,size().width,size().height);
		parent.hiddengraphics.setColor(Color.black);
		parent.hiddengraphics.drawRect(0,0,size().width-1,size().height-1);

      //draw grid
		{
         int ctr = 0;
			parent.hiddengraphics.setColor(Color.lightGray);
         //column
         ctr = 0;
			for (int i = -gridlines; i <= gridlines; i++)  {
				x = (centerX + i * gridspace);
            ctr++;
            if((ctr % 2) == 1) {
				   parent.hiddengraphics.drawLine( x, min_y, x, max_y );
            }
			}
         //row
         ctr = 0;
			for (int i = -gridlines; i <= gridlines; i++)  {
				y = (centerY + i * gridspace);
            ctr++;
            if((ctr % 2) == 1) {
				   parent.hiddengraphics.drawLine( min_x, y, max_x, y );
            }
			}
		}

      //layout stones
      r = (int) Math.round(gridspace * 0.75);
      int twoR = 2 * r;
      boolean lbSkip = false;

      Color green = new Color(0,220,0);
      boolean	[][]  lbArrCellEmpty = parent.game.board.getRawBoard();      
      
		for(int i=0; i<boardSize; i++) {
         for(int j=0; j<boardSize; j++) {

            if(!lbArrCellEmpty[i][j]) {
               lbSkip = false;
               parent.hiddengraphics.setColor(green);
               if(stoneSel) {
                  if(stoneSelIdxX == i && 
                     stoneSelIdxY == j) {
                     lbSkip = true;
                  }
               }
               if(!lbSkip) {
                  xi = i*2 + 1 - gridlines;
                  yi = gridlines - j*2 - 1;
		            x = (centerX + xi * gridspace);
                  y = (centerY + yi * gridspace);
	               parent.hiddengraphics.fillOval(x-r, y-r, twoR, twoR);
               }
            }
         }
		}

      //selected stone
      if(stoneSel) {
         parent.hiddengraphics.setColor(Color.red);      
         parent.hiddengraphics.fillOval(mouseDragX - r, mouseDragY - r, twoR, twoR);      
      }

		//szcwww beg draw the status string      
		if (!gameOver) {
         if(gameStart) {
            if(parent.game.board.isBoardFull()) {
			      displayRedString("Snatcher's Turn: snatch one piece off the board", 200, 35);
            }
            else {
               Player player = parent.game.getNextPlayer();
               if(player.getType() == Const.JUMPER) {
                  displayBlueString("Jumper's Turn", 300, 35);
               }
               else {
                  displayRedString("Snatcher's Turn", 300, 35);
               }
               //message
               if(doneButton.isVisible()) {
                  displayMsgString("At least one more jump is possible.  Please either take it or hit 'End My Turn'", 145, 55);
               }
               else if(invalidJump) {
                  displayMsgString("Undid the move because Player has to jump in this situation.", 200, 55);
               }
               else if(invalidSlide) {
                  if(parent.game.board.isCenterPiece(new Move(stoneSelIdxX, stoneSelIdxY))) {
                     displayMsgString("Undid the move because the center piece could not be moved in this situation.", 145, 55);
                  }
                  else {
                     displayMsgString("Undid the move because Player has to move one piece towards the center in this situation.", 120, 55);
                  }
               }
            }
         }
         else {
            displayString("Press Start button to play the game", 230, 35);
         }
		}
      else {
         //game over, declare the winner
         if(lastPlayer.getType() == Const.SNATCHER) {
            displayRedString(lastMsg, 200, 35);
         }
         else {
            displayBlueString(lastMsg, 200, 35);
         }         
      }
		//szcwww end draw the status string
      
		g.drawImage(parent.hiddenimagebuffer, 0,0, this);

      firstTime = false;
	}

	public void displayMsgString(String s, int x, int y) {
      Font textFont = new Font("Arial",Font.PLAIN,12);
      parent.hiddengraphics.setFont(textFont);           
	   parent.hiddengraphics.setColor(Color.black);
	   parent.hiddengraphics.drawString(s, x, y);         
	}

	public void displayString(String s, int x, int y) {
      Font textFont = new Font("Arial",Font.BOLD,13);
      parent.hiddengraphics.setFont(textFont);           
	   parent.hiddengraphics.setColor(Color.black);
	   parent.hiddengraphics.drawString(s, x, y);         
	}

	public void displayBlueString(String s, int x, int y) {
      Font textFont = new Font("Arial",Font.BOLD,13);
      parent.hiddengraphics.setFont(textFont);           
	   parent.hiddengraphics.setColor(Color.blue);
	   parent.hiddengraphics.drawString(s, x, y);         
	}

	public void displayRedString(String s, int x, int y) {
      Font textFont = new Font("Arial",Font.BOLD,13);
      parent.hiddengraphics.setFont(textFont);           
	   parent.hiddengraphics.setColor(Color.red);
	   parent.hiddengraphics.drawString(s, x, y);         
	}

	public void update(Graphics g) {
		paint(g);
	}

	public boolean insideBoard(int x, int y) {
      boolean lbInside = false;

		if (inside(x, y)) {
         if((x > min_x && x < max_x) &&
            (y > min_y && y < max_y)) {
            lbInside = true;
         }         
      }      
      return(lbInside);
	}

	public void resetNumOfMoves() {
      numOfSnatch = 0;
      numOfSlide  = 0;
      numOfJump   = 0;   
      
      invalidJump  = false;
      invalidSlide = false;      
   }

	public boolean noValidOfMove() {
      boolean lbNoValidMove = false;
      
      if((numOfSnatch + numOfSlide + numOfJump) == 0) {
         lbNoValidMove = true;
      }

      return(lbNoValidMove);
	}

	public boolean validNumOfMoves() {
      boolean lbValid = false;
      
      if((numOfSnatch + numOfSlide + numOfJump) == 1) {
         lbValid = true;
      }
      else {
         if(numOfSnatch == 1 && (numOfSlide + numOfJump) == 0) {
            lbValid = true;
         }
         else if(numOfSlide == 1 && (numOfSnatch + numOfJump) == 0) {
            lbValid = true;
         }
         else if(numOfJump >= 1 && (numOfSnatch + numOfSlide) == 0) {
            lbValid = true;
         }
      }

      if(debug) {
         System.out.println("validNumOfMoves() - " + " numOfSnatch " + numOfSnatch + " numOfSlide " + numOfSlide + 
                            " numOfJump " + numOfJump + " lbValid " + lbValid);
      }

      return(lbValid);
	}

	public boolean mouseHitStone(int pnX, int pnY) {
      boolean        lbHit = false;
      boolean [][]   lbArrCellEmpty = parent.game.board.getRawBoard();      
		int x, y, r;
      int xi, yi;
	   int minX, maxX, minY, maxY;

      r = (int) Math.round(gridspace * 0.5);
      int twoR = 2 * r;
      
		for(int i=0; i<boardSize; i++) {
         for(int j=0; j<boardSize; j++) {

            if(!lbArrCellEmpty[i][j]) {

               xi = i*2 + 1 - gridlines;
               yi = gridlines - j*2 - 1;
		         x = (centerX + xi * gridspace);
               y = (centerY + yi * gridspace);
               minX = x-r;
               maxX = x+r;               
               minY = y-r;
               maxY = y+r;
               if((pnX > minX && pnX < maxX) &&
                  (pnY > minY && pnY < maxY)) {
                  lbHit = true;
                  stoneSel = true;
                  stoneSelIdxX = i;
                  stoneSelIdxY = j;
                  sel_min_x = x - gridspace;
                  sel_max_x = x + gridspace;                  
                  sel_min_y = y - gridspace;
                  sel_max_y = y + gridspace;
                  break;
               }                        
            }
         }
		}
      return(lbHit);
	}

	public Move getSelReleasedMove(int pnX, int pnY) {
      Move           move = null;
      boolean        lbHit = false;
      boolean [][]   lbArrCellEmpty = parent.game.board.getRawBoard();      
		int x, y, r;
      int xi, yi;
	   int minX, maxX, minY, maxY;

      r = (int) Math.round(gridspace * 0.75);
      
		for(int i=0; i<boardSize; i++) {
         for(int j=0; j<boardSize; j++) {

            xi = i*2 + 1 - gridlines;
            yi = gridlines - j*2 - 1;
		      x = (centerX + xi * gridspace);
            y = (centerY + yi * gridspace);
            minX = x-r;
            maxX = x+r;               
            minY = y-r;
            maxY = y+r;
            if((pnX > minX && pnX < maxX) &&
               (pnY > minY && pnY < maxY)) {
               lbHit = true;
               move = new Move(i, j);
               break;
            }                        
         }
		}
      return(move);
	}

	public void mousePressed(MouseEvent e) {

      if(!gameStart) {
         return;
      }

		mousePresX = e.getX();
		mousePresY = e.getY();
      mousePres = true;
      mouseDrag = false;
      mouseRlse = false;      
      
      stoneSel = false;

		if (insideBoard(mousePresX, mousePresY)) {
         //check if it was pressed on a stone
         if(mouseHitStone(mousePresX, mousePresY)) {
            stoneSel = true;
            if(debug) {
               System.out.println("mousePressed() - hit stone" + " mousePresX " + mousePresX + " mousePresY " + mousePresY + 
                                  " i " + stoneSelIdxX + " j " + stoneSelIdxY +
                                  " wp " + size().width + " wh " + size().height);
            }
            //QQQ repaint();
         }         		
		}
	}

	public void mouseDragged(MouseEvent e) {

      invalidJump  = false;
      invalidSlide = false;

      if(!gameStart) {
         return;
      }

		mouseDragX = e.getX();
		mouseDragY = e.getY();
      mouseDrag = true;
      mouseRlse = false;

		if (insideBoard(mouseDragX, mouseDragY)) {

         if(stoneSel) {
            if(debug) {
               System.out.println("mouseDragged() - " + " mouseDragX " + mouseDragX + " mouseDragY " + mouseDragY + 
                                  " s " + gridspace +
                                  " wp " + size().width + " wh " + size().height);
            }
         
			   repaint();
         }
		}
      else {
         if(stoneSel) {
            if(debug) {
               System.out.println("mouseDragged() - " + " mouseDragX " + mouseDragX + " mouseDragY " + mouseDragY + 
                                  " s " + gridspace +
                                  " wp " + size().width + " wh " + size().height);
            }
         
			   repaint();
         }      
      }
   }

	public void mouseReleased(MouseEvent e) {

      invalidJump  = false;
      invalidSlide = false;

      if(!gameStart) {
         return;
      }

		mouseRlseX = e.getX();
		mouseRlseY = e.getY();
      mouseRlse = true;
      boolean [][]   lbArrCellEmpty = parent.game.board.getRawBoard();
      boolean lbGameOver = false;
      boolean lbActionDone = false;
      boolean lbValidMove  = false;

      moveListHuman = new MoveList();

		if (insideBoard(mouseRlseX, mouseRlseY)) {

         if(stoneSel) {
            if(debug) {
               System.out.println("mouseReleased() - " + " mouseRlseX " + mouseRlseX + " mouseRlseY " + mouseRlseY + 
                                  " s " + gridspace +
                                  " wp " + size().width + " wh " + size().height);
            }

            Move move = getSelReleasedMove(mouseRlseX, mouseRlseY);
            //jump or slide
            if(move != null) {
               if(lbArrCellEmpty[move.x][move.y]) {
                  moveListHuman.add(new Move(stoneSelIdxX, stoneSelIdxY));
                  moveListHuman.add(move);
                  if(debug) {
                     System.out.println("mouseReleased() - move from : " + moveListHuman.first().toString());
                     System.out.println("mouseReleased() - move to   : " + move.toString());
                  }                  
                  
                  lastMsg = parent.game.board.editMoves(moveListHuman);
                  if(lastMsg == null) {
                     if(moveListHuman.first().type == Const.TYPE_JUMP) {
                        numOfJump++;
                     }
                     else if(moveListHuman.first().type == Const.TYPE_SLIDE) {
                        numOfSlide++;
                     }
                     if(validNumOfMoves()) {
                        lbValidMove = true;
                        parent.game.board.executeMoves(moveListHuman);                     
                        lbGameOver = parent.game.isGameOver();
                                                   
                        if(moveListHuman.first().type == Const.TYPE_SLIDE) {
                           //slide
                           lbActionDone = true;
                        }
                        else {
                           //jump
                           if(parent.game.board.hasValidJumps()) {
                              //At least one more jump is possible.  Please either take it or hit 'End My Turn'"
                              enableDoneButton();
                           }
                           else {
                              lbActionDone = true;
                           }
                        }
                     }
                  }                 
               }
            }

 			   repaint();
         }
		}
      else {
         if(stoneSel) {
            if(debug) {
               System.out.println("mouseReleased() - " + " mouseRlseX " + mouseRlseX + " mouseRlseY " + mouseRlseY + 
                                  " s " + gridspace +
                                  " wp " + size().width + " wh " + size().height);
            }
            //snatch
            moveListHuman.add(new Move(stoneSelIdxX, stoneSelIdxY));
            lastMsg = parent.game.board.editMoves(moveListHuman);
            if(lastMsg == null) {
               if(moveListHuman.first().type == Const.TYPE_SNATCH) {
                  numOfSnatch++;
               }
               if(validNumOfMoves()) {
                  lbValidMove = true;
                  parent.game.board.executeMoves(moveListHuman);
                  lbActionDone = true;
               }
            }
			   repaint();
         }      
      }

      if(lbGameOver) {
         actionGameOver();
      }
      else {
         if(lbActionDone) {
            actionDone();
         }
         else {
            if(!lbValidMove) {
               if(parent.game.board.hasValidJumps()) {
                  //Undid the move because Player has to jump in this situation.
                  invalidJump = true;
               }
               else {
                  //Undid the move because Player has to move one piece towards the center in this situation.
                  invalidSlide = true;
               }                  
            }         
         }
      }
      
      mousePres = false;
      mouseDrag = false;      
      stoneSel = false;
   }
   
	public void mouseMoved(MouseEvent e) {}

	public void mouseClicked(MouseEvent e) {}

	public void mouseEntered(MouseEvent e) {}

	public void mouseExited(MouseEvent e) {}
}


/**
 * ControlsTop
 */
class ControlsTop extends Panel {

	ViewPanel      target;
   public boolean debug;         

	String labelBoardSize3  = "3";      
	String labelBoardSize4  = "4";
	String labelBoardSize5  = "5";

	String labelPlayerHuman  = "Human";
	String labelPlayerRandom = "Random";   

   Choice choiceBoard;
   Choice choiceSnatcher;
   Choice choiceJumper;
   Button buttonNewGame;
   Button buttonGameStart;
            
	public ControlsTop (ViewPanel target) {
		this.target = target;
      this.debug  = target.debug;
		setLayout(new FlowLayout(FlowLayout.CENTER));
		setBackground(Color.lightGray);

      if(debug) {
         System.out.println("ControlsTop() - ...");
      }

      //board size
		add(new Label("Board Size:", Label.RIGHT));
		choiceBoard = new Choice();
		choiceBoard.addItem(labelBoardSize3);
		choiceBoard.addItem(labelBoardSize4);
		choiceBoard.addItem(labelBoardSize5);
		choiceBoard.addItemListener(itemBoard);
		choiceBoard.select(0);
		add(choiceBoard);

      //snatcher id
		add(new Label("Snatcher:", Label.RIGHT));
		choiceSnatcher = new Choice();
		choiceSnatcher.addItem(labelPlayerHuman);
		//www choiceSnatcher.addItem(labelPlayerRandom);
		choiceSnatcher.addItemListener(itemSnatcher);
		choiceSnatcher.select(0);
		add(choiceSnatcher);

      //jumper id
		add(new Label("Jumper:", Label.RIGHT));
		choiceJumper = new Choice();
		choiceJumper.addItem(labelPlayerHuman);
		//www choiceJumper.addItem(labelPlayerRandom);
		choiceJumper.addItemListener(itemJumper);
		choiceJumper.select(0);
		add(choiceJumper);

      //new game
 		buttonNewGame = new Button("New Game");              
 		add(buttonNewGame);                                  
 		buttonNewGame.addActionListener(actionNewGame); 

      //game start
 		buttonGameStart = new Button("  Start  ");              
 		add(buttonGameStart);                                  
 		buttonGameStart.addActionListener(actionGameStart); 		
	}

   //item listenser - board choice
  	ItemListener itemBoard = new ItemListener () {

		public void itemStateChanged(ItemEvent itemBoard) {
      
         String item = (String) itemBoard.getItem();
         if(debug) {
            System.out.println("itemStateChanged() - itemBoard.toString(): " + itemBoard.toString());
            System.out.println("itemStateChanged() - item: " + item);
         }         
         
			if (item.equals(labelBoardSize5)) {
				target.setBoardSize(ViewPanel.BOARD_SIZE_5);
			} 
			else if (item.equals(labelBoardSize4)) {
				target.setBoardSize(ViewPanel.BOARD_SIZE_4);
			}
			else {
				target.setBoardSize(ViewPanel.BOARD_SIZE_3);
			}
		}
	 };  

   //item listenser - snatcher choice
  	ItemListener itemSnatcher = new ItemListener () {

		public void itemStateChanged(ItemEvent itemSnatcher) {
      
         String item = (String) itemSnatcher.getItem();
         if(debug) {
            System.out.println("itemStateChanged() - itemSnatcher.toString(): " + itemSnatcher.toString());
            System.out.println("itemStateChanged() - item: " + item);
         }         
         
			if (item.equals(labelPlayerHuman)) {
				target.setSnatcherId(Const.HUMAN);
			} 
			else if (item.equals(labelPlayerRandom)) {
				target.setSnatcherId(Const.RANDOM);
			}
		}
	 };  

   //item listenser - jumper choice
  	ItemListener itemJumper = new ItemListener () {

		public void itemStateChanged(ItemEvent itemJumper) {
      
         String item = (String) itemJumper.getItem();
         if(debug) {
            System.out.println("itemStateChanged() - itemJumper.toString(): " + itemJumper.toString());
            System.out.println("itemStateChanged() - item: " + item);
         }         
         
			if (item.equals(labelPlayerHuman)) {
				target.setJumperId(Const.HUMAN);
			} 
			else if (item.equals(labelPlayerRandom)) {
				target.setJumperId(Const.RANDOM);
			}
		}
	 };  

   //action - new game
  	ActionListener actionNewGame = new ActionListener () {

		public void actionPerformed(ActionEvent actionNewGame) {

			target.actionNewGame();
         
         choiceBoard.setEnabled(true);
         choiceSnatcher.setEnabled(true);
         choiceJumper.setEnabled(true);         
         buttonGameStart.setEnabled(true);
		}

	};

   //action - game start
  	ActionListener actionGameStart = new ActionListener () {

		public void actionPerformed(ActionEvent actionGameStart) {

			target.actionGameStart();
         
         choiceBoard.setEnabled(false);
         choiceSnatcher.setEnabled(false);
         choiceJumper.setEnabled(false);
         buttonGameStart.setEnabled(false);
		}

	};
}
