import java.lang.*;
import java.awt.*;
import java.awt.event.*;

public class HelpFrame extends Frame
	implements ActionListener {
	
	public HelpFrame() {
		System.out.println("HelpFrame()");

		setLayout(new BorderLayout());
		
		text_area = new TextArea(help, 30, 65, TextArea.SCROLLBARS_VERTICAL_ONLY);
		text_area.setEditable(false);
		add(text_area, "Center");

		addWindowListener(new WindowCloser());
		
		setTitle("Jump Snatch Help");
		pack();
	}

	public void actionPerformed(ActionEvent e) {
		setVisible(false);
	}

	private TextArea text_area;

	private final String help = new String(

"\nThe Jump Snatch board consists of 3, 4, or 5 all squares of a grid \n" + 
"which is initially filled with pieces.\n\n" +
"The Snatcher removes a piece from any square he/she chooses.\n" +
"The Jumper then makes the first move after which moves alternate \n" + 
"between Snatcher and Jumper until one player does a jump that \n" +
"leaves just one piece thereby winning.\n\n" +
"You can jump a piece if it is between you and an empty square \n" +
"along any line, vertical, horizontal or diagonal.  When you jump \n" +
"a piece, you remove it.\n\n" +
"If a jump is possible, a move consists of jumping (after doing \n" +
"one jump, each additional jump is optional).\n" +
"If no jump is possible, then the move must consist of sliding\n" +
"a piece towards the center if possible.  If that's not possible, \n " +
"the player may slide any piece in any direction except for the center \n" +
"piece of the odd size board.  After doing one slide, each additional \n" +
"slide is not allowed.\n\n" +
"To do a move on the board, point mouse at the applicable piece, \n" +
"drag it to an empty square and release the mouse button.\n\n" +
"For moves where there is an ambiguity (another jump is possible), \n" +
"the Player has the choice to take it or leave it by hitting 'End My Turn'.\n" +
"'End My Turn' button will appear only when at least one more jump is possible.\n\n" +
"Invalid moves will be undone and an message will be displayed to the Player\n" +
"explaining why."
);

}

class WindowCloser extends WindowAdapter {
	public void windowClosing(WindowEvent e) {
		System.out.println("windowClosing(WindowEvent)");
		e.getWindow().dispose();
	}
}
