//*****************************
//  Voronoi.Java
//  Monty Faidley and
//  Chris Poultney
//  Copyright 1997
//  ver 2.0  July 22, 1997
//*****************************
import java.applet.*;
import java.awt.*;
import java.io.InputStream;
import java.net.URL;
import java.util.*;

public class Voronoi extends Applet implements Runnable {
  
  public final static double LOW=.0000001;

  public final static int MAX_PLAYERS=8;
  public String THUNKER;
  public String BIGPOLY;
  public String GETWINNER;
  public String GOODGUESS;
  public String HUMAN;
  public String NONE;
  
  public String COMP1;
  public String COMP2;
  public String COMP3;
  public String COMP4;

  //*****GUI Stuff*******
  Panel rightPan;
  CardLayout rightPanCard;
  VInfo myInfo;
  Button infoBut;
//  Choice choice;
  
  int players=8;
  int turns=15;
  VPoint[] iPt=new VPoint[((turns*players+4)*(turns*players+3))/2];
  int[][] track=new int[((turns*players+4)*(turns*players+3))/2][2];
  
  boolean humanMove,done,gameOn;
  static final int RAD=5;
  double total;
  int portWidth,portHeight,screenWidth,screenHeight;
  VPoint[] corner=new VPoint[4];
  VLine[] border=new VLine[4];
  int xmin,xmax,ymin,ymax;
  double[] area;
  VBTree pt=new VBTree(turns*players);
  VPoly[] polys;
  boolean[] needUpdate;
  public String[] playerName;
  Color[] colors=new Color[8];
  Color[] playerColor=new Color[8];
  String[] Player=new String[8];
  String[] PlayStr ={"","","","","","","",""};
  Image playI, bigI;
  Graphics bigb, myG, playb;
  public Thread play_thread=null;
  VPoint passPt;
  
  //*** from VDialog.java

  private Button vdDone;
  private Choice[] vdChoice = new Choice[8];
  private Choice vdTurns = new Choice();
  private Panel vdPan = new Panel();
  public int Amount = 10;

  //*** from VWin.java ***

  private Button vwDone;
  private Label vwLab, vwLab2;
  private Panel vwPan = new Panel();

  //*** new v2.0

  private Panel ipPan = new Panel();
  private Label ipLab;
  private Button resetBut;

  //*** new stuff 4/2007
  public int pauseTime = 2000;
  Properties stringProps;
  
  public void init() {
      
  //******Properties******
    stringProps = new Properties();
    String sf = getParameter("stringFile");
    try {
      URL u = new URL(getDocumentBase(), sf);
      InputStream in = u.openStream();
      stringProps.load(in);
      System.out.println("using string file: " + sf);
    } catch(Exception e) {
	System.out.println("cannot open stringFile " + sf + ", using default");
    }
    THUNKER = stringProps.getProperty("strings.voronoi.thunker", "Thunker");
    BIGPOLY = stringProps.getProperty("strings.voronoi.bigpoly", "Biggest Poly");
    GETWINNER = stringProps.getProperty("strings.voronoi.getwinner", "Get Winner");
    GOODGUESS = stringProps.getProperty("strings.voronoi.goodguess", "Good Guess");
    HUMAN = stringProps.getProperty("strings.voronoi.human", "Human");
    NONE = stringProps.getProperty("strings.voronoi.none", "None");
    playerName = new String[8];
    playerName[0] = stringProps.getProperty("strings.voronoi.player1", "Red");
    playerName[1] = stringProps.getProperty("strings.voronoi.player2", "Blue");
    playerName[2] = stringProps.getProperty("strings.voronoi.player3", "Green");
    playerName[3] = stringProps.getProperty("strings.voronoi.player4", "Orange");
    playerName[4] = stringProps.getProperty("strings.voronoi.player5", "Pink");
    playerName[5] = stringProps.getProperty("strings.voronoi.player6", "Gray");
    playerName[6] = stringProps.getProperty("strings.voronoi.player7", "Purple");
    playerName[7] = stringProps.getProperty("strings.voronoi.player8", "Brown");
    vdDone = new Button(stringProps.getProperty("strings.voronoi.play", "Play"));
    vwDone = new Button(stringProps.getProperty("strings.voronoi.playagain", "Play Again"));
    ipLab = new Label(stringProps.getProperty("strings.voronoi.inprogress", "Game play in progress..."));
    resetBut = new Button(stringProps.getProperty("strings.voronoi.reset", "Reset"));

    COMP1 = THUNKER;
    COMP2 = BIGPOLY;
    COMP3 = GETWINNER;
    COMP4 = GOODGUESS;

  //******GUI Stuff*******
    setLayout(null);
//    choice = new Choice();
//    choice.addItem("File");
//    choice.addItem(stringProps.getProperty("strings.voronoi.reset", "Reset"));
//    choice.addItem(stringProps.getProperty("strings.voronoi.info", "Info"));
//    choice.reshape(0,0,80,20);
//    add( choice );
//    choice.move(10,10);

    String it = stringProps.getProperty("strings.voronoi.info", "Info");
    infoBut = new Button(it);
    FontMetrics fm = getFontMetrics(getFont());
    int w = fm.stringWidth(it);
    infoBut.reshape(0, 0, w+16, 20);
    add(infoBut);
    infoBut.move(10, 10);

    rightPanCard = new CardLayout();
    rightPan = new Panel();
    rightPan.reshape(485,0,getWidth()-490,440);
    rightPan.setLayout(rightPanCard);
    add( rightPan );

    //*** from VDialog.java

    vdPan.setLayout(new GridLayout(12,1));
    Panel p;

    for(int x=2; x<16; x++)
      vdTurns.addItem(Integer.toString(x));
    vdTurns.select("10");
    p = new Panel();
    p.setLayout(new GridLayout(1, 2));
    p.add(new Label(stringProps.getProperty("strings.voronoi.turns", "Turns:")));
    p.add(vdTurns);
    vdPan.add(p);

    for(int i=0; i<8; i++)
    {
      vdChoice[i] = new Choice();
      vdChoice[i].addItem(NONE);
      vdChoice[i].addItem(HUMAN);
      vdChoice[i].addItem(COMP1);
      vdChoice[i].addItem(COMP2);
      vdChoice[i].addItem(COMP3);
      vdChoice[i].addItem(COMP4);
      p = new Panel();
      p.setLayout(new GridLayout(1, 2));
      p.add(new Label(playerName[i]));
      p.add(vdChoice[i]);
      vdPan.add(p);
    }
    vdChoice[0].select(COMP1);
    vdChoice[1].select(HUMAN);
    vdPan.add(vdDone);

    rightPan.add( "VDialog", vdPan );
    rightPanCard.addLayoutComponent( "VDialog", vdPan );

  //*** from VWin.java ***
    String mess = "";
    vwLab = new Label( mess, Label.CENTER );
    vwLab2 = new Label("", Label.CENTER);
    vwPan.setLayout(new GridLayout(3, 1));
    vwPan.add( vwLab );
    vwPan.add(vwLab2);
    vwPan.add(vwDone);
    Panel tempPan = new Panel();
    tempPan.setLayout(new BorderLayout());
    tempPan.add(vwPan, BorderLayout.NORTH);
    rightPan.add( "VWin", tempPan );
    rightPanCard.addLayoutComponent( "VWin", tempPan );

    //*** new v2.0

    ipPan.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));
    ipPan.add( ipLab );
    ipPan.add( resetBut );
    rightPan.add( "IP", ipPan );
    rightPanCard.addLayoutComponent( "IP", ipPan );

    rightPanCard.show(rightPan, "VDialog");

    area=new double[players];
    polys=new VPoly[players*turns];
    needUpdate=new boolean[players*turns];
    
    colors[0] = new Color(240,50,50);
    colors[1] = new Color(50,50,240);
    colors[2] = new Color(50,200,50);
    colors[3] = Color.orange;
    colors[4] = Color.magenta;
    colors[5] = new Color(175,175,175);
    colors[6] = new Color(100,0,100);
    colors[7] = new Color(200,100,50);
    
    for(int i=0;i<iPt.length;i++) {
      iPt[i]=new VPoint();
    }

    for(int i=0;i<8;i++) {
      Player[i]=playerName[i];
      playerColor[i]=colors[i];
    }
    
    xmin=0;
    xmax=400;
    ymin=40;
    ymax=440;
    corner[0] = new VPoint(xmin,ymin);
    corner[1] = new VPoint(xmin,ymax);
    corner[2] = new VPoint(xmax,ymax);
    corner[3] = new VPoint(xmax,ymin);
    border[0] = new VLine(corner[0],corner[1]);
    border[1] = new VLine(corner[1],corner[2]);
    border[2] = new VLine(corner[2],corner[3]);
    border[3] = new VLine(corner[3],corner[0]);
    portWidth=xmax;
    portHeight=ymax;
    screenWidth=bounds().width;
    screenHeight=bounds().height;
    this.setBackground(Color.white);
    bigI=createImage(screenWidth,screenHeight);
    bigb=bigI.getGraphics();
    playI=createImage(portWidth,portHeight);
    playb=playI.getGraphics();
    myG=this.getGraphics();
  }//End of init
  
  private void StartOver() {
    clearthis();
    pt.Reset();
    PlayStr[0]=COMP1;
    PlayStr[1]=HUMAN;
    turns = 10;
    for(int i=2; i<8; i++)
      PlayStr[i]=NONE;
    
    SetVars();
    
    for(int i=0;i<players;i++) {
      area[i]=0;
    }

    gameOn=true;
  }  
  
  private void SetVars()
  {
    players = 8;

    play_thread.suspend();

    turns = Integer.parseInt(vdTurns.getSelectedItem());
    players=0;
    for(int i=0; i<8; i++)
      {
        if( vdChoice[i].getSelectedItem().equals(NONE) ) {
          ;
        } else {
          Player[players]=playerName[i];
          PlayStr[players]=vdChoice[i].getSelectedItem();
          playerColor[players]=colors[i];
          players++;
        }
      }
  }
  
  public void DrawScreen( )
  {
    int Pnum = pt.numPts()%players;
    int RectHeight=(int)380/players;
    int TurnNum = (int)Math.floor(pt.numPts()/players)+1;
    
    bigb.setColor(Color.darkGray);
    bigb.fillRect(0,0,400,40);
    bigb.fillRect(400,40,80,20);
    
    bigb.setColor(Color.white);
    bigb.drawString(stringProps.getProperty("strings.voronoi.title", "The Voronoi Game"), 145, 20);
    bigb.drawString(stringProps.getProperty("strings.voronoi.score", "Score"), 425, 55);
    
    bigb.setColor(playerColor[Pnum]);
    bigb.fillRect(400,0,80,40);
    bigb.setColor(Color.white);
    bigb.drawString(Player[Pnum],402,15);
    
    if( TurnNum > turns )
      bigb.drawString(stringProps.getProperty("strings.voronoi.gameover", "Game Over"),402,35);
    else
      bigb.drawString(stringProps.getProperty("strings.voronoi.turn", "Turn") + ": "+TurnNum+"/"+turns, 402, 35);
    
    for(int i=0; i<players; i++)
      {
        bigb.setColor(playerColor[i]);
        bigb.fillRect(400,60+i*RectHeight,80,RectHeight);
        bigb.setColor(Color.white);
        bigb.drawString(PlayStr[i], 402, 60+(int)(RectHeight/2)+i*RectHeight);
        bigb.drawString(" " + (int)area[i], 402, 75+(int)(RectHeight/2)+i*RectHeight);
        bigb.setColor(Color.black);
        bigb.drawRect(400,60+i*RectHeight,79,RectHeight);
        if(i == Pnum && gameOn && TurnNum <= turns) {
          bigb.drawRect(401,60+i*RectHeight+1,79-2,RectHeight-2);
          bigb.drawRect(402,60+i*RectHeight+2,79-4,RectHeight-4);
        }
      }
    bigb.setColor(Color.black);
    bigb.drawRect(0,0,479,439);
    bigb.drawRect(400,0,79,40);
    bigb.drawRect(0,0,400,39);
    bigb.drawRect(400,40,79,20);
  }

  int pcnt = 0;
  public void paint(Graphics g) {
    DrawScreen();
    g.drawImage(bigI, 0, 0, this);
    if(pcnt == 0)
      repaint();
    else if(pcnt == 1)
      showStatus(stringProps.getProperty("strings.voronoi.choose", "Choose number of turns and players"));
    pcnt++;
  }
  
  public void Update( Graphics g )
  {
    g.drawImage(playI, 0, 0, this);
  }                                        
  
  public void clear() {
    
    playb.setColor(Color.white);
    playb.fillRect(0,40,400,400);
    playb.setColor(Color.black);
  }
  
  public void clearthis() {
    
    myG.setColor(Color.white);
    myG.fillRect(0,40,400,400);
    myG.setColor(Color.black);
  }
  
  public boolean mouseUp(Event e,int x,int y) {
    if(!humanMove) {
      return true;
    }
    
    VPoint t=new VPoint(x,y);
    passPt=null;
    if(!validPt(t))
      return true;
    
    if((e.modifiers & Event.CTRL_MASK) != 0) {
      String msg="New poly area:"+PolyArea((double)x,(double)y);
      showStatus(msg);
      return true;
    } else if((e.modifiers & Event.SHIFT_MASK) != 0) {
      String msg="("+x+","+y+")";
      showStatus(msg);
      return true;
    }
    
    // Check if duplicate point
    if(isDup(t))
      return true;
    
    passPt=new VPoint(x,y);
    done=true;
    
    return true;
  }
  
  public void FindBisectors(VPoint here,int pts) {
    pt.FindBisectors(border,here,pts);
  }
  
  public int FindIntPoints(VPoint[] iPt,int[][] track,VPoint here,int pts) {
    int numInt=0,numTot=0;
    VLine tempLn;
    VPoint tempPt;
    for(int i=0;i<pts+3;i++) {
      tempLn=pt.bisect(i);
      for(int j=i+1;j<pts+3;j++) {
        numTot++;
        tempPt=tempLn.Intersect(pt.bisect(j));
        if(validIntPt(tempPt)) {
          iPt[numInt].Set(tempPt);
          track[numInt][0]=i;
          track[numInt][1]=j;
          numInt++;
        }
      }
    }
//    Totals info, do not remove
//    System.out.println("numInt:"+numInt+"/"+numTot);
    
    return numInt;
  }
  
  public VPoly GetNewPoly(boolean ep,VPoint here,VPoint[] iPt,int[][] track,VPoint[][] addPts,int numInt,int pts) {
    
    VSegment tempSeg=new VSegment();
    VPoly retPoly=new VPoly(here);
    VPoint tempPt;
    int temp,loopVar,realAdd;
    boolean newPt,done;
    
    realAdd=0;
    loopVar=0;
    for(int i=0;i<numInt;i++) {
      if(iPt[i]==null) {
      } else {
        tempSeg.Set(here,iPt[i]);
        if((pt.SetPrevNext(iPt[i]))==null) {
          done=true;
        } else {
          done=false;
        }
        newPt=true;
        for(int j=0;!done;j++) {
          loopVar++;
          done=pt.IterDone();
          if(j%2==0) {
            temp=pt.GetNext().num();
          } else {
            temp=pt.GetPrev().num();
          }
          if(track[i][0]==temp+4 || track[i][1]==temp+4) {
            continue;
          }
          tempPt=tempSeg.Intersect(pt.bisect(temp+4));
          if(tempPt!=null) {
            if(Math.abs(iPt[i].dX()-tempPt.dX())==0 && Math.abs(iPt[i].dY()-tempPt.dY())==0 && ep) {
              ;
            } else {
              newPt=false;
              break;
            }
          }
        }
        if(newPt) {
          realAdd++;
          retPoly.Add(iPt[i]);
          if(track[i][0]>3 && ep) {
            needUpdate[track[i][0]-4]=true;
          }
          if(track[i][1]>3 && ep) {
            needUpdate[track[i][1]-4]=true;
          }
        }
      }
    }
//    more totals info, do not remove
//    System.out.print("loopVar:"+loopVar+",avg="+(double)loopVar/(double)numInt);
//    System.out.println(",realAvg="+(double)(loopVar-realAdd*pt.numPts())/(double)(numInt-realAdd));
    
    return retPoly;
  }
  
  public void UpdatePolys(VPoint[][] addPts,VPoly newPoly) {
    for(int i=0;i<pt.numPts()-1;i++) {
      if(needUpdate[i]) {
        DeleteOldPoints(polys[i],pt.bisect(i+4));
        AddNewPoints(polys[i],newPoly,pt.bisect(i+4));
      }
    }
  }
  
  
  public void DrawPolys(Graphics g) {
    double temp;
    
    for(int i=0;i<players;i++) {
      area[i]=0;
    }
    
    clear();
    total=0;
    for(int i=0;i<pt.numPts();i++) {
      temp=polys[i].Area();
      area[i%players]+=temp;
      total+=temp;
      polys[i].Draw(g,playerColor[i%players]);
      g.setColor(Color.black);
      g.fillOval(pt.point(i).iX()-RAD,pt.point(i).iY()-RAD,RAD*2,RAD*2);
    }
  }
  
  public void DeleteOldPoints(VPoly P,VLine B) {
    double s=B.Eval(P.GetCenter());
    double ps,qs;
    int temp;
    VPoint tempPt=new VPoint();
    s/=Math.abs(s);
    temp=P.NumPoints();
    for(int j=0;j<temp;j++) {
      tempPt=P.Get(j);
      if(tempPt==null) {
        continue;
      }
      ps=B.Eval(tempPt);
      qs=B.Eval(tempPt);
      if(Math.abs(ps)>=.01) {
        if(Math.abs(ps)<.5 && ps/Math.abs(ps)!=s) {
        }
        qs/=Math.abs(qs);
        if(qs!=s) {
          P.Delete(tempPt);
          j--;
          temp--;
        } else {
          ;
        }
      } else {
        ;
      }
    }
  }
  
  public void AddNewPoints(VPoly P,VPoly newPoly,VLine B) {
    VPoint tempPt;
    VPoint[] addMe={null,null};
    double[] vals={0,0};
    double newVal,tx,ty;
    
    for(int i=0;i<newPoly.NumPoints();i++) {
      addMe[0]=null;
      addMe[1]=null;
      vals[0]=5000000;
      vals[1]=5000000;
      tempPt=newPoly.Get(i);
      if(Math.abs(B.Dist2(tempPt))<LOW) {
        tx=tempPt.dX()-newPoly.GetCenter().dX();
        ty=tempPt.dY()-newPoly.GetCenter().dY();
        newVal=tx*tx+ty*ty;
        for(int j=0;j<2;j++) {
          if(newVal<vals[j]) {
            vals[j]=newVal;
            addMe[j]=tempPt;
            break;
          }
        }
      }
      for(int j=0;j<2;j++) {
        if(addMe[j]!=null) {
          P.Add(addMe[j]);
        }
      }
    }
  }
  
  public boolean action(Event e, Object arg)
  {
    if( ((String)e.arg).equals("File") )
    {
      return true ;
    } else if( ((String)e.arg).equals(stringProps.getProperty("strings.voronoi.info", "Info")) ){
      myInfo = new VInfo(stringProps);
//      choice.select("File");
      return true;
    } else if( ((String)e.arg).equals("Quit") ){
      //destroy();
//      choice.select("File");
      return true;
    } else if( ((String)e.arg).equals(stringProps.getProperty("strings.voronoi.reset", "Reset")) ){
      gameOn = false;
//      choice.select("File");
      rightPanCard.show(rightPan, "VDialog");
      showStatus(stringProps.getProperty("strings.voronoi.choose", "Choose number of turns and players"));
      return true;
    } else if( e.target == vdDone ){
      rightPanCard.show(rightPan, "IP");
      play_thread.resume();
      return true;
    } else if( e.target == vwDone ){
      showStatus(stringProps.getProperty("strings.voronoi.choose", "Choose number of turns and players"));
      rightPanCard.show(rightPan, "VDialog");
      play_thread.resume();
      return true;
    }
    return false;
  }
  
  public void pause() {
      try {
	  Thread.sleep(pauseTime);
      } catch(InterruptedException ie) { ; }
  }
  
  public void start() {
    // start animation thread
    if(play_thread==null) {
      play_thread=new Thread(this);
      play_thread.start();
    }
  }
  
  public void stop() {
    // stop animation thread
    if(play_thread!=null && play_thread.isAlive()) {
      play_thread.stop();
    }
    play_thread=null;
  }
  
  public void run() {
    while(true) {
      StartOver();
      Update(bigb);
      clear();
      paint(myG);
      while(pt.numPts()<players*turns && gameOn) {
        VPoint newPt=null;
        showStatus(stringProps.getProperty("strings.voronoi.waitingfor", "Waiting for") + " "
        	+ Player[pt.numPts()%players] + " (" + PlayStr[pt.numPts()%players] + ")");
        humanMove=false;
        if(PlayStr[pt.numPts()%players].equals(THUNKER)) {
          pause();
          newPt=Thunker();
        } else if(PlayStr[pt.numPts()%players].equals(BIGPOLY)) {
          pause();
          newPt=BigPoly();
        } else if(PlayStr[pt.numPts()%players].equals(GETWINNER)) {
          pause();
          newPt=GetWinner();
        } else if(PlayStr[pt.numPts()%players].equals(GOODGUESS)) {
          pause();
          newPt=GoodGuess();
        } else if(PlayStr[pt.numPts()%players].equals(HUMAN)) {
          humanMove=true;
          newPt=null;
          done=false;
          while((!done) && gameOn) {
              try {
        	  Thread.sleep(50);
              } catch(InterruptedException ie) { ; }
          }
          humanMove=false;
          newPt=passPt;
        }
	
        if(newPt!=null) {
          AddPt(newPt);
	  
          DrawPolys(playb);
          if((int)total!=160000) {
//            System.out.println(total);
          }
	  
          Update(bigb);
          clear();
          paint(myG);
	  
        }
      } // main game loop
      if(gameOn) {
	showStatus(stringProps.getProperty("strings.voronoi.gameover", "Game Over"));
        GameOverBox();
      }
    } // while(1)
  }
  public void GameOverBox () {
    double mArea = area[0];
    int winner = 0;
    for(int x=1; x<players; x++)
    {
      if( mArea < area[x] )
      {
        mArea = area[x];
        winner = x;
      }
    }//end for
    vwLab.setText(stringProps.getProperty("strings.voronoi.winner", "And the winner is") + "...");
    String winString = "";
    for( int y=0; y<MAX_PLAYERS; y++)
    {
      if( playerColor[winner] == colors[y] )
      {
        winString += " " + playerName[y];
        break;
      }
    }//end for
    winString += " " + PlayStr[winner];
    vwLab2.setText( winString );
    rightPanCard.show( rightPan, "VWin" );
    play_thread.suspend();
  }
  
  public int PolyArea(double x,double y) {
    int a=(int)NewPoly(new VPoint(x,y),false,null).Area();
    
    return a;
  }
  
  public void AddPt(VPoint thePt) {
    VPoint[][] addPts=new VPoint[pt.numPts()][10];
    
    for(int i=0;i<players*turns;i++) {
      needUpdate[i]=false;
    }
    
    pt.Add(new VPoint(thePt));
    polys[pt.numPts()-1]=new VPoly(NewPoly(thePt,true,addPts));
  }
  
  public VPoly NewPoly(VPoint thePt,boolean eval,VPoint[][] addPts) {
    int numInt;
    VPoly temPoly;
    int tempts;
    
    tempts=eval ? pt.numPts() : pt.numPts()+1;
    
    FindBisectors(thePt,tempts);
    
    numInt=FindIntPoints(iPt,track,thePt,tempts);
    
    pt.Sort(thePt,tempts-1);

    temPoly=GetNewPoly(eval,thePt,iPt,track,addPts,numInt,tempts);
    
    if(eval) {
      UpdatePolys(addPts,temPoly);
    }
    
    return temPoly;
  }
  
  //********** Computer Move Functions *************
  
  private VPoint Thunker()
  {
    Random Rnd = new Random();
    boolean Cont = true;
    VPoint retVal = new VPoint();
    while( Cont == true )
      {
        int x = Math.abs(Rnd.nextInt()%(xmax-xmin-1))+xmin+1;
        int y = Math.abs(Rnd.nextInt()%(ymax-ymin-1))+ymin+1;
        retVal.Set(x,y);
        Cont = isDup(retVal);
      }//end while
    return( retVal );
  }//End Thunker
  
  private VPoint BigPoly()
  {
    long temp[] = {0, 0, 0, 0};
    int num=0;
    VPoint tempPoint = new VPoint();
    if( pt.numPts() == 0 )
      {
	tempPoint.Set( 200, 200 );
	return( tempPoint );
      }
    
    for(int i=0; i<pt.numPts(); i++)
      {
	if( (temp[0] < polys[i].PArea)&&( pt.numPts()%players != i%players) )
	  {
	    num = i;
	    temp[0] = (long)polys[i].PArea;
	  }
      }
    //ASSERT: num is now the # of the biggest poly
    return( EvalPoly( num ));
  }//End of BigPoly
  
  private VPoint GetWinner()
  {
    int tooBig=0;
    int thePoint=0;
    int numP = (int)Math.floor(pt.numPts()/players);
    VPoint retVal = new VPoint();
    if( pt.numPts() == 0 )
      {
        retVal.Set( 200, 200 );
        return( retVal );
      }
    
    for(int i=0; i<players; i++)
      if( (area[tooBig] < area[i])&&( pt.numPts()%players != i) )
        tooBig = i;
    //ASSERT::tooBig is the # of the guy who is too big
    for(int i=0; i<numP; i++)
      {
        thePoint = (i*players)+(tooBig);
	
      }
    //ASSERT::thePoint is the point of the biggest poly he owns
    return( EvalPoly( thePoint ));
  }
  
  private VPoint EvalPoly( int PolyNum )
  {
    long temp[] = {0, 0, 0, 0};
    int num=-1;
    VPoint tempPoint = new VPoint();
    VPoint[] tempPts=new VPoint[4];
    tempPoint = polys[PolyNum].GetCenter();
    
    tempPts[0] = new VPoint(tempPoint.dX()+10,tempPoint.dY()+9);
    tempPts[1] = new VPoint(tempPoint.dX()-9,tempPoint.dY()+10);
    tempPts[2] = new VPoint(tempPoint.dX()+10,tempPoint.dY()-9);
    tempPts[3] = new VPoint(tempPoint.dX()-9,tempPoint.dY()-10);
    for(int i=0;i<4;i++) {
      if(isDup(tempPts[i]) || !validPt(tempPts[i])) {
        temp[i]=0;
      } else {
        num=i;
        temp[i]=PolyArea(tempPts[i].dX(),tempPts[i].dY());
      }
    }
    if( num==-1)
      return Thunker();
    if( temp[0] > temp[1] ) {
      tempPoint=tempPts[0];
      num=0;
    } else {
      tempPoint=tempPts[1];
      num=1;
    }
    if( temp[2] > temp[num] ) {
      tempPoint=tempPts[2];
      num=2;
    } else if( temp[3] > temp[num] ) {
      tempPoint=tempPts[3];
      num=3;
    }
    //ASSERT::num = the # of the biggest possible poly
    return( tempPoint );
  }//End of EvalPoly
  
  private VPoint GoodGuess()
  {
    boolean Cont = true;
    int x=0, y=0, num=0;
    Random Rnd = new Random();
    VPoint retVal[] = new VPoint[10];
    long Area=0, tArea=0;
    
    for( int i=0; i<10; i++)
      {
        Cont=true;
        while( Cont == true )
          {
            x = Math.abs(Rnd.nextInt()%(xmax-xmin-1))+xmin+1;
            y = Math.abs(Rnd.nextInt()%(ymax-ymin-1))+ymin+1;
            retVal[i]=new VPoint(x,y);
            Cont = isDup(retVal[i]);
          }//end while      
      }//End big for
    //ASSERT::retVal[] is an array of 10 random points
    
    for(int w=0; w<10; w++)
      {
        tArea = PolyArea( retVal[w].dX(), retVal[w].dY() );
        if( Area < tArea ) {
          Area=tArea;
          num = w;
        }
      }
    return( retVal[num] );
  }//End GoodGuess
  
  public boolean isDup(VPoint p) {
    for(int i=0;i<pt.numPts();i++) {
      if(pt.point(i).equals(p)) {
        return true;
      }
    }
    return false;
  }
  
  public boolean validIntPt(VPoint p) {
    if(p==null) {
      return false;
    }
    return (p.dX()>=xmin-1 && p.dX()<=xmax+1 && p.dY()>=ymin-1 && p.dY()<=ymax+1);
  }
  
  public boolean validPt(VPoint p) {
    if(p==null) {
      return false;
    }
    return (p.dX()>xmin && p.dX()<xmax && p.dY()>ymin && p.dY()<ymax);
  }
  
}//End of class Voronoi
