package nyu.hps.notipping.web;

// NoTippingApplet
//
// version 1.0
// location: \java\notipping\
//
// Tyler Neylon, 2002
//

import java.applet.*;
import java.lang.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.util.Vector;
import javax.swing.JComboBox;
import java.awt.Color;

//////////////////////////////////////////
//////////////////////////////////////////

public class NoTippingApplet extends Applet {

	public String myWinner = "not set";
	public String myLoser = "not set";
	public String myWinnerScore = "not set";
	public String myLoserScore = "not set";

    public void init() {
    }

	public void start() {
		Color myColor = Color.decode("#352D0D");
		setBackground(myColor);
		new NoTippingFrame();
	}
	
	public String getWinner()
	{
		myWinner = NoTippingComponent.getTheWinner();
		return myWinner;
	}
	
	
	public String getLoser()
	{
		myLoser = NoTippingComponent.getTheLoser();
		return myLoser;
	}
	
	
	public String getWinnerScore()
	{
		myWinnerScore = NoTippingComponent.getTheWinnerScore();
		return myWinnerScore;
	}
	
	public String getLoserScore()
	{
		myLoserScore = NoTippingComponent.getTheLoserScore();
		return myLoserScore;
	}
}

//////////////////////////////////////////
//////////////////////////////////////////

class NoTippingFrame extends Frame {
	public NoTippingFrame() {
		setLayout(new BorderLayout());
		NoTippingComponent main_display = new NoTippingComponent();
		add(main_display, "Center");
		Container toolbar = new Panel();
		GridBagLayout gbl = new GridBagLayout();
		GridBagConstraints gbc = new GridBagConstraints();
		toolbar.setLayout(gbl);
		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 1.0;

		JComboBox c1 = new JComboBox();
		c1.setName("GameType");
		c1.addItem("Human (Red) vs Computer (Blue)");
		c1.addItem("Computer (Red) vs Human (Blue)");
		c1.addItem("Human (Red) vs Human (Blue)");
		c1.setActionCommand("GameType");
		c1.addActionListener(main_display);
		toolbar.add(c1);
		
		JComboBox c2 = new JComboBox();
		c2.setName("Difficulty");
		c2.addItem("Easy");
		c2.addItem("Medium");
		c2.addItem("Hard");
		c2.setActionCommand("Difficulty");
		c2.addActionListener(main_display);
		toolbar.add(c2);
		
		Label l = new Label();
		l.setText("Weights: ");
		toolbar.add(l);
		
		c2 = new JComboBox();
		c2.setName("NumWeights");
		for (int i=5;i<=10;i++) {
			c2.addItem(i);
		}
		c2.setSelectedIndex(10-5);
		c2.setActionCommand("NumWeights");
		c2.addActionListener(main_display);
		toolbar.add(c2);

		Button b = new Button("Start");
		b.setActionCommand("Restart");
		b.addActionListener(main_display);
		gbl.setConstraints(b, gbc);
		toolbar.add(b);

		b = new Button("Hint");
		b.setActionCommand("Hint");
		b.addActionListener(main_display);
		gbl.setConstraints(b, gbc);
		toolbar.add(b);
		
		b = new Button("Help");
		b.setActionCommand("Help");
		b.addActionListener(main_display);
		gbl.setConstraints(b, gbc);
		toolbar.add(b);

		addWindowListener(new WindowCloser());

		add(toolbar, "North");
		setTitle("The No Tipping Game");
		pack();
		setVisible(true);
		setEnabled(true);
	}
}

//////////////////////////////////////////
//////////////////////////////////////////

class WindowCloser extends WindowAdapter {
	public void windowClosing(WindowEvent e) {
		System.out.println("windowClosing(WindowEvent)");
		e.getWindow().dispose();
	}
}

