function QueryArtist( id, divID ) {
    this.id = id;                       // Identificator of this object
    this.divID = divID;                 // ID of the div where to place this object
    this.N = 0;                         // Number of tags
    this.name = "";                     // Name of the Artist
    this.tagList = new Array();         // Tag list (Objects: name, count, url)
    this.dropDown;                      // Drop down list
    this.artistImageURL;                // Image URL for the given artist
    this.fitnessScore = 0.0;            // Fitness Score for the given artist
    this.tagsReady = false;             // Boolean to know if we have loaded the tags info
    this.artistReady = false;           // Boolean to know if the have loaded the artist info
    this.MAX_TAGS = 10;                  // Max tags to display (constant)

    /**
    * Sets the name of the artist
    * @param name    Name of the artist
    * @return         
    */
    this.setName = function( name ) {
        this.name = name;
    }

    /**
    * Sets the URL of artist image
    * @param imageURL   Image URL for the artist image
    * @return         
    */
    this.setArtistImageURL = function( imageURL ) {
        this.artistImageURL = imageURL;
    }

    /**
    * Sets the list of tags
    * @param score   Float from 0-1 representing the fitness score
    * @return         
    */
    this.setFitnessScore = function( score ) {
        this.fitnessScore = score;
    }

    /**
    * Sets the list of fitness scores for each tag
    * @param tags   Array of tags objects (tag object: name, count, url)
    * @return         
    */
    this.setTagList = function( tags ) {
        this.N = tags.length;
        for ( var i = 0; i < this.N; i++ ) {
            this.tagList[i] = tags[i]
        }
    }

    /**
    * Callback function for the artist info from LastFM
    * @param data   data from LastFM getArtistInfo
    * @return
    */
    this.tagsCallback = function( data ) {
        //console.log( data );
        //console.log( data.toptags.tag );
        this.setTagList( data.toptags.tag );
        this.tagsReady = true;
        this.print( );
    }

    /**
    * Callback function for the artist info from LastFM
    * @param data   data from LastFM getArtistInfo
    * @return
    */
    this.artistCallback = function( data ) {
        //console.log( data );
        //console.log(  data.artist.image[3]["#text"] );
        this.setArtistImageURL( data.artist.image[2]["#text"] );
        this.artistReady = true;
        this.print( );
    }

    /**
    * Retrieves the Artist Info from LastFM and calls the artistCallback
    * @param
    * @return         
    */
    this.getArtistInfo = function( ) {
        qArtist = this;
        lastfm.artist.getInfo({artist: this.name},
            {
                success: function(data){
                    /* Use data. */
                    qArtist.artistCallback( data );
                }, 
                error: function(code, message){
                    /* Show error message. */
                    document.write("<p>ERROR</p>");
                }
            }
        );
    }

    /**
    * Retrieves the Top Tags from LastFM and calls the tagsCallback
    * @param
    * @return         
    */
    this.getTopTags = function( ) {
        qArtist = this;
        lastfm.artist.getTopTags({artist: this.name},
            {
                success: function(data){
                    /* Use data. */
                    qArtist.tagsCallback( data );
                }, 
                    error: function(code, message){
                    /* Show error message. */
                    document.write("<p>ERROR</p>");
                }
            }
        );
    }

    /**
    * Gets the necessary info from LastFM (a name is necessary)
    * @param tags   Array of tags objects (tag object: name, count, url)
    * @return         
    */
    this.getLastFMInfo = function( name ) {
        this.name = name;
        this.getArtistInfo( );
        this.getTopTags( );
    }

       
    
    /**
    * Prints the Query Artist Object
    * @param
    * @return       HTML formatted string
    */
    this.print = function( ) {
        if ( this.tagsReady && this.artistReady ) {
            var tags = "";
            for ( var i = 0; i < this.MAX_TAGS; i++ ) {
                tags += '<div id="tagQA">' + 
                    '<div id="tagNameQA">' + this.tagList[i].name + '</div>' + 
                    '<div id="progressQA"><span id="tag' + i + this.id + '">[ Loading Progress Bar ]</span></div></div><br/>';
            }
            string = 'Artist: ' + this.name + "<br/>"
                + "<img src=\"" + this.artistImageURL + "\" /><br/>"
                + '<div id="tagsQA">' + tags + '</div>';
            
            //string += '<div id="tag"><span id="tag1">[ Loading Progress Bar ]</span></div>';
            this.divID.html( string );

            var progressBars = new Array( );
            for ( var i = 0; i < this.MAX_TAGS; i++ ) {
                progressBars[i] = new JS_BRAMUS.jsProgressBar($('tag'+i+this.id), this.tagList[i].count,
                    {
                        barImage	: Array(
                            'images/bramus/percentImage_back4.png',
                            'images/bramus/percentImage_back3.png',
                            'images/bramus/percentImage_back2.png',
                            'images/bramus/percentImage_back1.png'
                        ),
                        onTick : function(pbObj) {return true;}
                    }
                );

            }
        }
    };
}
