/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.text.DecimalFormat;
import java.util.Random;

public class RandomPlayer {
    RandomPlayer(String host, int port, String name, int nGambles, int nRuns) throws Exception {
        System.out.println("connecting");
        Socket s = new Socket(host, port);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(s.getOutputStream()));
        BufferedReader br = new BufferedReader(new InputStreamReader(s.getInputStream()));
        bw.write(String.valueOf(name) + "\n");
        bw.flush();
        String in = br.readLine();
        if (!in.equals("OK")) {
            System.out.println("got back: " + in);
            throw new RuntimeException();
        }
        double[] allocs = new double[nGambles];
        Random rnd = new Random();
        DecimalFormat df = new DecimalFormat("0.00000");
        int i = 0;
        while (i < nRuns) {
            System.out.println("playing round " + i);
            int j = 0;
            while (j < nGambles) {
                allocs[j] = rnd.nextDouble();
                ++j;
            }
            RandomPlayer.normalize(allocs);
            StringBuffer sb = new StringBuffer(nGambles * 8);
            int j2 = 0;
            while (j2 < nGambles) {
                sb.append(df.format(allocs[j2])).append(" ");
                ++j2;
            }
            String out = sb.toString();
            System.out.println("sending: " + out);
            bw.write(String.valueOf(out) + "\n");
            bw.flush();
            in = br.readLine();
            if (!in.equals("OK")) {
                System.out.println("got back: " + in);
                throw new RuntimeException();
            }
            in = br.readLine();
            System.out.println("got back: " + in);
            ++i;
        }
        System.out.println("done");
    }

    static void normalize(double[] d) {
        double total = 0.0;
        int i = 0;
        while (i < d.length) {
            total += d[i];
            ++i;
        }
        i = 0;
        while (i < d.length) {
            int n = i++;
            d[n] = d[n] / total;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 5) {
            System.out.println("usage:  java RandomPlayer <host> <port> <name> <nGambles> <nRuns>");
            System.exit(1);
        }
        new RandomPlayer(args[0], Integer.parseInt(args[1]), args[2], Integer.parseInt(args[3]), Integer.parseInt(args[4]));
    }
}

