/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;

public class LongDataGen {
    static final DecimalFormat DF_INT = new DecimalFormat("000");
    static final DecimalFormat DF_RET = new DecimalFormat("00.000");
    static final DecimalFormat DF_PROB = new DecimalFormat("0.000");
    static final int HI = 0;
    static final int MD = 1;
    static final int LO = 2;
    static final double MAX_RET = 40.0;
    static final Random RND = new Random();

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("\tusage:  java DataGen <nGambles> <outFile>\n");
            System.exit(1);
        }
        int ng = Integer.parseInt(args[0]);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(args[1]));
            bw.write("#gamble(gambleid, high return, high prob, medium return, med prob, low return, low prob)");
            bw.newLine();
            int i = 0;
            while (i < ng) {
                double[] probs = new double[3];
                probs[2] = RND.nextDouble() * 0.8 + 0.1;
                probs[1] = RND.nextDouble() * 0.8 + 0.1;
                probs[0] = RND.nextDouble() * 0.8 + 0.1;
                double probsTotal = probs[0] + probs[1] + probs[2];
                probs[2] = probs[2] / probsTotal;
                probs[1] = probs[1] / probsTotal;
                probs[0] = probs[0] / probsTotal;
                double[] rets = new double[3];
                rets[2] = RND.nextDouble() * 0.3 + 0.05;
                rets[1] = RND.nextDouble() * 0.5 + 0.05;
                rets[0] = (1.0 - (probs[1] * rets[1] + probs[2] * rets[2])) / probs[0];
                if (rets[0] <= rets[1] || rets[0] >= 40.0 || probs[1] < 0.4) {
                    --i;
                } else {
                    bw.write(String.valueOf(DF_INT.format(i)) + ", " + DF_RET.format(rets[0]) + ", " + DF_PROB.format(probs[0]) + ", " + DF_RET.format(rets[1]) + ", " + DF_PROB.format(probs[1]) + ", " + DF_RET.format(rets[2]) + ", " + DF_PROB.format(probs[2]));
                    bw.newLine();
                }
                ++i;
            }
            bw.newLine();
            ArrayList<Integer> g2a = new ArrayList<Integer>(ng);
            int floor = (int)Math.floor(ng / 16);
            int i2 = 0;
            while (i2 < 16) {
                int j = 0;
                while (j < floor) {
                    g2a.add(new Integer(i2));
                    ++j;
                }
                ++i2;
            }
            int nRemaining = ng - 16 * floor;
            if (nRemaining > 0) {
                ArrayList<Integer> aperm = new ArrayList<Integer>();
                int i3 = 0;
                while (i3 < 16) {
                    aperm.add(new Integer(i3));
                    ++i3;
                }
                Collections.shuffle(aperm);
                i3 = 0;
                while (i3 < nRemaining) {
                    g2a.add((Integer)aperm.get(i3));
                    ++i3;
                }
            }
            Collections.shuffle(g2a);
            bw.write("#gambleatts(gambleid, gambleclass)");
            bw.newLine();
            int i4 = 0;
            while (i4 < ng) {
                String s = null;
                switch ((Integer)g2a.get(i4)) {
                    case 0: {
                        s = "0";
                        break;
                    }
                    case 1: {
                        s = "1";
                        break;
                    }
                    case 2: {
                        s = "2";
                        break;
                    }
                    case 3: {
                        s = "3";
                        break;
                    }
                    case 4: {
                        s = "4";
                        break;
                    }
                    case 5: {
                        s = "5";
                        break;
                    }
                    case 6: {
                        s = "6";
                        break;
                    }
                    case 7: {
                        s = "7";
                        break;
                    }
                    case 8: {
                        s = "8";
                        break;
                    }
                    case 9: {
                        s = "9";
                        break;
                    }
                    case 10: {
                        s = "10";
                        break;
                    }
                    case 11: {
                        s = "11";
                        break;
                    }
                    case 12: {
                        s = "12";
                        break;
                    }
                    case 13: {
                        s = "13";
                        break;
                    }
                    case 14: {
                        s = "14";
                        break;
                    }
                    case 15: {
                        s = "15";
                    }
                }
                bw.write(String.valueOf(DF_INT.format(i4)) + ", " + s);
                bw.newLine();
                ++i4;
            }
            bw.newLine();
            ArrayList<Integer> gidperm = new ArrayList<Integer>(ng);
            int i5 = 0;
            while (i5 < ng) {
                gidperm.add(new Integer(i5));
                ++i5;
            }
            Collections.shuffle(gidperm);
            Iterator it = gidperm.iterator();
            bw.write("#link(gambleid, gambleid)");
            bw.newLine();
            int nq = (int)Math.round((double)ng / 40.0);
            int i6 = 0;
            while (i6 < nq) {
                String id1 = DF_INT.format(it.next());
                String id2 = DF_INT.format(it.next());
                String id3 = DF_INT.format(it.next());
                String id4 = DF_INT.format(it.next());
                bw.write(String.valueOf(id1) + ", " + id2);
                bw.newLine();
                bw.write(String.valueOf(id1) + ", " + id3);
                bw.newLine();
                bw.write(String.valueOf(id1) + ", " + id4);
                bw.newLine();
                bw.write(String.valueOf(id2) + ", " + id3);
                bw.newLine();
                bw.write(String.valueOf(id2) + ", " + id4);
                bw.newLine();
                bw.write(String.valueOf(id3) + ", " + id4);
                bw.newLine();
                ++i6;
            }
            int nt = (int)Math.round((double)ng / 20.0);
            int i7 = 0;
            while (i7 < nt) {
                String id1 = DF_INT.format(it.next());
                String id2 = DF_INT.format(it.next());
                String id3 = DF_INT.format(it.next());
                bw.write(String.valueOf(id1) + ", " + id2);
                bw.newLine();
                bw.write(String.valueOf(id1) + ", " + id3);
                bw.newLine();
                bw.write(String.valueOf(id2) + ", " + id3);
                bw.newLine();
                ++i7;
            }
            int np = (int)Math.round((double)ng / 8.0);
            int i8 = 0;
            while (i8 < np) {
                String id1 = DF_INT.format(it.next());
                String id2 = DF_INT.format(it.next());
                bw.write(String.valueOf(id1) + ", " + id2);
                bw.newLine();
                ++i8;
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println();
            System.out.println(" during data generation");
            System.exit(0);
        }
    }
}

