/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HumanPlayerWithoutSockets {
    UserWindow userWindow;
    String name;
    private final int nGambles;
    private static final int windowWidth = 400;
    private static final int sliderHeight = 30;
    private SimulatorWithoutSockets sim;
    private JApplet app;
    boolean connectionEstablished = false;

    public HumanPlayerWithoutSockets(int nGambles, SimulatorWithoutSockets sim, JApplet app) {
        this.nGambles = nGambles;
        System.out.println(nGambles);
        this.sim = sim;
        this.name = "Human Player";
        this.app = app;
        this.userWindow = new UserWindow();
        this.userWindow.setSize(400, 65 + nGambles * 65);
        this.userWindow.setBackground(Color.WHITE);
        this.userWindow.setLocation(850, 0);
        this.userWindow.setVisible(true);
    }

    public Component getGUI() {
        return this.userWindow;
    }

    private void play(Double[] allocs) {
        if (this.connectionEstablished) {
            String out = this.convertToString(this.nGambles, allocs);
            this.sim.newInputFromClient(this, out);
        }
    }

    private void sendName() {
        if (this.connectionEstablished) {
            this.sim.newInputFromClient(this, this.name);
        }
    }

    public void connect(String name) {
        System.out.println("connecting");
        this.sim.newClient(this);
        this.connectionEstablished = true;
    }

    public String convertToString(int nGambles, Double[] allocs) {
        DecimalFormat df = new DecimalFormat("0.000");
        StringBuffer sb = new StringBuffer(nGambles * 8);
        int j = 0;
        while (j < nGambles) {
            sb.append(df.format(allocs[j])).append(" ");
            ++j;
        }
        String out = sb.toString();
        System.out.println("sending: " + out);
        return out;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("usage:  Java HumanPlayerWithoutSocket<Ngambles>");
            System.exit(1);
        }
        new HumanPlayerWithoutSockets(Integer.parseInt(args[0]), new SimulatorWithoutSockets(new JApplet()), new JApplet());
    }

    static class MySlider
    extends JSlider {
        int num;
        static Font f2 = new Font("Dialog", 0, 12);

        public MySlider() {
            this.setMajorTickSpacing(10);
            this.setMinorTickSpacing(1);
            this.setFont(f2);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
            this.repaint();
        }

        public void setNum(int num) {
            this.num = num;
        }

        public int getNum() {
            return this.num;
        }
    }

    static class ResultsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        Double[] bets;
        MySlider[] slids;
        int nGambles;
        ChangeListener sliderChanged = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MySlider source = (MySlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    ResultsPanel.this.bets[source.getNum()] = source.getValue();
                    System.out.println(String.valueOf(source.getNum()) + " changed to " + source.getValue());
                }
            }
        };

        public ResultsPanel(int nGambles) {
            this.setBorder(new BevelBorder(1));
            this.nGambles = nGambles;
            this.bets = new Double[nGambles];
            this.slids = new MySlider[nGambles];
            this.setBets();
        }

        public void setBets() {
            int i = this.nGambles - 1;
            while (i >= 0) {
                this.slids[i] = new MySlider();
                this.slids[i].setNum(i);
                this.slids[i].addChangeListener(this.sliderChanged);
                this.slids[i].setMajorTickSpacing(10);
                this.slids[i].setMinorTickSpacing(1);
                this.slids[i].setPaintTicks(true);
                this.slids[i].setPaintLabels(false);
                this.slids[i].setPreferredSize(new Dimension(375, 30));
                this.bets[i] = 50.0;
                JLabel sNum = new JLabel(String.valueOf(i) + " ", 0);
                sNum.setFont(new Font("Dialog", 0, 12));
                this.add(sNum);
                this.add(this.slids[i]);
                this.repaint();
                --i;
            }
        }

        public Double[] getBets() {
            return this.bets;
        }
    }

    class UserWindow
    extends JPanel {
        private static final long serialVersionUID = 1L;
        Font f1 = new Font("Dialog", 1, 12);
        Font f2 = new Font("Dialog", 0, 12);
        FontMetrics fm = this.getFontMetrics(this.f2);
        JButton bPlay;
        JButton bSetName;
        JButton bStart;
        JTextField nameField;
        ResultsPanel pInputs;
        int idxOrder = -1;
        double[] rets;
        double[] drs;
        Color[] colors;
        AffineTransform atVert;
        String name;
        JLabel lname;

        public UserWindow() {
            this.rets = new double[HumanPlayerWithoutSockets.this.nGambles];
            this.drs = new double[HumanPlayerWithoutSockets.this.nGambles];
            this.colors = new Color[HumanPlayerWithoutSockets.this.nGambles];
            this.atVert = AffineTransform.getRotateInstance(-1.5707963267948966);
            this.name = "Human Player";
            this.buildGUI();
        }

        void buildGUI() {
            this.lname = new JLabel("Name: " + this.name);
            JLabel lAttrs = new JLabel("Game with " + HumanPlayerWithoutSockets.this.nGambles + " gambles");
            this.lname.setFont(this.f1);
            lAttrs.setFont(this.f2);
            this.bStart = new JButton("Start");
            this.bPlay = new JButton("Send");
            this.bSetName = new JButton("Set Name");
            this.nameField = new JTextField("Type your name", 10);
            this.bPlay.setFont(this.f1);
            this.bSetName.setFont(this.f1);
            this.bSetName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newName = UserWindow.this.nameField.getText();
                    System.out.println(UserWindow.this.nameField.getText());
                    if (!newName.equals("Type your name")) {
                        ((UserWindow)UserWindow.this).HumanPlayerWithoutSockets.this.name = newName;
                        UserWindow.this.lname.setText("Name: " + newName);
                        UserWindow.this.repaint();
                    }
                }
            });
            this.bStart.setFont(this.f1);
            this.bPlay.setEnabled(false);
            this.bStart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserWindow.this.bPlay.setEnabled(true);
                    UserWindow.this.bStart.setEnabled(false);
                    UserWindow.this.bSetName.setEnabled(false);
                    HumanPlayerWithoutSockets.this.connect(UserWindow.this.name);
                    HumanPlayerWithoutSockets.this.sendName();
                }
            });
            this.bPlay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Double[] bets = UserWindow.this.pInputs.getBets();
                    HumanPlayerWithoutSockets.this.play(bets);
                }
            });
            JPanel pTop = new JPanel();
            pTop.setLayout(new BoxLayout(pTop, 1));
            lAttrs.setAlignmentX(0.5f);
            pTop.add(lAttrs);
            this.lname.setAlignmentX(0.5f);
            pTop.add(this.lname);
            this.nameField.setAlignmentX(0.5f);
            pTop.add(this.nameField);
            this.bSetName.setAlignmentX(0.5f);
            pTop.add(this.bSetName);
            pTop.setPreferredSize(new Dimension(100, 100));
            JPanel pMid = new JPanel();
            pMid.setLayout(new FlowLayout());
            pMid.add(this.bPlay);
            pMid.add(this.bStart);
            this.pInputs = new ResultsPanel(HumanPlayerWithoutSockets.this.nGambles);
            this.pInputs.setBackground(Color.white);
            this.pInputs.setPreferredSize(new Dimension(380, HumanPlayerWithoutSockets.this.nGambles * 60));
            Box boxNorth = Box.createVerticalBox();
            boxNorth.add(pTop);
            boxNorth.add(Box.createVerticalStrut(5));
            boxNorth.add(pMid);
            boxNorth.add(Box.createVerticalStrut(5));
            boxNorth.add(this.pInputs);
            JPanel pane = new JPanel();
            pane.setLayout(new BorderLayout());
            pane.setBorder(new EmptyBorder(5, 5, 5, 5));
            pane.add((Component)boxNorth, "North");
            HumanPlayerWithoutSockets.this.app.getContentPane().add(pane);
        }
    }
}

