/*
 * Decompiled with CFR 0.152.
 */
package wordwrestlegame;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import wordwrestlegame.InputWordPanel;
import wordwrestlegame.prefixTree;

public class WordWrestleGame
extends Applet
implements ActionListener {
    private static String initWord;
    private static String styleInitWord;
    private static prefixTree pft;
    private static Set<String> usedStrSet;
    private static JTextPane compressedWord;
    private static JTextField numMovesTextField;
    private static InputWordPanel lPlyPanel;
    private static InputWordPanel rPlyPanel;
    private static JButton reset;
    private String winnerName = new String();
    private int winnerScore = 0;
    private int numOfMoves = 5;
    private int turns = 0;

    @Override
    public void start() {
        System.out.println("Starting...");
        this.gameStart();
        lPlyPanel.setCaretFocus();
    }

    public void resetWWGame() {
        usedStrSet.clear();
        lPlyPanel.resetInputWordPanel();
        rPlyPanel.resetInputWordPanel();
        this.turns = 0;
        initWord = pft.getRandomWord();
        usedStrSet.add(initWord);
        numMovesTextField.setText("Number of Moves: " + Integer.toString(this.numOfMoves) + "    (" + "FirstPlayer" + "'s turn)");
        compressedWord.setText("<html><h1>" + initWord + "</h1></html>");
        String s = JOptionPane.showInputDialog(this, (Object)"Enter number of moves: ");
        this.numOfMoves = Integer.parseInt(s);
        numMovesTextField.setText("Number of Moves: " + Integer.toString(this.numOfMoves) + "    (" + "FirstPlayer" + "'s turn)");
    }

    @Override
    public void init() {
        pft = new prefixTree();
        try {
            pft.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        initWord = pft.getRandomWord();
        usedStrSet = new HashSet<String>();
        usedStrSet.add(initWord);
    }

    public void gameStart() {
        this.setSize(new Dimension(800, 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getNumOfMovesPanel(), "North");
        this.add((Component)this.getPlayersPanel(), "Center");
        this.add((Component)this.getCompressedWordPanel(), "South");
    }

    private JPanel getNumOfMovesPanel() {
        JPanel numOfMovesPanel = new JPanel(new BorderLayout());
        String s = JOptionPane.showInputDialog(numOfMovesPanel, (Object)"Enter number of moves: ");
        this.numOfMoves = Integer.parseInt(s);
        numMovesTextField = new JTextField("Number of Moves: " + Integer.toString(this.numOfMoves) + "    (" + "FirstPlayer" + "'s turn)");
        Font newTextFieldFont = new Font(numMovesTextField.getFont().getName(), numMovesTextField.getFont().getStyle(), 24);
        numMovesTextField.setFont(newTextFieldFont);
        numMovesTextField.setEditable(false);
        reset = new JButton("Reset");
        reset.addActionListener(this);
        numOfMovesPanel.add(numMovesTextField);
        numOfMovesPanel.add((Component)reset, "East");
        return numOfMovesPanel;
    }

    private JPanel getCompressedWordPanel() {
        compressedWord = new JTextPane();
        compressedWord.setContentType("text/html");
        compressedWord.setPreferredSize(new Dimension(50, 200));
        compressedWord.setText("<html><h1>" + initWord + "</h1></html>");
        compressedWord.setEditable(false);
        JPanel compressWordPanel = new JPanel(new BorderLayout());
        compressWordPanel.add((Component)compressedWord, "Center");
        return compressWordPanel;
    }

    private JPanel getPlayersPanel() {
        JPanel playersPanel = new JPanel(new GridLayout(1, 2));
        lPlyPanel = new InputWordPanel(this, "FirstPlayer", 1);
        rPlyPanel = new InputWordPanel(this, "SecondPlayer", 2);
        playersPanel.add((Component)lPlyPanel, "West");
        playersPanel.add((Component)rPlyPanel, "Center");
        playersPanel.setVisible(true);
        return playersPanel;
    }

    public void playerInputedWord(String input, int playerID) {
        ++this.turns;
        compressedWord.setText(styleInitWord);
        System.out.println("Compressed Word = " + initWord + " playerID: " + playerID + " turns= " + this.turns + " numOfMoves: " + this.numOfMoves);
        if (this.turns % 2 == 0) {
            --this.numOfMoves;
        }
        if (playerID == 1) {
            numMovesTextField.setText("Number of Moves: " + Integer.toString(this.numOfMoves) + "    (" + "SecondPlayer" + "'s turn)");
        } else {
            numMovesTextField.setText("Number of Moves: " + Integer.toString(this.numOfMoves) + "    (" + "FirstPlayer" + "'s turn)");
        }
        if (this.turns % 2 == 0 && this.numOfMoves == 0) {
            String winPlayerMsg;
            if (lPlyPanel.getPlayerScore() > rPlyPanel.getPlayerScore()) {
                winPlayerMsg = WordWrestleGame.lPlyPanel.playerName + " wins!";
                this.winnerScore = lPlyPanel.getPlayerScore();
            } else if (lPlyPanel.getPlayerScore() == rPlyPanel.getPlayerScore()) {
                winPlayerMsg = "Tie";
                this.winnerScore = lPlyPanel.getPlayerScore();
            } else {
                winPlayerMsg = WordWrestleGame.rPlyPanel.playerName + " wins!";
                this.winnerScore = rPlyPanel.getPlayerScore();
            }
            this.winnerName = JOptionPane.showInputDialog(this, (Object)(winPlayerMsg + "   Please Enter Your Name:"));
            System.out.println("Winner: " + this.winnerName + "  Score: " + this.winnerScore);
            this.resetWWGame();
            return;
        }
        if (playerID == 1) {
            rPlyPanel.setInputAreaEditable(true);
        } else {
            lPlyPanel.setInputAreaEditable(true);
        }
        this.repaint();
    }

    public void addWordToSet(String word) {
        usedStrSet.add(word);
    }

    public boolean isWordInSet(String word) {
        return usedStrSet.contains(word);
    }

    public String getWinnerName() {
        return this.winnerName;
    }

    public int getWinnerScore() {
        return this.winnerScore;
    }

    public int updateCompressedWord(String input) {
        int commonLen = 0;
        int prefixEndInd = 0;
        String commonWord = new String();
        String preCommonWord = new String();
        String postCommonWord = new String();
        for (int i = input.length(); i > 0; --i) {
            String inputPrefix = input.substring(0, i);
            if (!initWord.endsWith(inputPrefix)) continue;
            int suffixPrefixInd = initWord.lastIndexOf(inputPrefix);
            preCommonWord = initWord.substring(0, suffixPrefixInd);
            commonWord = initWord.substring(suffixPrefixInd);
            postCommonWord = input.substring(i);
            commonLen = inputPrefix.length();
            prefixEndInd = i;
            break;
        }
        if (commonLen > 0) {
            initWord = initWord + input.substring(prefixEndInd);
            System.out.println(preCommonWord + "  " + commonWord + "  " + postCommonWord);
            styleInitWord = "<html><h1>" + preCommonWord + "<font color=\"red\">" + commonWord + "</font>" + postCommonWord + "</h1></html>";
        }
        return commonLen;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String mycaption = event.getActionCommand();
        System.out.println("The event is: " + mycaption);
        this.resetWWGame();
    }

    public prefixTree getPft() {
        return pft;
    }

    public static void main(String[] args) {
        WordWrestleGame game = new WordWrestleGame();
        game.init();
    }
}

