/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import javax.swing.Box;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;

public class SimulatorWithoutSockets {
    static final boolean TRACE = false;
    static final boolean DEBUG = false;
    static final int HI = 0;
    static final int MD = 1;
    static final int LO = 2;
    static final String[] LVLS = new String[]{"HI", "MD", "LO"};
    static final Random RND = new Random();
    static final DecimalFormat DF_INT = new DecimalFormat("000");
    static final DecimalFormat DF_RET = new DecimalFormat("00.000");
    static final DecimalFormat DF_PROB = new DecimalFormat("0.000");
    static final DecimalFormat DF_DLRS = new DecimalFormat("0.000");
    static final String OK = "OK";
    static final String ERR = "ERR";
    static final long CHECK_PLAY_SLEEP = 1000L;
    static final long ANIMATE_SLEEP = 100L;
    static final int MAX_CHANGE = 10;
    static int nGambles;
    int roundCount = 0;
    Gamble[] gambles;
    int attrFav1;
    int attrFav2;
    int attrUnfav1;
    int attrUnfav2;
    ArrayList<HumanPlayerWithoutSockets> clients = new ArrayList();
    ArrayList<Player> players = new ArrayList();
    HashMap<Player, HumanPlayerWithoutSockets> players2clients = new HashMap();
    HashMap<HumanPlayerWithoutSockets, Player> clients2players = new HashMap();
    ArrayList<Game> games = new ArrayList();
    int idxNextGame = 0;
    Viz viz;
    double maxTotalIncome = 0.0;
    double maxCumWealth = 1.0;
    int changeCount = 0;
    private ArrayList<HumanPlayerWithoutSockets> humanPlayers = new ArrayList();
    private JApplet applet;

    SimulatorWithoutSockets(JApplet applet) {
        this.applet = applet;
        this.readData();
        this.assignHiddenAttrs();
        SimulatorWithoutSockets.out("viz mode\n");
        this.viz = new Viz();
        this.viz.setSize(800, 500);
        this.viz.setVisible(true);
    }

    public Component getGUI() {
        return this.viz;
    }

    public Component getHumanGUI() {
        return this.viz.h.getGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newClient(HumanPlayerWithoutSockets c) {
        ArrayList<Player> arrayList = this.players;
        synchronized (arrayList) {
            Player p = new Player();
            this.clients.add(c);
            this.players.add(p);
            this.players2clients.put(p, c);
            this.clients2players.put(c, p);
            if (this.viz != null) {
                this.viz.addPlayer(p);
                this.viz.repaint();
                this.applet.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newInputFromClient(HumanPlayerWithoutSockets c, String input) {
        ArrayList<Player> arrayList = this.players;
        synchronized (arrayList) {
            Player p = this.clients2players.get(c);
            if (p.name == null) {
                SimulatorWithoutSockets.trace("expecting name\n");
                if (input.length() == 0) {
                    String err = "empty name";
                    SimulatorWithoutSockets.out(String.valueOf(err) + "\n");
                    return;
                }
                p.name = input;
                SimulatorWithoutSockets.out("registered player " + p.name + "\n");
            } else {
                SimulatorWithoutSockets.trace("expecting allocations\n");
                String[] ss = input.split("[ |,]+");
                if (ss.length != nGambles) {
                    String err = "expected " + nGambles + " tokens;" + " got " + ss.length;
                    SimulatorWithoutSockets.out(String.valueOf(err) + "\n");
                    return;
                }
                double[] allocs = new double[nGambles];
                int i = 0;
                while (i < nGambles) {
                    try {
                        allocs[i] = Double.parseDouble(ss[i]);
                    }
                    catch (NumberFormatException e) {
                        String err = "can't parse token: " + ss[i];
                        SimulatorWithoutSockets.out(String.valueOf(err) + "\n");
                        return;
                    }
                    ++i;
                }
                SimulatorWithoutSockets.normalize(allocs);
                p.newAllocs = allocs;
                p.haveNewAlloc = true;
            }
            if (this.viz != null) {
                this.viz.repaint();
            }
            this.applet.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lostClient(HumanPlayerWithoutSockets c) {
        ArrayList<Player> arrayList = this.players;
        synchronized (arrayList) {
            SimulatorWithoutSockets.out("lost client\n");
            Player p = this.clients2players.get(c);
            p.alive = false;
            p.lastTurn = null;
            if (this.viz != null) {
                this.viz.repaint();
            }
            this.applet.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryPlay() {
        ArrayList<Player> arrayList = this.players;
        synchronized (arrayList) {
            block7: {
                if (this.viz != null) break block7;
                int nAlive = 0;
                int nHaveNewAllocs = 0;
                int i = 0;
                while (i < this.players.size()) {
                    Player p = this.players.get(i);
                    if (p.alive) {
                        ++nAlive;
                        if (p.haveNewAlloc) {
                            ++nHaveNewAllocs;
                        }
                    }
                    ++i;
                }
                if (nAlive != 0 && nHaveNewAllocs >= nAlive) break block7;
                return false;
            }
            Game g = this.play();
            this.sendFeedback(g);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Game play() {
        ArrayList<Player> arrayList = this.players;
        synchronized (arrayList) {
            Game g = this.newGame(this.idxNextGame++);
            this.games.add(g);
            this.runAllocs(g);
            ++this.roundCount;
            return g;
        }
    }

    void sendFeedback(Game g) {
        StringBuffer sb = new StringBuffer(nGambles * 3);
        int i = 0;
        while (i < nGambles) {
            sb.append(LVLS[g.outcomes[i].lvl]).append(' ');
            ++i;
        }
        sb.setCharAt(sb.length() - 1, '\n');
        String feedback = sb.toString();
        int i2 = 0;
        while (i2 < this.players.size()) {
            Player p = this.players.get(i2);
            if (!p.alive) {
                SimulatorWithoutSockets.out("player " + p.name + " not alive\n");
            } else if (!p.haveNewAlloc) {
                SimulatorWithoutSockets.out("player " + p.name + " no new alloc\n");
            } else {
                Turn t = p.lastTurn;
                p.cumWealth *= t.totalIncome;
                if (t.totalIncome >= 2.0) {
                    ++p.nWins;
                }
                String totalIncome = DF_RET.format(t.totalIncome);
                HumanPlayerWithoutSockets c = this.players2clients.get(p);
                System.out.println("cumWealth for " + p.name + ": " + p.cumWealth);
                p.haveNewAlloc = false;
            }
            ++i2;
        }
    }

    void runAllocs(Game g) {
        this.maxTotalIncome = 0.0;
        int i = 0;
        while (i < this.players.size()) {
            Player p = this.players.get(i);
            if (!p.alive) {
                SimulatorWithoutSockets.out("player " + i + " not alive\n");
            } else if (!p.haveNewAlloc) {
                SimulatorWithoutSockets.out("player " + i + " no new alloc\n");
                p.lastTurn = null;
            } else {
                Turn t = new Turn(p.newAllocs);
                p.newAllocs = null;
                p.turns.add(t);
                p.lastTurn = t;
                ++p.nGames;
                int j = 0;
                while (j < nGambles) {
                    t.incomes[j] = t.allocs[j] * g.outcomes[j].pyf;
                    ++j;
                }
                t.totalIncome = 0.0;
                j = 0;
                while (j < nGambles) {
                    t.totalIncome += t.incomes[g.gambleOrder[j]];
                    t.cumIncomeInGambleOrder[j] = t.totalIncome;
                    ++j;
                }
                this.maxTotalIncome = Math.max(this.maxTotalIncome, t.totalIncome);
                this.maxCumWealth = Math.max(this.maxCumWealth, p.cumWealth * t.totalIncome);
                SimulatorWithoutSockets.out("player " + p.name + ": totalIncome = " + t.totalIncome + "\n");
            }
            ++i;
        }
    }

    Game newGame(int turn) {
        SimulatorWithoutSockets.out("newGame(" + turn + ")\n");
        ArrayList<Integer> al = new ArrayList<Integer>(nGambles);
        int i = 0;
        while (i < nGambles) {
            al.add(new Integer(i));
            ++i;
        }
        Collections.shuffle(al);
        int[] gambleOrder = new int[nGambles];
        int i2 = 0;
        while (i2 < nGambles) {
            gambleOrder[i2] = (Integer)al.get(i2);
            ++i2;
        }
        Outcome[] outcomes = new Outcome[nGambles];
        int i3 = 0;
        while (i3 < nGambles) {
            Outcome outcome;
            int lvl;
            Gamble g = this.gambles[gambleOrder[i3]];
            SimulatorWithoutSockets.trace(String.valueOf(DF_INT.format(i3)) + ": playing gamble " + g + "\n");
            double[] probs = new double[]{g.probs[0], g.probs[1], g.probs[2]};
            SimulatorWithoutSockets.trace("probs: " + SimulatorWithoutSockets.arrayStr(probs, DF_PROB) + "\n");
            int attrSway = 1;
            if (g.attr == this.attrFav1 || g.attr == this.attrFav2) {
                SimulatorWithoutSockets.trace("attr favorable\n");
                attrSway = 0;
                probs[2] = probs[2] / 2.0;
                probs[0] = probs[0] + probs[2];
                SimulatorWithoutSockets.normalize(probs);
            } else if (g.attr == this.attrUnfav1 || g.attr == this.attrUnfav2) {
                SimulatorWithoutSockets.trace("attr unfavorable\n");
                attrSway = 2;
                probs[0] = probs[0] / 2.0;
                probs[2] = probs[2] + probs[0];
                SimulatorWithoutSockets.normalize(probs);
            } else {
                SimulatorWithoutSockets.trace("attr neutral\n");
            }
            SimulatorWithoutSockets.trace("probs: " + SimulatorWithoutSockets.arrayStr(probs, DF_PROB) + "\n");
            int[] nLinks = new int[3];
            if (g.links.length == 1) {
                SimulatorWithoutSockets.trace("no links\n");
            } else {
                SimulatorWithoutSockets.trace(String.valueOf(g.links.length - 1) + " links\n");
                int j = 0;
                while (j < g.links.length) {
                    Gamble gg = g.links[j];
                    if (gg.id != g.id) {
                        lvl = gg.outcomes.length == turn ? -1 : gg.outcomes[turn].lvl;
                        SimulatorWithoutSockets.trace("gamble " + gg.id + " " + lvl + "\n");
                        switch (lvl) {
                            case 0: {
                                nLinks[0] = nLinks[0] + 1;
                                break;
                            }
                            case 1: {
                                nLinks[1] = nLinks[1] + 1;
                                break;
                            }
                            case 2: {
                                nLinks[2] = nLinks[2] + 1;
                            }
                        }
                    }
                    ++j;
                }
                SimulatorWithoutSockets.trace("nLinks: " + nLinks[0] + nLinks[1] + nLinks[2] + "\n");
                if (nLinks[0] > nLinks[1] + nLinks[2]) {
                    SimulatorWithoutSockets.trace("bumping up probs[HI]\n");
                    probs[2] = probs[2] / 2.0;
                    probs[0] = probs[0] + probs[2];
                    SimulatorWithoutSockets.normalize(probs);
                } else if (nLinks[2] > nLinks[0] + nLinks[1]) {
                    SimulatorWithoutSockets.trace("bumping up probs[LO]\n");
                    probs[0] = probs[0] / 2.0;
                    probs[2] = probs[2] + probs[0];
                    SimulatorWithoutSockets.normalize(probs);
                } else {
                    SimulatorWithoutSockets.trace("no change\n");
                }
            }
            SimulatorWithoutSockets.trace("probs: " + SimulatorWithoutSockets.arrayStr(probs, DF_PROB) + "\n");
            double rnd = RND.nextDouble();
            lvl = -1;
            double pyf = Double.NaN;
            if (rnd < probs[0]) {
                lvl = 0;
                pyf = g.rets[0];
            } else if (rnd < probs[0] + probs[1]) {
                lvl = 1;
                pyf = g.rets[1];
            } else {
                lvl = 2;
                pyf = g.rets[2];
            }
            SimulatorWithoutSockets.trace("rnd=" + rnd + " lvl=" + lvl + " pyf=" + pyf + "\n");
            outcomes[g.id] = outcome = new Outcome(i3, attrSway, nLinks, probs, rnd, lvl, pyf);
            g.outcomes = (Outcome[])SimulatorWithoutSockets.add(g.outcomes, outcome);
            SimulatorWithoutSockets.debug(String.valueOf(DF_INT.format(i3)) + ": g: " + g + " --> " + outcome + "\n");
            ++i3;
        }
        return new Game(turn, gambleOrder, outcomes);
    }

    void assignHiddenAttrs() {
        ArrayList<Integer> al = new ArrayList<Integer>(16);
        int i = 0;
        while (i < 16) {
            al.add(new Integer(i));
            ++i;
        }
        Collections.shuffle(al);
        this.attrFav1 = (Integer)al.get(0);
        this.attrFav2 = (Integer)al.get(1);
        this.attrUnfav1 = (Integer)al.get(2);
        this.attrUnfav2 = (Integer)al.get(3);
        SimulatorWithoutSockets.out("attrs: fav: " + this.attrFav1 + "," + this.attrFav2 + " unfav: " + this.attrUnfav1 + "," + this.attrUnfav2 + "\n");
    }

    void readData() {
        String s = "#gamble(gambleid, high return, high prob, medium return, med prob, low return, low prob)\n000, 09.340, 0.066, 02.393, 0.455, 00.610, 0.478\n001, 05.66, 0.225, 01.500, 0.421, 00.140, 0.354\n002, 06.835, 0.128, 01.772, 0.489, 00.680, 0.383\n003, 06.539, 0.191, 01.458, 0.483, 00.137, 0.325\n004, 04.954, 0.234, 01.605, 0.510, 00.091, 0.256\n005, 04.748, 0.162, 02.304, 0.475, 00.374, 0.363\n006, 03.251, 0.329, 01.762, 0.421, 00.755, 0.250\n007, 04.480, 0.235, 01.900, 0.425, 00.414, 0.340\n008, 03.622, 0.386, 01.211, 0.421, 00.480, 0.193\n009, 04.009, 0.302, 01.459, 0.514, 00.221, 0.184\n#gambleatts(gambleid, gambleclass)\n000, 15\n001, 7\n002, 8\n003, 4\n004, 9\n005, 5\n006, 11\n007, 3\n008, 14\n009, 2\n#link(gambleid, gambleid)\n003, 002\n003, 008\n002, 008\n006, 001\n";
        SimulatorWithoutSockets.debug("readData( " + s + " )\n");
        try {
            double[] dd;
            BufferedReader br = new BufferedReader(new StringReader(s));
            ArrayList[] als = new ArrayList[3];
            int i = 0;
            while (i < 3) {
                als[i] = new ArrayList();
                ++i;
            }
            int section = -1;
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (line.charAt(0) == '#') {
                    if (line.indexOf("gamble(") != -1) {
                        section = 0;
                        continue;
                    }
                    if (line.indexOf("gambleatts(") != -1) {
                        section = 1;
                        continue;
                    }
                    if (line.indexOf("link(") != -1) {
                        section = 2;
                        continue;
                    }
                    throw new RuntimeException("unexpected line in data file: " + line);
                }
                String[] ss = line.split("[, ]+");
                dd = new double[ss.length];
                int i2 = 0;
                while (i2 < ss.length) {
                    dd[i2] = Double.parseDouble(ss[i2]);
                    ++i2;
                }
                als[section].add(dd);
            }
            SimulatorWithoutSockets.debug("read " + als[0].size() + " gambles, " + als[1].size() + " attrs, " + als[2].size() + " links\n");
            if (als[0].size() != als[1].size()) {
                throw new RuntimeException("# gambles != # attrs");
            }
            nGambles = als[0].size();
            System.out.println(nGambles);
            this.gambles = new Gamble[nGambles];
            int i3 = 0;
            while (i3 < nGambles) {
                double[] ddg = (double[])als[0].get(i3);
                double[] dda = (double[])als[1].get(i3);
                if (ddg[0] != (double)i3 || dda[0] != (double)i3) {
                    throw new RuntimeException("gambles or attrs not in order");
                }
                if (ddg.length != 7 || dda.length != 2) {
                    throw new RuntimeException("wrong # of tokens in gamble or attr " + i3);
                }
                double[] rets = new double[]{ddg[1], ddg[3], ddg[5]};
                double[] probs = new double[]{ddg[2], ddg[4], ddg[6]};
                SimulatorWithoutSockets.normalize(probs);
                int attr = (int)dda[1];
                this.gambles[i3] = new Gamble(i3, probs, rets, attr);
                ++i3;
            }
            i3 = 0;
            while (i3 < als[2].size()) {
                dd = (double[])als[2].get(i3);
                Object[] links1 = this.gambles[(int)dd[0]].links;
                Object[] links2 = this.gambles[(int)dd[1]].links;
                if (links1 != links2) {
                    Gamble[] links3 = (Gamble[])SimulatorWithoutSockets.merge(links1, links2);
                    int j = 0;
                    while (j < links1.length) {
                        ((Gamble)links1[j]).links = links3;
                        ++j;
                    }
                    j = 0;
                    while (j < links2.length) {
                        ((Gamble)links2[j]).links = links3;
                        ++j;
                    }
                }
                ++i3;
            }
        }
        catch (Exception e) {
            SimulatorWithoutSockets.out("exception reading returns and links: " + e + "\n");
            e.printStackTrace();
            SimulatorWithoutSockets.out("exiting\n");
            System.exit(1);
        }
    }

    static String arrayStr(double[] dd, DecimalFormat df) {
        StringBuffer sb = new StringBuffer(dd.length * (df.toPattern().length() + 1));
        int i = 0;
        while (i < dd.length) {
            sb.append(df.format(dd[i])).append(' ');
            ++i;
        }
        return sb.toString();
    }

    static Object[] add(Object[] in, Object val) {
        Class<?> c = val.getClass();
        int len = in.length + 1;
        Object[] out = (Object[])Array.newInstance(c, len);
        int i = 0;
        while (i < in.length) {
            out[i] = in[i];
            ++i;
        }
        out[in.length] = val;
        return out;
    }

    static Object merge(Object[] in1, Object[] in2) {
        Class<?> c = in1[0].getClass();
        int len = in1.length + in2.length;
        Object[] out = (Object[])Array.newInstance(c, len);
        int count = 0;
        int i = 0;
        while (i < in1.length) {
            out[count++] = in1[i];
            ++i;
        }
        i = 0;
        while (i < in2.length) {
            out[count++] = in2[i];
            ++i;
        }
        return out;
    }

    static void normalize(double[] d) {
        double total = 0.0;
        int i = 0;
        while (i < d.length) {
            total += d[i];
            ++i;
        }
        i = 0;
        while (i < d.length) {
            int n = i++;
            d[n] = d[n] / total;
        }
    }

    static void trace(String s) {
    }

    static void debug(String s) {
    }

    static void out(String s) {
        System.out.print(s);
        System.out.flush();
    }

    public static void main(String[] args) {
        new SimulatorWithoutSockets(new JApplet());
    }

    class Gamble {
        final int id;
        final double[] probs;
        final double[] rets;
        final int attr;
        final String s;
        Gamble[] links = new Gamble[]{this};
        Outcome[] outcomes = new Outcome[0];

        Gamble(int id, double[] probs, double[] rets, int attr) {
            this.id = id;
            this.probs = probs;
            this.rets = rets;
            this.attr = attr;
            this.s = "id=" + DF_INT.format(id) + " p={ " + SimulatorWithoutSockets.arrayStr(probs, DF_PROB) + "}" + " r={ " + SimulatorWithoutSockets.arrayStr(rets, DF_RET) + "}" + " a=" + (attr < 10 ? " " : "") + attr;
        }

        public String toString() {
            return this.s;
        }
    }

    class Game {
        final int turn;
        final int[] gambleOrder;
        final Outcome[] outcomes;

        Game(int turn, int[] gambleOrder, Outcome[] outcomes) {
            this.turn = turn;
            this.gambleOrder = gambleOrder;
            this.outcomes = outcomes;
        }

        public String toString() {
            return "game " + this.turn;
        }
    }

    class Outcome {
        final int idx;
        final int attrSway;
        final int[] lnkLvls;
        final double[] probs;
        final double rnd;
        final int lvl;
        final double pyf;
        final String s;

        Outcome(int idx, int attrSway, int[] lnkLvls, double[] probs, double rnd, int lvl, double pyf) {
            this.idx = idx;
            this.attrSway = attrSway;
            this.lnkLvls = lnkLvls;
            this.probs = probs;
            this.rnd = rnd;
            this.lvl = lvl;
            this.pyf = pyf;
            this.s = "@=" + DF_INT.format(idx) + " a=" + attrSway + " l=" + lnkLvls[0] + lnkLvls[1] + lnkLvls[2] + " p={ " + SimulatorWithoutSockets.arrayStr(probs, DF_PROB) + "}" + " r=" + DF_PROB.format(rnd) + " l=" + LVLS[lvl] + " p=" + DF_RET.format(pyf);
        }

        public String toString() {
            return this.s;
        }
    }

    class Player {
        String name;
        ArrayList<Turn> turns = new ArrayList();
        boolean alive = true;
        boolean haveNewAlloc = false;
        double[] newAllocs;
        int nGames = 0;
        int nWins = 0;
        double cumWealth = 1.0;
        Turn lastTurn = null;

        Player() {
        }
    }

    class Turn {
        final double[] allocs;
        double[] incomes = new double[nGambles];
        double[] cumIncomeInGambleOrder = new double[nGambles];
        double totalIncome;

        Turn(double[] d) {
            this.allocs = d;
        }
    }

    class Viz
    extends JPanel {
        Font f1 = new Font("Dialog", 1, 12);
        Font f2 = new Font("Dialog", 0, 12);
        FontMetrics fm = this.getFontMetrics(this.f2);
        JButton bPlay;
        JButton bHum;
        JPanel pOutcomes;
        JPanel pPlayers;
        int idxOrder = -1;
        double[] rets = new double[nGambles];
        double[] drs = new double[nGambles];
        Color[] colors = new Color[nGambles];
        AffineTransform atVert = AffineTransform.getRotateInstance(-1.5707963267948966);
        private HumanPlayerWithoutSockets h;

        Viz() {
            this.buildGUI();
            this.addHumanGUI();
        }

        void addPlayer(Player p) {
            this.pPlayers.add(new PlayerPanel(p));
            this.pPlayers.validate();
        }

        void animateGame(Game g) {
            this.idxOrder = -1;
            int i = 0;
            while (i < nGambles) {
                this.rets[i] = 0.0;
                this.drs[i] = 0.0;
                ++i;
            }
            i = 0;
            while (i < nGambles) {
                int idx = g.gambleOrder[i];
                SimulatorWithoutSockets.trace("showing outcome " + g.outcomes[idx] + "\n");
                this.rets[idx] = g.outcomes[idx].pyf;
                this.drs[idx] = Math.min(this.rets[idx] - 2.0, 4.0);
                this.colors[idx] = this.drs[idx] < 0.0 ? new Color((float)(-this.drs[idx] / 2.0), 0.0f, 0.0f) : new Color(0.0f, (float)(this.drs[idx] / 4.0), 0.0f);
                this.idxOrder = i;
                this.repaint();
                SimulatorWithoutSockets.this.applet.repaint();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }

        void buildGUI() {
            JLabel lAttrs = new JLabel("Favorable Attrs: " + SimulatorWithoutSockets.this.attrFav1 + "," + SimulatorWithoutSockets.this.attrFav2 + "  " + "Unfavorable Attrs: " + SimulatorWithoutSockets.this.attrUnfav1 + "," + SimulatorWithoutSockets.this.attrUnfav2);
            lAttrs.setFont(this.f1);
            this.bPlay = new JButton("Play");
            this.bPlay.setFont(this.f1);
            this.bHum = new JButton("Add Human!");
            this.bHum.setFont(this.f1);
            this.bHum.setVisible(false);
            this.bPlay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Viz.this.bPlay.setEnabled(false);
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ArrayList<Player> arrayList = ((Viz)(this).Viz.this).SimulatorWithoutSockets.this.players;
                            synchronized (arrayList) {
                                Game g = SimulatorWithoutSockets.this.play();
                                Viz.this.animateGame(g);
                                SimulatorWithoutSockets.this.sendFeedback(g);
                                (this).Viz.this.bPlay.setEnabled(true);
                                Viz.this.repaint();
                                SimulatorWithoutSockets.this.applet.repaint();
                            }
                        }
                    }.start();
                }
            });
            this.bHum.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Viz.this.bHum.setEnabled(false);
                    new Thread(){

                        @Override
                        public void run() {
                            SimulatorWithoutSockets.out("gui triggered human\n");
                            HumanPlayerWithoutSockets h = new HumanPlayerWithoutSockets(nGambles, SimulatorWithoutSockets.this, SimulatorWithoutSockets.this.applet);
                            SimulatorWithoutSockets.this.humanPlayers.add(h);
                            (this).Viz.this.bHum.setEnabled(true);
                            Viz.this.repaint();
                            SimulatorWithoutSockets.this.applet.repaint();
                        }
                    }.start();
                }
            });
            JPanel pTop = new JPanel();
            pTop.add(lAttrs);
            pTop.add(this.bPlay);
            pTop.add(this.bHum);
            this.pOutcomes = new OutcomesPanel();
            Box boxNorth = Box.createVerticalBox();
            boxNorth.add(pTop);
            boxNorth.add(this.pOutcomes);
            boxNorth.add(Box.createVerticalStrut(5));
            this.pPlayers = new JPanel();
            this.pPlayers.setLayout(new GridLayout(1, 0, 2, 2));
            JPanel pane = new JPanel();
            pane.setLayout(new BorderLayout());
            pane.setBorder(new EmptyBorder(5, 5, 5, 5));
            pane.add((Component)boxNorth, "North");
            pane.add((Component)this.pPlayers, "Center");
            pane.setPreferredSize(new Dimension(500, 700));
            SimulatorWithoutSockets.this.applet.getContentPane().add(pane);
        }

        public void addHumanGUI() {
            System.out.println("gui triggered human\n");
            this.h = new HumanPlayerWithoutSockets(nGambles, SimulatorWithoutSockets.this, SimulatorWithoutSockets.this.applet);
            SimulatorWithoutSockets.this.humanPlayers.add(this.h);
            this.bHum.setEnabled(true);
            this.repaint();
            SimulatorWithoutSockets.this.applet.repaint();
        }

        class OutcomesPanel
        extends JPanel {
            OutcomesPanel() {
                this.setPreferredSize(new Dimension(0, 100));
                this.setBorder(new BevelBorder(1));
            }

            @Override
            public void paintComponent(Graphics g) {
                Dimension d = this.getSize();
                int w = d.width;
                int h = d.height;
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, w, h);
                g.setColor(Color.BLACK);
                g.setFont(Viz.this.f1);
                g.drawString("Outcomes", 10, 20);
                g.drawString("Rounds played: " + ((Viz)Viz.this).SimulatorWithoutSockets.this.roundCount, w - 300, 20);
                g.setFont(Viz.this.f2);
                g.drawString("# gambles played: " + (Viz.this.idxOrder + 1), w - 150, 20);
                int wGamble = (w - 20) / nGambles;
                int wGraph = wGamble * nGambles;
                int x0 = (w - wGraph) / 2;
                int xng = x0 + wGraph;
                int hGraph = h - 25;
                int hUnit = hGraph / 6;
                int y0 = h - 8;
                int y2 = y0 - 2 * hUnit;
                int pad = 2 * wGamble;
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(x0 - pad, y0, xng + pad, y0);
                g.drawLine(x0 - pad, y2, xng + pad, y2);
                int i = 0;
                while (i < nGambles) {
                    if (Viz.this.drs[i] != 0.0) {
                        int ry;
                        int rh;
                        if (Viz.this.drs[i] < 0.0) {
                            rh = (int)Math.round(-Viz.this.drs[i] * (double)hUnit);
                            ry = y2;
                        } else {
                            rh = (int)Math.round(Viz.this.drs[i] * (double)hUnit);
                            ry = y2 - rh + 1;
                        }
                        if (rh == 0) {
                            rh = 1;
                        }
                        g.setColor(Viz.this.colors[i]);
                        g.fillRect(x0 + wGamble * i, ry, wGamble, rh);
                        g.drawString(String.valueOf(i), x0 + wGamble * 2 / 5 + 1 + wGamble * i, ry - 5);
                    }
                    ++i;
                }
            }
        }

        class PlayerPanel
        extends JPanel {
            Player p;

            PlayerPanel(Player p) {
                this.p = p;
                this.setBorder(new BevelBorder(1));
            }

            @Override
            public void paintComponent(Graphics g) {
                Dimension d = this.getSize();
                int w = d.width;
                int h = d.height;
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, w, h);
                if (this.p.alive) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(Color.LIGHT_GRAY);
                }
                g.setFont(Viz.this.f1);
                g.drawString(this.p.name == null ? "" : this.p.name, 10, 20);
                DecimalFormat df = new DecimalFormat("0.0000000");
                g.drawString("$ " + df.format(this.p.cumWealth), 10, 40);
                g.setFont(Viz.this.f2);
                String status = this.p.alive ? (this.p.haveNewAlloc ? "ready" : "waiting") : "disconnected";
                g.drawString(status, 10, 57);
                g.drawString("# wins: " + this.p.nWins, 10, 71);
                Graphics2D g2d = (Graphics2D)g;
                AffineTransform at = g2d.getTransform();
                g2d.rotate(-1.5707963267948966);
                if (this.p.lastTurn != null) {
                    Turn t = this.p.lastTurn;
                    int wAllocs = w - 75;
                    int hAllocs = h - 90;
                    g2d.setColor(Color.BLACK);
                    g2d.drawRect(-(h - 9), 20, hAllocs + 1, wAllocs + 1);
                    double allocRem = 1.0;
                    int barRem = hAllocs;
                    int pxlStart = -(h - 9);
                    int i = 0;
                    while (i < nGambles) {
                        if (t.allocs[i] != 0.0) {
                            double fracAllocUsing = t.allocs[i] / allocRem;
                            int barUsing = (int)Math.round(fracAllocUsing * (double)barRem);
                            if (Viz.this.rets[i] != 0.0 && barUsing > 0) {
                                g.setColor(Viz.this.colors[i]);
                                g.fillRect(pxlStart, 21, barUsing, wAllocs);
                            }
                            barRem -= barUsing;
                            pxlStart += barUsing;
                            allocRem -= t.allocs[i];
                        }
                        ++i;
                    }
                    double inc = Viz.this.idxOrder == -1 ? 0.0 : t.cumIncomeInGambleOrder[Viz.this.idxOrder];
                    String incStr = DF_DLRS.format(inc);
                    System.out.print(incStr);
                    int incStrLen = (int)Math.ceil(Viz.this.fm.stringWidth(incStr));
                    g2d.setColor(Color.BLACK);
                    g2d.setFont(Viz.this.f2);
                    g2d.drawString(incStr, -(h - 55 + incStrLen), w - 36);
                    g2d.setColor(Color.GRAY);
                    int incBarLen = (int)((double)(h - 135) * inc / ((Viz)Viz.this).SimulatorWithoutSockets.this.maxTotalIncome);
                    g2d.fillRect(-(h - 60), w - 45, incBarLen, 9);
                }
                String cwStr = DF_DLRS.format(this.p.cumWealth);
                int cwStrLen = (int)Math.ceil(Viz.this.fm.stringWidth(cwStr));
                g2d.setColor(Color.BLACK);
                g2d.setFont(Viz.this.f2);
                g2d.drawString(cwStr, -(h - 55 + cwStrLen), w - 15);
                g2d.setColor(Color.GRAY);
                int cwBarLen = (int)((double)(h - 135) * this.p.cumWealth / ((Viz)Viz.this).SimulatorWithoutSockets.this.maxCumWealth);
                g2d.fillRect(-(h - 60), w - 24, cwBarLen, 9);
                g2d.setTransform(at);
            }
        }
    }
}

