/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class Board {
    private static final int size = 10;
    private int[][] board = new int[10][10];
    private int[][] path;
    private Hint lastHint = null;
    private boolean expectMove = false;

    public boolean isTherePath(int n) {
        this.initPath();
        boolean bl = false;
        block4: for (int i = 0; i < 10 && !bl; ++i) {
            switch (n) {
                case 1: {
                    bl = this.isTherePath(i, 0, n);
                    continue block4;
                }
                case 2: {
                    bl = this.isTherePath(0, i, n);
                    continue block4;
                }
            }
        }
        return bl;
    }

    public String generateNextHint() {
        Random random = new Random();
        int n = Math.abs(random.nextInt()) % 4;
        Hint hint = null;
        switch (n) {
            case 0: {
                hint = new Hint(0, 0, 0, 0);
                break;
            }
            case 1: {
                hint = new Hint(1, 0, 0, 0);
                break;
            }
            case 2: {
                int n2 = Math.abs(random.nextInt()) % 10;
                hint = new Hint(3, n2, 0, 0);
                break;
            }
            case 3: {
                int n3 = Math.abs(random.nextInt()) % 100 + 1;
                int n4 = Math.abs(random.nextInt()) % n3 + 1;
                hint = new Hint(4, 0, n4, n3);
                break;
            }
            default: {
                System.out.println("h is " + n);
            }
        }
        if (this.goodHint(hint)) {
            this.lastHint = hint;
            this.expectMove = true;
            return hint.toString();
        }
        return this.generateNextHint();
    }

    public int acceptMove(int n, int n2, int n3) {
        System.out.println("accept " + n + "  " + n2 + " from " + 2);
        if (!this.expectMove || this.board[n][n2] != 0) {
            return 1;
        }
        if (this.lastHint.satisfy((n + 1) * (n2 + 1))) {
            this.board[n][n2] = n3;
            return 0;
        }
        return 2;
    }

    public boolean validMove(int n, int n2) {
        System.out.println(n + " " + n2 + "  " + this.board[n][n2]);
        if (!this.expectMove || this.board[n][n2] != 0 || !this.lastHint.satisfy((n + 1) * (n2 + 1))) {
            System.out.println("false");
            return false;
        }
        System.out.println("true");
        return true;
    }

    private boolean goodHint(Hint hint) {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (this.board[i][j] != 0 || !hint.satisfy((i + 1) * (j + 1))) continue;
                return true;
            }
        }
        return false;
    }

    private void initPath() {
        this.path = new int[10][10];
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.path[i][j] = -2;
            }
        }
    }

    private boolean isTherePath(int n, int n2, int n3) {
        if (n < 0 || n >= 10 || n2 < 0 || n2 >= 10 || this.board[n][n2] != n3) {
            return false;
        }
        if (this.path[n][n2] != -2) {
            return this.path[n][n2] == 1;
        }
        if (n3 == 1 && n2 == 9 || n3 == 2 && n == 9) {
            return true;
        }
        this.path[n][n2] = -1;
        boolean bl = false;
        for (int i = -1; i < 2 && !bl; ++i) {
            for (int j = -1; j < 2 && !bl; bl |= this.isTherePath(n + i, n2 + j, n3), ++j) {
            }
        }
        this.path[n][n2] = bl ? 1 : 0;
        return bl;
    }

    public int getPlayer(int n, int n2) {
        if (this.validMove(n, n2)) {
            return 4;
        }
        return this.board[n][n2];
    }
}

