/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class PortfolioGenerator {
    public static List<Gamble> generateGambles(int gambleNum, int classNum) throws Exception {
        double expectedReturn = 2.0 * (double)gambleNum;
        ArrayList<Double> rates = new ArrayList<Double>();
        ArrayList<Gamble> gamblesList = new ArrayList<Gamble>();
        double sum = 0.0;
        int i = 0;
        while (i < gambleNum) {
            double r = PortfolioGenerator.getARandomNumInRange(1.0, 1.5);
            rates.add(r);
            sum += r;
            ++i;
        }
        i = 0;
        while (i < gambleNum) {
            double expect = (Double)rates.get(i) / sum * expectedReturn;
            Gamble gamble = PortfolioGenerator.generate(i, classNum, expect);
            gamblesList.add(gamble);
            ++i;
        }
        return gamblesList;
    }

    public static Gamble generate(int id, int classNum, double expectedReturn) throws Exception {
        int classId;
        Gamble gamble = new Gamble();
        gamble.classId = classId = PortfolioGenerator.getARandomInttInRange(0, classNum - 1);
        gamble.id = id;
        BigDecimal bigDecimal = null;
        while (true) {
            gamble.medProb = PortfolioGenerator.getARandomNumInRange(0.4, 0.6);
            bigDecimal = new BigDecimal(gamble.medProb);
            gamble.medProb = bigDecimal.setScale(2, 4).doubleValue();
            if (gamble.medProb == 1.0) continue;
            do {
                gamble.lowProb = PortfolioGenerator.getARandomNumInRange(0.0, 1.0 - gamble.medProb);
                bigDecimal = new BigDecimal(gamble.lowProb);
                gamble.lowProb = bigDecimal.setScale(2, 4).doubleValue();
            } while (gamble.lowProb == 0.0 || gamble.lowProb == 1.0 - gamble.medProb);
            gamble.highProb = 1.0 - gamble.medProb - gamble.lowProb;
            bigDecimal = new BigDecimal(gamble.highProb);
            gamble.highProb = bigDecimal.setScale(2, 4).doubleValue();
            if (gamble.highProb != 0.0) break;
        }
        while (true) {
            double expectedReturnCopy = expectedReturn;
            double highrange = Math.min(10.0, expectedReturnCopy / gamble.highProb);
            gamble.high_return = PortfolioGenerator.getARandomNumInRange(1.0, highrange);
            if (Math.min(gamble.high_return, (expectedReturnCopy -= gamble.high_return * gamble.highProb) / gamble.medProb) < 1.0) continue;
            gamble.medium_return = PortfolioGenerator.getARandomNumInRange(1.0, Math.min(gamble.high_return, expectedReturnCopy / gamble.medProb));
            gamble.low_return = (expectedReturnCopy -= gamble.medium_return * gamble.medProb) / gamble.lowProb;
            bigDecimal = new BigDecimal(gamble.high_return);
            gamble.high_return = bigDecimal.setScale(2, 4).doubleValue();
            bigDecimal = new BigDecimal(gamble.medium_return);
            gamble.medium_return = bigDecimal.setScale(2, 4).doubleValue();
            bigDecimal = new BigDecimal(gamble.low_return);
            gamble.low_return = bigDecimal.setScale(2, 4).doubleValue();
            if (gamble.high_return > gamble.medium_return && gamble.medium_return > gamble.low_return && gamble.high_return > 1.0 && gamble.low_return < 1.0 && gamble.low_return > 0.09) break;
        }
        return gamble;
    }

    public static double round2Digit(double num) {
        int tmp = (int)Math.round(num * 100.0);
        return (double)tmp / 100.0;
    }

    public static double getARandomNumInRange(double min, double max) throws Exception {
        if (max < min) {
            throw new Exception("the high bound should be no less than the low bound!");
        }
        return min + Math.random() * (max - min);
    }

    public static int getARandomInttInRange(int min, int max) throws Exception {
        if (max < min) {
            throw new Exception("the high bound should be no less than the low bound!");
        }
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public static double getARandomNumLargerThanAPositive(double n) throws Exception {
        if (n < 0.0) {
            throw new Exception("N should be no smaller than 0!");
        }
        double highBound = PortfolioGenerator.getARandomNumInRange(n, Double.MAX_VALUE);
        return PortfolioGenerator.getARandomNumInRange(n, highBound);
    }

    public static String outputAsString(List<Gamble> list, int[][] links) {
        StringBuilder sb = new StringBuilder();
        sb.append("Gamble\n gi class hi:hiprob med:medprob low:lowprob\n");
        for (Gamble gamble : list) {
            sb.append(String.valueOf(gamble.outputToFile()) + "\n");
        }
        sb.append("\nLink\n  gi  gj\n");
        int i = 0;
        while (i < links.length) {
            int j = i + 1;
            while (j < links.length) {
                if (links[i][j] == 1) {
                    sb.append("  " + i + " , " + j + "\n");
                }
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    public static int[][] genLinks(int gambleNum) {
        int[][] linkedMatrix = new int[gambleNum][gambleNum];
        int i = 0;
        while (i < gambleNum) {
            int j = i + 1;
            while (j < gambleNum) {
                double dice = Math.random();
                if (dice < 0.8) {
                    linkedMatrix[i][j] = 0;
                    linkedMatrix[j][i] = 0;
                } else {
                    linkedMatrix[i][j] = 1;
                    linkedMatrix[j][i] = 1;
                }
                ++j;
            }
            ++i;
        }
        return linkedMatrix;
    }

    public static void main(String[] args) throws Exception {
        int gambelNum = 10;
        int classNum = 5;
        List<Gamble> list = PortfolioGenerator.generateGambles(gambelNum, classNum);
        int[][] links = PortfolioGenerator.genLinks(gambelNum);
        String output = PortfolioGenerator.outputAsString(list, links);
        System.out.println(output);
    }
}

