/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class Player {
    private int id;
    private double wealth;
    private int score;
    private boolean cheated;
    private ArrayList<Double> returns;
    private double returnSum;
    private double variance;
    private double previous;
    private double sharpeRatio;

    Player(int id) {
        this.id = id;
        this.wealth = 10.0;
        this.previous = 10.0;
        this.cheated = false;
        this.returns = new ArrayList();
        this.variance = 0.0;
        this.returnSum = 0.0;
        this.sharpeRatio = 0.0;
    }

    public void caculateSharpeRatio() {
        double sum = 0.0;
        for (Double ret : this.returns) {
            sum += ret.doubleValue();
        }
        this.returnSum = sum;
        if (this.returnSum == 0.0) {
            this.sharpeRatio = 0.0;
            return;
        }
        double mean = sum / (double)this.returns.size();
        double var = 0.0;
        for (Double ret : this.returns) {
            var += Math.pow(ret - mean, 2.0);
        }
        this.variance = var = Math.sqrt(var / (double)this.returns.size());
        this.sharpeRatio = this.returnSum / var;
    }

    public double getWealth() {
        return this.wealth;
    }

    public void setWealth(double wealth) {
        this.wealth = wealth;
    }

    public void increaseScoreByOne() {
        ++this.score;
    }

    public double getPNL() {
        if (this.returns.size() == 0) {
            return 0.0;
        }
        return this.returns.get(this.returns.size() - 1);
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public boolean isCheated() {
        return this.cheated;
    }

    public void setCheated(boolean cheated) {
        this.cheated = cheated;
    }

    public ArrayList<Double> getReturns() {
        return this.returns;
    }

    public void setReturns(ArrayList<Double> returns) {
        this.returns = returns;
    }

    public double getVariance() {
        return this.variance;
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public double getReturnSum() {
        return this.returnSum;
    }

    public void setReturnSum(double returnSum) {
        this.returnSum = returnSum;
    }

    public double getSharpeRatio() {
        return this.sharpeRatio;
    }

    public void setSharpeRatio(double sharpeRatio) {
        this.sharpeRatio = sharpeRatio;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public double getPrevious() {
        return this.previous;
    }

    public void setPrevious(double previous) {
        this.previous = previous;
    }
}

