/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

class MyPanel
extends JPanel {
    private boolean flag = true;
    private final int SIZE = 20;
    private final int CAKY_WIDTH = 400;
    private final int STEP = 10;
    private String xTitle;
    private String yTitle;
    private static List<String> elem = new ArrayList<String>();
    private static List<Double> value = new ArrayList<Double>();
    private static DecimalFormat df = new DecimalFormat("####.##");

    public MyPanel() {
        this.xTitle = "X";
        this.yTitle = "Y";
    }

    public MyPanel(String x, String y) {
        this.xTitle = x;
        this.yTitle = y;
    }

    public void init() {
        elem.clear();
        value.clear();
    }

    public void insert(String aElem, double aValue) {
        elem.add(aElem);
        value.add(aValue);
    }

    public void update(String aElem, double aValue) {
        int index = elem.indexOf(aElem);
        value.set(index, aValue);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.drawHistogram(g);
    }

    public void drawHistogram(Graphics g) {
        g.setColor(Color.BLACK);
        g.setFont(new Font("SANS_SERIF", 0, 15));
        g.drawString("Gambles Return", 220, 30);
        g.setColor(Color.GREEN);
        g.drawLine(20, this.getHeight() - 20, 20, 20);
        g.drawLine(20, this.getHeight() - 20, this.getWidth() - 20, this.getHeight() - 20);
        g.setColor(Color.RED);
        int[] x1 = new int[]{14, 20, 26};
        int[] y1 = new int[]{28, 20, 28};
        g.drawPolyline(x1, y1, 3);
        int[] x2 = new int[]{this.getWidth() - 20 - 8, this.getWidth() - 20, this.getWidth() - 20 - 8};
        int[] y2 = new int[]{this.getHeight() - 20 - 6, this.getHeight() - 20, this.getHeight() - 20 + 6};
        g.drawPolyline(x2, y2, 3);
        if (value.size() == 0) {
            return;
        }
        int wigth = (this.getWidth() - 60) / (value.size() * 2);
        double max = 0.0;
        for (Double elem : value) {
            if (!(max < elem)) continue;
            max = elem;
        }
        double num = (double)(this.getHeight() - 60) / (1.2 * (max + 0.001));
        int i = 0;
        while (i < elem.size()) {
            int height = (int)(value.get(i) * num);
            g.setColor(new Color(Digit.getDigit(255), Digit.getDigit(255), Digit.getDigit(255)));
            g.fillRect(wigth * (i * 2 + 1) + 20, this.getHeight() - 20 - height, wigth, height);
            g.setColor(Color.RED);
            g.drawString(df.format(value.get(i)), wigth * (i * 2 + 1) + 20, this.getHeight() - 20 - 10 - height);
            g.drawString(elem.get(i), wigth * (i * 2 + 1) + 20, this.getHeight() - 20 + 15);
            ++i;
        }
    }

    public void setHistogramTitle(String y, String x) {
        this.xTitle = x;
        this.yTitle = y;
    }
}

