import React from 'react';
import ReactDOM from 'react-dom';
import { Router, HashRouter } from "react-router-dom";
import './index.css';
import App from './App';
import configureStore from './store';
import { Provider } from 'react-redux';
import * as serviceWorker from './serviceWorker';
import '../node_modules/bootstrap/dist/css/bootstrap.min.css';
// Firebase App (the core Firebase SDK) is always required and must be listed first
import firebase from "firebase/app";
// If you are using v7 or any earlier version of the JS SDK, you should import firebase using namespace import
// import * as firebase from "firebase/app"

// If you enabled Analytics in your project, add the Firebase SDK for Analytics
import "firebase/analytics";

// Add the Firebase products that you want to use
import "firebase/auth";
import "firebase/firestore";
import { SnackbarProvider } from 'notistack';

const firebaseConfig = {
  apiKey: "AIzaSyBDvIg6Ta-i71I8nfgL8Laa9P1VoDpPkIE",
  authDomain: "dietlp.firebaseapp.com",
  projectId: "dietlp",
  storageBucket: "dietlp.appspot.com",
  messagingSenderId: "566902879160",
  appId: "1:566902879160:web:f4742cafee9f293175954d"
};

if (!firebase.apps.length) {
  firebase.initializeApp(firebaseConfig);
} else {
  firebase.app(); // if already initialized, use that one
}


ReactDOM.render(

  <Provider store={configureStore()}>
    <SnackbarProvider maxSnack={1} anchorOrigin={{
      vertical: 'top',
      horizontal: 'center',
    }}>
      <HashRouter>
        <App />
      </HashRouter>

    </SnackbarProvider>
  </Provider>
  ,
  document.getElementById('root')
);

// If you want your app to work offline and load faster, you can change
// unregister() to register() below. Note this comes with some pitfalls.
// Learn more about service workers: https://bit.ly/CRA-PWA
serviceWorker.unregister();
