import React from "react";
import { connect } from "react-redux";
import {
    getUserData,
    addSolution,
    updateUserData,
} from "../../helpers/DataActions.js";
import { withSnackbar } from "notistack";
import { withRouter } from "react-router-dom";
import { Container, Button, Col, Row, Spinner, } from "react-bootstrap";
import { FormGroup, FormControlLabel, Switch} from "@material-ui/core"
import { Redirect, useHistory } from "react-router";
import Day from "./Day.js";
import data from "./foods.json";
import worker from "workerize-loader!./worker"; // eslint-disable-line import/no-webpack-loader-syntax
import ontology from "./onology.json";
import { ThreeSixty } from "@material-ui/icons";

class Plan extends React.Component {
    opts;
    solutions;
    days = 7;
    constructor(props) {
        super(props);
        this.terminate = this.terminate.bind(this);
        if (this.props.isAuthed) {
            this.state = {
                finished: false,
                clicked: false,
                workforce: [],
                solutions: [],
                diet: this.props.userData?.private.diet || [],
            };
            this.opts = {
                calories: {
                    min: this.props.userData.shared.goals.calories[0],
                    max: this.props.userData.shared.goals.calories[1],
                }, //"priority": 0
                protein: {
                    min: this.props.userData.shared.goals.protein[0],
                    max: this.props.userData.shared.goals.protein[1],
                }, //, "priority": 1
                carbohydrates: {
                    min: this.props.userData.shared.goals.carbohydrates[0],
                    max: this.props.userData.shared.goals.carbohydrates[1],
                }, //, "priority": 2
                fat: {
                    min: this.props.userData.shared.goals.fat[0],
                    max: this.props.userData.shared.goals.fat[1],
                }, //, "priority": 1
                seconds: {
                    min: this.props.userData.shared.goals.time[0],
                    max: this.props.userData.shared.goals.time[1],
                },
            };
        }
    }

    displayDiet() {
        console.log("Rendering with displayDiet", this.state.diet)
        this.setState(
            {
                solutions: []
            }
        );
        if (window.innerWidth < 1024) {
            this.state.diet?.forEach((entry, index) => {
                this.setState((prevState) => ({
                    solutions: prevState.solutions.concat(
                        <Col xs={12}>
                            <Day
                                day={index + 1}
                                meals={entry}
                                constraints={this.props.userData.shared.goals}
                            ></Day>
                        </Col>
                    ),
                }));
            });
        }
        else {
            this.state.diet?.forEach((entry, index) => {
                this.setState((prevState) => ({
                    solutions: prevState.solutions.concat(
                        <Col>
                            <Day
                                day={index + 1}
                                meals={entry}
                                constraints={this.props.userData.shared.goals}
                            ></Day>
                        </Col>
                    ),
                }));
            });
        }

    }
    componentWillMount() {
        window.scrollTo(0, 0);
        if (this.state.diet != null) {
            this.displayDiet()
        }
        this.unlisten = this.props.history.listen((location, action) => {
            console.log("route change", location, action, this.props.action);
            const term = location.pathname.split("/").pop();
            if (term == "failed") {
                this.displayDiet();
                alert("We were not able to generate any plans that satisfied your constraints. Please try widening them.")
                this.props.history.push('/plan')
            }
        });

    }
    componentWillUnmount() {
        this.unlisten();
    }


    componentDidMount() {
        if (this.props.action == "generate") {
            this.props.history.push('/plan');
            let self = this;
            setTimeout(function () {
                self.generateMeals();
            }, 500);

        }
    }

    restrictUniverse(allergenList) {
        return new Promise((resolve, reject) => {
            //Take total dataset and filter out allergens. Return a nested array split into indices for worker use.
            let groupList = [];
            for (const item of allergenList) {
                if (item.indexOf("(all)") != -1) {
                    let category = item.replace(" (all)", "");

                    let ingredients = [...ontology[category]];

                    groupList = groupList.concat(ingredients);
                }
            }
            let allergens = [...allergenList, ...groupList];
            console.log("Full ingredient list:", allergens);
            let recipes = Object.keys(data).filter((item) => {
                //Do this globally one time on the dataset
                //allergens = allergens.concat()
                if (
                    allergens?.some((element) =>
                        data[item]["ingredients"].toLowerCase().includes(element)
                    ) ||
                    allergens?.some((element) =>
                        data[item]["name"].toLowerCase().includes(element)
                    )
                ) {
                    console.log(data[item]["name"] + " is not allowed, excluding.");
                    return false;
                }
                return true;
            });
            resolve(
                recipes.reduce((resultArray, item, index) => {
                    const chunkIndex = Math.floor(
                        index / Math.floor(recipes.length / this.days)
                    );
                    if (!resultArray[chunkIndex]) {
                        resultArray[chunkIndex] = []; // start a new chunk
                    }
                    resultArray[chunkIndex].push(item);
                    return resultArray;
                }, [])
            );
        });
    }

    createWorkers() {
        let workers = new Array(this.days);
        for (var i = 0; i < this.days; i++) {
            workers[i] = worker();
        }
        return workers;
    }

    generateMeals() {
        this.setState((prevState) => ({
            solutions: [],
            clicked: true,
        }));

        //First restrict global set of recipes.
        this.restrictUniverse(this.props.userData.shared.allergens).then((universe) => {
            let dayCount = 0;
            let workforce = this.createWorkers();
            this.setState((prevState) => ({
                workforce,
            }));
            let diet = workforce.map((instance, index) => {
                return new Promise((resolve, reject) => {
                    console.log("instance with", universe[index]);
                    instance
                        .calculate(
                            universe[index],
                            this.opts,
                            this.props.userData.private.demographics.meals,
                            index
                        )
                        .then((solution) => {
                            //Sometimes we cannot guarantee a liked food.
                            //This is a best-effort approach. If we do not have a liked food on even days, try again, but only once
                            let containsLiked = false;
                            if (index % 2 == 0) {
                                for (const key in solution) {
                                    if (
                                        this.props.userData.shared.tastes.some((element) =>
                                            solution[key]["ingredients"].includes(element)
                                        ) ||
                                        this.props.userData.shared.tastes.some((element) =>
                                            solution[key]["name"].includes(element.toLowerCase())
                                        )
                                    ) {
                                        console.log(
                                            "The solution contains a liked food",
                                            solution[key]
                                        );
                                        containsLiked = true;
                                        break;
                                    }
                                }
                            } else {
                                containsLiked = true;
                            }

                            if (!containsLiked) {
                                resolve(
                                    instance.calculate(
                                        universe[index],
                                        this.opts,
                                        this.props.userData.private.demographics.meals,
                                        index
                                    )
                                );
                            } else {
                                resolve(solution);
                            }
                        });
                });
            }, this);

            if (window.innerWidth < 1024) {
                //If mobile
                diet.forEach((p) =>
                    p.then((entry) => {
                        dayCount += 1;
                        this.setState((prevState) => ({
                            solutions: prevState.solutions.concat(
                                <Col xs={12}>
                                    <Day
                                        day={dayCount}
                                        meals={entry}
                                        constraints={this.props.userData.shared.goals}
                                    ></Day>
                                </Col>
                            ),
                        }));
                    })
                );
            } else {
                diet.forEach((p) =>
                    p.then((entry) => {
                        dayCount += 1;
                        this.setState((prevState) => ({
                            solutions: prevState.solutions.concat(
                                <Col>
                                    <Day
                                        day={dayCount}
                                        meals={entry}
                                        constraints={this.props.userData.shared.goals}
                                    ></Day>
                                </Col>
                            ),
                        }));
                    })
                );
            }

            return Promise.all(diet).then((results) => {
                console.log("Solved:", results);
                this.setState(
                    (prevState) => ({
                        diet: results,
                        finished: true,
                        workforce: [],
                    }),
                    () => {
                        this.saveChanges(results);
                    }
                );
            });
        });
    }

    showToast = (msg, variant) => {
        this.props.enqueueSnackbar(msg, { variant });
    };

    saveChanges = (set) => {
        console.log(this.state);
        let privateData = { ...this.props.userData.private }
        privateData.diet = set
        const updated = Object.assign({ ...this.props.userData }, { "private": privateData });

        console.log("Saved state below:");
        console.log(updated);
        this.props.updateUserData(this.props.token, updated, this.showToast);
    };
    terminate() {
        console.log("killing process")
        this.state.workforce.map((instance, index) => {
            instance.terminate();
        });
        //this.forceUpdate();
        this.setState(
            (prevState) => ({
                clicked: false,
                workforce: [],
                diet: this.props.userData.diet || [],
            }),
            this.props.history.push("/plan/failed")
        );
    }

    render() {
        if (this.props.isAuthed) {
            if (this.props.userData.unregistered) {
                return <Redirect to="/settings"></Redirect>;
            }
            if (!this.state.clicked || this.state.finished) {
                return (
                    <div>
                        
                        <Button variant="primary" size="sm" style={{float: "right", margin: 40}}
                                onClick={() => {
                                    window.print()
                                }}
                            >
                                Print
                            </Button>
                        <Container align="center" style={{ paddingTop: 40 }}>
                            <FormGroup row>
                                <FormControlLabel
                                    control={<Switch checked={false} onChange={() => { this.props.history.push("/group/plan/") }} name="groupToggle" />}
                                    label="Group Mode"
                                />
                            </FormGroup>

                            <h3>My Week's Plan</h3>
                            <br></br>
                            <p>
                                <b>Calories:</b> [{this.props.userData.shared?.goals.calories[0]},{" "}
                                {this.props.userData.shared?.goals.calories[1]}], &nbsp;
                                <b>Fat:</b> [{this.props.userData.shared.goals.fat[0]},{" "}
                                {this.props.userData.shared?.goals.fat[1]}], &nbsp;
                                <b>Carbohydrates:</b> [
                                {this.props.userData.shared?.goals.carbohydrates[0]},{" "}
                                {this.props.userData.shared?.goals.carbohydrates[1]}], &nbsp;
                                <b>Protein:</b> [{this.props.userData.shared?.goals.protein[0]},{" "}
                                {this.props.userData.shared?.goals.protein[1]}],&nbsp;
                                <b>Time:</b> [{parseInt(this.props.userData.shared?.goals.time[0] / 60)}
                                , {parseInt(this.props.userData.shared?.goals.time[1] / 60)}]
                            </p>
                            <br></br>
                            <Button
                                onClick={() => {
                                    this.generateMeals();
                                }}
                            >
                                Generate a new plan
                            </Button>
                        </Container>
                        <div style={{ paddingTop: 30 }}>
                            <Container fluid>
                                <Row> {this.state.solutions} </Row>
                            </Container>
                        </div>
                    </div>
                );
            } else {
                return (
                    <div>
                        
                        <Container style={{ paddingTop: 40 }}>
                            <FormGroup row>
                                <FormControlLabel
                                    control={<Switch checked={false} onChange={() => { this.props.history.push("/group/plan/") }} name="groupToggle" />}
                                    label="Group Mode"
                                />
                            </FormGroup>
                            <br></br>
                            <div align="center">
                                <h3>My Week's Plan</h3>
                                <br></br>
                                <p>
                                    <b>Calories:</b> [{this.props.userData.shared?.goals.calories[0]},{" "}
                                    {this.props.userData.shared?.goals.calories[1]}], &nbsp;
                                    <b>Fat:</b> [{this.props.userData.shared?.goals.fat[0]},{" "}
                                    {this.props.userData.shared?.goals.fat[1]}], &nbsp;
                                    <b>Carbohydrates:</b> [
                                    {this.props.userData.shared?.goals.carbohydrates[0]},{" "}
                                    {this.props.userData.shared?.goals.carbohydrates[1]}], &nbsp;
                                    <b>Protein:</b> [{this.props.userData.shared?.goals.protein[0]},{" "}
                                    {this.props.userData.shared?.goals.protein[1]}],&nbsp;
                                    <b>Time:</b> [
                                    {parseInt(this.props.userData.shared.goals.time[0] / 60)},{" "}
                                    {parseInt(this.props.userData.shared.goals.time[1] / 60)}]
                                </p>
                                <br></br>
                                <h6>
                                    Working some magic to find make your meal plan (this will take
                                    a few moments)...
                                </h6>
                                <br></br>
                                <Button
                                    variant="danger"

                                    onClick={() => {
                                        //this.forceUpdate();
                                        this.terminate();
                                    }}
                                >
                                    Cancel process
                                </Button>
                            </div>
                        </Container>
                        <br></br>
                        <div style={{ paddingTop: 30 }}>
                            <Container fluid>
                                <Row> {this.state.solutions} </Row>
                            </Container>
                        </div>
                    </div>
                );
            }
        }

        return (
            <div>
                <Redirect to="/"></Redirect>
            </div>
        );
    }
}

const mapStateToProps = (state) => ({
    token: state.reducer.token,
    userData: state.reducer.userData,
    isAuthed: state.reducer.isAuthed,
});

export default connect(mapStateToProps, { getUserData, updateUserData })(
    withRouter(withSnackbar(Plan))
);