import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Vector;
import java.util.ListIterator;


/*
 * Created on Sep 29, 2005
 */

/**
 * @author Ariel Cohen
 */
public class FinderImp implements Finder{
	Vector network;
    private Responder responder;
    private Vector ants;
    private String responderHost;
    private String responderName;
	boolean alive;
	boolean antsAreAlive;
    private Vector antsReportingLocationsAtThisRound;
    private int round;
    private int currentNumberOfAnts;
    private String finderName;
	
    /**
	 * Constructor for the FinderImp.
	 * @exception RemoteException There is no RMI.
	 */    
	public FinderImp(String finderName, String responderName, String responderHost){
		this.responderHost = responderHost;
	    this.responderName = responderName;
	    this.finderName    = finderName;
		currentNumberOfAnts = 0;
	    try{
	    	initializeResponder();
    		network = new Vector();
    		int j;
    		for(int i=1; i<=Utilities.NUMBER_OF_ROWS; i++){
    			if(i%2 == 0)
    				j = 2;
    			else
    				j = 1;			
    			for(; j<=Utilities.NUMBER_OF_COLUMNS; j=j+2){
    				SpecialLocation temp = new SpecialLocation(i,j);
    				if((i==Utilities.START.getX() & j==Utilities.START.getY()))
    					temp.setExist(); //we can assume only start location was found
    				network.add(temp);
    			}
    		}    	
    		ants = new Vector();
    		antsReportingLocationsAtThisRound = new Vector();
    		initiateAnts();
	    }catch(Exception e){System.out.println("Finder: Could not connect to Responder " + responderName);
	    					System.out.println("Finder is NOT working!");
	    					return;
		}	
		alive = true;
		antsAreAlive = true;
	    System.out.println("Finder is working...");
	}
	
	public void initiateAnts(){
		for(int i = 1; i<= Utilities.NUMBER_OF_ANTS; i++){
			AntImp ant = new AntImp(i, this, responderName, responderHost);
			ants.add(ant);
			currentNumberOfAnts++;
		}
	}	
	
	public void run(){
		for(ListIterator it = ants.listIterator() ; it.hasNext() ; ){        //going over the messages
			AntImp ant = (AntImp)it.next();
			new Thread(ant).start();
		}
		try{
			while(alive){
				try{
					Thread.sleep(100);
				}catch(InterruptedException e){}
				if(checkAllNeighborsOfRechableLocationsWereReached()){
					System.out.println("Finder: I figured out the responder's network");
					System.out.flush();
					alive = false;
				}
				if(ants.size() == 0)
					alive = false;
				if(antsReportingLocationsAtThisRound.size() == currentNumberOfAnts){
    				increaseRoundNumber();
				}
			}
			//reportPathsToResponder(); //no paths to report
			System.out.println("Finder: I'm asking Responder to resolve the paths"); 
			System.out.flush();
   			responder.resolveGoldenPaths();
   			Vector responderNetwork = new Vector();
			for(ListIterator it = network.listIterator() ; it.hasNext() ; ){       
				SpecialLocation networkLocation = (SpecialLocation)it.next();	
				if(networkLocation.isExist())
					responderNetwork.add(networkLocation);
			}
   			System.out.println("Finder: the Responder's network:");
   			Utilities.print(responderNetwork);
		}catch(RemoteException e){
			System.out.println("Finder: I lost the connection with the Responder");
		}
		killAnts();
 	}


	/**
	 * Initiates a converstion with the Responder
	 * @param responderHost The responder's host
	 * @param responderName The responder's name
	 */
	public void initializeResponder() throws Exception{
			responder = (Responder)Naming.lookup("rmi://" + responderHost + "/" + responderName);
			responder.activate(finderName);
	}	

	
	private synchronized void increaseRoundNumber() throws RemoteException{
		synchronized(responder){ //insure rounds are increased symulatnsly
			responder.increaseRoundNumber();
			round++;
			antsReportingLocationsAtThisRound.clear();
			notifyAll();
		}
	}
	
	public synchronized void reportLocations(int antID, Location currentLocation, Vector neighborsOfCurrentNode){
		if(!antsAreAlive)
			return;
//System.out.println("Finder: Ant " + antID + " is reporting " + neighborsOfCurrentNode.size() + " Locations.");			
//System.out.flush();
		Integer antIDInteger = new Integer(antID);
		if(!antsReportingLocationsAtThisRound.contains(antIDInteger)){
			antsReportingLocationsAtThisRound.add(antIDInteger);
		}
		if(neighborsOfCurrentNode.size() == 0){ //not a real report
			return;
		}
		Location neighborLocation = null;
		for(ListIterator it = neighborsOfCurrentNode.listIterator() ; it.hasNext() ; ){        
			neighborLocation = (Location)it.next();
			for(ListIterator it2 = network.listIterator() ; it2.hasNext() ; ){       
				SpecialLocation networkLocation = (SpecialLocation)it2.next();			
				if(networkLocation.getX() == neighborLocation.getX()){
					if(networkLocation.getY() == neighborLocation.getY()){	
						networkLocation.setExist();
					}
				}	
			}
		}
		//if it has no neighbor locations to report that could be
		//of two reasons:
		//no location, asked responder for second time and got 
		//no response - but in later neighbors are already reported
		//by this ant before
		int x = currentLocation.getX();
		int y = currentLocation.getY();
		for(ListIterator it2 = network.listIterator() ; it2.hasNext() ; ){        //going over the messages
			SpecialLocation networkLocation = (SpecialLocation)it2.next();	
			int nx = networkLocation.getX();
			int ny = networkLocation.getY();
			if(nx == x+1)
				if(((ny == y+1) | (ny == y-1)) & networkLocation.wasNotFoundYet()){
					networkLocation.setNotExist();
				}
			if(nx == x-1)
				if(((ny == y+1) | (ny == y-1)) & networkLocation.wasNotFoundYet()){
					networkLocation.setNotExist();
				}
		}
//System.out.println("Finder: Ant " + antID + " is waiting....");	
//System.out.flush();
		try{
			wait();
		}catch(InterruptedException e){}		
	}
	
	private synchronized boolean checkAllNeighborsOfRechableLocationsWereReached(){
		for(ListIterator it = network.listIterator() ; it.hasNext() ; ){        //going over the messages
			SpecialLocation centerLocation = (SpecialLocation)it.next();	
			int cx = centerLocation.getX();
			int cy = centerLocation.getY();
			if(!centerLocation.isExist()){//wasn't found or not exist
				continue;
			}
			for(ListIterator it2 = network.listIterator() ; it2.hasNext() ; ){        //going over the messages
				SpecialLocation specialLocation = (SpecialLocation)it2.next();	
				int sx = specialLocation.getX();
				int sy = specialLocation.getY();
				if(sx == cx+1)
					if(((sy == cy+1) | (sy == cy-1)) & specialLocation.wasNotFoundYet())
						return false;
				if(sx == cx-1)
					if(((sy == cy+1) | (sy == cy-1)) & specialLocation.wasNotFoundYet())
						return false;
			}
		}
		return true;		
	}
 
	//only being called from reportLocations which is synchronized
	public synchronized void reportPathsToResponder() throws RemoteException{
		System.out.println("Finder: I'm reporting paths to responder");
		System.out.flush();
		Vector dummiVector = new Vector();
		responder.addGoldenPath(dummiVector); //report 1 paths
	}

	public synchronized void reportDeadAnt(int antID){
		System.out.println("Finder: Ant " + antID + " reported it is dead");
		System.out.flush();
		for(ListIterator it = ants.listIterator() ; it.hasNext() ; ){        //going over the messages
			AntImp ant = (AntImp)it.next();
			if(ant.getID() == antID){
				it.remove();
				currentNumberOfAnts--;
				return;
			}
		}		
	}
	
	private synchronized void killAnts(){
   		System.out.println("Finder: I'm killing all the Ants");
   		antsAreAlive = false;
   		for(ListIterator it = ants.listIterator() ; it.hasNext() ; ){        //going over the messages
			AntImp ant = (AntImp)it.next();
			ant.kill();
			it.remove();
   		}
   		notifyAll();
	}
	
	class SpecialLocation extends Location{
		private static final long serialVersionUID = 7426372295622776147L;
		private int status; //-1 not exist, 1 exist, 0 not found yet
		
		public SpecialLocation(int x, int y){
			super(x,y);
			status = 0;
		}
		
		public void setNotExist(){
			status = -1;
		}
		
		public void setExist(){
			status = 1;
		}
		
		public boolean isExist(){
			if(status == 1)
				return true;
			return false;
		}	
		
		public boolean wasNotFoundYet(){
			if(status == 0)
				return true;
			return false;
		}
		
	}
	
	/**
	 * Excutes the Finder.
	 * @param args An array of: Finders's name, Responder's name and Responder's host (if exists)
	 */
	public static void main(String args[]){
		if(args.length < 2){ //must at least get the names of the Finder and Responder							
			System.out.println("Please supply names for the Finder and Responder ");
			return;
		}
		String responderHost ="";
		if(args.length > 2)	//host of responder 
			responderHost = args[2];
		FinderImp finder = new FinderImp(args[0], args[1],responderHost);
		new Thread(finder).start();
	}
	
}
