#include <cstdio>
#include <cstring>
#include <vector>
#include <ctime>
#include <math.h>
#include <iostream>
#include <sstream>
#include <fstream>

using namespace std;

#define WORD_LEN 32
#define MAX_LINE_LENGTH 4096
#define MAX_VAL	1000000
#define MAX_STRING_LEN	1024

unsigned mask[WORD_LEN]={1};
unsigned mask2[WORD_LEN];

class bitmap_rec;
class bitmap_dim;
class Node;

typedef struct Rec
{
	//bitmaps
	bitmap_rec* map;
	bitmap_dim* mapDim;

	//position in dynamic vector
	int pos;

	//allocated?
	bool allocated;

} vRecord;

typedef struct val_count
{
	int val;
	int count;

} VALUE;

typedef struct elem_n_upla
{
	int val;
	bitmap_dim* mapNodeDim;
	bitmap_rec* mapAND;
	vector<int> mapSec;
	int record;
	int cont_val;

} ELEM;
                                 
                            

/// CountTable[i] contains the number of 1's in the byte value of i
const char CountTable[256] = {
                                 0UL, 1UL, 1UL, 2UL, 1UL, 2UL, 2UL, 3UL, 1UL, 2UL, 2UL, 3UL, 2UL, 3UL, 3UL, 4UL, 1UL, 2UL, 2UL, 3UL, 2UL, 3UL, 3UL, 4UL, 2UL, 3UL, 3UL, 4UL, 3UL, 4UL, 4UL, 5UL, 1UL, 2UL, 2UL, 3UL, 2UL, 3UL, 3UL, 4UL, 2UL, 3UL, 3UL, 4UL, 3UL, 4UL, 4UL, 5UL, 2UL, 3UL, 3UL, 4UL, 3UL, 4UL, 4UL, 5UL, 3UL, 4UL, 4UL, 5UL, 4UL, 5UL, 5UL, 6UL, 1UL,
                                 2UL, 2UL, 3UL, 2UL, 3UL, 3UL, 4UL, 2UL, 3UL, 3UL, 4UL, 3UL, 4UL, 4UL, 5UL, 2UL, 3UL, 3UL, 4UL, 3UL, 4UL, 4UL, 5UL, 3UL, 4UL, 4UL, 5UL, 4UL, 5UL, 5UL, 6UL, 2UL, 3UL, 3UL, 4UL, 3UL, 4UL, 4UL, 5UL, 3UL, 4UL, 4UL, 5UL, 4UL, 5UL, 5UL, 6UL, 3UL, 4UL, 4UL, 5UL, 4UL, 5UL, 5UL, 6UL, 4UL, 5UL, 5UL, 6UL, 5UL, 6UL, 6UL, 7UL, 1UL,
                                 2UL, 2UL, 3UL, 2UL, 3UL, 3UL, 4UL, 2UL, 3UL, 3UL, 4UL, 3UL, 4UL, 4UL, 5UL, 2UL, 3UL, 3UL, 4UL, 3UL, 4UL, 4UL, 5UL, 3UL, 4UL, 4UL, 5UL, 4UL, 5UL, 5UL, 6UL, 2UL, 3UL, 3UL, 4UL, 3UL, 4UL, 4UL, 5UL, 3UL, 4UL, 4UL, 5UL, 4UL, 5UL, 5UL, 6UL, 3UL, 4UL, 4UL, 5UL, 4UL, 5UL, 5UL, 6UL, 4UL, 5UL, 5UL, 6UL, 5UL, 6UL, 6UL, 7UL, 2UL,
                                 3UL, 3UL, 4UL, 3UL, 4UL, 4UL, 5UL, 3UL, 4UL, 4UL, 5UL, 4UL, 5UL, 5UL, 6UL, 3UL, 4UL, 4UL, 5UL, 4UL, 5UL, 5UL, 6UL, 4UL, 5UL, 5UL, 6UL, 5UL, 6UL, 6UL, 7UL, 3UL, 4UL, 4UL, 5UL, 4UL, 5UL, 5UL, 6UL, 4UL, 5UL, 5UL, 6UL, 5UL, 6UL, 6UL, 7UL, 4UL, 5UL, 5UL, 6UL, 5UL, 6UL, 6UL, 7UL, 5UL, 6UL, 6UL, 7UL, 6UL, 7UL, 7UL, 8UL
                             };

/******************************************************************/
/*                                                                */
/*                         FUNCTIONS    						  */
/*                                                                */
/******************************************************************/

//Max and Min
int min(int a, int b) { return a<b?a:b; }
int max(int a, int b) { return a>b?a:b; }
int count_T=0;
int countTot=0;
int index_global=0;

//Read input file
int** read_datafile(int**, char*);

//Loading Bitmaps
void load_bitmaps(int , int , int **, int );

//Main procedures
void bucBitmapDSC(int**, int, int);
void bucBitmapASC(int**, int, int);
int** partition(int**, int, int, int*, int);
void compute_aggregates(Node* , int** );

//Create and delete BottomUpTree
Node* make_BottomUpTree(int , int );
void set_node_other_levels(Node* , int );
void delete_tree(Node* );
void sub_tree(Node* child, int c, int** data);

//Output tuples
void printf_other_t_uple_n_data(char* , int , int , int** );
void print_t_upla(int , int );
int print_n_uple_val(char* , int , int , vector<vRecord>::iterator);
void printf_other_t_uple_n(char* , int );

/******************************************************************/
/*                                                                */
/*                           GLOBALS							  */
/*                                                                */
/******************************************************************/
typedef vector<VALUE> V1;

typedef struct cData
{
	vRecord* bitmaps;
	V1 bitmap_pos;

}	cubeData;

cubeData* bitData;
vector<int> pos(50);
vector<ELEM> n_uple_val;
vector<int> card(50);
vector<int> tmp_val;
int first_words[2];
//vector<bitmap_dim*> upper_bit;

//Variables
int n_dimensions;
int n_tuples;
int dim_local;
long minSup;
int init_area;

time_t init,end;
FILE* fo;

//Struttura usata dalla classe bitmap_rec
typedef struct count_flag
{
	/* cont_1 contiene il numero di bit 1 della
	 * i-esima word della bitmap (compressa) che
	 * si sta leggendo
	*/
	int cont_1;

	/* Flag che indica il tipo di bitmap compressa:
	 * 'L'--> Literal (Word non compressa)	 
	 * 'F'--> Fill (Word compressa)
	*/
	char type_w;

} countFlag;

/* Serve come header per la bitmap compressa 
 * Per ogni word compressa, contiene:
 * 1. init_pos:   la posizione iniziale (riferita alla bitmap non compressa)
 * 2. len:		  la lunghezza (cio il numero totale di word compresse in una)
 * 3. type_fill:  il tipo di compressione (Fill '1' oppure '0')
*/
typedef struct data_compress
{
	int init_pos;
	short int len;
	bool type_fill;

}data_comp;

/******************************************************************/
/*                                                               */
/*                          CLASSES								  */
/*                                                                */
/******************************************************************/
class bitmap_rec
{
	unsigned *bit_rec;	
	int tmp_bitmap;	
	int last_bit;
	short int init_index;
	short int n_word_com;   //numero di word correnti compresse 
	vector<data_comp> fill_word;
	int num_words;	

	public:

		bitmap_rec() {};
		bitmap_rec(int val) { num_words=val; this->bit_rec =(unsigned*) malloc(sizeof(unsigned)*num_words); 
		memset(this->bit_rec,(unsigned)0,sizeof(unsigned)*num_words); n_word_com=0; };
		bitmap_rec(int , int , int);
		void set_bit_wah(int array_pos, int byte_pos);
		void set_bit_wah_without_F1(int array_pos, int byte_pos);
		int make_and_two_without_mem_and_F0(bitmap_rec* b);
		void make_and_two_with_mem_and_F0(bitmap_rec* a,bitmap_rec* b, int index, int val_dim);
		void make_and_two_with_mem(bool flag,bitmap_rec* a, bitmap_rec* b, int index, int val_dim);
		unsigned get_word(int num) { return bit_rec[num]; };
		int get_tmp_bitmap () { return tmp_bitmap; };
		int get_word_com () { return n_word_com; };
		void inc_word_com () { n_word_com++; };
		int get_num_words () { return num_words; };
		void set_num_words (int val ) { num_words=val; };
		void set_word_com (int val ) { n_word_com=val; };
		int init_and(bitmap_rec* b);
		int one_bitmap_empty(bitmap_rec* b);
		int binary_search(bitmap_rec* ,int ,int, int  );
		int find_index(bitmap_rec* ,int ,int, int  );
		int make_and_two_without_mem_and_F1(bitmap_rec* b);
		int make_and_two_without_mem_and_F1_sorted(bitmap_rec* b);
		void make_and_two_with_mem_and_F1(bitmap_rec* a, bitmap_rec* b, int val_dim);
		int find_word(bitmap_rec* vec,int word, int first, int last);
		void make_and_two_with_mem_and_F1_sorted(bitmap_rec* a,bitmap_rec* b, int val);
		void make_and_two_with_mem_sorted(bool flagS,bitmap_rec* a, bitmap_rec* b, int val_dim, int index);
		void make_and_two_with_mem_sorted2(bool flagS, bitmap_rec* a, bitmap_rec* b, int val_dim, int index);
	

		int get_size_fill_word () { return fill_word.size(); };		
		void print_vector();
		void clear_fill();
		
		~bitmap_rec();
	
		//Logical operation		
		void resize(int dim, int array_pos, int byte_pos);

		//Bitmaps size
		int size() { return num_words; };

		//AND between Bitmaps
		void make_and(bitmap_rec* , bitmap_rec* , int , int , int , int );
		bool check_word(unsigned array_pos);
			
		bool is_null()	{	return (this == NULL ? true : false);  }
};

	void bitmap_rec::print_vector()
	{
			for(int i=0; i!=this->fill_word.size(); i++)
				printf("\n init_pos:%d len:%d",this->fill_word[i].init_pos,this->fill_word[i].len);
	}

	void bitmap_rec::clear_fill()
	{
		this->fill_word.clear();
	}

	bitmap_rec::bitmap_rec(int n, int array_pos, int byte_pos)
	{			

			/* Alloco la bitmap con n bit, considerato che n rappresenta
			 * una stima della lunghezza della bitmap compressa 
			*/
		
			(n % WORD_LEN)? num_words=n/WORD_LEN+1: num_words=n/WORD_LEN;
			if (num_words<2) num_words=2;
			this->bit_rec =(unsigned*) malloc(sizeof(unsigned)*num_words); 
			memset(this->bit_rec,(unsigned)0,sizeof(unsigned)*num_words);			

			/* Setta l'indice iniziale a 0 */
			init_index=0;

			/* Si setta la word temporanea alla prima word acceduta */
			tmp_bitmap=array_pos;
			
			fill_word.clear();

			/* Riserva spazio nel vettore per le word di tipo fill */
			fill_word.reserve((n_tuples/card[0]));	

			/* Se la prima word che si scrive
			 *  maggiore di 0,
			 * significa che ci sono molte word a zero
			 * e va inserito nel vettore un primo elemento
			 * che indichi la compressione che si sta 
			 * effettuando, cio che si hanno
			 * array_pos word '0'
			*/
		     
			/* Si sta scrivendo sulla prima word,
			 * ci significa che la dimensione del range non
			 * si conosce e quindi si imposta len iniziale
			 * uguale ad 1. 
			*/			
			data_comp elem;
			elem.init_pos=array_pos;
			elem.len=1;				
			fill_word.push_back(elem);			

			/* E' la prima volta che si scrive.
			 * Numero di word compresse 
			*/			
			fill_word[0].type_fill=1;
			last_bit=array_pos*WORD_LEN+byte_pos;
			n_word_com=0;							
			bit_rec[n_word_com] |= mask[byte_pos];
			
	}


	void bitmap_rec::set_bit_wah_without_F1(int array_pos, int byte_pos)
	{				
		if(array_pos==tmp_bitmap){	
				/* Si sta leggendo la stessa word */			
				bit_rec[n_word_com] |= mask[byte_pos];
				
					if(fill_word[fill_word.size()-1].type_fill==1 
						&& last_bit==array_pos*WORD_LEN+byte_pos-1){
							last_bit++;														
					}
					else fill_word[fill_word.size()-1].type_fill=0;					
										
		}
		else
		{		
			/* Se la bitmap nuova  maggiore di quella corrente */
			if(array_pos>=tmp_bitmap+1)
			{										
					/* Le word literal che non hanno bit 1 finali
					 * vengono gestite dalla prima word
					 * successiva che conterr un bit 1.					
					*/											
					n_word_com++;						
					
					/* Gestisco re-allocation se il numero di 
					 * word della bitmap non bastano.
					 * Alloco 1/2 della memoria gi allocata
					*/		
					if(n_word_com>=num_words)
					{					
						int num_words_old=num_words;
						num_words += num_words/2;				
						this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*num_words);
						
						for(int g=num_words-1; g>=num_words_old; g--)
							this->bit_rec[g]='\000';															
					}

					/* Si inserisce il bit in posizione */		
					bit_rec[n_word_com] |=  mask[byte_pos];										
				
					//TODO ottimizzare
					if(array_pos==tmp_bitmap+1)
					{
						/* Le word literal sono contigue,
						 * si allarga l'intervallo precedente
						*/
						fill_word[fill_word.size()-1].len++;

						if(fill_word[fill_word.size()-1].type_fill==1 
						&& last_bit==array_pos*WORD_LEN+byte_pos-1)
							last_bit++;												
						else fill_word[fill_word.size()-1].type_fill=0;	
					}
					else{
						/* Le word non sono contigue,
						 * si inserisce un nuovo intervallo
						*/					
						data_comp elem;
						elem.init_pos=array_pos;
						elem.len=fill_word[fill_word.size()-1].len+1;				
						fill_word.push_back(elem);
						
					}				
					tmp_bitmap=array_pos;
			}				
		}//else					
	}

	//resize bitmap
	void bitmap_rec::resize(int dim, int array_pos, int byte_pos)
	{	  		
		fill_word.clear();
		init_index=0;
		num_words=(dim<2)?2:dim;
		this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*num_words);		
		memset(this->bit_rec,(unsigned)0,sizeof(unsigned)*num_words);
			
			/* Si setta la word temporanea alla prima word acceduta */
			tmp_bitmap=array_pos;
						
			/* Se la prima word che si scrive
			 *  maggiore di 0,
			 * significa che ci sono molte word a zero
			 * e va inserito nel vettore un primo elemento
			 * che indichi la compressione che si sta 
			 * effettuando, cio che si hanno
			 * array_pos word '0'
			*/
			data_comp elem;
			elem.init_pos=array_pos;
			elem.len=1;			
			fill_word.push_back(elem);

			fill_word[0].type_fill=1;
			last_bit=array_pos*WORD_LEN+byte_pos;

			/* E' la prima volta che si scrive.
			 * Numero di word compresse. 
			*/			
			n_word_com=0;					
			bit_rec[n_word_com] |= mask[byte_pos];		

	}

	/* Effettua AND tra le prime bitmap */
	int bitmap_rec::init_and(bitmap_rec* b)
	{
		vector<data_comp>::iterator p1, p2;			
		p1 = this->fill_word.begin();
		p2 = b->fill_word.begin();
		int count=0;

		/* Da dove si inizia e si finisce (come posizioni globali)
		 * per l'AND tra le word literal
		*/
		int min_pos;				
		if(this->fill_word.size()!=0 && b->fill_word.size()!=0)			
			min_pos = min(p1->init_pos,p2->init_pos);		
		else
		/* Sono tutti Literal */
		if(this->fill_word.size()==0 && b->fill_word.size()==0)			
			min_pos=min(this->get_word_com(),b->get_word_com())+1;
		
		/* Misti */						
		else if(this->fill_word.size()==0 && b->fill_word.size()!=0)
			min_pos=min(this->get_word_com()+1,p2->init_pos);		
		else							
			min_pos=min(b->get_word_com()+1,p1->init_pos);		
		
		/* Gestisco AND all'esterno del vettore 
		/* Effettuo AND sulle due bitmap da 
		 * init1_com e init2_com a min_pos.
		*/
		unsigned tmp;
		for(int h=0; h<min_pos; h++)
		{
			tmp = this->bit_rec[h] & b->bit_rec[h];
			for(int g=0; g<WORD_LEN; g++)
				if(tmp & mask[g])
					count++;
		}
		return count;											
	}

	/* Non effettua merge, ma uno dei due vettori  vuoto:
	 * quindi effettua AND tra una bitmap non compressa e 
	 * l'altra compressa.
    */
	int bitmap_rec::one_bitmap_empty(bitmap_rec* b)
	{				
		vector<data_comp>::iterator ptr, ptr_end;
		int pos_max, pos_max_other, flag;	
		unsigned tmp;
		int count=0;		

		if(this->fill_word.size()!=0 && b->fill_word.size()==0)
		{					
					flag=1;
					ptr=this->fill_word.begin();
					ptr_end=this->fill_word.end();					
					pos_max=this->get_tmp_bitmap();
					pos_max_other=b->get_tmp_bitmap();					
		}
		else if(this->fill_word.size()==0 && b->fill_word.size()!=0)
		{					
					flag=0;
					ptr=b->fill_word.begin();
					ptr_end=b->fill_word.end();					
					pos_max=b->get_tmp_bitmap();
					pos_max_other=this->get_tmp_bitmap();										
		}

		int first_val, last_pos, init; 		
		int sum, min_pos;

		/* Conserva le info sul primo range
		 * del vettore su cui effettuare il confronto		 
		*/				
		first_val=ptr->init_pos;
		last_pos=ptr->len;			
		int min_tmp_bitmap=min(this->get_tmp_bitmap(),b->get_tmp_bitmap());
		
		for(; ptr!=ptr_end; )
		{								
					/* Incrementa il contatore per effettuare
					 * il confronto con il secondo range e 
					 * calcolare il numero di word literal da 
					 * 'intersecare'.
					*/	
					init=first_val+last_pos;						
					ptr++;			

					/* Effettua And su word literal 
					 * rimanenti, se si  giunti alla 
					 * fine della lista. Altrimenti,
					 * calcola la distanza in word dal 
					 * secondo range.
					*/		
					if(init<=min_tmp_bitmap)
					{
						if(ptr==ptr_end) 								
							min_pos=min_tmp_bitmap;																				
						else							
							min_pos=min(ptr->init_pos-1,min_tmp_bitmap);														
					}
					else return count;

					/* Effettua l'AND tra le word literal comprese
					 * tra un intervallo compresso e il successivo.
					*/
					for(int i=init-((ptr-1)->len), j=init; j<=min_pos; i++, j++)
					{										
						if(flag)
							tmp=this->bit_rec[i] & b->bit_rec[j];
						else
							tmp=this->bit_rec[j] & b->bit_rec[i];

						for(int g=0; g<WORD_LEN; g++)
							if(tmp & mask[g])
								count++;												
					}	
					
					if(ptr!=ptr_end)
					{
						if(ptr->init_pos>pos_max_other)
							return count;

						first_val=ptr->init_pos;						
						last_pos=ptr->len-((ptr-1)->len);											
					}
					//attenzione-->aggiunto
					else break;
		}			
		return count;
	}

	int bitmap_rec::find_word(bitmap_rec* b, int val, int first, int last)
	{
		int index, init_pos, len, len_prec, lenght;

		for(;;)
		{
			index=first + ceil((float)((last-first)/2.0));			
			init_pos=b->fill_word[index].init_pos;
			len=b->fill_word[index].len;		
							
			if(val >= init_pos)
			{						
				if(index==0){
					len_prec = 0;
					lenght = len;
				}
				else{				
					len_prec = b->fill_word[index-1].len;
					lenght = len - len_prec;	
				}		
								
				//L'elemento  contenuto nell'array compresso
				//ci significa che  literal e torna l'offset
				if(val<init_pos+lenght)	{			
					index_global=index;					
					return (val-init_pos+len_prec);		
				}
				//[0, 5] [10, 10] [25, 12]  --> 25  in pos = 25-25+10=10 mentre 26 --> 26-25+10=11				
								
				//L'elemento si trova in un range fatto di zeri a destra di index
				if(index!=b->fill_word.size()-1)
				{
					if(val>=init_pos + lenght && val<b->fill_word[index+1].init_pos)
					{						
						index_global=index;
						return -1;
					}
					else{	
						if(first>=last) 
						{							
							index_global=0; 
							return -1;							
						}
						first=index+1;	
						continue;						
					}
				}							
			}
			else
			//val < di init_pos
			{
				if (index==0)	{
					index_global=index;
					return -1;
				}

				if(index==1) 
					lenght=b->fill_word[index-1].len;
				else
					lenght=b->fill_word[index-1].len - b->fill_word[index-2].len;	
							
				if(val>=b->fill_word[index-1].init_pos + lenght)
				{						
					index_global=index-1;
					return -1;		
				}
				else					
				{
					if(index==first) 
					{						
						first=0;
						last=index;
						continue;
					}
					
					last=index-1;	
					continue;
				}	
			}	
		}//for		
	}	

	int bitmap_rec::make_and_two_without_mem_and_F1_sorted(bitmap_rec* b)
	{		
		int init_pos, len, lenght, ret=0, count=0, init, minimo=0;
		int min_tmp_bitmap=min(this->get_tmp_bitmap(),b->get_tmp_bitmap());
		
		  vector<data_comp>::iterator p1=this->fill_word.begin();	
		int len_prec, initial_pos, end_pos, d, mini, maxi;	
		unsigned tmp_bitmap;
		bool flag=0;
		unsigned char * p;

		init_pos=p1->init_pos;
		len=p1->len;			

		d=b->init_index;	
		initial_pos=b->fill_word[d].init_pos;

		if((init_pos>end_pos && d>b->fill_word.size()-1) || (init_pos>min_tmp_bitmap))
			return count;

		if(d==0)
		{
				len_prec=0;
				end_pos=b->fill_word[0].init_pos + b->fill_word[0].len - 1;
		}
		else
		{
				len_prec=b->fill_word[d-1].len;
				end_pos=b->fill_word[d].init_pos + (b->fill_word[d].len - len_prec) - 1;
		}	
	

		if(init_pos<initial_pos && d!=0)
		{
				
				while(init_pos<initial_pos && d>0)
				{
					
					d--;
					initial_pos=b->fill_word[d].init_pos;					
				}
				

				b->init_index=d;
				if(d==0)
				{
					len_prec=0;
					end_pos=initial_pos + b->fill_word[0].len - 1;
				}
				else
				{
					len_prec=b->fill_word[d-1].len;
					end_pos=initial_pos + (b->fill_word[d].len - len_prec) - 1;
				}
		}
		
		while(init_pos>end_pos)
		{			
			b->init_index++;
			end_pos=b->fill_word[b->init_index].init_pos + (b->fill_word[b->init_index].len - b->fill_word[b->init_index-1].len) -1;
			flag=1;
		}

		if(flag)
		{
				d=b->init_index;			
				initial_pos=b->fill_word[d].init_pos;
				len_prec=b->fill_word[d-1].len;
		}												

		mini=min(init_pos+len-1,end_pos);
		maxi=max(init_pos,initial_pos);

		for(int y=maxi; y<=mini; y++)
		{								
			if(y>init_pos && y<init_pos+len-1 && p1->type_fill==1)
			{
				if(y>initial_pos && y<end_pos && b->fill_word[d].type_fill==1)
				{								
					count+=WORD_LEN;
					continue;
				}
				else tmp_bitmap=b->bit_rec[y-initial_pos+len_prec];
				
			}			
			else tmp_bitmap=b->bit_rec[y-initial_pos+len_prec] & this->bit_rec[y-init_pos];				

				if(tmp_bitmap)
				{
					 p = (unsigned char *) & tmp_bitmap;
					 for(int i=0; i<4; i++, p++)
						count += CountTable[*p];					 					 		
				}			
		}

		for(;;)
		{
			if(d<b->fill_word.size()-1 && init_pos+len-1>=b->fill_word[d+1].init_pos)
			{
				b->init_index++;
				d=b->init_index;			
				initial_pos=b->fill_word[d].init_pos;
				len_prec=b->fill_word[d-1].len;
				end_pos=b->fill_word[d].init_pos + (b->fill_word[d].len - b->fill_word[d-1].len) -1;

				mini=min(init_pos+len-1,end_pos);
				maxi=max(init_pos,initial_pos);

				for(int y=maxi; y<=mini; y++)
				{	
					if(y>init_pos && y<init_pos+len-1 && p1->type_fill==1)
						tmp_bitmap=b->bit_rec[y-initial_pos+len_prec];															
					else tmp_bitmap=b->bit_rec[y-initial_pos+len_prec] & this->bit_rec[y-init_pos];			
						
						if(tmp_bitmap)
						{
							
							 p = (unsigned char *) & tmp_bitmap;
							 for(int i=0; i<4; i++, p++)
								count += CountTable[*p];	
							
							
						}
					
				}
				continue;				
			}
			else return count;
		}		
		//return count;			
	}//end

	int bitSign(int val, int bitmap, int pos)
	{
		int ret_val=bitmap*WORD_LEN+pos;
		if(val==1) return ret_val;
		if(val==2 || val==3) return ret_val+1;
		if(val>=4 && val<8) return ret_val+2;
		if(val>=8 && val<16) return ret_val+3;
		if(val>=16 && val<32) return ret_val+4;
		if(val>=32 && val<64) return ret_val+5;
		if(val>=64 && val<128) return ret_val+6;
		if(val>=128 && val<256) return ret_val+7;
	}

	void bitmap_rec::make_and_two_with_mem_and_F1_sorted(bitmap_rec* a,bitmap_rec* b, int val_dim)
	{		
		int init_pos, len, lenght, ret=0, count=0, init, minimo=0;
		int min_tmp_bitmap = min(a->get_tmp_bitmap(),b->get_tmp_bitmap());
		
		  vector<data_comp>::iterator p1 = a->fill_word.begin();	
		int len_prec, initial_pos, end_pos, d, mini, maxi, tmp_com;	
		unsigned tmp_bitmap;
		bool flag=0;
		unsigned char *p;

		this->set_num_words(2);
		this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*2);
		memset(this->bit_rec,(unsigned)0,sizeof(unsigned)*2);					
		this->set_word_com(0);		

		n_uple_val[val_dim].mapSec.clear();
		n_uple_val[val_dim].cont_val=0;	
		
		init_pos=p1->init_pos;
		len=p1->len;	
		
		d=b->init_index;	
		initial_pos=b->fill_word[d].init_pos;

		if(d==0)
		{
				len_prec=0;
				end_pos=b->fill_word[0].init_pos + b->fill_word[0].len - 1;
		}
		else
		{
				len_prec=b->fill_word[d-1].len;
				end_pos=b->fill_word[d].init_pos + (b->fill_word[d].len - len_prec) - 1;
		}
		if((init_pos>end_pos && d>b->fill_word.size()-1) || (init_pos>min_tmp_bitmap))
			return;

		if(init_pos<initial_pos && d!=0)
		{
				
				while(init_pos<initial_pos && d>0)
				{					
					d--;
					initial_pos=b->fill_word[d].init_pos;					
				}				

				b->init_index=d;
				if(d==0)
				{
					len_prec=0;
					end_pos=initial_pos + b->fill_word[0].len - 1;
				}
				else
				{
					len_prec=b->fill_word[d-1].len;
					end_pos=initial_pos + (b->fill_word[d].len - len_prec) - 1;
				}
		}
				
		while(init_pos>end_pos)
		{			
			b->init_index++;
			end_pos=b->fill_word[b->init_index].init_pos + 
				(b->fill_word[b->init_index].len - b->fill_word[b->init_index-1].len) -1;
			flag=1;
		}			

		if(flag)
		{
			d=b->init_index;			
			initial_pos=b->fill_word[d].init_pos;
			len_prec=b->fill_word[d-1].len;
		}							
						
		mini=min(init_pos+len-1,end_pos);
		maxi=max(init_pos,initial_pos);

		for(int y=maxi; y<=mini; y++)
		{			
			if(y>init_pos && y<init_pos+len-1 && p1->type_fill==1){
				tmp_bitmap=b->bit_rec[y-initial_pos+len_prec];				
			}			
			else tmp_bitmap=b->bit_rec[y-initial_pos+len_prec] & a->bit_rec[y-init_pos];	
								
			if(tmp_bitmap)
			{
						tmp_com=this->get_word_com();
						if(tmp_com>=this->get_num_words())
						{										
							this->set_num_words(tmp_com*2);
							this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*this->get_num_words());																				
																						
						}
						this->bit_rec[tmp_com]= tmp_bitmap;		

						 p = (unsigned char *) & tmp_bitmap;
						 for(int i=0; i<=24; i+=8, p++)
						 {
							 if(*p!=0)
							 {
								 n_uple_val[val_dim].cont_val += CountTable[*p];
								 n_uple_val[val_dim].record=bitSign(*p,y,i);
							}							
						}
						 
						n_uple_val[val_dim].mapSec.push_back(y);																	
						this->inc_word_com();			
			}				
		}		
		for(;;)
		{
			if(d<b->fill_word.size()-1 && init_pos+len-1>=b->fill_word[d+1].init_pos)
			{				
				b->init_index++;
				d=b->init_index;			
				initial_pos=b->fill_word[d].init_pos;
				len_prec=b->fill_word[d-1].len;
				end_pos=b->fill_word[d].init_pos + (b->fill_word[d].len - b->fill_word[d-1].len) -1;

				mini=min(init_pos+len-1,end_pos);
				maxi=max(init_pos,initial_pos);				

				for(int y=maxi; y<=mini; y++)
				{	
					if(y>init_pos && y<init_pos+len-1 && p1->type_fill==1){
						tmp_bitmap=b->bit_rec[y-initial_pos+len_prec];				
				}				
				else tmp_bitmap = b->bit_rec[y-initial_pos+len_prec] & a->bit_rec[y-init_pos];

				if(tmp_bitmap)
				{
						tmp_com=this->get_word_com();
						if(tmp_com>=this->get_num_words())
						{							
							this->set_num_words(tmp_com*2);
							this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*this->get_num_words());
						}
						this->bit_rec[tmp_com]=tmp_bitmap;	

						p = (unsigned char *) & tmp_bitmap;						 
						for(int i=0; i<=24; i+=8, p++)
						 {
							 if(*p!=0)
							 {
								 n_uple_val[val_dim].cont_val += CountTable[*p];
								 n_uple_val[val_dim].record=bitSign(*p,y,i);
							}							
						}
						 								
						n_uple_val[val_dim].mapSec.push_back(y);																	
						this->inc_word_com();			
					}											
				}
				continue;				
			}
			else return;
		}		
			
	}//end

	int bitmap_rec::make_and_two_without_mem_and_F1(bitmap_rec* b)
	{		
		bitmap_rec *tmp, *tmp_other;		
		tmp=this->fill_word.size()<b->fill_word.size()?this:b;
		tmp_other=this->fill_word.size()>=b->fill_word.size()?this:b;
		unsigned char* p;

		int init_pos, len, lenght, ret=0, count=0, init, minimo=0;
		int min_tmp_bitmap=min(this->get_tmp_bitmap(),b->get_tmp_bitmap());
		unsigned tmp_bitmap;		
		
		  vector<data_comp>::iterator p1=tmp->fill_word.begin();		
		
		int d=index_global=0;				
		int init1, len2, len_prec;				

		init_pos=p1->init_pos;
		len=p1->len;		
		
		
		for(;p1!=tmp->fill_word.end();)
		{
				/* Si fa una sola ricerca binaria per intervallo e poi la scansione del vettore */
				init=init_pos;						

				//lenght  la lunghezza da sottrarre per il range corrente
				if(init_pos==tmp->fill_word[0].init_pos)
					lenght=0;
				else
					lenght=(p1-1)->len;
				
				if(init>min_tmp_bitmap) return count;
				minimo=min(tmp_other->fill_word.size()-1,ceil((float)(init/2.0)));	
				ret=find_word(tmp_other,init,d,minimo);					
													
				if(ret!=-1)
				{							
					tmp_bitmap = tmp->bit_rec[(init-init_pos)+lenght] & tmp_other->bit_rec[ret]; 						
					 
					/* Se il risultato  diverso da zero, cio ci sono
					 * bit 1 all'interno della word considerata,
					 * e il num di dimensioni  superiore a 3,
					 * allora salvo l'informazione sulla struttura
					 * globale che contiene le aggregazioni a livelli.
					*/								
					 p = (unsigned char *) & tmp_bitmap;
					 for(int i=0; i<4; i++, p++)
						count += CountTable[*p];						 
				}//ret

				init++;					
				while(init<init_pos+len)
				{	
						if(init>min_tmp_bitmap) return count;						
						init1=tmp_other->fill_word[index_global].init_pos;
												
						if(index_global==0){
							len_prec=0;
							len2=tmp_other->fill_word[0].len;
						}
						else{
							len_prec=tmp_other->fill_word[index_global-1].len;
							len2=tmp_other->fill_word[index_global].len - len_prec;
						}	
						
						if(init<init1){
							init++;
							continue;
						}

						//init  una word literal
						else if(init>=init1 && init<init1+len2)
						{																	
							if(p1->type_fill==1 && init<init_pos+len-1)													
								 tmp_bitmap = tmp_other->bit_rec[init-init1+len_prec]; 																					
							
							else tmp_bitmap = tmp->bit_rec[(init-init_pos)+lenght] & 
								tmp_other->bit_rec[init-init1+len_prec]; 							

							 p = (unsigned char *) & tmp_bitmap;
							 for(int i=0; i<4; i++, p++)
								count += CountTable[*p];								

							 init++;
							 continue;
						}
						//se  nell'intervallo a destra fatto di zeri
						else if(init>=init1+len2)							
						{	
							//non ci sono pi range di 1, sono tutti zeri
							if(tmp_other->fill_word.size()-1<index_global+1)							
								return count;
							else
							{
								if(init<tmp_other->fill_word[index_global+1].init_pos)
								{
									//la word non  literal, si controllano le word che rimangono									
									init++;									
								}
								else if(init>=tmp_other->fill_word[index_global+1].init_pos)
								{
									//la word potrebbe essere literal e appartenere al successivo range
									index_global++;									
								}
								continue;
							}							
						}						
						//altrimenti si va avanti con init						
						else init++;						
					}//while
					
					d=index_global;								
					p1++;
					if(p1!=tmp->fill_word.end())
					{
						init_pos=p1->init_pos;
						len=p1->len - (p1-1)->len;
					}
		}	
		return count;
}

	void bitmap_rec::make_and_two_with_mem_and_F1(bitmap_rec* a, bitmap_rec* b, int val_dim)
	{		
		bitmap_rec *tmp, *tmp_other;		
		tmp=a->fill_word.size()<b->fill_word.size()?a:b;
		tmp_other=a->fill_word.size()>=b->fill_word.size()?a:b;
		int init_pos, len, lenght, ret=0, count=0, init, minimo;
		int min_tmp_bitmap=min(a->get_tmp_bitmap(),b->get_tmp_bitmap());
		unsigned tmp_bitmap;

		this->set_num_words(2);
		this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*2);
		memset(this->bit_rec,(unsigned)0,sizeof(unsigned)*2);

		//memset(this->bit_rec,(unsigned)0,sizeof(unsigned)*this->get_num_words());
		this->set_word_com(0);		

		n_uple_val[val_dim].mapSec.clear();
		n_uple_val[val_dim].cont_val=0;		

		  vector<data_comp>::iterator p1=tmp->fill_word.begin();		
		init_pos=p1->init_pos;
		len=p1->len;	

		int d=index_global=0;	
		int init1, len2, len_prec;
		
		for(;p1!=tmp->fill_word.end();)
		{
				/* Si fa una sola ricerca binaria per intervallo e poi la scansione del vettore */
				init=init_pos;						

				//lenght  la lunghezza da sottrarre per il range corrente
				if(init_pos==tmp->fill_word[0].init_pos)
					lenght=0;
				else
					lenght=(p1-1)->len;
					
				if(init>min_tmp_bitmap) return;
				minimo=min(tmp_other->fill_word.size()-1,ceil((float)(init/2.0)));	
				ret=find_word(tmp_other,init,d,minimo);	
										
				if(ret!=-1)
				{					
					tmp_bitmap = tmp->bit_rec[(init-init_pos)+lenght] & tmp_other->bit_rec[ret]; 																								

					if(tmp_bitmap)
					{
						if(this->get_word_com()>=this->get_num_words())
						{							
							//this->set_num_words(this->get_num_words()+1);
							this->set_num_words(this->get_word_com()*2);
							this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*this->get_num_words());
						}
						this->bit_rec[this->get_word_com()]=tmp_bitmap;															
						for(int g=0; g<WORD_LEN; g++)
						{
							if(tmp_bitmap & mask[g])
							{ 							
								n_uple_val[val_dim].cont_val++;
								n_uple_val[val_dim].record=init*WORD_LEN+g;
							}
						}
						n_uple_val[val_dim].mapSec.push_back(init);																	
						this->inc_word_com();			
					}	
					//Dopo aver trovato il primo elemento con la ricerca binaria,
					//si continua con una scansione lineare del vettore
					//fino a coprire tutto il range.
				}

					init++;					
					while(init<init_pos+len)
					{						
						if(init>min_tmp_bitmap) return;						
						init1=tmp_other->fill_word[index_global].init_pos;
												
						if(index_global==0){
							len_prec=0;
							len2=tmp_other->fill_word[0].len;
						}
						else{
							len_prec=tmp_other->fill_word[index_global-1].len;
							len2=tmp_other->fill_word[index_global].len - len_prec;
						}		

						if(init<init1)
						{
							init++;
							continue;
						}
						//init  una word literal
						if(init>=init1 && init<init1+len2)
						{							
							tmp_bitmap = tmp->bit_rec[(init-init_pos)+lenght] & 
								tmp_other->bit_rec[init-init1+len_prec]; 

							if(tmp_bitmap)
							{
								if(this->get_word_com()>=this->get_num_words())
								{							
									this->set_num_words(this->get_word_com()*2);
									this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*this->get_num_words());
								}
								this->bit_rec[this->get_word_com()]=tmp_bitmap;															
								for(int g=0; g<WORD_LEN; g++)
								{
									if(tmp_bitmap & mask[g])
									{ 							
										n_uple_val[val_dim].cont_val++;
										n_uple_val[val_dim].record=init*WORD_LEN+g;
									}
								}
								n_uple_val[val_dim].mapSec.push_back(init);																	
								this->inc_word_com();			
							}	
							init++;
							continue;
						}
						//se  nell'intervallo a destra fatto di zeri
						else if(init>=init1+len2)							
						{	
							//non ci sono pi range di 1, sono tutti zeri
							if(tmp_other->fill_word.size()-1<index_global+1)							
								return;
							else
							{
								if(init<tmp_other->fill_word[index_global+1].init_pos)
								{
									//la word non  literal, si controllano le word che rimangono									
									init++;									
								}
								else if(init>=tmp_other->fill_word[index_global+1].init_pos)
								{
									//la word potrebbe essere literal e appartenere al successivo range
									index_global++;									
								}
								continue;
							}							
						}						
						//altrimenti si va avanti con init						
						else init++;						
					}//while
					
					d=index_global;								
					p1++;
					if(p1!=tmp->fill_word.end())
					{
						init_pos=p1->init_pos;
						len=p1->len - (p1-1)->len;
					}
		}		
}


	/* Effettua AND su word compresse non considerando
	 * compressione su Fill 1. TODO --> Compressione Fill 1
	*/								
	int bitmap_rec::make_and_two_without_mem_and_F0(bitmap_rec* b)
	{
		int count=0;
		
		/* Richiama procedura che effettua AND tra le prime bitmap
		 * che precedono i primi intervalli di compressione 
		*/
		count=this->init_and(b);		

		/* Esci se erano 0 entrambi */
		if(this->fill_word.size()==0 && b->fill_word.size()==0) 			
			return count;	
					
		/******************************
		 *							  *
		 * Prima parte: MERGE delle   *
		 * liste che contengono range *
		 * di word compresse.		  *
		 *                            *
		 ******************************/
						
		/* CASO 1. Uno dei due vettori  vuoto. 
		 * Non possono esserlo entrambi altrimenti
		 * uscirebbe prima dalla procedura.
		*/
		if (this->fill_word.size()==0 || b->fill_word.size()==0){
			count+=this->one_bitmap_empty(b);			
			return count;
		}

		
		/* CASO 2. I due vettori contengono elementi ed
		 *  necessario effettuare un merging.		
		 * Merge: lista in cui viene effettuato il merge delle liste			 
		 * che conterr la lista di word compresse della bitmap
		 * e le sue caratteristiche.
		*/
		vector<data_comp> merge;			

		/* Nel caso peggiore, in cui le liste sono disgiunte,
		 * la dimensione della lista  la somma delle 
		 * dimensioni delle liste di partenza.
		*/
		merge.reserve(this->fill_word.size()+b->fill_word.size());		

	    /* Vettori delle posizioni delle word compresse
		 * sia per la prima che per la seconda word,
		 * utili per effettuare velocemente gli AND tra le
		 * word Literal.
		*/
		vector<int> pos_word_com1, pos_word_com2;	
		pos_word_com1.reserve(this->fill_word.size());
		pos_word_com2.reserve(b->fill_word.size());

		/* Indicano i segnaposto per effettuare AND sfalsati,
		 * considerata la compressione delle word.
		*/
		int sum_len1=0, sum_len2=0, min_tmp_bitmap=0;

		if(this->fill_word.size()!=0 && b->fill_word.size()!=0)
		{					
			min_tmp_bitmap=min(this->get_tmp_bitmap(), b->get_tmp_bitmap());							
			vector<data_comp>::iterator p1, p2;	
			p1=this->fill_word.begin();
			p2=b->fill_word.begin();
			data_comp elem;			
			
			/* Gestisco il primo range compresso */
			for(;p1!=this->fill_word.end() || p2!=b->fill_word.end();)
			{	
				/* All'inizio inserisce il primo elemento 
				 * nel vettore la cui init_pos  pi piccola.				
				*/				
				if(merge.empty())
				{					
					if(p1->init_pos<p2->init_pos)
					{				
						elem.init_pos=p1->init_pos;
						elem.len=p1->len;						
						//Aggiorno i riferimenti a merge 
						pos_word_com1.push_back(elem.len);
						pos_word_com2.push_back(0);
						//Inserisco il primo elemento 
						merge.push_back(elem);
						p1++;						
					}
					else if(p1->init_pos>p2->init_pos)
					{
						elem.init_pos=p2->init_pos;
						elem.len=p2->len;						
						pos_word_com1.push_back(0);
						pos_word_com2.push_back(elem.len);
						merge.push_back(elem);
						p2++;				
					}
					else if(p1->init_pos==p2->init_pos)
					{
						/* A parit di init_pos, controlla anche la lunghezza
						 * e inserisce per primo il range che ha len maggiore.
						*/
						if(p1->len>=p2->len)
						{						
							elem.init_pos=p1->init_pos;
							elem.len=p1->len;
							//Aggiorno i riferimenti
							pos_word_com1.push_back(elem.len);
							pos_word_com2.push_back(p2->len);													
						}
						else
						{
							elem.init_pos=p2->init_pos;
							elem.len=p2->len;								
							pos_word_com1.push_back(p1->len);
							pos_word_com2.push_back(elem.len);															
						}					
						merge.push_back(elem);
						p1++;
						p2++;						
					}
										
				}				

				/* Il vettore merge contiene gi qualcosa.
				 * Controlla se le liste sono entrambe non vuote.
				*/
				if(p1!=this->fill_word.end() && p2!=b->fill_word.end())
				{			  
					/* Preleva range della bitmap 
					 * con pos_init pi piccola 
					 * dal vettore fill_word 
					*/					
					int tmp_val,len1,len2,l1n;
					int flag=p1->init_pos < p2->init_pos? 1: 0;
					int min_pos=p1->init_pos < p2->init_pos? p1->init_pos:p2->init_pos;

					if(p1->init_pos!=this->fill_word[0].init_pos)
						len1=p1->len-((p1-1)->len);
					else
						len1=p1->len;

					if(p2->init_pos!=b->fill_word[0].init_pos)
						len2=p2->len-((p2-1)->len);
					else
						len2=p2->len;

					int len=p1->init_pos < p2->init_pos? len1:len2;						
									
					if(min_pos<=min_tmp_bitmap)
					{
						
						/* Controlla se  possibile un merge, cio se l'intervallo si incontra col precedente. */						
						int merge_val = merge[merge.size()-1].init_pos + merge[merge.size()-1].len;	

						/* Gli intervalli si intersecano */
						if(min_pos <= merge_val)
						{		
								/*Gli intervalli si intersecano in parte: merge degli intervalli */
								if((min_pos + len)-1>=merge_val)
								{
									//merge[merge.size()-1].len+=(min_pos+(*p1).len-1)-merge_val;								
									tmp_val=len-(merge_val-(min_pos));
									if(tmp_val>0)
										merge[merge.size()-1].len+=tmp_val;
								}																
								if(flag)
									pos_word_com1[pos_word_com1.size()-1]+=len;																	
								else 	
									pos_word_com2[pos_word_com2.size()-1]+=len;											
						}
						/* Gli intervalli sono disgiunti */
						else
						{									
							/* Inserisce l'intervallo.
							 * Aggiorna i vettori di posizione delle word compresse,							 
							*/								
							elem.init_pos=min_pos;
							elem.len=len;												
							merge.push_back(elem);

							int prec1=pos_word_com1[pos_word_com1.size()-1];
							int prec2=pos_word_com2[pos_word_com2.size()-1];

							if(flag){																														
								pos_word_com1.push_back(prec1+len);
								pos_word_com2.push_back(prec2);
							}
							else{																														
								pos_word_com2.push_back(prec2+len);
								pos_word_com1.push_back(prec1);
							}																																																																	
						}//else

						// Incrementa i contatori p1/p2
						if(flag)						
							p1++;							
						else 							
							p2++; 						
					}//if	
					else break;
					continue;
				}//if				

				/* Gestisce il caso in cui un vettore si  svuotato, cio gli intervalli compressi sono finiti. */
				else if(p1==this->fill_word.end() || p2==b->fill_word.end())
				{						
						//se sono vuoti entrambi, vai direttamente alla fase 2
						if(p1==this->fill_word.end() && p2==b->fill_word.end())
							goto exit_2;

						min_tmp_bitmap=min(this->get_tmp_bitmap(),b->get_tmp_bitmap());						
						
						bool flag;
						data_comp elem;
						int lenght, init_pos1, last, d, last_elem_other, minimo;
						 vector<data_comp>::iterator p_tmp2;																	
																						
						if(p1!=this->fill_word.end())
						{
							flag=1;														
							p_tmp2=this->fill_word.begin();
							init_pos1=this->fill_word[0].init_pos;		
							last=this->fill_word[this->fill_word.size()-1].init_pos;
							 
							if(b->fill_word.size()==1)
								last_elem_other=b->fill_word[0].len + b->fill_word[0].init_pos;
							else
							{
								int lun = b->fill_word[b->fill_word.size()-1].len - b->fill_word[b->fill_word.size()-2].len;
								last_elem_other = b->fill_word[b->fill_word.size()-1].init_pos + lun;
							}
							minimo=min(ceil((float)last_elem_other/2)+1,this->fill_word.size()-1);
							d=find_index(this,last_elem_other,0,minimo);																											
						}
						else
						{						
							flag=0;															
							init_pos1=b->fill_word[0].init_pos;	
							last=b->fill_word[b->fill_word.size()-1].init_pos;
							p_tmp2=b->fill_word.begin();
							
							if(this->fill_word.size()==1)
								last_elem_other=this->fill_word[0].len + this->fill_word[0].init_pos;
							else
							{
								int lun = this->fill_word[this->fill_word.size()-1].len - this->fill_word[this->fill_word.size()-2].len;
								last_elem_other = this->fill_word[this->fill_word.size()-1].init_pos + lun;
							}
							minimo=min(ceil((float)last_elem_other/2)+1,b->fill_word.size()-1);
							d=find_index(b,last_elem_other,0,minimo);														
						}	

						int merge_val = merge[merge.size()-1].init_pos+merge[merge.size()-1].len;							
						p_tmp2=p_tmp2+d;						
						
						if(p_tmp2->init_pos!=init_pos1)
								lenght=p_tmp2->len-((p_tmp2-1)->len);
							else 
								lenght=p_tmp2->len;							

						/* Scorre p_tmp finch non si trova un range valido da inserire. */									
						while(p_tmp2->init_pos<=min_tmp_bitmap)
						{																	
							/* L'intervallo precede il merge_val */														
							if(p_tmp2->init_pos<=merge_val)
							{
								/* L'intervallo si interseca ed esce a destra : merging */
								if(p_tmp2->init_pos+lenght-1>=merge_val)
								{
									int val_merge=lenght-(merge_val-p_tmp2->init_pos);									
									/* Effettua Merge */									
									merge[merge.size()-1].len+=val_merge;  /* --> [][] intervalli contigui unificati [  ] */									
								}	

								/* Bisogna aggiornare i riferimenti. Non ai aggiunge un intervallo nuovo, 
								 * ma si cambiano le dim di quello esistente.
								*/
								if(flag)
									pos_word_com1[pos_word_com1.size()-1]=p_tmp2->len;																										
								else
									pos_word_com2[pos_word_com2.size()-1]=p_tmp2->len;
							}		
							else /* Gli intervalli sono disgiunti */
							{																						 														
								elem.init_pos=p_tmp2->init_pos;
								elem.len=lenght;												
								merge.push_back(elem);

								int prec1=pos_word_com1[pos_word_com1.size()-1];
								int prec2=pos_word_com2[pos_word_com2.size()-1];

								if(flag)
								{																														
									pos_word_com1.push_back(p_tmp2->len);
									pos_word_com2.push_back(prec2);
								}
								else
								{																														
									pos_word_com2.push_back(p_tmp2->len);
									pos_word_com1.push_back(prec1);
								}				
							}//else

							if(p_tmp2->init_pos==last)
								goto exit_2;
							else p_tmp2++;																							
							lenght = p_tmp2->len - ((p_tmp2-1)->len);								
															
						}//while
						goto exit_2;														
					}//else				
			}//for			
		}//if
	

		/***************************************
		 *							           *
		 * Seconda parte: SCANSIONE della      *
		 * della lista trovata che contiene    *
		 * l'intersezione dei range	compressi. *	
		 *							           *
		 ***************************************/

		/* Scorre la lista per controllare i range 
		 * su cui effettuare gli AND tra literal.
		*/
		

		/* Nel caso in cui la lista di merge sia vuota
		 * cio quando si ha una lista di literal e 
		 * poi molte word 0 finali e quindi l'intervallo
		 * compresso non viene registrato nella lista
		*/
exit_2:	if(merge.size()!=0)
		{							
			
			/* Scorre il primo vettore e ne prende i valori */			
			  vector<data_comp>::iterator ptr=merge.begin();			
			  vector<int>::iterator t1 = pos_word_com1.begin();
			  vector<int>::iterator t2 = pos_word_com2.begin();			

			int first_val, last_pos; 		
			int num_word_and, val_init;			

			/* Conserva le info sul primo range
			 * del vettore su cui effettuare il confronto
			*/
			first_val=ptr->init_pos;
			last_pos=ptr->len-1;			

			for(; ptr!=merge.end(); )
			{							
				/* Incrementa il contatore per effettuare
				 * il confronto con il secondo range e 
				 * calcolare il numero di word literal da 
				 * 'intersecare'.
				*/	
				ptr++;					
                
				/* Effettua And su word literal 
				 * rimanenti, se si  giunti alla 
				 * fine della lista. Altrimenti,
				 * calcola la distanza in word dal 
				 * secondo range.
				*/
				val_init=first_val+last_pos+1;				
				unsigned tmp;				
		
				if(ptr==merge.end())
					num_word_and=(min_tmp_bitmap)-(first_val+last_pos);										
				else
				{							
					num_word_and = (ptr->init_pos-1)-(first_val+last_pos);	
					first_val = ptr->init_pos;
					last_pos = ptr->len-1;					
				}				
							
				/* Effettua l'AND tra le word literal comprese
				 * tra un intervallo compresso e il successivo.
				*/	
				int initt=val_init;											
				for(int i=initt-(*t1), j=initt-(*t2), y=0; y<num_word_and; i++, j++, y++,initt++)
				{					
					tmp = this->bit_rec[i] & b->bit_rec[j]; 															
					
					/* Se il risultato  diverso da zero, cio ci sono
					 * bit 1 all'interno della word considerata,
					 * e il num i dimensioni  superiore a 3,
					 * allora salvo l'informazione sulla struttura
					 * globale che contiene le aggregazioni a livelli.
					*/				
					for(int g=0; g<WORD_LEN; g++)
						if(tmp & mask[g]) 							
							count++;										
				}

				/* Incrementa i ptr a word compresse
				 * che punteranno all'intervallo corrente. 
				*/			
				t1++;			
				t2++;									
			}//for
		}//if		
		merge.clear();		
		pos_word_com1.clear();
		pos_word_com2.clear();		

		/* TODO: Se il num di dimensioni  superiore a 3, si memorizzano
		   sull'header globale il merge e le rispettive posizioni */

		/* Restituisce il numero di bit 1 dell'And tra le bitmap */		
		return count;
		
	}//end procedura

	int bitmap_rec::binary_search(bitmap_rec* b, int val, int first, int last)
	{			
		
		int index=first + ceil((float)((last-first)/2.0));		
		int init_pos=b->fill_word[index].init_pos;
		int len=b->fill_word[index].len;

		if(index==0)
		{
			if(val<init_pos)
					return val;
			else 
				//val  >= di init_pos ed minore di len-->compresso nell'intervallo di indice 0
				if( val<init_pos+len)
					return -1;
				else 
					//val  >= init_pos+len ma minore della succ init_pos -->non compresso nell'intervallo
					//compreso tra l'indice 0 e l'indice 1					
					if(b->fill_word.size()==1) 
						return (val-len);

					if(val<b->fill_word[index+1].init_pos)
						return (val-len);
					else
						//val  >= della successiva init_pos ma minore della successiva len-->compresso 
						//nell'intervallo di indice 1
						if(val<b->fill_word[index+1].init_pos+(b->fill_word[index+1].len-len))
							return -1;
		}
		
		if(index==b->fill_word.size()-1)
		{
			if(val>=init_pos+(len-b->fill_word[index-1].len))
				return (val-len);
			else
				//val < = di init_pos+(len-b->fill_word[index-1].len)
				if(val>=init_pos)
					return -1;
				else if(val<init_pos && val>= b->fill_word[index-1].init_pos+(b->fill_word[index-1].len - len))
					//non compresso
					return (val - b->fill_word[index-1].len);
		}		

		int lenght;				
		if(val>=init_pos)
		{			
			lenght=len - b->fill_word[index-1].len;					
				
			//L'elemento  contenuto nell'array compresso
			if(val<init_pos+lenght)				
				return -1;
			

			//L'elemento si trova in un range non compresso a destra di index
			if(val>=init_pos + lenght && val<b->fill_word[index+1].init_pos)
			{
				
				return (val-len);	
				
			}
			else			
				binary_search(b,val,index+1,last);	
		}
		else
		//val < di init_pos
		{
			if(index==1) 
				lenght=b->fill_word[index-1].len;
			else
				lenght=b->fill_word[index-1].len - b->fill_word[index-2].len;			
			
			if(val>=b->fill_word[index-1].init_pos + lenght)
				//valore non compresso che sta nel range a sinistra
				return (val-b->fill_word[index-1].len);			
			else					
				binary_search(b,val,first,index-1);				
		}	
		//return -1;
	}

	/* Effettua AND su word compresse non considerando
	 * compressione su Fill 1. TODO --> Compressione Fill 1
	*/								
	void bitmap_rec::make_and_two_with_mem_and_F0(bitmap_rec* a, bitmap_rec* b, int index, int val_dim)
	{		
	
		/* Scorre il primo vettore e ne prende i valori */
		  vector<data_comp>::iterator p1=a->fill_word.begin();
		  vector<data_comp>::iterator p2=b->fill_word.begin();			

		n_uple_val[val_dim].mapSec.clear();
		n_uple_val[val_dim].cont_val=0;
		
		
		memset(this->bit_rec,(unsigned)0,sizeof(unsigned)*this->get_num_words());
		this->set_word_com(0);

		/* Da dove si inizia e si finisce (come posizioni globali)
		 * per l'AND tra le word literal
		*/
		int count=0, min_pos;		
		
		if(a->fill_word.size()!=0 && b->fill_word.size()!=0)		
			min_pos = min(p1->init_pos,p2->init_pos);	
		else
		/* Sono tutti Literal */
		if(a->fill_word.size()==0 && b->fill_word.size()==0)			
			min_pos=min(a->get_word_com(),b->get_word_com())+1;	
		/* Misti */						
		else if(a->fill_word.size()==0 && b->fill_word.size()!=0)
			min_pos=min(a->get_word_com()+1,p2->init_pos);		
		else							
			min_pos=min(b->get_word_com()+1,p1->init_pos);
		
		/* Gestisco AND all'esterno del vettore 
		/* Effettuo AND sulle due bitmap da 
		 * init1_com e init2_com a min_pos.
		*/		
		unsigned tmp;
		for(int h=0; h<min_pos; h++)
		{
			tmp = a->bit_rec[h] & b->bit_rec[h];
			if(tmp)
			{
						if(this->get_word_com()>=this->get_num_words())
						{
							
							this->set_num_words(this->get_num_words()+1);
							this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*this->get_num_words());
						}
						this->bit_rec[this->get_word_com()]=tmp;				
						

						for(int g=0; g<WORD_LEN; g++)
						{
							if(tmp & mask[g])
							{ 							
								n_uple_val[val_dim].cont_val++;
								n_uple_val[val_dim].record=h*WORD_LEN+g;
							}
						}
						n_uple_val[val_dim].mapSec.push_back(h);																	
						this->inc_word_com();			
			}			
		}

		/* Esci se erano 0 entrambi */
		if(a->fill_word.size()==0 && b->fill_word.size()==0) {
			
			return;					
		}
			
		/******************************
		 *							  *
		 * Prima parte: MERGE delle   *
		 * liste che contengono range *
		 * di word compresse.		  *
		 *                            *
		 ******************************/
						
		/* CASO 1. Uno dei due vettori  vuoto. 
		 * Non possono esserlo entrambi altrimenti
		 * uscirebbe prima dalla procedura.
		*/
		if (a->fill_word.size()==0 || b->fill_word.size()==0)
		{				
				  vector<data_comp>::iterator ptr, ptr_end;
				int pos_max, pos_max_other, flag;				

				if(a->fill_word.size()!=0 && b->fill_word.size()==0)
				{					
					flag=1;
					ptr=a->fill_word.begin();
					ptr_end=a->fill_word.end();					
					//pos_max=a->get_tmp_bitmap();
					//pos_max_other=b->get_tmp_bitmap();
				}
				else if(a->fill_word.size()==0 && b->fill_word.size()!=0)
				{					
					flag=0;
					ptr=b->fill_word.begin();
					ptr_end=b->fill_word.end();					
					//pos_max=b->get_tmp_bitmap();
					//pos_max_other=a->get_tmp_bitmap();					
				}
				
				int first_val, last_pos, init; 		
				int sum, min_pos;				

				/* Conserva le info sul primo range
				 * del vettore su cui effettuare il confronto
				*/
				first_val=ptr->init_pos;
				last_pos=ptr->len;	

				//Non serve pi -->sum=last_pos;
				int min_tmp_bitmap=min(a->get_tmp_bitmap(),
					b->get_tmp_bitmap());

				for(; ptr!=ptr_end; )
				{			
				
					/* Incrementa il contatore per effettuare
					 * il confronto con il secondo range e 
					 * calcolare il numero di word literal da 
					 * 'intersecare'.
					*/	
					init=first_val+last_pos;								
					ptr++;		
				
					/* Effettua And su word literal 
					 * rimanenti, se si  giunti alla 
					 * fine della lista. Altrimenti,
					 * calcola la distanza in word dal 
					 * secondo range.
					*///TODO sistemare
					if(init<=min_tmp_bitmap)
					{
						if(ptr==ptr_end) 						
							min_pos=min_tmp_bitmap;																			
						else						
							min_pos=min(ptr->init_pos-1,min_tmp_bitmap);													
					}
					else return;			

					/* Effettua l'AND tra le word literal comprese
					 * tra un intervallo compresso e il successivo.
					*/
					for(int i=init -((ptr-1)->len), j=init; j<=min_pos; i++, j++)
					{					
						if(flag)
							tmp=a->bit_rec[i] & b->bit_rec[j];
						else
							tmp=a->bit_rec[j] & b->bit_rec[i];

						if(tmp)
						{
								if(this->get_word_com()>=this->get_num_words())
								{									
									this->set_num_words(this->get_num_words()+1);
									this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*this->get_num_words());
								}
								this->bit_rec[this->get_word_com()]=tmp;				
								

								for(int g=0; g<WORD_LEN; g++)
								{
									if(tmp & mask[g])
									{ 							
										n_uple_val[val_dim].cont_val++;
										n_uple_val[val_dim].record=init*WORD_LEN+g;
									}
								}
								n_uple_val[val_dim].mapSec.push_back(init);																	
								this->inc_word_com();			
						}														
					}								    		
					if(ptr!=ptr_end){
						if(ptr->init_pos>min_tmp_bitmap)
							return;

						first_val=ptr->init_pos;
						last_pos=ptr->len-(ptr-1)->len;						
					}
					//aggiungo anche questa uscita dal ciclo for
					else break;
				}
				return;
		}
		
		/* CASO 2. I due vettori contengono elementi ed
		 *  necessario effettuare un merging.
		*/

		/* Lista in cui viene effettuato il merge delle liste			 
		 * che conterr la lista di word compresse della bitmap
		 * e le sue caratteristiche.
		*/
		  vector<data_comp> merge;	

		/* Nel caso in cui non esiste un merge,
		 * la dimensione della lista  la somma delle 
		 * dimensioni delle liste di partenza.
		*/
		merge.reserve(a->fill_word.size()+b->fill_word.size());

	    /* Vettori delle posizioni delle word compresse
		 * sia per la prima che per la seconda word,
		 * utili per effettuare velocemente gli AND tra le
		 * word Literal.
		*/
		  vector<int> pos_word_com1, pos_word_com2;	
		pos_word_com1.reserve(a->fill_word.size());
		pos_word_com2.reserve(b->fill_word.size());

		/* Indicano i segnaposto per effettuare AND sfalsati
		 * considerata la compressione delle word.
		*/
		int sum_len1=0, sum_len2=0, min_tmp_bitmap=0;

		if(a->fill_word.size()!=0 && b->fill_word.size()!=0)
		{					
			min_tmp_bitmap=min(a->get_tmp_bitmap(), b->get_tmp_bitmap());							
			vector<data_comp>::iterator p1, p2;	
			p1=a->fill_word.begin();
			p2=b->fill_word.begin();
			data_comp elem;			
			
			/* Gestisco il primo range compresso */
			for(;p1!=a->fill_word.end() || p2!=b->fill_word.end();)
			{	
				/* All'inizio inserisce il primo elemento 
				 * nel vettore la cui init_pos  pi piccola.				
				*/				
				if(merge.empty())
				{				
					//rimane cos perch p1 e p2 sono elementi iniziali delle liste
					//e contengono la lunghezza reale del range
					if(p1->init_pos<p2->init_pos)
					{				
						elem.init_pos=p1->init_pos;
						elem.len=p1->len;						
						//Aggiorno i riferimenti a merge 
						pos_word_com1.push_back(elem.len);
						pos_word_com2.push_back(0);
						//Inserisco il primo elemento 
						merge.push_back(elem);
						p1++;						
					}
					else if(p1->init_pos>p2->init_pos)
					{
						elem.init_pos=p2->init_pos;
						elem.len=p2->len;						
						pos_word_com1.push_back(0);
						pos_word_com2.push_back(elem.len);
						merge.push_back(elem);
						p2++;				
					}
					else if(p1->init_pos==p2->init_pos)
					{
						/* A parit di init_pos, controlla anche la lunghezza
						 * e inserisce per primo il range che ha len maggiore.
						*/
						if(p1->len>=p2->len)
						{						
							elem.init_pos=p1->init_pos;
							elem.len=p1->len;
							//Aggiorno i riferimenti
							pos_word_com1.push_back(elem.len);
							pos_word_com2.push_back(p2->len);													
						}
						else
						{
							elem.init_pos=p2->init_pos;
							elem.len=p2->len;								
							pos_word_com1.push_back(p1->len);
							pos_word_com2.push_back(elem.len);															
						}					
						merge.push_back(elem);
						p1++;
						p2++;						
					}
					
					continue;
				}				

				/* Il vettore merge contiene gi qualcosa.
				 * Controlla se le liste sono entrambe non vuote.
				*/
				if(p1!=a->fill_word.end() && p2!=b->fill_word.end())
				{			  
					/* Preleva range della bitmap 
					 * con pos_init pi piccola 
					 * dal vettore fill_word 
					*/					
					int tmp_val;
					int flag=p1->init_pos < p2->init_pos? 1: 0;
					int min_pos=p1->init_pos < p2->init_pos? p1->init_pos:p2->init_pos;
					int len1, len2, len;

					if(p1!=a->fill_word.begin())
						len1=p1->len-((p1-1)->len);
					else
						len1=p1->len;

					if(p2!=b->fill_word.begin())
						len2=p2->len-((p2-1)->len);
					else
						len2=p2->len;

					len=p1->init_pos < p2->init_pos? len1:len2;	

					//cambiamo-->int len=p1->init_pos < p2->init_pos? p1->len:p2->len;							
				
					if(min_pos<=min_tmp_bitmap)
					{					
						/* Controlla se  possibile un merge, cio se l'intervallo si incontra col precedente. */						
						int merge_val = merge[merge.size()-1].init_pos + merge[merge.size()-1].len;	

						/* Gli intervalli si intersecano */
						if(min_pos <= merge_val)
						{		
								/*Gli intervalli si intersecano in parte: merge degli intervalli */
								if((min_pos + len)-1>=merge_val)
								{
									//merge[merge.size()-1].len+=(min_pos+(*p1).len-1)-merge_val;								
									tmp_val=len-(merge_val-(min_pos));
									if(tmp_val>0)
										merge[merge.size()-1].len+=tmp_val;
								}																
								if(flag)
									pos_word_com1[pos_word_com1.size()-1]+=len;																	
								else 	
									pos_word_com2[pos_word_com2.size()-1]+=len;											
						}
						/* Gli intervalli sono disgiunti */
						else
						{									
							/* Inserisce l'intervallo.
							 * Aggiorna i vettori di posizione delle word compresse,							 
							*/								
							elem.init_pos=min_pos;
							elem.len=len;												
							merge.push_back(elem);

							int prec1=pos_word_com1[pos_word_com1.size()-1];
							int prec2=pos_word_com2[pos_word_com2.size()-1];

							if(flag){																														
								pos_word_com1.push_back(prec1+len);
								pos_word_com2.push_back(prec2);
							}
							else{																														
								pos_word_com2.push_back(prec2+len);
								pos_word_com1.push_back(prec1);
							}																																																																	
						}//else

						// Incrementa i contatori p1/p2
						if(flag)						
							p1++;							
						else 							
							p2++; 						
					}//if	
					else break;
					continue;
				}//if				

				/* Gestisce il caso in cui un vettore si  svuotato, cio gli intervalli compressi sono finiti. */
				else if(p1==a->fill_word.end() || p2==b->fill_word.end())
				{						
						//se sono vuoti entrambi, vai direttamente alla fase 2
						if(p1==a->fill_word.end() && p2==b->fill_word.end())
							goto exit_2;

						min_tmp_bitmap=min(a->get_tmp_bitmap(),b->get_tmp_bitmap());						
						
						bool flag;
						int lenght,init_pos1, last, d,  last_elem_other, minimo;
						data_comp elem;
						  vector<data_comp>::iterator p_tmp2;	
						

						if(p1!=a->fill_word.end())
						{							
							flag=1;							
							
							p_tmp2=a->fill_word.begin();
							init_pos1=a->fill_word[0].init_pos;		
							last=a->fill_word[a->fill_word.size()-1].init_pos;
						
							if(b->fill_word.size()==1)
								last_elem_other=b->fill_word[0].len + b->fill_word[0].init_pos;
							else
							{
								int lun = b->fill_word[b->fill_word.size()-1].len - b->fill_word[b->fill_word.size()-2].len;
								last_elem_other = b->fill_word[b->fill_word.size()-1].init_pos + lun;
							}
							minimo=min(ceil((float)last_elem_other/2)+1,a->fill_word.size()-1);
							d=find_index(a,last_elem_other,0,minimo);
							
						}
						else
						{						
							flag=0;							
							
							init_pos1=b->fill_word[0].init_pos;	
							last=b->fill_word[b->fill_word.size()-1].init_pos;
							p_tmp2=b->fill_word.begin();
						
							if(a->fill_word.size()==1)
								last_elem_other=a->fill_word[0].len + a->fill_word[0].init_pos;
							else
							{
								int lun = a->fill_word[a->fill_word.size()-1].len - a->fill_word[a->fill_word.size()-2].len;
								last_elem_other = a->fill_word[a->fill_word.size()-1].init_pos + lun;
							}
							minimo=min(ceil((float)last_elem_other/2)+1,b->fill_word.size()-1);
							d=find_index(b,last_elem_other,0,minimo);
							
							
						}	

						int merge_val = merge[merge.size()-1].init_pos+merge[merge.size()-1].len;							
						p_tmp2=p_tmp2+d;						
						
						if(p_tmp2->init_pos!=init_pos1)
								lenght=p_tmp2->len-((p_tmp2-1)->len);
							else 
								lenght=p_tmp2->len;
						
						/* Scorre p_tmp finch non si trova un range valido da inserire. 	*/									
						while(p_tmp2->init_pos<=min_tmp_bitmap)
						{																												
							/* L'intervallo precede il merge_val */														
							if(p_tmp2->init_pos<=merge_val)
							{
								/* L'intervallo si interseca ed esce a destra : merging */
								if(p_tmp2->init_pos+lenght-1>=merge_val)
								{
									int val_merge=lenght-(merge_val-p_tmp2->init_pos);		

									/* Effettua Merge */									
									merge[merge.size()-1].len+=val_merge;  /* --> [][] intervalli contigui unificati [  ] */									
								}				
								/* Bisogna aggiornare i riferimenti. Non si aggiunge un intervallo nuovo, 
								 * ma si cambiano le dim di quello esistente.
								*/
								if(flag)
									pos_word_com1[pos_word_com1.size()-1]=p_tmp2->len;																										
								else
									pos_word_com2[pos_word_com2.size()-1]=p_tmp2->len;
																										
							}		
							else /* Gli intervalli sono disgiunti */
								//devo fare in modo che non inserisce questo intervallo se  stata superata
								//la min_tmp_bitmap
							{																						 														
								elem.init_pos=p_tmp2->init_pos;
								elem.len=lenght;												
								merge.push_back(elem);

								int prec1=pos_word_com1[pos_word_com1.size()-1];
								int prec2=pos_word_com2[pos_word_com2.size()-1];

								if(flag)
								{																														
									//pos_word_com1.push_back(prec1+lenght);
									pos_word_com1.push_back(p_tmp2->len);
									pos_word_com2.push_back(prec2);
								}
								else
								{																														
									//pos_word_com2.push_back(prec2+lenght);
									pos_word_com2.push_back(p_tmp2->len);
									pos_word_com1.push_back(prec1);
								}				
							}//else							
															
							if(p_tmp2->init_pos==last)
								goto exit_2;
							else p_tmp2++;																							
							lenght = p_tmp2->len - ((p_tmp2-1)->len);	
							
															
						}//while
						goto exit_2;														
					}//else				
			}//for			
		}//if	

		/***************************************
		 *							           *
		 * Seconda parte: SCANSIONE della      *
		 * della lista trovata che contiene    *
		 * l'intersezione dei range	compressi. *	
		 *							           *
		 ***************************************/

		/* Scorre la lista per controllare i range 
		 * su cui effettuare gli AND tra literal.
		*/
	
		/* Nel caso in cui la lista di merge sia vuota
		 * cio quando si ha una lista di literal e 
		 * poi molte word 0 finali e quindi l'intervallo
		 * compresso non viene registrato nella lista
		*/
exit_2:	if(merge.size()!=0)
		{				
			
			/* Scorre il primo vettore e ne prende i valori */
			  vector<data_comp>::iterator ptr=merge.begin();			
			  vector<int>::iterator t1 = pos_word_com1.begin();
			  vector<int>::iterator t2 = pos_word_com2.begin();

			int first_val, last_pos; 		
			int num_word_and, val_init;

			/* Conserva le info sul primo range
			 * del vettore su cui effettuare il confronto
			*/
			first_val=ptr->init_pos;
			last_pos=ptr->len-1;		

			for(; ptr!=merge.end(); )
			{							
				/* Incrementa il contatore per effettuare
				 * il confronto con il secondo range e 
				 * calcolare il numero di word literal da 
				 * 'intersecare'.
				*/					
				ptr++;									
				                
				/* Effettua And su word literal 
				 * rimanenti, se si  giunti alla 
				 * fine della lista. Altrimenti,
				 * calcola la distanza in word dal 
				 * secondo range.
				*/
				val_init=first_val+last_pos+1;
				unsigned tmp;				
		
				if(ptr==merge.end()) 
					num_word_and=(min_tmp_bitmap)-(first_val+last_pos);						
				else
				{							
					num_word_and = (ptr->init_pos-1)-(first_val+last_pos);	
					first_val = ptr->init_pos;
					last_pos = ptr->len-1;
				}					

				/* Effettua l'AND tra le word literal comprese
				 * tra un intervallo compresso e il successivo.
				*/	
				int initt=val_init;	
				for(int i=initt-(*t1), j=initt-(*t2), y=0; y<num_word_and; i++, j++, y++, initt++)
				{
					tmp = a->bit_rec[i] & b->bit_rec[j]; 	

					/* Se il risultato  diverso da zero, cio ci sono
					 * bit 1 all'interno della word considerata,
					 * e il num di dimensioni  superiore a 3,
					 * allora salvo l'informazione sulla struttura
					 * globale che contiene le aggregazioni a livelli.
					*/
					if(tmp)
					{
						if(this->get_word_com()>=this->get_num_words()){							
							this->set_num_words(this->get_num_words()+1);
							this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*this->get_num_words());
						}
						this->bit_rec[this->get_word_com()]=tmp;						

						for(int g=0; g<WORD_LEN; g++)
							if(tmp & mask[g])
							{ 							
								n_uple_val[val_dim].cont_val++;
								n_uple_val[val_dim].record=initt*WORD_LEN+g;
							}

						n_uple_val[val_dim].mapSec.push_back(initt);						
						this->inc_word_com();

						/*
							1.Inserisci soltanto le word che servono per
							  effettuare dopo gli AND con le liste compresse
							2.Inserisci nel vettore di interi gli indici che 
							  corrispondono a quella word in quella partizione.

							Per esempio, se abbiamo:
							word1,word2 -->indici: 34, 56 (posizioni nella partizione non compressa)
							se fill_word  del tipo: [30, 6] [59, 10], l'unico incrocio possibile
							sar quello con la word 56, poich in fill_word la word 34  tutta fatta di zeri!!
						*/													
					}//if
				}//for

				/* Incrementa i ptr a word compresse
				 * che punteranno all'intervallo corrente. 
				*/				
				t1++;
				t2++;									
			}//for
		}//if		
		merge.clear();
		pos_word_com1.clear();
		pos_word_com2.clear();			
		/* Restituisce il numero di bit 1 dell'And tra le bitmap */		
		
	}//end procedura

	int bitmap_rec::find_index(bitmap_rec* b,int val, int first, int last)
	{
		int index=first + ceil((float)((last-first)/2.0));
		
		int init_pos=b->fill_word[index].init_pos;
		int len=b->fill_word[index].len;

		if(index==0 ){	
			
			return index;
		}
		if(index==b->fill_word.size()-1)
			return (index-1);

		int lenght;				
		if(val >= init_pos)
		{			
			lenght = len - b->fill_word[index-1].len;	
			
				
			//L'elemento  contenuto nell'array compresso
			if(val<init_pos+lenght){
	
				return index;
			}

			//L'elemento si trova in un range non compresso a destra di index
			if(val>=init_pos + lenght && val<b->fill_word[index+1].init_pos)
			{
				
				return index;	
				
			}
			else			
				find_index(b,val,index+1,last);	
		}
		else
		//val < di init_pos
		{
			if(index==1) 
				lenght=b->fill_word[index-1].len;
			else
				lenght=b->fill_word[index-1].len - b->fill_word[index-2].len;	
			
			
			if(val>=b->fill_word[index-1].init_pos + lenght){
				//valore non compresso che sta nel range a sinistra			
				return (index-1);			
			}
			else					
				find_index(b,val,first,index-1);	
			
		}		

	}

	void bitmap_rec::make_and_two_with_mem_sorted2(bool flagS, bitmap_rec* a, bitmap_rec* b, int val_dim, int index)
	{
		  vector<int>::iterator iter=n_uple_val[val_dim].mapSec.begin();
		  vector<data_comp>::iterator iterF;
		int val, ind, initial_pos,end_pos_prec;	
		bool flag;
		unsigned tmp;
		unsigned char *p;
		
		//Inizializza il contatore 
		n_uple_val[index].cont_val=0;
		if(flagS)
		{						
			this->set_num_words(2);
			this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*2);
			memset(this->bit_rec,(unsigned)0,sizeof(unsigned)*2);
			this->set_word_com(0);					
			n_uple_val[index].mapSec.clear();
		}

		int d=b->init_index, len_prec, end_pos, tmp_com;		
		initial_pos=b->fill_word[d].init_pos;

		if(d==0)
		{
				len_prec=0;
				end_pos=initial_pos + b->fill_word[0].len - 1;
		}
		else
		{
				len_prec=b->fill_word[d-1].len;
				end_pos=initial_pos + (b->fill_word[d].len - len_prec) - 1;				
		}	
			/* Se val si trova in una posizione precedente
			 * del vettore, effettua una ricerca all'indietro. 
			*/
			flag=0;
			val=(*iter);			
			if(val<initial_pos && d!=0)
			{				
				while(val<initial_pos && d>0)
				{					
					d--;
					initial_pos=b->fill_word[d].init_pos;		
				}			
				
				b->init_index=d;
				if(d==0)
				{
					len_prec=0;
					end_pos=initial_pos + b->fill_word[0].len - 1;
				}
				else
				{
					len_prec=b->fill_word[d-1].len;
					end_pos=initial_pos + (b->fill_word[d].len - len_prec) - 1;
					
				}
			}				
		
	
		for(ind=0; iter!=n_uple_val[val_dim].mapSec.end(); )
		{						
			val=(*iter);									
			if(val>b->get_tmp_bitmap()) return;	
			
			if(val<initial_pos) {iter++; ind++; continue;}

			if(val>=initial_pos && val<=end_pos)		
			{		
				tmp= a->bit_rec[ind]  &  b->bit_rec[val-initial_pos+len_prec];	
											
				if(tmp)
				{							
					//Se ha figli
					if(flagS)
					{						
							tmp_com= this->get_word_com();								
							if(tmp_com>=this->get_num_words())
							{			
								this->set_num_words(tmp_com*2);
								this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*this->get_num_words());																							
							}														
							this->bit_rec[tmp_com]= tmp;	

							 p = (unsigned char *) & tmp;
							 for(int i=0; i<=24; i+=8, p++)
							 {
								 if(*p!=0)
								 {
									 n_uple_val[index].cont_val += CountTable[*p];
									 n_uple_val[index].record=bitSign(*p,val,i);
								}							
							 }													
							 this->inc_word_com();
							 n_uple_val[index].mapSec.push_back(val);														
						}
						//se non ha figli
						else
						{			
							p = (unsigned char *) & tmp;
							for(int i=0; i<=24; i+=8, p++)
								n_uple_val[index].cont_val+= CountTable[*p];									 																														
						}
					}
					iter++; ind++; continue;
				}
				else if(val>end_pos)
				{	
						
					while(val>end_pos)
					{
						d++;				
						if(d==b->fill_word.size()) return;
						initial_pos=b->fill_word[d].init_pos;
						len_prec=b->fill_word[d-1].len;
						end_pos=initial_pos + (b->fill_word[d].len - len_prec) - 1;							
					}				
					b->init_index=d;
					continue;								
				}//else				
		}//for

	}//procedure


	void bitmap_rec::make_and_two_with_mem_sorted(bool flagS, bitmap_rec* a, bitmap_rec* b, int val_dim, int index)
	{
		/*
		 * Cicla su n_uple_val[index].mapSec.size()
		 * e prende le word memorizzate. Ci sono 2 casi:
		 * 1. word da merge e word da merge
		 * 2. word da merge e word da fill
		*/						
		  vector<int>::iterator iter;
		  vector<data_comp>::iterator iterF;
		int val, ind, initial_pos,end_pos_prec;	
		bool flag;
		unsigned tmp;
		unsigned char *p;

		n_uple_val[index].cont_val=0;				
		
		if(flagS)
		{						
			this->set_num_words(2);
			this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*2);
			memset(this->bit_rec,(unsigned)0,sizeof(unsigned)*2);
			this->set_word_com(0);					
			n_uple_val[index].mapSec.clear();
		}
				
		int d=b->init_index, len_prec, end_pos, tmp_com;		
		initial_pos=b->fill_word[d].init_pos;

		if(d==0)
		{
				len_prec=0;
				end_pos=initial_pos + b->fill_word[0].len - 1;
		}
		else
		{
				len_prec=b->fill_word[d-1].len;
				end_pos=initial_pos + (b->fill_word[d].len - len_prec) - 1;

				if(d==1) end_pos_prec=b->fill_word[0].init_pos + b->fill_word[0].len-1;
				else
					end_pos_prec=b->fill_word[d-1].init_pos + (b->fill_word[d-1].len-b->fill_word[d-2].len)-1;
				
		}

		
				
		for(ind=0, iter=n_uple_val[val_dim].mapSec.begin(); iter!=n_uple_val[val_dim].mapSec.end(); iter++, ind++)
		{			
			flag=0;
			val=(*iter);									
			if(val>b->get_tmp_bitmap()) return;													
			if(val<initial_pos && d!=0 && val>end_pos_prec) continue;
			
			/* Se val si trova in una posizione precedente
			 * del vettore, effettua una ricerca all'indietro. 
			*/
			if(val<initial_pos && d!=0)
			{				
				while(val<initial_pos && d>0)
				{					
					d--;
					initial_pos=b->fill_word[d].init_pos;		
				}			
				

				b->init_index=d;
				if(d==0)
				{
					len_prec=0;
					end_pos=initial_pos + b->fill_word[0].len - 1;
				}
				else
				{
					len_prec=b->fill_word[d-1].len;
					end_pos=initial_pos + (b->fill_word[d].len - len_prec) - 1;
					if(d==1) end_pos_prec=b->fill_word[0].init_pos + b->fill_word[0].len-1;
				else
					end_pos_prec=b->fill_word[d-1].init_pos + (b->fill_word[d-1].len-b->fill_word[d-2].len)-1;
					
				}
			}
						
			while(val>end_pos)
			{			
				b->init_index++;
				end_pos=b->fill_word[b->init_index].init_pos + 
					(b->fill_word[b->init_index].len - b->fill_word[b->init_index-1].len) -1;
				flag=1;					
			}			

			if(flag)
			{
				d=b->init_index;			
				initial_pos=b->fill_word[d].init_pos;
				len_prec=b->fill_word[d-1].len;
				if(d==1) end_pos_prec=b->fill_word[0].init_pos + b->fill_word[0].len-1;
				else
					end_pos_prec=b->fill_word[d-1].init_pos + (b->fill_word[d-1].len-b->fill_word[d-2].len)-1;
			}			
			

			/* Se val  minore di end_pos, controllo
			 * soltanto il range di literal. Se non c',
			 * continuo con il successivo val
			*/
			
			
			if(val>=initial_pos)			
			{		
				tmp= a->bit_rec[ind]  &  b->bit_rec[val-initial_pos+len_prec];	
											
				if(tmp)
				{		
					
					//Se ha figli
					if(flagS)
					{						
							tmp_com= this->get_word_com();								
							if(tmp_com>=this->get_num_words())
							{			
								this->set_num_words(tmp_com*2);
								this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*this->get_num_words());																							
							}														
							this->bit_rec[tmp_com]= tmp;	

							 p = (unsigned char *) & tmp;
							 for(int i=0; i<=24; i+=8, p++)
							 {
								 if(*p!=0)
								 {
									 n_uple_val[index].cont_val += CountTable[*p];
									 n_uple_val[index].record=bitSign(*p,val,i);
								}							
							 }							
							
								this->inc_word_com();
								n_uple_val[index].mapSec.push_back(val);							
							
					}
					//se non ha figli
					else
					{			
						p = (unsigned char *) & tmp;
						for(int i=0; i<=24; i+=8, p++)
							n_uple_val[index].cont_val+= CountTable[*p];									 																														
					}
				}							
			}
			
			else continue;	
		}
		
	}


	void bitmap_rec::make_and_two_with_mem(bool flag, bitmap_rec* a, bitmap_rec* b, int val_dim, int index)
	{
		/*
		 * Cicla su n_uple_val[index].mapSec.size()
		 * e prendi le word memorizzate. Ci sono 2 casi:
		 * 1. word da merge e word da merge
		 * 2. word da merge e word da fill
		*/				
		  vector<int>::iterator iter;
		  vector<data_comp>::iterator iterF;
		int val, sum, ind;		
		unsigned tmp;
		n_uple_val[index].cont_val=0;	
		
		if(flag)
		{			
			memset(this->bit_rec,(unsigned)0,sizeof(unsigned)*this->get_num_words());
			this->set_word_com(0);						
			n_uple_val[index].mapSec.clear();
		}
		
		int rel_offset=-1, minimo;
		int d=index_global=0;		
		
		for(ind=0, iter=n_uple_val[val_dim].mapSec.begin(); iter!=n_uple_val[val_dim].mapSec.end(); iter++, ind++)
		{
			val=(*iter);									
			if(val>b->get_tmp_bitmap()) 							
				return;		

			/* Cerca su b->fill_word se la word di indice 'val'
			 * non  zero; se  cos, effettua l'AND.
			 * Quindi scorre tutta la lista di range compressi,
			 * tenendo conto del campo 'len' e sommandone
			 * tutti i valori per trovare la pos corretta.
			*/									
			if(b->fill_word.size()==0){	
				rel_offset=val;
				goto next;	
			}					
			if(val<b->fill_word[d].init_pos) continue;
			
			minimo=min(b->fill_word.size()-1,ceil((float)(val/2.0)));														
			rel_offset=find_word(b,val,d,minimo);
			d=index_global;			
			
			if(rel_offset!=-1)			
				goto next;						
			else continue;
								
next:		tmp= a->bit_rec[ind] & 
				b->bit_rec[rel_offset];				
				
				if(tmp)
				{				
					if(flag)
					{
						if(this->get_word_com()>=this->get_num_words()){													
							this->set_num_words(this->get_word_com()+1);
							this->bit_rec=(unsigned*) realloc(this->bit_rec,sizeof(unsigned)*this->get_num_words());
						}
						this->bit_rec[this->get_word_com()]=tmp;
						
						for(int y=0; y<WORD_LEN; y++)
							{
								if (tmp & mask[y])								
								else printf(" 0");
							}
						
							for(int y=0; y<WORD_LEN; y++)
							{
								if (tmp & mask[y])
								{
									n_uple_val[index].record=val*WORD_LEN+y;
									n_uple_val[index].cont_val++;								
								}	
							}
							n_uple_val[index].mapSec.push_back(val);																	
							this->inc_word_com();												
					}
					else
					{
						
						for (int y=0; y<WORD_LEN; y++)						
							if (tmp & mask[y])													
								n_uple_val[index].cont_val++;															
					}
				}		 
		}//for	   		
	}
	

	/*void bitmap_rec::make_and(bitmap_rec* a, bitmap_rec* b,
							  int index, int flag, int alt, int val_dim)
	{		
		unsigned tmp;
		int y;

		n_uple_val[val_dim].mapSec.clear();
		n_uple_val[val_dim].cont_val=0;

		/* Non c' conservato nulla, ma salva le word e le posizioni */
		/*if(!flag)
		{
			int first=a->first_byte>b->first_byte?a->first_byte:b->first_byte;
			int last=a->last_byte<b->last_byte?a->last_byte:b->last_byte;

			for (int i=first; i<=last; i++)
			{
				tmp = a->bit_rec[i] & b->bit_rec[i];
				if(tmp)
				{
					this->bit_rec[i] = tmp;

					for (y=0; y<WORD_LEN; y++)
						if (tmp  & mask[y])
						{
							n_uple_val[val_dim].cont_val++;
							n_uple_val[val_dim].record=i*WORD_LEN+y;
						}

					if(alt)
						n_uple_val[val_dim].mapSec.push_back(i);
				}
			}
		}
		/* C' gi conservato qualcosa */
		/*else
		{
			  vector<int>::iterator iter;
			int val;

			for(iter=n_uple_val[index].mapSec.begin(); iter!=n_uple_val[index].mapSec.end(); iter++)
			{
				val=*iter;
				if(b->bit_rec[val])
				{
					tmp = b->bit_rec[val] & a->bit_rec[val];
					if(tmp)
					{
						this->bit_rec[val] = tmp;

						for (y=0; y<WORD_LEN; y++)
							if (tmp  & mask[y])
							{
								n_uple_val[val_dim].record=val*WORD_LEN+y;
								n_uple_val[val_dim].cont_val++;
							}

							if (alt)
								n_uple_val[val_dim].mapSec.push_back(val);
					}
				}
			}
		}//if
	}//end procedura*/

	bool bitmap_rec:: check_word(unsigned word){
		if(this->bit_rec[word]) return true;
		return false;
	}

	/*void bitmap_rec::set_bit_rec(int array_pos, unsigned int  byte_pos){

		this->bit_rec[array_pos] |=  mask[byte_pos];
		last_byte=array_pos;
	}*/

	bitmap_rec::~bitmap_rec(){		
		free(bit_rec);
	}

/* Classe per le bitmap di secondo livello */
class bitmap_dim {

		unsigned *bit_dim;
		int init_bit, last_bit;
		int num_words;

	public:

		bitmap_dim() { init_bit=MAX_VAL;	last_bit=0; };
		bitmap_dim(int );
		bitmap_dim(int n, bool elem);

		~bitmap_dim() {	delete [] bit_dim; };

		void set_bitmap_dim(int );
		void reset_bitmap_dim(int dim);
		int size() {return num_words;}
		void set_AllBit_to_1();

		void set_bit_to_0(int i, int j);
		void make_and(unsigned* elem,  int init, int end);

		int get_current_bit();
		int get_last_bit();
		bool get_bit(int , int );
		int get_num_words() {return num_words; };
		unsigned* ret_bit_dimAll() { return this->bit_dim;};

		void set_bit_dim(int ,int ,int );
		void make_and_maps_2(int index, int val_dim, int* words);

		void make_and_maps(vector<int>, int, int*  );

		bool check_word(unsigned word){
			if(this->bit_dim[word]) return true;
			return false;
		}

		void make_and_maps(bool ok, vector<int> prec_val, int val_dim, int *init, int *last);

	};

	bitmap_dim::bitmap_dim(int n){

		(n % WORD_LEN)? this->num_words=n/WORD_LEN+1: this->num_words=n/WORD_LEN;

			this->bit_dim = new unsigned[num_words];

			memset(this->bit_dim,(unsigned)0,sizeof(unsigned)*num_words);
			init_bit=MAX_VAL;
			last_bit=0;
	}

	bitmap_dim::bitmap_dim(int n, bool elem){

		(n % WORD_LEN)? this->num_words=n/WORD_LEN+1: this->num_words=n/WORD_LEN;

			this->bit_dim = new unsigned[num_words];
			memset(this->bit_dim,(unsigned)0xFFFFFFFF,sizeof(unsigned)*num_words);	

			init_bit=MAX_VAL;
			last_bit=0;		
	}

	void bitmap_dim::set_bit_to_0(int i, int j)
	{			
		this->bit_dim[i]  &=  mask2[j];
	}

	void bitmap_dim::make_and_maps_2(int index, int val_dim, int* words)
	{
		bool flag = false;
		int val;	
		val=index;
		bitmap_dim *a = &bitData[val].bitmaps[n_uple_val[val].val].mapDim[val_dim-val-1];
		val=val_dim-1;
		bitmap_dim *b = &bitData[val].bitmaps[n_uple_val[val].val].mapDim[val_dim-val-1];

		int last=min(a->get_last_bit()/WORD_LEN,b->get_last_bit()/WORD_LEN);
		int init=max(a->get_current_bit()/WORD_LEN, b->get_current_bit()/WORD_LEN);
	
		for (int i=init; i<=last; i++)
		{
			if(a->bit_dim[i])
			{							
				this->bit_dim[i] = a->bit_dim[i] & b->bit_dim[i];									
				if(this->bit_dim[i])
				{									
					if(!flag)
					{
						words[1]=words[0]=i;
						flag=true;
					}
					else words[1]=i;
				}//if
			}//if
		}//for	
	}

	void bitmap_dim::set_AllBit_to_1()
	{		
		memset(this->bit_dim,(unsigned)0xFFFFFFFF,sizeof(unsigned)*num_words);
	}

	void bitmap_dim::make_and(unsigned* elem,  int init, int end)
	{		
		for(int i=init; i<=end; i++){	
					
				this->bit_dim[i] &= elem[i];				
		}
	}

	void bitmap_dim::reset_bitmap_dim(int dim){
	

		if(dim > num_words * WORD_LEN){

			delete [] bit_dim;
			(dim % WORD_LEN)? num_words=dim/WORD_LEN+1: num_words=dim/WORD_LEN;
			bit_dim = new unsigned[num_words];
		}
		
		memset(this->bit_dim,(unsigned)0,sizeof(unsigned)*(num_words));
		init_bit=MAX_VAL;
		last_bit=0;
	}

	int bitmap_dim::get_current_bit() { return init_bit; }

	bool bitmap_dim::get_bit(int array_pos,  int byte_pos){

		 if(this->bit_dim[array_pos] & mask[byte_pos]) return true;
		 return false;
	}

	int bitmap_dim::get_last_bit() { return last_bit; }

	void bitmap_dim::set_bit_dim(int array_pos, int byte_pos, int ret)
	{
		bit_dim[array_pos] |=  mask[byte_pos];
		last_bit=ret>=last_bit?ret:last_bit;
		init_bit=ret<=init_bit?ret:init_bit;
	}

	void bitmap_dim:: set_bitmap_dim(int n){

			(n % WORD_LEN)? num_words=n/WORD_LEN+1: num_words=n/WORD_LEN;
			bit_dim = new unsigned[num_words];
			memset(this->bit_dim,(unsigned)0,sizeof(unsigned)*num_words);
	}

	void bitmap_dim::make_and_maps(bool ok, vector<int> prec_val, int val_dim, int* init2, int* last2)
	{		
		bool flag = false;
		  vector<int>::iterator y = prec_val.begin();
	
		int val=prec_val[0];
		bitmap_dim *a = &bitData[val].bitmaps[n_uple_val[val].val].mapDim[val_dim-val-1];		
		val=prec_val[1];
		bitmap_dim *b = &bitData[val].bitmaps[n_uple_val[val].val].mapDim[val_dim-val-1];	

		//memset(this->bit_dim,(unsigned)0,sizeof(unsigned)*this->get_num_words());
				
		int last=min(a->get_last_bit()/WORD_LEN,b->get_last_bit()/WORD_LEN);		
		int init=max(a->get_current_bit()/WORD_LEN, b->get_current_bit()/WORD_LEN);		
				
		for (int i=init; i<=last; i++)
		{
			if(a->bit_dim[i])
			{					   	
				this->bit_dim[i] = a->bit_dim[i] & b->bit_dim[i];									
				if(this->bit_dim[i])
				{					
					if(prec_val.size()>2)
					{
						for(y=prec_val.begin()+2; y!=prec_val.end(); y++)
						{					
							this->bit_dim[i] &= (&bitData[*y].bitmaps[n_uple_val[*y].val].
								mapDim[val_dim-*y-1])->bit_dim[i];
						}
					}					
					if( this->bit_dim[i])
						if(!flag)
					{
						(*init2)=(*last2)=i;
						flag=true;
					}					
					else (*last2)=i;
				 }//if
			  }//if
		  }//for
	}

	void bitmap_dim::make_and_maps(vector<int> prec_val, int val_dim, int* words)
	{

		bool flag = false;
		  vector<int>::iterator y = prec_val.begin();

		int val=prec_val[0];
		bitmap_dim *a = &bitData[val].bitmaps[n_uple_val[val].val].mapDim[val_dim-val-1];
		val=prec_val[1];
		bitmap_dim *b = &bitData[val].bitmaps[n_uple_val[val].val].mapDim[val_dim-val-1];

		int last=min(a->get_last_bit()/WORD_LEN,b->get_last_bit()/WORD_LEN);
		int init=max(a->get_current_bit()/WORD_LEN, b->get_current_bit()/WORD_LEN);

		for (int i=init; i<=last; i++)
		{
			if(a->bit_dim[i])
			{
				this->bit_dim[i] = a->bit_dim[i] & b->bit_dim[i];
				if(this->bit_dim[i])
				{
					if(prec_val.size()>2)
					{
						for(y=prec_val.begin()+2; y!=prec_val.end(); y++)
							this->bit_dim[i] &= (&bitData[*y].bitmaps[n_uple_val[*y].val].
								mapDim[val_dim-*y-1])->bit_dim[i];
					}

					if(!flag)
					{
						words[1]=words[0]=i;
						flag=true;
					}
					else words[1]=i;

				}//if
			}//if
		}//for
	}


class Node {

	short val_dim;
	short level;
	vector<Node*> child;

public:
	Node(){}
	~Node(){}

	/* Metods */
	/* Set and get dimension values */
	void set_val_dim(short value) { val_dim=value; }
	short get_val_dim() { return val_dim; }

	/* Set and get levels */
	void set_level(int lev) { level=lev; }
	int get_level() { return level; }

	/* Insert new child */
	void insert_new_child(Node *son){ child.push_back(son); }

	/* Return child in position 'pos' */
	Node *get_child_in_pos(int pos) { return child[pos]; }

	/* Return children number */
	int num_child() { return child.size(); }

};







