
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <fstream>
#include <iostream>
#include "SAT.h"
#include "SATFinder.h"

#pragma warning(disable:4768)


void searchSAT(int argc, char* argv[])
{
	int frontierSize = 500;
	int numFinalNodes = 500;

	if (argc != 4 && argc != 6)
	{
		printf("Usage: search thresholdFile sampleDataFile satFile [maxNumberActiveState numberFinalStateToStop]\n");
		return;
	}

	if (argc == 6)
	{
		frontierSize = atoi(argv[4]);
		numFinalNodes = atoi(argv[5]);
	}

	SATFinder finder;
	finder.setSearchParam(frontierSize, numFinalNodes);
	finder.searchSAT(argv[1], argv[2], argv[3]);
}


void detectBurst(int argc, char* argv[])
{
	if (argc != 4)
	{
		printf("Usage: detect thresholdFile dataFile satFile\n");
		return;
	}

	SAT sat;
	sat.readStruct(argv[3], argv[1]);
	sat.incrementalDetect(argv[2]);
}

void dynamicDetectBurst(int argc, char* argv[])
{
	if (argc != 4)
	{
		printf("Usage: dynamicDetect thresholdFile dataFile satFile\n");
		return;
	}

	SAT sat;
	sat.readStruct(argv[3], argv[1]);
	sat.incrementalDynamicDetect(argv[2]);
}


int main(int argc, char* argv[])
{
//	searchSAT(argc, argv);
//	detectBurst(argc, argv);
	dynamicDetectBurst(argc, argv);
	return 0;
}
