
/* f:obj 2:("f";2) where K f(K x,K y){} */
typedef int I;
typedef double F;
typedef char C;
typedef C*S;
typedef unsigned char UC;
typedef struct k{I c,t,n;struct k*k[1];}*K;
extern S sp(S); /* symbol from phrase */

/* atom generators, e.g. gi(2),gf(2.0),gc('2'),gs(sp("2")) */
extern K gi(I),gf(F),gc(C),gs(S),gn(),gpn(S,I);

/* list generator (t as in 4::), e.g. gtn(-1,9) integer vector */
extern K gtn(I t,I n);

/* atom accessors, e.g.	Ki(x)=3D2 */
#define Ki(x) ((x)->n)
#define Kf(x) (*KF(x))
#define Kc(x) (*(UC*)&(x)->n)
#define Ks(x) ((S)(x)->n)

/* list accessors, e.g. KF(x)[i]=3D2.0 */
#define KI(x) ((I*)((x)->k))
#define KF(x) ((F*)((x)->k))
#define KC(x) ((UC*)((x)->k))
#define KS(x) ((S*)((x)->k))
#define KK(x) ((K*)((x)->k))

/* error, e.g. if(x->t!=3D-1)return kerr("need integer vector");*/
extern K kerr(C*);

/* e.g.=20
load function(s) from a.c

#include "k20.h"
K f(K x,K y){return gi(Ki(x)+Ki(y));} // add 2 integers
K g(K x){return gf(Kf(x)+1);}	// add 1 to float
...

LINUX(dlopen): cc -shared a.c -o a.so
NT(loadlibrary): project(a);dll;add a.c(with __declspec(dllexport)K =
...);link(k20.lib)

in k,
  f:"[path]/a"2:("f";2)
  g:"[path]/a"2:("g";1)

  f[2;3]
5
  g[2.3]
3.3
*/


