import java.awt.*;

public class House {
    public static final int NUM_POLYGONS = 2;
    public static final double FACE_RADIUS = 50.0;

    public Color c;
    public double main_length;

    public double[][][] initial_coordinates;
    public Matrix_3x3[] polygon_matrices;

    public Matrix_3x3 viewing_matrix;
    public int[][][] appearance_coordinates;

    public double scale_value;
    public double[] offset;    

    public double[] font_coordinates; 
    public int[] real_font_coordinates;
    public Matrix_3x3 font_matrix, real_font_matrix;
    public String message;

    public House(double scale, double x, double y, String msg) {
	int i, j, k;

	this.c = Color.green;
	this.scale_value = scale;
	this.main_length = scale_value * FACE_RADIUS;

	this.initial_coordinates = new double[NUM_POLYGONS][][];
	this.polygon_matrices = new Matrix_3x3[NUM_POLYGONS];

	this.initial_coordinates[0] = new double[2][4];
	initial_coordinates[0][0][0] = -1.0 * main_length;    initial_coordinates[0][1][0] = -1.0 * main_length;
	initial_coordinates[0][0][1] =  main_length;          initial_coordinates[0][1][1] = -1.0 * main_length;
	initial_coordinates[0][0][2] =  main_length;          initial_coordinates[0][1][2] = main_length;
	initial_coordinates[0][0][3] = -1.0 * main_length;    initial_coordinates[0][1][3] = main_length;	
	polygon_matrices[0] = new Matrix_3x3();
	polygon_matrices[0].identity();
	// scale
	polygon_matrices[0].translate(0.0, 0.0);

	this.initial_coordinates[1] = new double[2][3];
	initial_coordinates[1][0][0] =  0.0;                  initial_coordinates[1][1][0] = 1.0 * main_length;
	initial_coordinates[1][0][1] =  1.50 * main_length;   initial_coordinates[1][1][1] = 0.0;
	initial_coordinates[1][0][2] = -1.50 * main_length;   initial_coordinates[1][1][2] = 0.0;
	polygon_matrices[1] = new Matrix_3x3();
	polygon_matrices[1].identity();
	// scale
	polygon_matrices[1].translate(0.0, main_length);

	this.viewing_matrix = new Matrix_3x3();
	this.appearance_coordinates = new int[this.initial_coordinates.length][][];
	for (i = 0; i < this.appearance_coordinates.length; i++) {
	    this.appearance_coordinates[i] = new int[this.initial_coordinates[i].length][];
	    for (j = 0; j < this.appearance_coordinates[i].length; j++) {
		this.appearance_coordinates[i][j] = new int[this.initial_coordinates[i][j].length];
		for (k = 0; k < this.appearance_coordinates[i][j].length; k++) {
		    this.appearance_coordinates[i][j][k] = 0;
		}
	    }
	}

	this.offset = new double[2];
	offset[0] = x;
	offset[1] = y;

	this.font_coordinates = new double[2];
	this.real_font_coordinates = new int[2];
	this.font_matrix = new Matrix_3x3();
	this.real_font_matrix = new Matrix_3x3();
	this.message = msg;

	font_coordinates[0] = -5.0 * scale;
	font_coordinates[1] = -5.0 * scale;

	font_matrix.identity();
    }

    public Color getColor() {
	return this.c;
    }

    public int[] getFontCoordinates(int screenWidth, int screenHeight) {
	int i, j;
	double [] cord;
	this.real_font_matrix.copyFromMatrix(this.font_matrix);
	this.real_font_matrix.translate2D(offset);
	this.real_font_matrix.mathToApplet(screenWidth, screenHeight);
	cord = this.real_font_matrix.transform(this.font_coordinates[0], this.font_coordinates[1]);
	this.real_font_coordinates[0] = (int)Math.round(cord[0]);
	this.real_font_coordinates[1] = (int)Math.round(cord[1]);
	return this.real_font_coordinates;
    }

    public int[][][] getHouseCoordinates(int screenWidth, int screenHeight) {
	int i, j;
	double [] cord;
	this.viewing_matrix.identity();
	for (i = NUM_POLYGONS - 1; i >= 0; i--) {
	    this.viewing_matrix.copyFromMatrix(this.polygon_matrices[i]);
	    this.viewing_matrix.translate2D(offset);
	    this.viewing_matrix.mathToApplet(screenWidth, screenHeight);
	    for (j = 0; j < this.initial_coordinates[i][0].length; j++) {
		cord = this.viewing_matrix.transform(this.initial_coordinates[i][0][j], this.initial_coordinates[i][1][j]);
		this.appearance_coordinates[i][0][j] = (int)Math.round(cord[0]);
		this.appearance_coordinates[i][1][j] = (int)Math.round(cord[1]);
	    }
	}
	return this.appearance_coordinates;
    }
}
