/*
 * Decompiled with CFR 0.152.
 */
package nyu.hps.notipping.web;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import nyu.hps.notipping.web.HelpFrame;
import nyu.hps.notipping.web.Move;
import nyu.hps.notipping.web.Weight;
import optimalMove.NotippingAutoPlayer;

public class NoTippingComponent
extends Component
implements MouseListener,
MouseMotionListener,
ActionListener {
    private int width;
    private int height;
    private int meter;
    private int ss_width;
    private int horizon;
    private int ss_height;
    private int f_height;
    private Vector weights;
    private int weight_selected;
    private int selected_x;
    private int selected_y;
    private int whose_turn;
    private int left_torque;
    private int right_torque;
    private boolean game_over;
    private Stack moves;
    private int phase;
    private int num_on_grass;
    private int who_lost;
    private BufferedImage image;
    private HelpFrame help_frame;
    public String player1 = "human";
    public String player2 = "computer";
    boolean showhint = false;
    int difficulty = 0;
    int max_seconds = 3;
    int currentgame = 0;
    NotippingAutoPlayer comp_player = null;
    String hint = "";
    private Button startb = null;
    private int last_weight;
    private int last_position;
    private int last_player;
    private int max_weights = 10;
    private int max_positions = 15;

    private Rectangle computeRectangle(Weight w) {
        int h = w.w * 2 + 17;
        if (w.place == 0) {
            if (w.whose == 0) {
                return new Rectangle(20 * w.w + 10, 15 + (8 - w.w) * 2, 12, h);
            }
            return new Rectangle(this.width - 20 * (10 - w.w) - 20, 15 + (8 - w.w) * 2, 12, h);
        }
        if (w.place == 1) {
            return new Rectangle(this.screen_x(w.position) - 6, this.horizon - this.ss_height - this.f_height - h, 12, h);
        }
        return new Rectangle(20 * w.position + 10, this.height - 40 + (8 - w.w) * 2, 12, h);
    }

    public void setPlayers(int game) {
        switch (game) {
            case 0: {
                System.out.println("human vs computer");
                this.player1 = "human";
                this.player2 = "computer";
                this.comp_player = new NotippingAutoPlayer(2, this.max_seconds);
                this.comp_player.setMaxWeights(this.max_weights);
                this.comp_player.start();
                break;
            }
            case 1: {
                System.out.println("computer vs human");
                this.player1 = "computer";
                this.player2 = "human";
                this.comp_player = new NotippingAutoPlayer(1, this.max_seconds);
                this.comp_player.setMaxWeights(this.max_weights);
                this.comp_player.start();
                break;
            }
            default: {
                System.out.println("human vs human");
                this.player1 = "human";
                this.player2 = "human";
            }
        }
        this.currentgame = game;
    }

    public void setDifficulty(int diff) {
        this.difficulty = diff;
        switch (this.difficulty) {
            case 0: {
                this.max_seconds = 3;
                break;
            }
            case 1: {
                this.max_seconds = 8;
                break;
            }
            case 2: {
                this.max_seconds = 15;
                break;
            }
            default: {
                this.max_seconds = 8;
            }
        }
        System.out.println("max_seconds=" + this.max_seconds);
    }

    public void actionPerformed(ActionEvent e) {
        System.out.println("actionPerformed(" + e.getActionCommand() + ")");
        if (e.getActionCommand().equals("NumWeights")) {
            JComboBox cb = (JComboBox)e.getSource();
            int idx = cb.getSelectedIndex();
            int theweights = idx + 5;
            if (theweights >= this.max_positions) {
                JOptionPane.showMessageDialog(null, "Invalid. There cannot be more weights than available slots " + theweights + "," + this.max_positions);
                cb.setSelectedIndex(this.max_weights - 5);
                return;
            }
            if (this.moves.size() != 0 && JOptionPane.showConfirmDialog(null, "Start New Game? Current game will be lost", "Confirmation", 2) != 0) {
                cb.setSelectedIndex(this.max_weights - 5);
                return;
            }
            this.max_weights = idx + 5;
            this.begin();
            this.update(this.getGraphics());
            return;
        }
        if (e.getActionCommand().equals("SeesawLength")) {
            JComboBox cb = (JComboBox)e.getSource();
            int idx = cb.getSelectedIndex();
            int thepos = idx + 5;
            if (this.max_weights >= thepos) {
                JOptionPane.showMessageDialog(null, "Invalid. There cannot be more weights than available slots " + this.max_weights + "," + thepos);
                cb.setSelectedIndex(this.max_positions - 5);
                return;
            }
            if (this.moves.size() != 0 && JOptionPane.showConfirmDialog(null, "Start New Game? Current game will be lost", "Confirmation", 2) != 0) {
                cb.setSelectedIndex(this.max_positions - 5);
                return;
            }
            this.max_positions = idx + 5;
            this.begin();
            this.update(this.getGraphics());
            return;
        }
        if (e.getActionCommand().equals("Difficulty")) {
            JComboBox cb = (JComboBox)e.getSource();
            int idx = cb.getSelectedIndex();
            if (this.moves.size() != 0 && JOptionPane.showConfirmDialog(null, "Start New Game? Current game will be lost", "Confirmation", 2) != 0) {
                cb.setSelectedIndex(this.currentgame);
                return;
            }
            this.setDifficulty(idx);
            this.setPlayers(this.currentgame);
            this.begin();
            this.update(this.getGraphics());
            return;
        }
        if (e.getActionCommand().equals("GameType")) {
            JComboBox cb = (JComboBox)e.getSource();
            int idx = cb.getSelectedIndex();
            if (this.moves.size() != 0 && JOptionPane.showConfirmDialog(null, "Start New Game? Current game will be lost", "Confirmation", 2) != 0) {
                cb.setSelectedIndex(this.currentgame);
                return;
            }
            this.setPlayers(idx);
            this.begin();
            this.update(this.getGraphics());
            return;
        }
        if (e.getActionCommand().equals("Hint")) {
            if (this.currentgame == 2) {
                this.hint = "No hints for human vs human mode";
            } else if (this.isComputerMove()) {
                this.hint = "Not your move";
            } else if (this.comp_player != null) {
                String state = this.getCurrentState();
                this.hint = "Hint: " + this.comp_player.getHint(state);
            } else {
                this.hint = "Hint on First move? Common! Use Put 3 at -1";
            }
            this.showhint = true;
            this.paint(this.getGraphics());
            return;
        }
        if (e.getActionCommand().equals("Undo")) {
            System.out.println("Undo");
            if (this.moves.size() == 0) {
                return;
            }
            Move m = (Move)this.moves.pop();
            if (this.phase == 1) {
                --this.num_on_grass;
            }
            if (this.moves.size() == 13) {
                this.phase = 0;
            }
            this.whose_turn = 1 - this.whose_turn;
            Weight w = (Weight)this.weights.get(m.w_index);
            if (m.position == -1) {
                w.place = 0;
            } else {
                w.place = 1;
                w.position = m.position;
            }
            if (this.game_over) {
                this.game_over = false;
                int n = this.weights.size() - 1;
                int i = 0;
                while (i < n) {
                    w = (Weight)this.weights.get(i);
                    w.do_draw = true;
                    ++i;
                }
            }
            this.update(this.getGraphics());
            return;
        }
        if (e.getActionCommand().equals("Restart")) {
            if (this.moves.size() == 0 || JOptionPane.showConfirmDialog(null, "Start New Game? Current game will be lost", "Confirmation", 2) == 0) {
                this.startb = (Button)e.getSource();
                this.begin();
                this.startb.setLabel("Restart");
                this.play1();
                this.update(this.getGraphics());
            }
            return;
        }
        if (e.getActionCommand().equals("Help")) {
            this.help_frame.setVisible(true);
        }
        String s = e.getActionCommand();
        this.makethemove(s);
    }

    public String getCurrentState() {
        String state = "";
        state = this.phase == 0 ? "ADD|" : "REMOVE|";
        int xx = 0;
        while (xx < this.weights.size()) {
            Weight w = (Weight)this.weights.get(xx);
            if (w.place == 1 && w.do_draw) {
                state = String.valueOf(state) + w.w + "," + w.position + " ";
            }
            ++xx;
        }
        state = String.valueOf(state) + "|";
        state = String.valueOf(state) + "in=" + this.right_torque + ",out=" + this.left_torque;
        System.out.println(state);
        return state;
    }

    public void makethemove(String s) {
        if (this.phase == 0) {
            Weight w;
            int i = s.indexOf(44);
            if (i == -1) {
                System.out.println("Syntax Error");
                return;
            }
            String s1 = s.substring(0, i);
            String s2 = s.substring(i + 1, s.length());
            int wt = new Integer(s1);
            int p = new Integer(s2);
            int n = this.weights.size() - 1;
            i = 0;
            while (i < n) {
                w = (Weight)this.weights.get(i);
                if (w.position == p && w.place == 1) {
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < n) {
                w = (Weight)this.weights.get(i);
                if (wt == w.w && w.whose == this.whose_turn && w.place == 0) {
                    w.place = 1;
                    w.position = p;
                    this.moves.push(new Move(i, this.whose_turn, -1));
                    if (this.moves.size() == this.max_weights * 2) {
                        ++this.phase;
                    }
                    this.last_player = this.whose_turn;
                    this.last_weight = wt;
                    this.last_position = p;
                    this.whose_turn = 1 - this.whose_turn;
                    this.update(this.getGraphics());
                    return;
                }
                ++i;
            }
        } else {
            System.out.println("************Using this for removing....." + s);
            System.out.println("Player=" + this.whose_turn);
            int i = s.indexOf(44);
            if (i == -1) {
                System.out.println("Syntax Error");
                return;
            }
            String s1 = s.substring(0, i);
            String s2 = s.substring(i + 1, s.length());
            int wt = new Integer(s1);
            int p = new Integer(s2);
            int n = this.weights.size() - 1;
            i = 0;
            while (i < n) {
                Weight w = (Weight)this.weights.get(i);
                if (w.w == wt && w.position == p && w.place == 1) {
                    w.place = 2;
                    this.moves.push(new Move(i, this.whose_turn, w.position));
                    w.position = this.num_on_grass++;
                    this.last_player = this.whose_turn;
                    this.last_weight = wt;
                    this.last_position = p;
                    this.whose_turn = 1 - this.whose_turn;
                    this.update(this.getGraphics());
                    return;
                }
                ++i;
            }
        }
    }

    public Dimension getPreferredSize() {
        System.out.println("getPreferredSize()");
        return new Dimension(500, 300);
    }

    public void setSize(Dimension d) {
        System.out.println("setSize(Dimension)");
        this.setSize(d.width, d.height);
    }

    public void setSize(int width, int height) {
        System.out.println("setSize(int, int)");
        this.width = width;
        this.height = height;
        super.setSize(width, height);
    }

    public void setBounds(Rectangle r) {
        System.out.println("setBounds(Rectangle)");
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        System.out.println("setBounds(" + x + ", " + y + ", " + width + ", " + height + ")");
        if (this.width == width && this.height == height) {
            return;
        }
        this.width = width;
        this.height = height;
        super.setBounds(x, y, width, height);
        this.image = new BufferedImage(width, height, 1);
    }

    public NoTippingComponent() {
        System.out.println("NoTippingComponent() v1.4");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.help_frame = new HelpFrame();
        this.help_frame.setVisible(false);
        this.begin();
    }

    public void update(Graphics g) {
        System.out.println("update(Graphics()");
        this.paint(g);
    }

    private void begin() {
        Weight w;
        this.weights = new Vector();
        this.weight_selected = -1;
        this.whose_turn = 0;
        this.game_over = false;
        this.moves = new Stack();
        this.phase = 0;
        this.num_on_grass = 0;
        int i = 1;
        while (i <= this.max_weights) {
            w = new Weight(i, 0, 0, 0);
            this.weights.add(w);
            w = new Weight(i, 1, 0, 0);
            this.weights.add(w);
            ++i;
        }
        this.weights.add(new Weight(3, 2, 1, -4));
        w = new Weight(3, 2, 1, 0);
        w.do_draw = false;
        this.weights.add(w);
        this.last_weight = -1;
        this.last_position = -999;
        this.last_player = -999;
        if (this.startb != null) {
            this.startb.setLabel("Start");
        }
    }

    public void play1() {
        if (this.currentgame == 1) {
            try {
                String state = this.getCurrentState();
                String the_move = this.comp_player.getMove(state);
                String[] wt_pos = the_move.split(",");
                Weight w1 = new Weight(Integer.parseInt(wt_pos[0]), this.whose_turn, 0, 0);
                Rectangle source = this.computeRectangle(w1);
                this.mousePressed(new MouseEvent(this, 501, (int)System.currentTimeMillis(), 1040, (int)source.getCenterX(), (int)source.getCenterY(), 1, false, 1));
                this.makethemove(the_move);
                int destX = this.screen_x(Integer.parseInt(wt_pos[1]));
                int destY = this.horizon - this.ss_height - this.f_height - 15;
                this.generateMouseMovements((int)source.getCenterX(), (int)source.getCenterY(), destX, destY);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void repaint() {
        System.out.println("repaint()");
    }

    public void paint(Graphics real_g) {
        Color c;
        Weight w;
        System.out.println("paint(Graphics)");
        this.horizon = this.height * 4 / 5;
        this.ss_height = this.height / 16;
        this.f_height = this.height / 10;
        this.ss_width = this.width - 100 + 16;
        this.meter = (this.ss_width - 16) / 30;
        int n = this.weights.size();
        this.left_torque = 0;
        this.right_torque = 0;
        int i = 0;
        while (i < n) {
            w = (Weight)this.weights.get(i);
            if (w.place == 1) {
                this.left_torque -= (w.position - -3) * w.w;
                this.right_torque -= (w.position - -1) * w.w;
            }
            ++i;
        }
        if (this.left_torque > 0 || this.right_torque < 0) {
            if (!this.game_over) {
                this.who_lost = 1 - this.whose_turn;
                i = 0;
                while (i < n) {
                    w = (Weight)this.weights.get(i);
                    if (w.place == 0) {
                        w.do_draw = false;
                    }
                    ++i;
                }
            }
            this.game_over = true;
        }
        Graphics2D g = this.image.createGraphics();
        g.setColor(new Color(140, 150, 200));
        g.drawRect(0, 0, this.width, this.height);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(new Color(250, 240, 230));
        g.fillOval(this.width - 100, 20, 50, 30);
        g.fillOval(this.width - 80, 30, 50, 30);
        g.fillOval(this.width - 90, 25, 40, 36);
        g.fillOval(this.width - 150, 15, 60, 40);
        g.fillOval(this.width - 160, 25, 50, 35);
        g.fillOval(this.width - 130, 30, 55, 35);
        g.fillOval(this.width - 50, 10, 40, 30);
        g.fillOval(this.width - 65, 15, 45, 35);
        g.fillOval(this.width - 130, 10, 80, 30);
        g.setColor(new Color(0, 255, 0));
        g.drawRect(0, this.horizon, this.width - 1, this.height - this.horizon);
        g.setColor(new Color(0, 255, 0));
        g.fillRect(0, this.horizon, this.width - 1, this.height - this.horizon);
        g.setColor(new Color(180, 120, 0));
        i = 0;
        while (i < 5) {
            g.drawLine(this.screen_x(-3) - i, this.horizon, this.screen_x(-3), this.horizon - this.f_height);
            g.drawLine(this.screen_x(-3), this.horizon - this.f_height, this.screen_x(-3) + i, this.horizon);
            g.drawLine(this.screen_x(-1) - i, this.horizon, this.screen_x(-1), this.horizon - this.f_height);
            g.drawLine(this.screen_x(-1), this.horizon - this.f_height, this.screen_x(-1) + i, this.horizon);
            ++i;
        }
        g.setColor(new Color(0, 0, 0));
        Font f = g.getFont();
        String left_s = Integer.toString(this.left_torque);
        String right_s = Integer.toString(this.right_torque);
        Graphics2D g2 = g;
        FontRenderContext frc = g2.getFontRenderContext();
        int s_width = (int)f.getStringBounds(left_s, frc).getWidth();
        int s_height = (int)f.getStringBounds(left_s, frc).getHeight();
        ((Graphics)g).drawString(left_s, this.screen_x(-3) - s_width / 2, this.horizon + s_height + 3);
        s_width = (int)f.getStringBounds(right_s, frc).getWidth();
        s_height = (int)f.getStringBounds(right_s, frc).getHeight();
        ((Graphics)g).drawString(right_s, this.screen_x(-1) - s_width / 2, this.horizon + s_height + 3);
        if (this.showhint) {
            ((Graphics)g).drawString(this.hint, 30, 120);
            this.showhint = false;
        }
        if (this.game_over) {
            Font font = new Font("SansSerif", 1, 30);
            Font old_f = g.getFont();
            g.setFont(font);
            ((Graphics)g).drawString("Bummer, dude", 30, 100);
            if (this.who_lost == 0) {
                ((Graphics)g).drawString("Red lost :(", 30, 140);
            } else {
                ((Graphics)g).drawString("Blue lost :(", 30, 140);
            }
            g.setFont(old_f);
            double theta = 0.0;
            int rotate_x = 0;
            if (this.left_torque > 0) {
                theta = -Math.atan((double)this.f_height / (double)(this.screen_x(-3) - this.screen_x(-10) + 8));
                rotate_x = this.screen_x(-3);
            }
            if (this.right_torque < 0) {
                theta = Math.atan((double)this.f_height / (double)(this.screen_x(10) - this.screen_x(-1) + 8));
                rotate_x = this.screen_x(-1);
            }
            System.out.println("theta is " + theta);
            System.out.println("taking atan of " + (double)this.f_height / (double)(this.screen_x(10) - this.screen_x(-1) + 8));
            g2.rotate(theta, rotate_x, this.horizon - this.f_height);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g2.setColor(new Color(230, 235, 240));
        g2.fillRect(42, this.horizon - this.ss_height - this.f_height, this.ss_width, this.ss_height);
        g2.setColor(new Color(60, 20, 0));
        i = -1 * this.max_positions;
        while (i <= this.max_positions) {
            if (i == this.last_position) {
                g2.drawLine(this.screen_x(i), this.horizon - this.ss_height - this.f_height, this.screen_x(i), this.horizon - this.f_height - this.ss_height * 15 / 4);
            } else {
                g2.drawLine(this.screen_x(i), this.horizon - this.ss_height - this.f_height, this.screen_x(i), this.horizon - this.f_height - this.ss_height * 3 / 4);
            }
            String s = "";
            f = g.getFont();
            int font_width = (int)f.getStringBounds(s, g2.getFontRenderContext()).getWidth();
            if (i % 2 == 0 && Math.abs(i) != this.max_positions) {
                s = new String(Integer.toString(i));
            }
            if (i == this.last_position) {
                s = String.valueOf(s) + "*";
            }
            g2.drawString(s, this.screen_x(i) - font_width / 2, this.horizon - this.f_height - 1);
            ++i;
        }
        n = this.weights.size();
        i = 0;
        while (i < n) {
            Weight w2 = (Weight)this.weights.get(i);
            switch (w2.whose) {
                case 0: {
                    c = new Color(200, 0, 0);
                    break;
                }
                case 1: {
                    c = new Color(0, 0, 200);
                    break;
                }
                default: {
                    c = new Color(0, 180, 0);
                }
            }
            g2.setColor(c);
            Rectangle r = this.computeRectangle(w2);
            if (w2.do_draw && (!this.game_over || w2.place == 1)) {
                g2.fillRect(r.x, r.y, r.width, r.height);
                g2.setColor(new Color(255, 255, 255));
                g2.drawString(Integer.toString(w2.w), r.x + 2, r.y + r.height - 2);
            }
            ++i;
        }
        if (this.weight_selected >= 0) {
            Color c2;
            Weight w3 = (Weight)this.weights.get(this.weight_selected);
            switch (w3.whose) {
                case 0: {
                    c2 = new Color(200, 0, 0);
                    break;
                }
                case 1: {
                    c2 = new Color(0, 0, 200);
                    break;
                }
                default: {
                    c2 = new Color(0, 180, 0);
                }
            }
            g2.setColor(c2);
            Rectangle r = new Rectangle(this.selected_x, this.selected_y, 12, w3.w * 2 + 17);
            g2.fillRect(r.x, r.y, r.width, r.height);
            g2.setColor(new Color(255, 255, 255));
            g2.drawString(Integer.toString(w3.w), r.x + 2, r.y + r.height - 2);
        }
        if (!this.game_over) {
            String s;
            if (this.whose_turn == 0) {
                c = new Color(150, 0, 0);
                s = new String("It's Red's turn");
            } else {
                c = new Color(0, 0, 150);
                s = new String("It's Blue's turn");
            }
            g.setColor(c);
            ((Graphics)g).drawString(s, 30, 70);
            c = new Color(0, 0, 0);
            g.setColor(c);
            s = this.phase == 0 ? new String("Adding phase") : new String("Removing phase");
            ((Graphics)g).drawString(s, 30, 90);
        }
        real_g.drawImage(this.image, 0, 0, null);
    }

    public boolean isComputerMove() {
        return this.whose_turn == 1 && this.player2.equals("computer") || this.whose_turn == 0 && this.player1.equals("computer");
    }

    public void mouseDragged(MouseEvent e) {
        System.out.println("mouseDragged(MouseEvent)");
        int x = e.getX();
        int y = e.getY();
        if (x < 0) {
            x = 0;
        }
        if (x >= this.width) {
            x = this.width - 1;
        }
        if (y < 0) {
            y = 0;
        }
        if (y >= this.height) {
            y = this.height - 1;
        }
        if (this.weight_selected < 0) {
            return;
        }
        Weight w = (Weight)this.weights.get(this.weight_selected);
        int h = w.w * 2 + 17;
        this.selected_x = x - 6;
        this.selected_y = y - h / 2;
        this.update(this.getGraphics());
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        System.out.println("mousePressed(MouseEvent)");
        if (this.isComputerMove()) {
            return;
        }
        int n = this.weights.size();
        int i = 0;
        while (i < n) {
            Weight w = (Weight)this.weights.get(i);
            Rectangle r = this.computeRectangle(w);
            if (r.contains(e.getPoint()) && (w.whose == this.whose_turn || this.phase != 0)) {
                System.out.println("weight hit");
                this.weight_selected = i;
                w.do_draw = false;
                this.selected_x = r.x;
                this.selected_y = r.y;
                this.update(this.getGraphics());
                break;
            }
            ++i;
        }
    }

    public void mouseReleased(MouseEvent e) {
        System.out.println("mouseReleased(MouseEvent)");
        if (this.weight_selected < 0) {
            return;
        }
        Weight w = (Weight)this.weights.get(this.weight_selected);
        w.do_draw = true;
        Point p = e.getPoint();
        int top = this.horizon - this.ss_height - this.f_height - 40;
        Rectangle grass_rect = new Rectangle(0, this.horizon, this.width, this.height - this.horizon);
        if (grass_rect.contains(p)) {
            w.place = 2;
            this.moves.push(new Move(this.weight_selected, this.whose_turn, w.position));
            this.last_position = w.position;
            this.last_player = this.whose_turn;
            this.last_weight = w.w;
            w.position = this.num_on_grass++;
            this.whose_turn = 1 - this.whose_turn;
            this.weight_selected = -1;
            this.update(this.getGraphics());
        } else {
            int i = -1 * this.max_positions;
            while (i <= this.max_positions) {
                Rectangle r = new Rectangle(this.screen_x(i) - this.meter / 2, top, this.meter, 50);
                if (r.contains(p)) {
                    int n = this.weights.size() - 1;
                    int j = 0;
                    while (j < n) {
                        Weight w2 = (Weight)this.weights.get(j);
                        if (w2.place == 1 && w2.position == i) {
                            this.weight_selected = -1;
                            this.update(this.getGraphics());
                            return;
                        }
                        ++j;
                    }
                    w.place = 1;
                    w.position = i;
                    this.moves.push(new Move(this.weight_selected, this.whose_turn, -1));
                    if (this.moves.size() == this.max_weights * 2) {
                        ++this.phase;
                    }
                    this.last_position = w.position;
                    this.last_player = this.whose_turn;
                    this.last_weight = w.w;
                    this.whose_turn = 1 - this.whose_turn;
                    break;
                }
                ++i;
            }
            this.weight_selected = -1;
            this.update(this.getGraphics());
        }
        if (this.isComputerMove()) {
            if (this.comp_player == null) {
                this.comp_player = new NotippingAutoPlayer(2, this.max_seconds);
                this.comp_player.setMaxWeights(this.max_weights);
                this.comp_player.start();
            }
            String state = this.getCurrentState();
            String the_move = this.comp_player.getMove(state);
            String[] wt_pos = the_move.split(",");
            Weight w1 = new Weight(Integer.parseInt(wt_pos[0]), this.whose_turn, 0, 0);
            Rectangle source = this.computeRectangle(w1);
            this.mousePressed(new MouseEvent(this, 501, (int)System.currentTimeMillis(), 1040, (int)source.getCenterX(), (int)source.getCenterY(), 1, false, 1));
            this.makethemove(the_move);
            int destX = this.screen_x(Integer.parseInt(wt_pos[1]));
            int destY = this.horizon - this.ss_height - this.f_height - 15;
            try {
                this.generateMouseMovements((int)source.getCenterX(), (int)source.getCenterY(), destX, destY);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void generateMouseMovements(int x1, int y1, int x2, int y2) throws Exception {
        int t = 1500;
        double cx = x1;
        double cy = y1;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double d12y = (y1 + y2) / 2;
        double vx = dx / (double)t;
        double vy = dy / (double)t;
        do {
            Thread.sleep(30L);
            cy = d12y;
            this.mouseDragged(new MouseEvent(this, 506, (int)System.currentTimeMillis(), 1040, (int)cx, (int)cy, 1, false, 0));
        } while (cy != d12y);
        do {
            Thread.sleep(30L);
            cx = x2;
            this.mouseDragged(new MouseEvent(this, 506, (int)System.currentTimeMillis(), 1040, (int)cx, (int)cy, 1, false, 0));
        } while (cx != (double)x2);
        do {
            Thread.sleep(30L);
            cy = y2;
            this.mouseDragged(new MouseEvent(this, 506, (int)System.currentTimeMillis(), 1040, (int)cx, (int)cy, 1, false, 0));
        } while (cy != (double)y2);
        this.mouseReleased(new MouseEvent(this, 502, (int)System.currentTimeMillis(), 16, (int)cx, (int)cy, 1, false, 1));
    }

    private int screen_x(int meters) {
        return 42 + this.ss_width / 2 + meters * this.meter;
    }
}

