/*
 * Decompiled with CFR 0.152.
 */
package optimalMove;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import optimalMove.AddPhaseState;
import optimalMove.Constants;
import optimalMove.LeveledGameGraph;
import optimalMove.Ply;
import optimalMove.rPhaseState;
import optimalMove.weightPlacement;

public class Client {
    public static int MAXSECONDS;

    public static void main(String[] args) throws Exception {
        String fromServer;
        Socket socket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        String tag = args[0];
        String ply_order = args[1];
        String max_seconds = args[2];
        String addition_phase_behavior = args[3];
        MAXSECONDS = Integer.parseInt(max_seconds);
        Ply.Ownership first_turn = null;
        if (ply_order.startsWith("1")) {
            first_turn = Ply.Ownership.Mine;
        } else if (ply_order.startsWith("2")) {
            first_turn = Ply.Ownership.Opponents;
        }
        try {
            socket = new Socket("localhost", 4445);
            out = new PrintWriter(socket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host: localhost.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: localhost.");
            System.exit(1);
        }
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
        out.println(tag);
        AddPhaseState root_state = new AddPhaseState(first_turn);
        while ((fromServer = in.readLine()) != null) {
            System.out.println("Server: " + fromServer);
            if (fromServer.equals("Bye")) break;
            if (!fromServer.startsWith("ADD") && !fromServer.startsWith("REMOVE")) continue;
            String delims = "\\|";
            String[] tokens = fromServer.split(delims);
            String phase = tokens[0];
            String weights_string = tokens[1];
            delims = "[ ]+";
            String[] weights_array = weights_string.split(delims);
            TreeMap<Integer, Integer> wp = new TreeMap<Integer, Integer>();
            int i = 0;
            while (i < weights_array.length) {
                delims = ",";
                String[] wt_string = weights_array[i].split(delims);
                wp.put(Integer.parseInt(wt_string[1]), Integer.parseInt(wt_string[0]));
                ++i;
            }
            weightPlacement next_move = new weightPlacement(0, 0);
            if (phase.equals("ADD")) {
                for (Map.Entry entry : wp.entrySet()) {
                    if ((Integer)entry.getKey() == -4 || !root_state.empty_positions.contains(entry.getKey())) continue;
                    weightPlacement one_weight = new weightPlacement((Integer)entry.getValue(), (Integer)entry.getKey());
                    root_state.add_weight_verbose(one_weight);
                    System.out.println();
                    root_state.display();
                    System.out.println();
                    root_state.torques.display();
                }
                int num_children = root_state.num_nontipping_addition_children();
                if (num_children > 0) {
                    ArrayList<weightPlacement> moves;
                    if (addition_phase_behavior.startsWith("Random")) {
                        moves = root_state.non_tipping_addition_moves();
                        Random generator = new Random();
                        int randomIndex = generator.nextInt(num_children);
                        next_move = moves.get(randomIndex);
                    } else {
                        moves = root_state.non_tipping_addition_moves();
                        next_move = moves.get(0);
                        int curr_min_children = Constants.MAXINT;
                        int move_idx = 0;
                        while (move_idx < moves.size()) {
                            weightPlacement curr_move = moves.get(move_idx);
                            AddPhaseState curr_child = new AddPhaseState(root_state);
                            curr_child.add_weight(curr_move);
                            int curr_children = curr_child.num_nontipping_addition_children();
                            if (curr_children < curr_min_children) {
                                curr_min_children = curr_children;
                                next_move = curr_move;
                            }
                            ++move_idx;
                        }
                    }
                } else if (num_children == 0) {
                    next_move = root_state.a_legal_move();
                }
                root_state.add_weight_verbose(next_move);
                System.out.println();
                root_state.display();
                System.out.println();
                root_state.torques.display();
            } else if (phase.equals("REMOVE")) {
                rPhaseState initial_state = new rPhaseState(wp);
                initial_state.next_ply.Whose = Ply.Ownership.Mine;
                initial_state.weight_bounds = initial_state.torques.wb_lookup();
                int num_children = initial_state.num_nontipping_children();
                if (num_children > 0) {
                    LeveledGameGraph test_graph = new LeveledGameGraph(initial_state);
                    rPhaseState next_child = test_graph.timed_Expand_Eval_Verbose(initial_state, 0);
                    int next_move_location = initial_state.removal_needed(next_child);
                    int next_move_weight = (Integer)initial_state.weight_positions.get(next_move_location);
                    next_move = new weightPlacement(next_move_weight, next_move_location);
                } else if (num_children == 0) {
                    next_move = initial_state.a_legal_move();
                }
            }
            String fromUser = next_move.server_string();
            if (fromUser == null) continue;
            out.println(fromUser);
        }
        out.close();
        in.close();
        stdIn.close();
        socket.close();
    }
}

