#ifndef VFLIBRARY_H
#define VFLIBRARY_H

#include <iostream>
#include <string>

#include <argraph.h>
#include <argedit.h>

using namespace std;

//namespace VFlibrary{

typedef ARGraph<string,void> MyARGraph;

class VStringDestroyer: public AttrDestroyer{
public:
	virtual void destroy(void *p){
		delete p;
	};
};
class VStringComparator: public AttrComparator{
public:
	virtual bool compatible(void* pa, void* pb){
		string* a=(string*)pa;
		string* b=(string*)pb;
//		std::cout<<*a<<":"<<*b<<"\n";
		//string c="a";
		return !(a->compare(*b));
	};
};


class VIntComparator: public AttrComparator{
public:
	virtual bool compatible(void* attr1, void* attr2){
		int* a=(int*)attr1;
		int* b=(int*)attr2;
		return !(((*a)-(*b))==0);
	};
};

bool read_graph_vf_gff(std::ifstream& in, ARGEdit& ed){
	enum State {
		AttendGraph,
		LoadNumNodes,
		LoadNodes,
		LoadNumEdges,
		LoadEdges,
		End
	} //state = AttendGraph;
	state=LoadNumNodes;
	enum EState{
		FirstEdge,
		SecondEdge
	} estate=FirstEdge;

	string s;
	int itemcount=0, i=0;
	int firste, seconde;
	while(!in.eof() && state!=End){
		in>>s;
		//std::cout<<"-"<<s<<"\n";
		if(s=="")
			return false;
		switch (state){
			/*case AttendGraph:{
				if(s[0]=='#'){
					//std::cout<<"graph name:"<<s<<"\n";
					//_graph.name=s;
					state=LoadNumNodes;
				}
				else{
					return false;
				}
				break;
			}*/
			case LoadNumNodes:{
				itemcount=atoi(s.c_str());
				if(itemcount==0)
					return false;
				i=0;
				state=LoadNodes;
				break;
			}
			case LoadNodes:{
				ed.InsertNode(new string(s));
				i++;
				if(i>=itemcount)
					state=LoadNumEdges;

				break;
			}
			case LoadNumEdges:{
				itemcount=atoi(s.c_str());
				if(itemcount==0)
					return false;
				i=0;
				state=LoadEdges;
				break;
			}
			case LoadEdges:{
				if(estate==FirstEdge){
					firste=atoi(s.c_str());
					estate=SecondEdge;
				}
				else{
					seconde=atoi(s.c_str());
					ed.InsertEdge(firste, seconde, NULL);
					ed.InsertEdge(seconde, firste, NULL);
					estate=FirstEdge;
					i++;
				}
				if(i>=itemcount){
					state=End;
				}
				break;
			}
		}
	}

	return true;
};

//}

#endif
