// GraphFindConsole.cpp : file di progetto principale.

#include <iostream>
#include <fstream>
#include <iomanip>
#include <map>

#include "graph_path_finder.h"
#include "graph_search_utility.h"
#include "graph_reader.h"
#include "db_functions.h"
#include "OCP_Tree.h"
#include "GraphGrepSXLibrary.h"
#include <boost/graph/adjacency_list.hpp>

#include <VFlibrary.h>
#include <match_vf.h>

bool graph_build(const string &input_network_file);
bool graph_find(const string &input_network_file, const string &query_graph_file);
void usage();

int main(int argc, char* argv[])
{
	if(argc<2)
	{
		cout<<"\nToo few parameters.\n"<<endl;
		usage();
		return 0;
	}


	string cmd = argv[1];

	if(cmd=="-f" && argc==4){
		//esegui la query
		if(!graph_find(argv[2], argv[3]))
			cout<<"Errore irreversibile. Impossibile individuare i candidati."<<endl;
	}
	else if(cmd=="-b" && argc==3){
		//costrisci l'albero e salvalo
		if(!graph_build(argv[2]))
				cout<<"Errore irreversibile. Impossibile creare il database."<<endl;
	}
	else{
		usage();
	}
};

bool graph_build(const string &input_network_file){
	string database_file = "database.data";

	std::cout<<"Building index...";
	
	OCP_Tree* index_tree=new OCP_Tree();
	TIMEHANDLE start = start_time();
	
	if(!db_create(input_network_file, index_tree))
		return false;
//	index_tree->print();
	
	double time = end_time(start);

	std::cout<<" Done! #"<<time<<endl;
	std::cout<<"Saving DB...";
	
	start = start_time();
	if(!db_save(database_file, index_tree))
	{
		std::cout<< "Impossibile salvare il db: '" << database_file.c_str() << "'" << endl;
		return false;
	}

	time = end_time(start);
	std::cout<<" Done! #"<<time<<endl;
	return true;
}

bool graph_find(const string &input_network_file, const string &query_graph_file){
	TIMEHANDLE totstart=start_time();
	string database_file = "database.data";
	
	std::cout<<"Loading db...";
	OCP_Tree* index_tree=new OCP_Tree();
	TIMEHANDLE start = start_time();
	db_load(index_tree, database_file);
	double time = end_time(start);
	std::cout<<"Done! #"<<time<<endl;
	
	std::cout<<"Candidates....";
	graph_t query_graph;
	if(!db_query_load(query_graph_file, query_graph))
		return false;

	OCP_Tree* q_index_tree=new OCP_Tree();;
	db_query_build(query_graph, q_index_tree);
	std::cout<<"Done! "<<endl;

	std::cout<<"Filtering...";
	graph_set_t set;	
	//for(int i=0;i<index_tree->total_graph_count;i++)
	//	set.insert(i);
	start = start_time();
	db_query_run(index_tree, q_index_tree, set); 
	time = end_time(start);
	std::cout<<"Done! #"<<time<<endl;

	/*db_query_out(set);
	cout<<"VentoDB...";
	start = start_time();
	db_cache my_db_cache;
	my_db_cache.load_db(input_network_file);
	if(!db_filter_by_cache(my_db_cache, set))
	{
		std::cout<<"Errore nella creazione del VentoDB."<<endl;
		return false;
	}
	time = end_time(start);
	std::cout<<" Done! #"<<time<<endl;

	//Run vento for matching
	vento_run(query_graph_file);
	//Extract matching time from file
	time = get_vento_time();
	if(time==-1)
	cout<<"Errore nell'esecuzione del matching"<<endl;
	std::cout<<std::setprecision(3)<<
	"#Matching_time: "<<time<<endl;
	*/

	std::cout<<"Loading query: vflib2...";
	string s;
	std::ifstream qin;
	qin.open(query_graph_file.c_str(), ios_base::in);
	qin>>s;//per saltare #graphname
	ARGEdit *qedit=new ARGEdit();
	read_graph_vf_gff(qin, *qedit);
	MyARGraph* qgraph=new MyARGraph(qedit);
	qgraph->SetNodeComparator(new VStringComparator());
	std::cout<<"Done! "<<endl;


	std::set<graph_index_t>::iterator setit=set.begin();
	std::set<graph_index_t>::iterator setend=set.end();

	std::cout<<"vflib2 Matching..."<<endl;
	TIMEHANDLE mtime; double mtimetot=0;
	//start=start_time();
	std::ifstream dbin;
	dbin.open(input_network_file.c_str(), ios_base::in);
//	string s;
	int cindex=0;
	while(!dbin.eof() && setit!=setend){
		dbin>>s;
		if(s[0]=='#'){
			std::cout<<"#"<<cindex<<"\n";
			if(cindex==*setit){
				ARGEdit* ed=new ARGEdit();;
				if(read_graph_vf_gff(dbin, *ed)){
					MyARGraph* g=new MyARGraph(ed);
					mtime=start_time();
					matchvf_monostate(qgraph, g);
					mtimetot+=end_time(mtime);
				}
				setit++;
			}
			cindex++;
		}
	}
	dbin.close();
	//end=end_time(start);
	std::cout<<"Done! #"<<mtimetot<<endl;

	double totend=end_time(totstart);
	std::cout<<"Done! #"<<totend<<endl;
	return true;
};

void usage()
{
		cout<<"\nusage:"<<endl;
		cout<<"graphgrepsx_console -b db_file.txt \tBuild only"<<endl;
		cout<<"graphgrepsx_console -f db_file.txt query_file.txt\tQuery only"<<endl;
};
