#include <sys/types.h>
#include <iostream>
#include <fstream>
#include <time.h>
#include <errno.h>
#include <stdlib.h>
#include <string>
#include <map>
#include <vector>
#include <queue>
#include <assert.h>
#include <ctype.h>
#include <string>
#include <db_cxx.h>

//MAX Table name length and MAX line length
#define MAX_TABLENAME 128
#define MAX_LINE 1024

//int value of OP-commands
#define INTERSECT 0
#define TESTUNIQUE 1
#define SPIT 2
#define CARTESIANPRODUCT 3
#define SELECT 4

//used namespaces
using namespace std;
using std::vector;
using std::string;
using std::iterator;
using std::allocator;
using std::map;
using std::queue;
using std::deque;

//extern control flags
extern bool OUTPUT_DATA_COUNT;	//flag to control if showing the current matched record with each operation
extern bool QUIET_MODE;				//flag to control if showing the debug information
extern bool DEBUG_OPFILE;			//flag to control if showing the debug information of OPFILE

extern int DEFAULT_LP;					//The LP defination
extern int NUM_INTS;					//The Number of Intergers of a FingerPrint. Default is 256. Used in the Frowns Filtering process.
extern int INT_SIZE;						//The size of an int (in bits). Default is 32. Used in Frowns Filtering process.
extern int NUM_FP;						//The group size of fingerprints. Default is 4000. Used in Frowns Filtering process.

extern const string delims;				//The defination of th delims. Used in tools.cpp and opfile.cpp

typedef u_short NodeType;				//Defination of the NodeType
extern const int NodeTypeBitLen;			//The size of an NodeType (in bits). The information is needed when storing data into BekerlyDB

// Used for time measuing
typedef map<char*,double> clockmap;
extern clockmap v_clock_old;
extern clockmap v_clock_sum;
void setclock(char* name,int end_flag);
void printtime(char*name);

//used data-structures for storing data into DB
class PathTable;
class TableWithDegreePaths;
typedef map<string,PathTable*> Map_PathTable;							    
typedef map<string,TableWithDegreePaths*> Map_TableWithDegreePaths;         

//utility functions
vector<string> sep_words(const string& str);
NodeType* LoadTablefromDB(Db* db,const char* tablename);
NodeType* sep_DegreeString(const string& str,int lp);



