/*
  GraphBlast Algorithm
  interface.c responsible for interfacing to vflib
  Author: Diego Reforgiato Recupero
*/

#include "argraph.h"
#include "argedit.h"
#include "vf2_sub_state.h"
#include "vf_sub_state.h"
#include "vf_state.h"
#include "vf2_state.h"
#include "vf2_mono_state.h"
#include "vf_mono_state.h"
#include "match.h"
#//include "argloader.h"
#include <stdio.h>

using namespace std;
#include <iostream>
#include <fstream>

#define MAXNODES 5000

unsigned short read_word(FILE *in) { 
  unsigned char b1, b2;
  
  b1=getc(in); /* Least-significant Byte */
  b2=getc(in); /* Most-significant Byte */
  
  return b1 | (b2 << 8);
}

/* This function assumes that the adjacency matrix is statically allocated.
 * The return value is the number of nodes in the graph.
 */
int read_graph(FILE *in, char matrix[MAXNODES][MAXNODES]) { 
  int nodes;
  int edges;
  int target;
  int i, j;
  
  /* Read the number of nodes */
  nodes = read_word(in);
  
  /* Clean-up the matrix */
  for(i=0; i<nodes; i++)
    for(j=0; j<nodes; j++)
      matrix[i][j]=0;
  
  /* For each node i ... */
  for(i=0; i<nodes; i++) { 
    /* Read the number of edges coming out of node i */
    edges=read_word(in);
    
    /* For each edge out of node i... */
    for(j=0; j<edges; j++) { 
      /* Read the destination node of the edge */
      target = read_word(in);
      
      /* Insert the edge in the adjacency matrix */
      matrix[i][target] = 1;
    }
  }
  
  return nodes;
}

// print info
bool my_visitor(int n, node_id ni1[], node_id ni2[], void *usr_data) { 
  FILE *f = (FILE *)usr_data;
  
  // Prints the matched pairs on the file
  int i;
  for(i=0; i<n; i++)
    fprintf(f, "(%hd, %hd) ", ni1[i], ni2[i]);
  fprintf(f, "\n");
  
  // Return false to search for the next matching
  return false;
}

class Point {
 public: 
  char a[10];
  Point(char x[10]) {
    strcpy(this->a,x);
  }
};

//class PointDestroyer: public AttrDestroyer { 
// public:
// virtual void destroy(char *p) { 
//   free(p);
// }
//};

// Class Comparator required for vflib
class PointComparator: public AttrComparator {

 public:
  PointComparator() {
  }
  
  virtual bool compatible(void *pa, void *pb) {
    bool ret;
    char op = '0'; // 1:'<' 2:'<=' 3:'>' 4:'>=' 5:'!='
    int num = 0;
    int num1 = -1;
    int i = 0;
    if((char)((char *)pa)[0]=='<') {
      if((char)((char *)pa)[1]=='=') {
        op='2';
	num = atoi((char*)pa+2);
      }
      else {
	op='1';
	num = atoi((char*)pa+1);
      }
    }
    else
      if((char)((char *)pa)[0]=='>') {
	if((char)((char *)pa)[1]=='=') {
	  op='4';
	  num = atoi((char*)pa+2);
	}
	else {
	  op='3';
	  num = atoi((char*)pa+1);
	}
      }
      else
	if((char)((char *)pa)[0]=='!') {
	  if((char)((char *)pa)[1]=='=') {
	    op='5';
	    num = atoi((char*)pa+2);
	  }
	}
    while(i!=strlen((char *)pb)) {
      if(isdigit((char)((char *)pb)[i])==0)
	break;
      i++;
    }
    if(i==strlen((char *)pb))
      num1 = atoi((char *)pb);
    else
      if(op!='0')
	return false;
    switch(op) {
    case '0':
      if(!strcmp((char *)pa,(char *)pb))
	return true;
      else
	return false;
      break;
    case '1':
      if(num1 < num)
	return true;
      else
	return false;
      break;
    case '2':
      if(num1 <= num)
	return true;
      else
	return false;
      break;
    case '3':
      if(num1 > num)
	return true;
      else
	return false;
      break;
    case '4':
      if(num1 >= num)
	return true;
      else
	return false;
      break;
    case '5':
      if(num1 != num)
	return true;
      else
	return false;
      break;
    }
  }
};

// read Map file which contains graphs
void ReadMap(FILE *fp,int **M,int *cont_map) {
  int x;
  while(!feof(fp)) {
    *M = (int *)realloc(*M,sizeof(int)*((*cont_map)+1));
    fscanf(fp,"%d",&(*M)[(*cont_map)]);
    if(feof(fp))
      return;
    (*cont_map)++;
  }
}

int Find(int x,int *M,int cont_map) {
  int j;
  for(j=0;j<cont_map;j++) {
    if(M[j]==x)
      return 1;
  }
  return 0;
}

// internal method for translating index nodes from graphgrep representation to vf representation when acc_vf has been performed
int Load_Trans(int **trans) {
  int x,y;
  FILE *f=fopen(".//graphblastdata//translate.dat","r");
  if(f==NULL)
    return -1;
  while(!feof(f)) {
    fscanf(f,"%d %d",&x,&y);
    if(feof(f))
      break;
    *trans=(int *)realloc(*trans,sizeof(int)*(x+1));
    (*trans)[x]=y;
  }
  fclose(f);
  return 0;
}

// main method
int main(int argc,char *argv[]) { 
  ARGEdit query_ed;
  FILE *fp,*fp1,*Map;
  time_t begin,end;
  int i,j,j1,j2,cont_map=0,xx=-1,*trans=NULL;
  int n,cont = 0;
  int num_nodes,num_edges;
  int *M=NULL;
  char str[100],q_out[100];
  double tot = 0; 
  int ACC_VF;
  node_id ni1[MAXNODES], ni2[MAXNODES];

  /* INTERFACE RUNNING VENTO's SOFTWARE */
  
  if(argc != 3) {
    fprintf(stderr,"\nuse \"exe\" \"DB_name\" \"query_name\"\n\n");
    exit(1);
  }
  Map = fopen("Map","r");
  if(Map) {
    ReadMap(Map,&M,&cont_map);
    ACC_VF=0;
//    fprintf(stderr,"\nGot %d graphs from GraphGrep's Filtering",cont_map);
  }
  else {
    i=Load_Trans(&trans);
    if(i!=-1)
      ACC_VF=1;
  }
  
  /* START READING QUERY */
  begin = clock();
  fp = fopen(argv[2],"r");
  if(!fp) {
    fprintf(stderr,"\n Query not found\n\n");
    exit(1);
  }
  fscanf(fp,"%s",str);
  fscanf(fp,"%d",&num_nodes);
  
  for(i=0; i<num_nodes; i++) {
    fscanf(fp,"%s",str);
    query_ed.InsertNode(new Point(str)); // The inserted node will have index i.
  }
  fscanf(fp,"%d",&num_edges);
  
  for(i=0; i<num_edges; i++) {
    fscanf(fp,"%d %d",&j1,&j2);
    query_ed.InsertEdge(j1, j2, NULL); // NULL stands for no sem. attribute.
    query_ed.InsertEdge(j2, j1, NULL); // NULL stands for no sem. attribute.
  }
  fclose(fp);
  end = clock();
  tot += (double)(end-begin)/CLOCKS_PER_SEC;
  /* END READING QUERY*/

  /* START READING DATABASE */
  fp = fopen(argv[1],"r");
  if(!fp) {
    fprintf(stderr,"\n Dataset not found\n\n");
    exit(1);
  }
  
  remove("output");

  while(!feof(fp)) { // for all the graphs
    ARGEdit ed;
    fscanf(fp,"%s",str);
    if(feof(fp))
      break;
    if(str[0]=='#')
      xx++;
    //    int xx = atoi(str+6);
    if(Find(xx,M,cont_map) || !M) {
//	    begin = clock();

      fscanf(fp,"%d",&num_nodes);
      
      for(i=0; i<num_nodes; i++) {
        fscanf(fp,"%s",str);
        ed.InsertNode(new Point(str)); // The inserted node will have index i.
      }
      fscanf(fp,"%d",&num_edges);
    
      for(i=0; i<num_edges; i++) {
        fscanf(fp,"%d %d",&j1,&j2);
        ed.InsertEdge(j1, j2, NULL); // NULL stands for no sem. attribute.
        ed.InsertEdge(j2, j1, NULL); // NULL stands for no sem. attribute.
      }
      ARGraph<Point,void> query_graph(&query_ed),graph(&ed); // vflib graph
    
      query_graph.SetNodeComparator(new PointComparator()); // comparator
	
      begin = clock();
    
      VF2MonoState s0(&query_graph, &graph); // graph matching. vflib refers to it as monomorphism
      //VF2State s0(&query_graph, &graph);
      //VF2SubState s0(&query_graph, &graph);
          
      fp1 = fopen("output","a+");
      fprintf(fp1,"Graph:%d\n",(ACC_VF==1)?trans[xx]:xx);

      match(&s0, my_visitor,fp1);

      //fprintf(stderr,"\nElapsed : %lf",(double)(end-begin)/CLOCKS_PER_SEC);
      fclose(fp1);

      end = clock();

      tot += (double)(end-begin)/CLOCKS_PER_SEC;
      
    }
    else {
      fscanf(fp,"%d",&num_nodes);
      
      for(i=0; i<num_nodes; i++) {
        fscanf(fp,"%s",str);
      }
      fscanf(fp,"%d",&num_edges);
      for(i=0; i<num_edges; i++) {
        fscanf(fp,"%d %d",&j1,&j2);
      }
    }
  }
  strcpy(q_out,argv[2]);
  strcat(q_out,".out");
  unlink(q_out);
  rename("output",q_out);
  
  fprintf(stdout,"#Matching_time: %.2lf\n",tot);
  free(trans);
  trans=NULL;
  fclose(fp);
  if(Map)
    fclose(Map);
  free(M);
  return 0;
}
  
