/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.javasound.JSMinim;
import ddf.minim.javasound.MpegAudioFileReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.mpeg.sampled.file.IcyListener;
import javazoom.spi.mpeg.sampled.file.tag.IcyInputStream;

final class MpegAudioFileReaderWorkaround
extends MpegAudioFileReader {
    MpegAudioFileReaderWorkaround(JSMinim sys) {
        super(sys);
    }

    public AudioInputStream getAudioInputStream(URL url, String userAgent) throws UnsupportedAudioFileException, IOException {
        this.system.debug("MpegAudioFileReaderWorkaround.getAudioInputStream(" + url.toString() + ", " + userAgent + "): begin");
        long lFileLengthInBytes = -1L;
        URLConnection conn = url.openConnection();
        boolean isShout = false;
        int toRead = 4;
        byte[] head = new byte[toRead];
        if (userAgent != null) {
            conn.setRequestProperty("User-Agent", userAgent);
        }
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestProperty("Icy-Metadata", "1");
        conn.setRequestProperty("Connection", "close");
        this.system.debug("Base input stream is: " + conn.getInputStream().toString());
        BufferedInputStream bInputStream = new BufferedInputStream(conn.getInputStream());
        bInputStream.mark(toRead);
        int read = bInputStream.read(head, 0, toRead);
        if (read > 2 && head[0] == 73 | head[0] == 105 && head[1] == 67 | head[1] == 99 && head[2] == 89 | head[2] == 121) {
            isShout = true;
        }
        bInputStream.reset();
        BufferedInputStream inputStream = null;
        if (isShout) {
            this.system.debug("URL is a shoutcast server.");
            IcyInputStream icyStream = new IcyInputStream(bInputStream);
            icyStream.addTagParseListener(IcyListener.getInstance());
            inputStream = icyStream;
        } else {
            String metaint = conn.getHeaderField("icy-metaint");
            if (metaint != null) {
                this.system.debug("URL is probably an icecast 2 mp3 stream");
                IcyInputStream icyStream = new IcyInputStream((InputStream)bInputStream, metaint);
                icyStream.addTagParseListener(IcyListener.getInstance());
                inputStream = icyStream;
            } else {
                this.system.debug("URL is not shoutcast or icecast 2.");
                inputStream = bInputStream;
            }
        }
        AudioInputStream audioInputStream = null;
        try {
            this.system.debug("Attempting to get audioInputStream.");
            audioInputStream = this.getAudioInputStream(inputStream, lFileLengthInBytes);
        }
        catch (UnsupportedAudioFileException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        catch (IOException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        this.system.debug("MpegAudioFileReaderWorkaround.getAudioInputStream(URL,String): end");
        return audioInputStream;
    }
}

