## Asad Ali and Sohail Rana
## Arabic-English Verb Conjugation Program
## Heuristics
## January 2013

########

import unicodedata

print 'This is the Arabic to Roman Numeral Translation that has been used in this program'
myscript={'a':'1571','b': '1576'}
script=open("arabicscript","r")
scripttext =script.readlines()
script.close()
letters = []
for line in scripttext:
	arr_script=line.split(" ")
	myscript[arr_script[0]]=arr_script[1]
	letters.append(arr_script[0])
	
for x in letters:
        print x, ' = ', unichr(int(myscript[x]))

#########

##Suffix and Prefix lookups. 

suffixconjugation = {'pastfirstpersonsingular': 't', 'pastsecondpersonmasc':'t', 'pastsecondpersonfem': 't', 'pastthirdpersonmasc': '',
                     'pastthirdpersonfem': 't', 'pastfirstpersonplural': 'na', 'pastsecondpersonplural': 'tn', 'pastthirdpersonplural': 'wa',
                     'pastdualmixed': 'a', 'pastdualmasc': 'tma', 'pastdualfem': 'tn', 'presentfirstpersonsingular': '', 'presentsecondpersonmasc': '',
                     'presentsecondpersonfem': 'yn', 'presentthirdpersonmasc': '', 'presentthirdpersonfem': '', 'presentfirstpersonplural': '',
                     'presentsecondpersonplural': 'wn', 'presentthirdpersonplural': 'wn', 'presentdualmixed': 'an', 'presentdualmasc': 'a', 'presentdualfem': 'n',
                     'pastcontfirstpersonsingular': '', 'pastcontsecondpersonmasc': '', 'pastcontsecondpersonfem': 'yn', 'pastcontthirdpersonmasc': '',
                     'pastcontthirdpersonfem': '', 'pastcontfirstpersonplural': '', 'pastcontsecondpersonplural': 'wn', 'pastcontthirdpersonplural': 'wn',
                     'pastcontdualmixed': 'an', 'pastcontdualmasc': 'a','pastcontdualfem': 'n', 'imperativesecondpersonmasc': '', 'imperativesecondpersonfem': 'y',
                     'imperativesecondpersonplural': 'wa', 'imperativedualmixed': 'wa', 'imperativedualmasc': 'a', 'imperativedualfem': 'a',
                     'passivefirstpersonsingular': 't', 'passivesecondpersonmasc': 't', 'passivesecondpersonfem': 't',
                     'passivethirdpersonmasc': '', 'passivethirdpersonfem': 't', 'passivefirstpersonplural': 'na', 'passivethirdpersonplural' : 'wa' , 
                     'passivesecondpersonplural': 'wa', 'passivedualmixed': 'tma', 'passivedualmasc': 'tma', 'passivedualfem': 'tma', 'futurefirstpersonsingular': '',
                     'futuresecondpersonmasc': '', 'futuresecondpersonfem': '', 'futurethirdpersonmasc': '',
                     'futurethirdpersonfem': '', 'futurefirstpersonplural': '', 'futuresecondpersonplural': 'wn', 'futurethirdpersonplural': 'wn',
                     'futuredualmixed': 'a', 'futuredualmasc': 'ma', 'futuredualfem': 'n'}



prefixconjugation = {'pastfirstpersonsingular': '', 'pastsecondpersonmasc':'', 'pastsecondpersonfem': '', 'pastthirdpersonmasc': '',
                     'pastthirdpersonfem': '', 'pastfirstpersonplural': '', 'pastsecondpersonplural': '', 'pastthirdpersonplural': '', 'pastdualmixed': '',
                     'pastdualmasc': '', 'pastdualfem': '', 'presentfirstpersonsingular': 'a', 'presentsecondpersonmasc': 't',
                     'presentsecondpersonfem': 't', 'presentthirdpersonmasc': 'y', 'presentthirdpersonfem': 't', 'presentfirstpersonplural': 'n',
                     'presentsecondpersonplural': 't', 'presentthirdpersonplural': 'ya', 'presentdualmixed': '', 'presentdualmasc': '',
                     'presentdualfem': '', 'pastcontfirstpersonsingular': 'a', 'pastcontsecondpersonmasc': 't',
                     'pastcontsecondpersonfem': 't', 'pastcontthirdpersonmasc': 'y', 'pastcontthirdpersonfem': 't', 'pastcontfirstpersonplural': 'n',
                     'pastcontsecondpersonplural': 't', 'pastcontthirdpersonplural': 'ya', 'pastcontdualmixed': '', 'pastcontdualmasc': '',
                     'pastcontdualfem': '', 'imperativesecondpersonmasc': '','imperativesecondpersonfem': 'y', 'imperativesecondpersonplural': 'wa', 'imperativedualmixed': 'wa', 'imperativedualmasc': 'a',
                     'imperativedualfem': 'a', 'passivefirstpersonsingular': '', 'passivesecondpersonmasc': '', 'passivesecondpersonfem': '',
                     'passivethirdpersonmasc': '', 'passivethirdpersonfem': '', 'passivefirstpersonplural': '', 'passivesecondpersonplural': '', 'passivethirdpersonplural' : '' ,
                     'passivedualmixed': '', 'passivedualmasc': '', 'passivedualfem': '', 'futurefirstpersonsingular': 'sa', 'futuresecondpersonmasc': 'st',
                     'futuresecondpersonfem': 'st', 'futurethirdpersonmasc': 'sy', 'futurethirdpersonfem': 'st',
                     'futurefirstpersonplural': 'sn', 'futuresecondpersonplural': 'st', 'futurethirdpersonplural': 'sy', 'futuredualmixed': 'st',
                     'futuredualmasc': 'st', 'futuredualfem': 'st'}


pastcontinuousconj = {'pastcontfirstpersonsingular': 'knt', 'pastcontsecondpersonmasc': 'knt', 'pastcontsecondpersonfem': 'knt',
                      'pastcontthirdpersonmasc': 'kan', 'pastcontthirdpersonfem': 'kant', 'pastcontfirstpersonplural': 'kan',
                      'pastcontsecondpersonplural': 'kntm', 'pastcontthirdpersonplural': 'kanwa', 'pastcontdualmixed': 'kntma',
                      'pastcontdualmasc': 'kntma', 'pastcontdualfem': 'kntn'}


#########

###################

## getting User input and then using it

cnt5 = 0
while cnt5 == 0:
        askq = raw_input('Would you like to use the AS Arabic-English Verb Conjugation Dictionary(Y/N): ')
        if (askq == 'Y') or (askq == 'y'):
                cnt5 = 1
        elif (askq == 'N') or (askq == 'n'):
                quit()
        else:
                print "Don't be a smarty pants. Input a Y or N"
                cnt5 = 0
cnt = 0
while cnt == 0:
    arboreng = raw_input('Would you like the English-Arabic or Arabic-English translation (Please type EA or AE): ')
    if arboreng == 'EA':
        scriptbeg={'a':'1571', 'b':'65169'} #Initializing the Arabic Script (Beginning) Dictionary
        script1=open("arabicscriptbeg","r") #Open file and read it
        scripttext1 =script1.readlines() #read each line of the file and store it as scripttext1
        script1.close() #close the file
        for line in scripttext1: 
                arr_script1=line.split(" ") #Split the lines each time a space appears
                scriptbeg[arr_script1[0]]=arr_script1[1] #Add each word of the line to the dictionary scriptbeg
                
        ########### Repeat the Same Process with Middle and End Dictionary
        scriptmid={'a':'1571', 'b':'65170'}
        script2=open("arabicscriptmid","r")
        scripttext2 =script2.readlines()
        script2.close()
        for line in scripttext2:
                arr_script2=line.split(" ")
                scriptmid[arr_script2[0]]=arr_script2[1]

        ###########
        scriptend={'a':'65156', 'b':'65168'}
        script3=open("arabicscriptend","r")
        scripttext3=script3.readlines()
        script3.close()
        for line in scripttext3:
                arr_script3=line.split(" ")
                scriptend[arr_script3[0]]=arr_script3[1]


        ## Getting arabic root from the file
        mydictionary = {'read' : 'qr'} #Initializing Dictionary
        dictionaryfile = open("arabicdictionary.txt","r") #Open file with words in it
        text = dictionaryfile.readlines() #Read each line and store it as text
        dictionaryfile.close() #Close file
        for line in text: 
                arr = line.split("=") #Split each line wherever an equal sign appears
                mydictionary[arr[0]] = arr[1] #add the word to mydictionary

        counter=0
        while counter == 0:
            ineng = raw_input ("Please give me a root followed by a conjugation or a root followed by the word 'root': ")
            mywords = ineng.split(" ")
            root1 = mydictionary[mywords[0]] # Getting arabic root from the array we made above
            root1=root1.strip() # Each root is stripped into letters and stored as an array called root1 again
            root=root1.replace(" ","") 
            ## Add suffix and prefix and print the word
            if(mywords[1]=='present') or (mywords[1] == 'past') or (mywords[1]=='future') or (mywords[1]=='imperative') or (mywords[1]=='passive'):
                print 'The conjugation is: ' + prefixconjugation[''.join(mywords[1:])] + root + suffixconjugation[''.join(mywords[1:])]
                counter = 1
            elif(mywords[1]=='pastcont'):
                print 'The conjugation is: ' + pastcontinuousconj[''.join(mywords[1:])] + ' ' + prefixconjugation['present' + ''.join(mywords[2:])] + root + suffixconjugation['present'+''.join(mywords[2:])]
                counter = 1
            elif(mywords[1]=='root'):
                print root
                counter = 1
            else:
                print 'Please Check your input again and type it right this time'
                counter = 0

        ###########
        ## If the second word of the array mywords is 'root', then simply divide the root into its letters in an array
        if (mywords[1]=='root'):
                lets = []
                tmp = root1.split(" ")
                for x in tmp:
                   lets.append(x)
        ## Else take the root, add the suffix and prefix to it. Strip the whole word and append it one by one to the array lets

        elif (mywords[1]=='pastcont'):
                suff= suffixconjugation['present'+''.join(mywords[2:])]
                pref = prefixconjugation['present' + ''.join(mywords[2:])]
                lets = []
                tmp = list(pref)
                for x in tmp:
                   lets.append(x)
                tmp = root1.split(" ")
                for x in tmp:
                   lets.append(x) 
                tmp = list(suff) 
                for x in tmp:
                   lets.append(x)
        else:
                suff= suffixconjugation[''.join(mywords[1:])]
                pref = prefixconjugation[''.join(mywords[1:])]
                lets = []
                tmp = list(pref)
                for x in tmp:
                   lets.append(x)
                tmp = root1.split(" ")
                for x in tmp:
                   lets.append(x) 
                tmp = list(suff) 
                for x in tmp:
                   lets.append(x)
        ## Create an empty string 'arabic' and look up the dictionary depending upon whether the letter is in the beginning, middle or
        ## end and add the string to arabic each time where arabic is the unicode of the specific letter
        arabic=''
        count = 0 ## Add a count so that we can tell whether the letter is the first, middle or the last letter of the word
        for x in lets:
                if count==0:
                        abc = scriptbeg[x]
                        abc=abc.strip()
                        arabic+= unichr(int(abc))
                elif count == len(lets)-1:
                        abc = scriptend[x]
                        abc=abc.strip() 
                        arabic+= unichr(int(abc))
                else:
                        abc = scriptmid[x]
                        abc=abc.strip()
                        arabic+= unichr(int(abc))
                count+=1





# past continuous dual mixed: k n t m a (+present form)
# past continuous dual masc: k n t m a (+present form)
# past continuous dual fem: k n t n (+present form)
        if(mywords[1]=='pastcont'):
            if (''.join(mywords[2:]) == 'firstpersonsingular') or (''.join(mywords[2:]) == 'secondpersonmasc') or (''.join(mywords[2:]) == 'secondpersonfem'):
                    arabic= unichr(int(65243))+unichr(int(65256))+unichr(int(65174))+ ' ' + arabic
            elif ''.join(mywords[2:]) == 'thirdpersonmasc':
                    arabic= unichr(int(65243))+unichr(int(65156))+unichr(int(1606))+ ' ' + arabic
            elif ''.join(mywords[2:]) == 'thirdpersonfem':
                    arabic= unichr(int(65243))+unichr(int(65156))+unichr(int(65256))+ unichr(int(65174))+ ' ' + arabic
            elif ''.join(mywords[2:]) == 'firstpersonplural':
                    arabic= unichr(int(65243))+unichr(int(65256))+ unichr(int(65156))+ ' ' + arabic
            elif ''.join(mywords[2:]) == 'secondpersonplural':
                    arabic= unichr(int(65243))+unichr(int(65256))+ unichr(int(65176))+ unichr(int(65252))+ ' ' + arabic
            elif (''.join(mywords[2:]) == 'dualmixed') or (''.join(mywords[2:]) == 'dualmasc'):
                    arabic= unichr(int(65243))+unichr(int(65256))+ unichr(int(65176))+ unichr(int(65252))+ unichr(int(65156))+ ' ' + arabic
            elif ''.join(mywords[2:]) == 'dualfem':
                    arabic= unichr(int(65243))+unichr(int(65256))+ unichr(int(65176))+ unichr(int(1606))+ ' ' + arabic
            else:
                    arabic= unichr(int(65243))+unichr(int(65156))+unichr(int(65256))+ unichr(int(1608))+ unichr(int(65156)) + ' ' + arabic

        print arabic
        cnt = 1
    elif arboreng == 'AE':
        arabengdict = {'anzr' : 'see presentfirstpersonsingular', 'ynzr': 'see presentsecondpersonmasc'} #Initializing Dictionary
        aedictfile = open("Present_Past_Future_Pastcont.txt","r") #Open file with words in it
        text1 = aedictfile.readlines() #Read each line and store it as text
        aedictfile.close() #Close file
        for line in text1: 
                arr1 = line.split("=") #Split each line wherever an equal sign appears
                if arabengdict.has_key(arr1[0]):
                        arabengdict[arr1[0]] += arr1[1] #add the word to mydictionary
                else:
                        arabengdict[arr1[0]] = arr1[1]
        aedictfile = open("Passive.txt","r") #Open file with words in it
        text1 = aedictfile.readlines() #Read each line and store it as text
        aedictfile.close() #Close file
        for line in text1: 
                arr1 = line.split("=") #Split each line wherever an equal sign appears
                if arabengdict.has_key(arr1[0]):
                        arabengdict[arr1[0]] += arr1[1] #add the word to mydictionary
                else:
                        arabengdict[arr1[0]] = arr1[1]
        aedictfile = open("Imperative.txt","r") #Open file with words in it
        text1 = aedictfile.readlines() #Read each line and store it as text
        aedictfile.close() #Close file
        for line in text1: 
                arr1 = line.split("=") #Split each line wherever an equal sign appears
                if arabengdict.has_key(arr1[0]):
                        arabengdict[arr1[0]] += arr1[1] #add the word to mydictionary
                else:
                        arabengdict[arr1[0]] = arr1[1]
        cnt1=0
        while cnt1 == 0:
            inarab = raw_input ("Please give me an arabic conjugated verb: ")
            if inarab in arabengdict:
                    tmptmp=arabengdict[inarab]
                    tmptmp.split("\n")
                    print
                    print 'Below is the English Verb and its Conjugation/s'
                    print tmptmp
                                                                                
                    break
            else:
                    print 'Please Check Your Conjugated Verb Again'
                    cnt1=0
        cnt=1

    else:
            print 'Please Input One of the two: AE or EA'
            cnt = 0

        
